// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package volcobserve

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opUpdateNotifyTemplateCommon = "UpdateNotifyTemplate"

// UpdateNotifyTemplateCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateNotifyTemplateCommon operation. The "output" return
// value will be populated with the UpdateNotifyTemplateCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateNotifyTemplateCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdateNotifyTemplateCommon Send returns without error.
//
// See UpdateNotifyTemplateCommon for more information on using the UpdateNotifyTemplateCommon
// API call, and error handling.
//
//    // Example sending a request using the UpdateNotifyTemplateCommonRequest method.
//    req, resp := client.UpdateNotifyTemplateCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VOLCOBSERVE) UpdateNotifyTemplateCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opUpdateNotifyTemplateCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdateNotifyTemplateCommon API operation for VOLC_OBSERVE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VOLC_OBSERVE's
// API operation UpdateNotifyTemplateCommon for usage and error information.
func (c *VOLCOBSERVE) UpdateNotifyTemplateCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.UpdateNotifyTemplateCommonRequest(input)
	return out, req.Send()
}

// UpdateNotifyTemplateCommonWithContext is the same as UpdateNotifyTemplateCommon with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateNotifyTemplateCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VOLCOBSERVE) UpdateNotifyTemplateCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.UpdateNotifyTemplateCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateNotifyTemplate = "UpdateNotifyTemplate"

// UpdateNotifyTemplateRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateNotifyTemplate operation. The "output" return
// value will be populated with the UpdateNotifyTemplateCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateNotifyTemplateCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdateNotifyTemplateCommon Send returns without error.
//
// See UpdateNotifyTemplate for more information on using the UpdateNotifyTemplate
// API call, and error handling.
//
//    // Example sending a request using the UpdateNotifyTemplateRequest method.
//    req, resp := client.UpdateNotifyTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VOLCOBSERVE) UpdateNotifyTemplateRequest(input *UpdateNotifyTemplateInput) (req *request.Request, output *UpdateNotifyTemplateOutput) {
	op := &request.Operation{
		Name:       opUpdateNotifyTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateNotifyTemplateInput{}
	}

	output = &UpdateNotifyTemplateOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdateNotifyTemplate API operation for VOLC_OBSERVE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VOLC_OBSERVE's
// API operation UpdateNotifyTemplate for usage and error information.
func (c *VOLCOBSERVE) UpdateNotifyTemplate(input *UpdateNotifyTemplateInput) (*UpdateNotifyTemplateOutput, error) {
	req, out := c.UpdateNotifyTemplateRequest(input)
	return out, req.Send()
}

// UpdateNotifyTemplateWithContext is the same as UpdateNotifyTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateNotifyTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VOLCOBSERVE) UpdateNotifyTemplateWithContext(ctx volcengine.Context, input *UpdateNotifyTemplateInput, opts ...request.Option) (*UpdateNotifyTemplateOutput, error) {
	req, out := c.UpdateNotifyTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type UpdateNotifyTemplateInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// Channel is a required field
	Channel *string `type:"string" json:",omitempty" required:"true" enum:"EnumOfChannelForUpdateNotifyTemplateInput"`

	// Content is a required field
	Content *string `type:"string" json:",omitempty" required:"true"`

	Description *string `type:"string" json:",omitempty"`

	// Id is a required field
	Id *string `type:"string" json:",omitempty" required:"true"`

	// Name is a required field
	Name *string `min:"1" max:"128" type:"string" json:",omitempty" required:"true"`

	Title *string `type:"string" json:",omitempty"`

	// Type is a required field
	Type *string `type:"string" json:",omitempty" required:"true" enum:"EnumOfTypeForUpdateNotifyTemplateInput"`
}

// String returns the string representation
func (s UpdateNotifyTemplateInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateNotifyTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateNotifyTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateNotifyTemplateInput"}
	if s.Channel == nil {
		invalidParams.Add(request.NewErrParamRequired("Channel"))
	}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Name != nil && len(*s.Name) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("Name", 128, *s.Name))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannel sets the Channel field's value.
func (s *UpdateNotifyTemplateInput) SetChannel(v string) *UpdateNotifyTemplateInput {
	s.Channel = &v
	return s
}

// SetContent sets the Content field's value.
func (s *UpdateNotifyTemplateInput) SetContent(v string) *UpdateNotifyTemplateInput {
	s.Content = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *UpdateNotifyTemplateInput) SetDescription(v string) *UpdateNotifyTemplateInput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateNotifyTemplateInput) SetId(v string) *UpdateNotifyTemplateInput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateNotifyTemplateInput) SetName(v string) *UpdateNotifyTemplateInput {
	s.Name = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *UpdateNotifyTemplateInput) SetTitle(v string) *UpdateNotifyTemplateInput {
	s.Title = &v
	return s
}

// SetType sets the Type field's value.
func (s *UpdateNotifyTemplateInput) SetType(v string) *UpdateNotifyTemplateInput {
	s.Type = &v
	return s
}

type UpdateNotifyTemplateOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Data *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s UpdateNotifyTemplateOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateNotifyTemplateOutput) GoString() string {
	return s.String()
}

// SetData sets the Data field's value.
func (s *UpdateNotifyTemplateOutput) SetData(v string) *UpdateNotifyTemplateOutput {
	s.Data = &v
	return s
}

const (
	// EnumOfChannelForUpdateNotifyTemplateInputEmail is a EnumOfChannelForUpdateNotifyTemplateInput enum value
	EnumOfChannelForUpdateNotifyTemplateInputEmail = "email"

	// EnumOfChannelForUpdateNotifyTemplateInputSms is a EnumOfChannelForUpdateNotifyTemplateInput enum value
	EnumOfChannelForUpdateNotifyTemplateInputSms = "sms"

	// EnumOfChannelForUpdateNotifyTemplateInputPhone is a EnumOfChannelForUpdateNotifyTemplateInput enum value
	EnumOfChannelForUpdateNotifyTemplateInputPhone = "phone"

	// EnumOfChannelForUpdateNotifyTemplateInputLark is a EnumOfChannelForUpdateNotifyTemplateInput enum value
	EnumOfChannelForUpdateNotifyTemplateInputLark = "lark"

	// EnumOfChannelForUpdateNotifyTemplateInputDingtalk is a EnumOfChannelForUpdateNotifyTemplateInput enum value
	EnumOfChannelForUpdateNotifyTemplateInputDingtalk = "dingtalk"

	// EnumOfChannelForUpdateNotifyTemplateInputWecom is a EnumOfChannelForUpdateNotifyTemplateInput enum value
	EnumOfChannelForUpdateNotifyTemplateInputWecom = "wecom"

	// EnumOfChannelForUpdateNotifyTemplateInputSlack is a EnumOfChannelForUpdateNotifyTemplateInput enum value
	EnumOfChannelForUpdateNotifyTemplateInputSlack = "slack"

	// EnumOfChannelForUpdateNotifyTemplateInputApi is a EnumOfChannelForUpdateNotifyTemplateInput enum value
	EnumOfChannelForUpdateNotifyTemplateInputApi = "api"
)

const (
	// EnumOfTypeForUpdateNotifyTemplateInputMetric is a EnumOfTypeForUpdateNotifyTemplateInput enum value
	EnumOfTypeForUpdateNotifyTemplateInputMetric = "metric"

	// EnumOfTypeForUpdateNotifyTemplateInputEvent is a EnumOfTypeForUpdateNotifyTemplateInput enum value
	EnumOfTypeForUpdateNotifyTemplateInputEvent = "event"
)
