// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package volcobserve

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateWebhookCommon = "CreateWebhook"

// CreateWebhookCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateWebhookCommon operation. The "output" return
// value will be populated with the CreateWebhookCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateWebhookCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateWebhookCommon Send returns without error.
//
// See CreateWebhookCommon for more information on using the CreateWebhookCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateWebhookCommonRequest method.
//    req, resp := client.CreateWebhookCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VOLCOBSERVE) CreateWebhookCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateWebhookCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateWebhookCommon API operation for VOLC_OBSERVE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VOLC_OBSERVE's
// API operation CreateWebhookCommon for usage and error information.
func (c *VOLCOBSERVE) CreateWebhookCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateWebhookCommonRequest(input)
	return out, req.Send()
}

// CreateWebhookCommonWithContext is the same as CreateWebhookCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWebhookCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VOLCOBSERVE) CreateWebhookCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateWebhookCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateWebhook = "CreateWebhook"

// CreateWebhookRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateWebhook operation. The "output" return
// value will be populated with the CreateWebhookCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateWebhookCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateWebhookCommon Send returns without error.
//
// See CreateWebhook for more information on using the CreateWebhook
// API call, and error handling.
//
//    // Example sending a request using the CreateWebhookRequest method.
//    req, resp := client.CreateWebhookRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VOLCOBSERVE) CreateWebhookRequest(input *CreateWebhookInput) (req *request.Request, output *CreateWebhookOutput) {
	op := &request.Operation{
		Name:       opCreateWebhook,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateWebhookInput{}
	}

	output = &CreateWebhookOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateWebhook API operation for VOLC_OBSERVE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VOLC_OBSERVE's
// API operation CreateWebhook for usage and error information.
func (c *VOLCOBSERVE) CreateWebhook(input *CreateWebhookInput) (*CreateWebhookOutput, error) {
	req, out := c.CreateWebhookRequest(input)
	return out, req.Send()
}

// CreateWebhookWithContext is the same as CreateWebhook with the addition of
// the ability to pass a context and additional request options.
//
// See CreateWebhook for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VOLCOBSERVE) CreateWebhookWithContext(ctx volcengine.Context, input *CreateWebhookInput, opts ...request.Option) (*CreateWebhookOutput, error) {
	req, out := c.CreateWebhookRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateWebhookInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// Name is a required field
	Name *string `min:"1" max:"512" type:"string" json:",omitempty" required:"true"`

	// Type is a required field
	Type *string `type:"string" json:",omitempty" required:"true" enum:"EnumOfTypeForCreateWebhookInput"`

	// Url is a required field
	Url *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s CreateWebhookInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWebhookInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateWebhookInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateWebhookInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Name != nil && len(*s.Name) > 512 {
		invalidParams.Add(request.NewErrParamMaxLen("Name", 512, *s.Name))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}
	if s.Url == nil {
		invalidParams.Add(request.NewErrParamRequired("Url"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *CreateWebhookInput) SetName(v string) *CreateWebhookInput {
	s.Name = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateWebhookInput) SetType(v string) *CreateWebhookInput {
	s.Type = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *CreateWebhookInput) SetUrl(v string) *CreateWebhookInput {
	s.Url = &v
	return s
}

type CreateWebhookOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Data []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s CreateWebhookOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateWebhookOutput) GoString() string {
	return s.String()
}

// SetData sets the Data field's value.
func (s *CreateWebhookOutput) SetData(v []*string) *CreateWebhookOutput {
	s.Data = v
	return s
}

const (
	// EnumOfTypeForCreateWebhookInputWecom is a EnumOfTypeForCreateWebhookInput enum value
	EnumOfTypeForCreateWebhookInputWecom = "wecom"

	// EnumOfTypeForCreateWebhookInputDingtalk is a EnumOfTypeForCreateWebhookInput enum value
	EnumOfTypeForCreateWebhookInputDingtalk = "dingtalk"

	// EnumOfTypeForCreateWebhookInputLark is a EnumOfTypeForCreateWebhookInput enum value
	EnumOfTypeForCreateWebhookInputLark = "lark"

	// EnumOfTypeForCreateWebhookInputCustom is a EnumOfTypeForCreateWebhookInput enum value
	EnumOfTypeForCreateWebhookInputCustom = "custom"
)
