// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package volcobserve

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateRuleCommon = "CreateRule"

// CreateRuleCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateRuleCommon operation. The "output" return
// value will be populated with the CreateRuleCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateRuleCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateRuleCommon Send returns without error.
//
// See CreateRuleCommon for more information on using the CreateRuleCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateRuleCommonRequest method.
//    req, resp := client.CreateRuleCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VOLCOBSERVE) CreateRuleCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateRuleCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateRuleCommon API operation for VOLC_OBSERVE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VOLC_OBSERVE's
// API operation CreateRuleCommon for usage and error information.
func (c *VOLCOBSERVE) CreateRuleCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateRuleCommonRequest(input)
	return out, req.Send()
}

// CreateRuleCommonWithContext is the same as CreateRuleCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRuleCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VOLCOBSERVE) CreateRuleCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateRuleCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateRule = "CreateRule"

// CreateRuleRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateRule operation. The "output" return
// value will be populated with the CreateRuleCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateRuleCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateRuleCommon Send returns without error.
//
// See CreateRule for more information on using the CreateRule
// API call, and error handling.
//
//    // Example sending a request using the CreateRuleRequest method.
//    req, resp := client.CreateRuleRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VOLCOBSERVE) CreateRuleRequest(input *CreateRuleInput) (req *request.Request, output *CreateRuleOutput) {
	op := &request.Operation{
		Name:       opCreateRule,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateRuleInput{}
	}

	output = &CreateRuleOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateRule API operation for VOLC_OBSERVE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VOLC_OBSERVE's
// API operation CreateRule for usage and error information.
func (c *VOLCOBSERVE) CreateRule(input *CreateRuleInput) (*CreateRuleOutput, error) {
	req, out := c.CreateRuleRequest(input)
	return out, req.Send()
}

// CreateRuleWithContext is the same as CreateRule with the addition of
// the ability to pass a context and additional request options.
//
// See CreateRule for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VOLCOBSERVE) CreateRuleWithContext(ctx volcengine.Context, input *CreateRuleInput, opts ...request.Option) (*CreateRuleOutput, error) {
	req, out := c.CreateRuleRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ConditionForCreateRuleInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ComparisonOperator *string `type:"string" json:",omitempty"`

	MetricName *string `type:"string" json:",omitempty"`

	MetricUnit *string `type:"string" json:",omitempty"`

	Period *string `type:"string" json:",omitempty"`

	Statistics *string `type:"string" json:",omitempty"`

	Threshold *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ConditionForCreateRuleInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConditionForCreateRuleInput) GoString() string {
	return s.String()
}

// SetComparisonOperator sets the ComparisonOperator field's value.
func (s *ConditionForCreateRuleInput) SetComparisonOperator(v string) *ConditionForCreateRuleInput {
	s.ComparisonOperator = &v
	return s
}

// SetMetricName sets the MetricName field's value.
func (s *ConditionForCreateRuleInput) SetMetricName(v string) *ConditionForCreateRuleInput {
	s.MetricName = &v
	return s
}

// SetMetricUnit sets the MetricUnit field's value.
func (s *ConditionForCreateRuleInput) SetMetricUnit(v string) *ConditionForCreateRuleInput {
	s.MetricUnit = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *ConditionForCreateRuleInput) SetPeriod(v string) *ConditionForCreateRuleInput {
	s.Period = &v
	return s
}

// SetStatistics sets the Statistics field's value.
func (s *ConditionForCreateRuleInput) SetStatistics(v string) *ConditionForCreateRuleInput {
	s.Statistics = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *ConditionForCreateRuleInput) SetThreshold(v string) *ConditionForCreateRuleInput {
	s.Threshold = &v
	return s
}

type ConvertTagForCreateRuleInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ConvertTagForCreateRuleInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertTagForCreateRuleInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *ConvertTagForCreateRuleInput) SetKey(v string) *ConvertTagForCreateRuleInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ConvertTagForCreateRuleInput) SetValue(v string) *ConvertTagForCreateRuleInput {
	s.Value = &v
	return s
}

type CreateRuleInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AlertMethods []*string `type:"list" json:",omitempty"`

	ConditionOperator *string `type:"string" json:",omitempty"`

	Conditions []*ConditionForCreateRuleInput `type:"list" json:",omitempty"`

	ContactGroupIds []*string `type:"list" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	DimensionConditions *DimensionConditionsForCreateRuleInput `type:"structure" json:",omitempty"`

	// EffectEndAt is a required field
	EffectEndAt *string `type:"string" json:",omitempty" required:"true"`

	// EffectStartAt is a required field
	EffectStartAt *string `type:"string" json:",omitempty" required:"true"`

	// EnableState is a required field
	EnableState *string `type:"string" json:",omitempty" required:"true"`

	// EvaluationCount is a required field
	EvaluationCount *int64 `type:"integer" json:",omitempty" required:"true"`

	// Level is a required field
	Level *string `type:"string" json:",omitempty" required:"true"`

	LevelConditions []*LevelConditionForCreateRuleInput `type:"list" json:",omitempty"`

	MultipleConditions *bool `type:"boolean" json:",omitempty"`

	// Namespace is a required field
	Namespace *string `type:"string" json:",omitempty" required:"true"`

	NoData *NoDataForCreateRuleInput `type:"structure" json:",omitempty"`

	NotificationId *string `type:"string" json:",omitempty"`

	NotifyTemplates []*NotifyTemplateForCreateRuleInput `type:"list" json:",omitempty"`

	OriginalDimensions map[string][]*string `type:"map" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`

	RecoveryNotify *RecoveryNotifyForCreateRuleInput `type:"structure" json:",omitempty"`

	Regions []*string `type:"list" json:",omitempty"`

	// RuleName is a required field
	RuleName *string `type:"string" json:",omitempty" required:"true"`

	// RuleType is a required field
	RuleType *string `type:"string" json:",omitempty" required:"true" enum:"EnumOfRuleTypeForCreateRuleInput"`

	// SilenceTime is a required field
	SilenceTime *int64 `type:"integer" json:",omitempty" required:"true"`

	// SubNamespace is a required field
	SubNamespace *string `type:"string" json:",omitempty" required:"true"`

	Tags []*ConvertTagForCreateRuleInput `type:"list" json:",omitempty"`

	Webhook *string `type:"string" json:",omitempty"`

	WebhookIds []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s CreateRuleInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRuleInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateRuleInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateRuleInput"}
	if s.EffectEndAt == nil {
		invalidParams.Add(request.NewErrParamRequired("EffectEndAt"))
	}
	if s.EffectStartAt == nil {
		invalidParams.Add(request.NewErrParamRequired("EffectStartAt"))
	}
	if s.EnableState == nil {
		invalidParams.Add(request.NewErrParamRequired("EnableState"))
	}
	if s.EvaluationCount == nil {
		invalidParams.Add(request.NewErrParamRequired("EvaluationCount"))
	}
	if s.Level == nil {
		invalidParams.Add(request.NewErrParamRequired("Level"))
	}
	if s.Namespace == nil {
		invalidParams.Add(request.NewErrParamRequired("Namespace"))
	}
	if s.RuleName == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleName"))
	}
	if s.RuleType == nil {
		invalidParams.Add(request.NewErrParamRequired("RuleType"))
	}
	if s.SilenceTime == nil {
		invalidParams.Add(request.NewErrParamRequired("SilenceTime"))
	}
	if s.SubNamespace == nil {
		invalidParams.Add(request.NewErrParamRequired("SubNamespace"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlertMethods sets the AlertMethods field's value.
func (s *CreateRuleInput) SetAlertMethods(v []*string) *CreateRuleInput {
	s.AlertMethods = v
	return s
}

// SetConditionOperator sets the ConditionOperator field's value.
func (s *CreateRuleInput) SetConditionOperator(v string) *CreateRuleInput {
	s.ConditionOperator = &v
	return s
}

// SetConditions sets the Conditions field's value.
func (s *CreateRuleInput) SetConditions(v []*ConditionForCreateRuleInput) *CreateRuleInput {
	s.Conditions = v
	return s
}

// SetContactGroupIds sets the ContactGroupIds field's value.
func (s *CreateRuleInput) SetContactGroupIds(v []*string) *CreateRuleInput {
	s.ContactGroupIds = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateRuleInput) SetDescription(v string) *CreateRuleInput {
	s.Description = &v
	return s
}

// SetDimensionConditions sets the DimensionConditions field's value.
func (s *CreateRuleInput) SetDimensionConditions(v *DimensionConditionsForCreateRuleInput) *CreateRuleInput {
	s.DimensionConditions = v
	return s
}

// SetEffectEndAt sets the EffectEndAt field's value.
func (s *CreateRuleInput) SetEffectEndAt(v string) *CreateRuleInput {
	s.EffectEndAt = &v
	return s
}

// SetEffectStartAt sets the EffectStartAt field's value.
func (s *CreateRuleInput) SetEffectStartAt(v string) *CreateRuleInput {
	s.EffectStartAt = &v
	return s
}

// SetEnableState sets the EnableState field's value.
func (s *CreateRuleInput) SetEnableState(v string) *CreateRuleInput {
	s.EnableState = &v
	return s
}

// SetEvaluationCount sets the EvaluationCount field's value.
func (s *CreateRuleInput) SetEvaluationCount(v int64) *CreateRuleInput {
	s.EvaluationCount = &v
	return s
}

// SetLevel sets the Level field's value.
func (s *CreateRuleInput) SetLevel(v string) *CreateRuleInput {
	s.Level = &v
	return s
}

// SetLevelConditions sets the LevelConditions field's value.
func (s *CreateRuleInput) SetLevelConditions(v []*LevelConditionForCreateRuleInput) *CreateRuleInput {
	s.LevelConditions = v
	return s
}

// SetMultipleConditions sets the MultipleConditions field's value.
func (s *CreateRuleInput) SetMultipleConditions(v bool) *CreateRuleInput {
	s.MultipleConditions = &v
	return s
}

// SetNamespace sets the Namespace field's value.
func (s *CreateRuleInput) SetNamespace(v string) *CreateRuleInput {
	s.Namespace = &v
	return s
}

// SetNoData sets the NoData field's value.
func (s *CreateRuleInput) SetNoData(v *NoDataForCreateRuleInput) *CreateRuleInput {
	s.NoData = v
	return s
}

// SetNotificationId sets the NotificationId field's value.
func (s *CreateRuleInput) SetNotificationId(v string) *CreateRuleInput {
	s.NotificationId = &v
	return s
}

// SetNotifyTemplates sets the NotifyTemplates field's value.
func (s *CreateRuleInput) SetNotifyTemplates(v []*NotifyTemplateForCreateRuleInput) *CreateRuleInput {
	s.NotifyTemplates = v
	return s
}

// SetOriginalDimensions sets the OriginalDimensions field's value.
func (s *CreateRuleInput) SetOriginalDimensions(v map[string][]*string) *CreateRuleInput {
	s.OriginalDimensions = v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateRuleInput) SetProjectName(v string) *CreateRuleInput {
	s.ProjectName = &v
	return s
}

// SetRecoveryNotify sets the RecoveryNotify field's value.
func (s *CreateRuleInput) SetRecoveryNotify(v *RecoveryNotifyForCreateRuleInput) *CreateRuleInput {
	s.RecoveryNotify = v
	return s
}

// SetRegions sets the Regions field's value.
func (s *CreateRuleInput) SetRegions(v []*string) *CreateRuleInput {
	s.Regions = v
	return s
}

// SetRuleName sets the RuleName field's value.
func (s *CreateRuleInput) SetRuleName(v string) *CreateRuleInput {
	s.RuleName = &v
	return s
}

// SetRuleType sets the RuleType field's value.
func (s *CreateRuleInput) SetRuleType(v string) *CreateRuleInput {
	s.RuleType = &v
	return s
}

// SetSilenceTime sets the SilenceTime field's value.
func (s *CreateRuleInput) SetSilenceTime(v int64) *CreateRuleInput {
	s.SilenceTime = &v
	return s
}

// SetSubNamespace sets the SubNamespace field's value.
func (s *CreateRuleInput) SetSubNamespace(v string) *CreateRuleInput {
	s.SubNamespace = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateRuleInput) SetTags(v []*ConvertTagForCreateRuleInput) *CreateRuleInput {
	s.Tags = v
	return s
}

// SetWebhook sets the Webhook field's value.
func (s *CreateRuleInput) SetWebhook(v string) *CreateRuleInput {
	s.Webhook = &v
	return s
}

// SetWebhookIds sets the WebhookIds field's value.
func (s *CreateRuleInput) SetWebhookIds(v []*string) *CreateRuleInput {
	s.WebhookIds = v
	return s
}

type CreateRuleOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Data []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s CreateRuleOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateRuleOutput) GoString() string {
	return s.String()
}

// SetData sets the Data field's value.
func (s *CreateRuleOutput) SetData(v []*string) *CreateRuleOutput {
	s.Data = v
	return s
}

type DimensionConditionsForCreateRuleInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	MetaCondition *MetaConditionForCreateRuleInput `type:"structure" json:",omitempty"`

	ProjectCondition *ProjectConditionForCreateRuleInput `type:"structure" json:",omitempty"`

	TagCondition *TagConditionForCreateRuleInput `type:"structure" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s DimensionConditionsForCreateRuleInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DimensionConditionsForCreateRuleInput) GoString() string {
	return s.String()
}

// SetMetaCondition sets the MetaCondition field's value.
func (s *DimensionConditionsForCreateRuleInput) SetMetaCondition(v *MetaConditionForCreateRuleInput) *DimensionConditionsForCreateRuleInput {
	s.MetaCondition = v
	return s
}

// SetProjectCondition sets the ProjectCondition field's value.
func (s *DimensionConditionsForCreateRuleInput) SetProjectCondition(v *ProjectConditionForCreateRuleInput) *DimensionConditionsForCreateRuleInput {
	s.ProjectCondition = v
	return s
}

// SetTagCondition sets the TagCondition field's value.
func (s *DimensionConditionsForCreateRuleInput) SetTagCondition(v *TagConditionForCreateRuleInput) *DimensionConditionsForCreateRuleInput {
	s.TagCondition = v
	return s
}

// SetType sets the Type field's value.
func (s *DimensionConditionsForCreateRuleInput) SetType(v string) *DimensionConditionsForCreateRuleInput {
	s.Type = &v
	return s
}

type LevelConditionForCreateRuleInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Conditions []*ConditionForCreateRuleInput `type:"list" json:",omitempty"`

	Level *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s LevelConditionForCreateRuleInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s LevelConditionForCreateRuleInput) GoString() string {
	return s.String()
}

// SetConditions sets the Conditions field's value.
func (s *LevelConditionForCreateRuleInput) SetConditions(v []*ConditionForCreateRuleInput) *LevelConditionForCreateRuleInput {
	s.Conditions = v
	return s
}

// SetLevel sets the Level field's value.
func (s *LevelConditionForCreateRuleInput) SetLevel(v string) *LevelConditionForCreateRuleInput {
	s.Level = &v
	return s
}

type MetaConditionForCreateRuleInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AllDimensions *bool `type:"boolean" json:",omitempty"`

	Condition *string `type:"string" json:",omitempty"`

	Metas []*MetaForCreateRuleInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s MetaConditionForCreateRuleInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MetaConditionForCreateRuleInput) GoString() string {
	return s.String()
}

// SetAllDimensions sets the AllDimensions field's value.
func (s *MetaConditionForCreateRuleInput) SetAllDimensions(v bool) *MetaConditionForCreateRuleInput {
	s.AllDimensions = &v
	return s
}

// SetCondition sets the Condition field's value.
func (s *MetaConditionForCreateRuleInput) SetCondition(v string) *MetaConditionForCreateRuleInput {
	s.Condition = &v
	return s
}

// SetMetas sets the Metas field's value.
func (s *MetaConditionForCreateRuleInput) SetMetas(v []*MetaForCreateRuleInput) *MetaConditionForCreateRuleInput {
	s.Metas = v
	return s
}

type MetaForCreateRuleInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Comparator *string `type:"string" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Values []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s MetaForCreateRuleInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MetaForCreateRuleInput) GoString() string {
	return s.String()
}

// SetComparator sets the Comparator field's value.
func (s *MetaForCreateRuleInput) SetComparator(v string) *MetaForCreateRuleInput {
	s.Comparator = &v
	return s
}

// SetKey sets the Key field's value.
func (s *MetaForCreateRuleInput) SetKey(v string) *MetaForCreateRuleInput {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *MetaForCreateRuleInput) SetValues(v []*string) *MetaForCreateRuleInput {
	s.Values = v
	return s
}

type NoDataForCreateRuleInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	EvaluationCount *int64 `type:"integer" json:",omitempty"`
}

// String returns the string representation
func (s NoDataForCreateRuleInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NoDataForCreateRuleInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *NoDataForCreateRuleInput) SetEnable(v bool) *NoDataForCreateRuleInput {
	s.Enable = &v
	return s
}

// SetEvaluationCount sets the EvaluationCount field's value.
func (s *NoDataForCreateRuleInput) SetEvaluationCount(v int64) *NoDataForCreateRuleInput {
	s.EvaluationCount = &v
	return s
}

type NotifyTemplateForCreateRuleInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Channel *string `type:"string" json:",omitempty" enum:"EnumOfChannelForCreateRuleInput"`

	NotifyTemplateId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s NotifyTemplateForCreateRuleInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NotifyTemplateForCreateRuleInput) GoString() string {
	return s.String()
}

// SetChannel sets the Channel field's value.
func (s *NotifyTemplateForCreateRuleInput) SetChannel(v string) *NotifyTemplateForCreateRuleInput {
	s.Channel = &v
	return s
}

// SetNotifyTemplateId sets the NotifyTemplateId field's value.
func (s *NotifyTemplateForCreateRuleInput) SetNotifyTemplateId(v string) *NotifyTemplateForCreateRuleInput {
	s.NotifyTemplateId = &v
	return s
}

type ProjectConditionForCreateRuleInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Projects []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ProjectConditionForCreateRuleInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ProjectConditionForCreateRuleInput) GoString() string {
	return s.String()
}

// SetProjects sets the Projects field's value.
func (s *ProjectConditionForCreateRuleInput) SetProjects(v []*string) *ProjectConditionForCreateRuleInput {
	s.Projects = v
	return s
}

type RecoveryNotifyForCreateRuleInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s RecoveryNotifyForCreateRuleInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RecoveryNotifyForCreateRuleInput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *RecoveryNotifyForCreateRuleInput) SetEnable(v bool) *RecoveryNotifyForCreateRuleInput {
	s.Enable = &v
	return s
}

type TagConditionForCreateRuleInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Condition *string `type:"string" json:",omitempty"`

	Tags []*TagForCreateRuleInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s TagConditionForCreateRuleInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagConditionForCreateRuleInput) GoString() string {
	return s.String()
}

// SetCondition sets the Condition field's value.
func (s *TagConditionForCreateRuleInput) SetCondition(v string) *TagConditionForCreateRuleInput {
	s.Condition = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagConditionForCreateRuleInput) SetTags(v []*TagForCreateRuleInput) *TagConditionForCreateRuleInput {
	s.Tags = v
	return s
}

type TagForCreateRuleInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Comparator *string `type:"string" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Values []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s TagForCreateRuleInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForCreateRuleInput) GoString() string {
	return s.String()
}

// SetComparator sets the Comparator field's value.
func (s *TagForCreateRuleInput) SetComparator(v string) *TagForCreateRuleInput {
	s.Comparator = &v
	return s
}

// SetKey sets the Key field's value.
func (s *TagForCreateRuleInput) SetKey(v string) *TagForCreateRuleInput {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *TagForCreateRuleInput) SetValues(v []*string) *TagForCreateRuleInput {
	s.Values = v
	return s
}

const (
	// EnumOfAlertMethodListForCreateRuleInputEmail is a EnumOfAlertMethodListForCreateRuleInput enum value
	EnumOfAlertMethodListForCreateRuleInputEmail = "Email"

	// EnumOfAlertMethodListForCreateRuleInputPhone is a EnumOfAlertMethodListForCreateRuleInput enum value
	EnumOfAlertMethodListForCreateRuleInputPhone = "Phone"

	// EnumOfAlertMethodListForCreateRuleInputSms is a EnumOfAlertMethodListForCreateRuleInput enum value
	EnumOfAlertMethodListForCreateRuleInputSms = "SMS"

	// EnumOfAlertMethodListForCreateRuleInputWebhook is a EnumOfAlertMethodListForCreateRuleInput enum value
	EnumOfAlertMethodListForCreateRuleInputWebhook = "Webhook"
)

const (
	// EnumOfChannelForCreateRuleInputEmail is a EnumOfChannelForCreateRuleInput enum value
	EnumOfChannelForCreateRuleInputEmail = "email"

	// EnumOfChannelForCreateRuleInputSms is a EnumOfChannelForCreateRuleInput enum value
	EnumOfChannelForCreateRuleInputSms = "sms"

	// EnumOfChannelForCreateRuleInputPhone is a EnumOfChannelForCreateRuleInput enum value
	EnumOfChannelForCreateRuleInputPhone = "phone"

	// EnumOfChannelForCreateRuleInputLark is a EnumOfChannelForCreateRuleInput enum value
	EnumOfChannelForCreateRuleInputLark = "lark"

	// EnumOfChannelForCreateRuleInputDingtalk is a EnumOfChannelForCreateRuleInput enum value
	EnumOfChannelForCreateRuleInputDingtalk = "dingtalk"

	// EnumOfChannelForCreateRuleInputWecom is a EnumOfChannelForCreateRuleInput enum value
	EnumOfChannelForCreateRuleInputWecom = "wecom"

	// EnumOfChannelForCreateRuleInputSlack is a EnumOfChannelForCreateRuleInput enum value
	EnumOfChannelForCreateRuleInputSlack = "slack"

	// EnumOfChannelForCreateRuleInputApi is a EnumOfChannelForCreateRuleInput enum value
	EnumOfChannelForCreateRuleInputApi = "api"
)

const (
	// EnumOfRuleTypeForCreateRuleInputStatic is a EnumOfRuleTypeForCreateRuleInput enum value
	EnumOfRuleTypeForCreateRuleInputStatic = "static"

	// EnumOfRuleTypeForCreateRuleInputDynamic is a EnumOfRuleTypeForCreateRuleInput enum value
	EnumOfRuleTypeForCreateRuleInputDynamic = "dynamic"
)
