// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package volcobserve

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateNotifyTemplateCommon = "CreateNotifyTemplate"

// CreateNotifyTemplateCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateNotifyTemplateCommon operation. The "output" return
// value will be populated with the CreateNotifyTemplateCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateNotifyTemplateCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateNotifyTemplateCommon Send returns without error.
//
// See CreateNotifyTemplateCommon for more information on using the CreateNotifyTemplateCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateNotifyTemplateCommonRequest method.
//    req, resp := client.CreateNotifyTemplateCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VOLCOBSERVE) CreateNotifyTemplateCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateNotifyTemplateCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateNotifyTemplateCommon API operation for VOLC_OBSERVE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VOLC_OBSERVE's
// API operation CreateNotifyTemplateCommon for usage and error information.
func (c *VOLCOBSERVE) CreateNotifyTemplateCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateNotifyTemplateCommonRequest(input)
	return out, req.Send()
}

// CreateNotifyTemplateCommonWithContext is the same as CreateNotifyTemplateCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNotifyTemplateCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VOLCOBSERVE) CreateNotifyTemplateCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateNotifyTemplateCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateNotifyTemplate = "CreateNotifyTemplate"

// CreateNotifyTemplateRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateNotifyTemplate operation. The "output" return
// value will be populated with the CreateNotifyTemplateCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateNotifyTemplateCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateNotifyTemplateCommon Send returns without error.
//
// See CreateNotifyTemplate for more information on using the CreateNotifyTemplate
// API call, and error handling.
//
//    // Example sending a request using the CreateNotifyTemplateRequest method.
//    req, resp := client.CreateNotifyTemplateRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VOLCOBSERVE) CreateNotifyTemplateRequest(input *CreateNotifyTemplateInput) (req *request.Request, output *CreateNotifyTemplateOutput) {
	op := &request.Operation{
		Name:       opCreateNotifyTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateNotifyTemplateInput{}
	}

	output = &CreateNotifyTemplateOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateNotifyTemplate API operation for VOLC_OBSERVE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VOLC_OBSERVE's
// API operation CreateNotifyTemplate for usage and error information.
func (c *VOLCOBSERVE) CreateNotifyTemplate(input *CreateNotifyTemplateInput) (*CreateNotifyTemplateOutput, error) {
	req, out := c.CreateNotifyTemplateRequest(input)
	return out, req.Send()
}

// CreateNotifyTemplateWithContext is the same as CreateNotifyTemplate with the addition of
// the ability to pass a context and additional request options.
//
// See CreateNotifyTemplate for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VOLCOBSERVE) CreateNotifyTemplateWithContext(ctx volcengine.Context, input *CreateNotifyTemplateInput, opts ...request.Option) (*CreateNotifyTemplateOutput, error) {
	req, out := c.CreateNotifyTemplateRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateNotifyTemplateInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// Channel is a required field
	Channel *string `type:"string" json:",omitempty" required:"true" enum:"EnumOfChannelForCreateNotifyTemplateInput"`

	// Content is a required field
	Content *string `type:"string" json:",omitempty" required:"true"`

	Description *string `type:"string" json:",omitempty"`

	// Name is a required field
	Name *string `min:"1" max:"128" type:"string" json:",omitempty" required:"true"`

	Title *string `type:"string" json:",omitempty"`

	// Type is a required field
	Type *string `type:"string" json:",omitempty" required:"true" enum:"EnumOfTypeForCreateNotifyTemplateInput"`
}

// String returns the string representation
func (s CreateNotifyTemplateInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNotifyTemplateInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateNotifyTemplateInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateNotifyTemplateInput"}
	if s.Channel == nil {
		invalidParams.Add(request.NewErrParamRequired("Channel"))
	}
	if s.Content == nil {
		invalidParams.Add(request.NewErrParamRequired("Content"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Name != nil && len(*s.Name) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("Name", 128, *s.Name))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChannel sets the Channel field's value.
func (s *CreateNotifyTemplateInput) SetChannel(v string) *CreateNotifyTemplateInput {
	s.Channel = &v
	return s
}

// SetContent sets the Content field's value.
func (s *CreateNotifyTemplateInput) SetContent(v string) *CreateNotifyTemplateInput {
	s.Content = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateNotifyTemplateInput) SetDescription(v string) *CreateNotifyTemplateInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateNotifyTemplateInput) SetName(v string) *CreateNotifyTemplateInput {
	s.Name = &v
	return s
}

// SetTitle sets the Title field's value.
func (s *CreateNotifyTemplateInput) SetTitle(v string) *CreateNotifyTemplateInput {
	s.Title = &v
	return s
}

// SetType sets the Type field's value.
func (s *CreateNotifyTemplateInput) SetType(v string) *CreateNotifyTemplateInput {
	s.Type = &v
	return s
}

type CreateNotifyTemplateOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Data *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateNotifyTemplateOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateNotifyTemplateOutput) GoString() string {
	return s.String()
}

// SetData sets the Data field's value.
func (s *CreateNotifyTemplateOutput) SetData(v string) *CreateNotifyTemplateOutput {
	s.Data = &v
	return s
}

const (
	// EnumOfChannelForCreateNotifyTemplateInputEmail is a EnumOfChannelForCreateNotifyTemplateInput enum value
	EnumOfChannelForCreateNotifyTemplateInputEmail = "email"

	// EnumOfChannelForCreateNotifyTemplateInputSms is a EnumOfChannelForCreateNotifyTemplateInput enum value
	EnumOfChannelForCreateNotifyTemplateInputSms = "sms"

	// EnumOfChannelForCreateNotifyTemplateInputPhone is a EnumOfChannelForCreateNotifyTemplateInput enum value
	EnumOfChannelForCreateNotifyTemplateInputPhone = "phone"

	// EnumOfChannelForCreateNotifyTemplateInputLark is a EnumOfChannelForCreateNotifyTemplateInput enum value
	EnumOfChannelForCreateNotifyTemplateInputLark = "lark"

	// EnumOfChannelForCreateNotifyTemplateInputDingtalk is a EnumOfChannelForCreateNotifyTemplateInput enum value
	EnumOfChannelForCreateNotifyTemplateInputDingtalk = "dingtalk"

	// EnumOfChannelForCreateNotifyTemplateInputWecom is a EnumOfChannelForCreateNotifyTemplateInput enum value
	EnumOfChannelForCreateNotifyTemplateInputWecom = "wecom"

	// EnumOfChannelForCreateNotifyTemplateInputSlack is a EnumOfChannelForCreateNotifyTemplateInput enum value
	EnumOfChannelForCreateNotifyTemplateInputSlack = "slack"

	// EnumOfChannelForCreateNotifyTemplateInputApi is a EnumOfChannelForCreateNotifyTemplateInput enum value
	EnumOfChannelForCreateNotifyTemplateInputApi = "api"
)

const (
	// EnumOfTypeForCreateNotifyTemplateInputMetric is a EnumOfTypeForCreateNotifyTemplateInput enum value
	EnumOfTypeForCreateNotifyTemplateInputMetric = "metric"

	// EnumOfTypeForCreateNotifyTemplateInputEvent is a EnumOfTypeForCreateNotifyTemplateInput enum value
	EnumOfTypeForCreateNotifyTemplateInputEvent = "event"
)
