// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opBindAXNECommon = "BindAXNE"

// BindAXNECommonRequest generates a "volcengine/request.Request" representing the
// client's request for the BindAXNECommon operation. The "output" return
// value will be populated with the BindAXNECommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned BindAXNECommon Request to send the API call to the service.
// the "output" return value is not valid until after BindAXNECommon Send returns without error.
//
// See BindAXNECommon for more information on using the BindAXNECommon
// API call, and error handling.
//
//    // Example sending a request using the BindAXNECommonRequest method.
//    req, resp := client.BindAXNECommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VMS) BindAXNECommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opBindAXNECommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// BindAXNECommon API operation for VMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VMS's
// API operation BindAXNECommon for usage and error information.
func (c *VMS) BindAXNECommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.BindAXNECommonRequest(input)
	return out, req.Send()
}

// BindAXNECommonWithContext is the same as BindAXNECommon with the addition of
// the ability to pass a context and additional request options.
//
// See BindAXNECommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VMS) BindAXNECommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.BindAXNECommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBindAXNE = "BindAXNE"

// BindAXNERequest generates a "volcengine/request.Request" representing the
// client's request for the BindAXNE operation. The "output" return
// value will be populated with the BindAXNECommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned BindAXNECommon Request to send the API call to the service.
// the "output" return value is not valid until after BindAXNECommon Send returns without error.
//
// See BindAXNE for more information on using the BindAXNE
// API call, and error handling.
//
//    // Example sending a request using the BindAXNERequest method.
//    req, resp := client.BindAXNERequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VMS) BindAXNERequest(input *BindAXNEInput) (req *request.Request, output *BindAXNEOutput) {
	op := &request.Operation{
		Name:       opBindAXNE,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BindAXNEInput{}
	}

	output = &BindAXNEOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// BindAXNE API operation for VMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VMS's
// API operation BindAXNE for usage and error information.
func (c *VMS) BindAXNE(input *BindAXNEInput) (*BindAXNEOutput, error) {
	req, out := c.BindAXNERequest(input)
	return out, req.Send()
}

// BindAXNEWithContext is the same as BindAXNE with the addition of
// the ability to pass a context and additional request options.
//
// See BindAXNE for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VMS) BindAXNEWithContext(ctx volcengine.Context, input *BindAXNEInput, opts ...request.Option) (*BindAXNEOutput, error) {
	req, out := c.BindAXNERequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type BindAXNEInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AudioRecordFlag *int32 `type:"int32" json:",omitempty"`

	CityCode *string `type:"string" json:",omitempty"`

	CityCodeByPhoneNo *string `type:"string" json:",omitempty" enum:"EnumOfCityCodeByPhoneNoForBindAXNEInput"`

	DegradeCityList []*string `type:"list" json:",omitempty"`

	// ExpireTime is a required field
	ExpireTime *int64 `type:"int64" json:",omitempty" required:"true"`

	// NumberPoolNo is a required field
	NumberPoolNo *string `type:"string" json:",omitempty" required:"true"`

	OutId *string `type:"string" json:",omitempty"`

	// PhoneNoA is a required field
	PhoneNoA *string `type:"string" json:",omitempty" required:"true"`

	PhoneNoB *string `type:"string" json:",omitempty"`

	PhoneNoE *string `type:"string" json:",omitempty"`

	PhoneNoX *string `type:"string" json:",omitempty"`

	RandomFlag *int32 `type:"int32" json:",omitempty"`

	UserData *string `max:"2048" type:"string" json:",omitempty"`
}

// String returns the string representation
func (s BindAXNEInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BindAXNEInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BindAXNEInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BindAXNEInput"}
	if s.ExpireTime == nil {
		invalidParams.Add(request.NewErrParamRequired("ExpireTime"))
	}
	if s.NumberPoolNo == nil {
		invalidParams.Add(request.NewErrParamRequired("NumberPoolNo"))
	}
	if s.PhoneNoA == nil {
		invalidParams.Add(request.NewErrParamRequired("PhoneNoA"))
	}
	if s.UserData != nil && len(*s.UserData) > 2048 {
		invalidParams.Add(request.NewErrParamMaxLen("UserData", 2048, *s.UserData))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAudioRecordFlag sets the AudioRecordFlag field's value.
func (s *BindAXNEInput) SetAudioRecordFlag(v int32) *BindAXNEInput {
	s.AudioRecordFlag = &v
	return s
}

// SetCityCode sets the CityCode field's value.
func (s *BindAXNEInput) SetCityCode(v string) *BindAXNEInput {
	s.CityCode = &v
	return s
}

// SetCityCodeByPhoneNo sets the CityCodeByPhoneNo field's value.
func (s *BindAXNEInput) SetCityCodeByPhoneNo(v string) *BindAXNEInput {
	s.CityCodeByPhoneNo = &v
	return s
}

// SetDegradeCityList sets the DegradeCityList field's value.
func (s *BindAXNEInput) SetDegradeCityList(v []*string) *BindAXNEInput {
	s.DegradeCityList = v
	return s
}

// SetExpireTime sets the ExpireTime field's value.
func (s *BindAXNEInput) SetExpireTime(v int64) *BindAXNEInput {
	s.ExpireTime = &v
	return s
}

// SetNumberPoolNo sets the NumberPoolNo field's value.
func (s *BindAXNEInput) SetNumberPoolNo(v string) *BindAXNEInput {
	s.NumberPoolNo = &v
	return s
}

// SetOutId sets the OutId field's value.
func (s *BindAXNEInput) SetOutId(v string) *BindAXNEInput {
	s.OutId = &v
	return s
}

// SetPhoneNoA sets the PhoneNoA field's value.
func (s *BindAXNEInput) SetPhoneNoA(v string) *BindAXNEInput {
	s.PhoneNoA = &v
	return s
}

// SetPhoneNoB sets the PhoneNoB field's value.
func (s *BindAXNEInput) SetPhoneNoB(v string) *BindAXNEInput {
	s.PhoneNoB = &v
	return s
}

// SetPhoneNoE sets the PhoneNoE field's value.
func (s *BindAXNEInput) SetPhoneNoE(v string) *BindAXNEInput {
	s.PhoneNoE = &v
	return s
}

// SetPhoneNoX sets the PhoneNoX field's value.
func (s *BindAXNEInput) SetPhoneNoX(v string) *BindAXNEInput {
	s.PhoneNoX = &v
	return s
}

// SetRandomFlag sets the RandomFlag field's value.
func (s *BindAXNEInput) SetRandomFlag(v int32) *BindAXNEInput {
	s.RandomFlag = &v
	return s
}

// SetUserData sets the UserData field's value.
func (s *BindAXNEInput) SetUserData(v string) *BindAXNEInput {
	s.UserData = &v
	return s
}

type BindAXNEOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	PhoneNoA *string `type:"string" json:",omitempty"`

	PhoneNoACityCode *string `type:"string" json:",omitempty"`

	PhoneNoB *string `type:"string" json:",omitempty"`

	PhoneNoBCityCode *string `type:"string" json:",omitempty"`

	PhoneNoE *string `type:"string" json:",omitempty"`

	PhoneNoX *string `type:"string" json:",omitempty"`

	PhoneNoXCityCode *string `type:"string" json:",omitempty"`

	Status *int32 `type:"int32" json:",omitempty"`

	SubId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s BindAXNEOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BindAXNEOutput) GoString() string {
	return s.String()
}

// SetPhoneNoA sets the PhoneNoA field's value.
func (s *BindAXNEOutput) SetPhoneNoA(v string) *BindAXNEOutput {
	s.PhoneNoA = &v
	return s
}

// SetPhoneNoACityCode sets the PhoneNoACityCode field's value.
func (s *BindAXNEOutput) SetPhoneNoACityCode(v string) *BindAXNEOutput {
	s.PhoneNoACityCode = &v
	return s
}

// SetPhoneNoB sets the PhoneNoB field's value.
func (s *BindAXNEOutput) SetPhoneNoB(v string) *BindAXNEOutput {
	s.PhoneNoB = &v
	return s
}

// SetPhoneNoBCityCode sets the PhoneNoBCityCode field's value.
func (s *BindAXNEOutput) SetPhoneNoBCityCode(v string) *BindAXNEOutput {
	s.PhoneNoBCityCode = &v
	return s
}

// SetPhoneNoE sets the PhoneNoE field's value.
func (s *BindAXNEOutput) SetPhoneNoE(v string) *BindAXNEOutput {
	s.PhoneNoE = &v
	return s
}

// SetPhoneNoX sets the PhoneNoX field's value.
func (s *BindAXNEOutput) SetPhoneNoX(v string) *BindAXNEOutput {
	s.PhoneNoX = &v
	return s
}

// SetPhoneNoXCityCode sets the PhoneNoXCityCode field's value.
func (s *BindAXNEOutput) SetPhoneNoXCityCode(v string) *BindAXNEOutput {
	s.PhoneNoXCityCode = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *BindAXNEOutput) SetStatus(v int32) *BindAXNEOutput {
	s.Status = &v
	return s
}

// SetSubId sets the SubId field's value.
func (s *BindAXNEOutput) SetSubId(v string) *BindAXNEOutput {
	s.SubId = &v
	return s
}

const (
	// EnumOfCityCodeByPhoneNoForBindAXNEInputA is a EnumOfCityCodeByPhoneNoForBindAXNEInput enum value
	EnumOfCityCodeByPhoneNoForBindAXNEInputA = "A"

	// EnumOfCityCodeByPhoneNoForBindAXNEInputB is a EnumOfCityCodeByPhoneNoForBindAXNEInput enum value
	EnumOfCityCodeByPhoneNoForBindAXNEInputB = "B"
)
