// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vms

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opBatchAppendCommon = "BatchAppend"

// BatchAppendCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the BatchAppendCommon operation. The "output" return
// value will be populated with the BatchAppendCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned BatchAppendCommon Request to send the API call to the service.
// the "output" return value is not valid until after BatchAppendCommon Send returns without error.
//
// See BatchAppendCommon for more information on using the BatchAppendCommon
// API call, and error handling.
//
//    // Example sending a request using the BatchAppendCommonRequest method.
//    req, resp := client.BatchAppendCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VMS) BatchAppendCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opBatchAppendCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// BatchAppendCommon API operation for VMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VMS's
// API operation BatchAppendCommon for usage and error information.
func (c *VMS) BatchAppendCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.BatchAppendCommonRequest(input)
	return out, req.Send()
}

// BatchAppendCommonWithContext is the same as BatchAppendCommon with the addition of
// the ability to pass a context and additional request options.
//
// See BatchAppendCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VMS) BatchAppendCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.BatchAppendCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opBatchAppend = "BatchAppend"

// BatchAppendRequest generates a "volcengine/request.Request" representing the
// client's request for the BatchAppend operation. The "output" return
// value will be populated with the BatchAppendCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned BatchAppendCommon Request to send the API call to the service.
// the "output" return value is not valid until after BatchAppendCommon Send returns without error.
//
// See BatchAppend for more information on using the BatchAppend
// API call, and error handling.
//
//    // Example sending a request using the BatchAppendRequest method.
//    req, resp := client.BatchAppendRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VMS) BatchAppendRequest(input *BatchAppendInput) (req *request.Request, output *BatchAppendOutput) {
	op := &request.Operation{
		Name:       opBatchAppend,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &BatchAppendInput{}
	}

	output = &BatchAppendOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// BatchAppend API operation for VMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VMS's
// API operation BatchAppend for usage and error information.
func (c *VMS) BatchAppend(input *BatchAppendInput) (*BatchAppendOutput, error) {
	req, out := c.BatchAppendRequest(input)
	return out, req.Send()
}

// BatchAppendWithContext is the same as BatchAppend with the addition of
// the ability to pass a context and additional request options.
//
// See BatchAppend for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VMS) BatchAppendWithContext(ctx volcengine.Context, input *BatchAppendInput, opts ...request.Option) (*BatchAppendOutput, error) {
	req, out := c.BatchAppendRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type BatchAppendInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	PhoneList []*PhoneListForBatchAppendInput `type:"list" json:",omitempty"`

	// TaskOpenId is a required field
	TaskOpenId *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s BatchAppendInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchAppendInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *BatchAppendInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "BatchAppendInput"}
	if s.TaskOpenId == nil {
		invalidParams.Add(request.NewErrParamRequired("TaskOpenId"))
	}
	if s.PhoneList != nil {
		for i, v := range s.PhoneList {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "PhoneList", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPhoneList sets the PhoneList field's value.
func (s *BatchAppendInput) SetPhoneList(v []*PhoneListForBatchAppendInput) *BatchAppendInput {
	s.PhoneList = v
	return s
}

// SetTaskOpenId sets the TaskOpenId field's value.
func (s *BatchAppendInput) SetTaskOpenId(v string) *BatchAppendInput {
	s.TaskOpenId = &v
	return s
}

type BatchAppendOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	FailList []*FailListForBatchAppendOutput `type:"list" json:",omitempty"`

	TaskOpenId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s BatchAppendOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BatchAppendOutput) GoString() string {
	return s.String()
}

// SetFailList sets the FailList field's value.
func (s *BatchAppendOutput) SetFailList(v []*FailListForBatchAppendOutput) *BatchAppendOutput {
	s.FailList = v
	return s
}

// SetTaskOpenId sets the TaskOpenId field's value.
func (s *BatchAppendOutput) SetTaskOpenId(v string) *BatchAppendOutput {
	s.TaskOpenId = &v
	return s
}

type FailListForBatchAppendOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Desc *string `type:"string" json:",omitempty"`

	Index *int32 `type:"int32" json:",omitempty"`

	Phone *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s FailListForBatchAppendOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FailListForBatchAppendOutput) GoString() string {
	return s.String()
}

// SetDesc sets the Desc field's value.
func (s *FailListForBatchAppendOutput) SetDesc(v string) *FailListForBatchAppendOutput {
	s.Desc = &v
	return s
}

// SetIndex sets the Index field's value.
func (s *FailListForBatchAppendOutput) SetIndex(v int32) *FailListForBatchAppendOutput {
	s.Index = &v
	return s
}

// SetPhone sets the Phone field's value.
func (s *FailListForBatchAppendOutput) SetPhone(v string) *FailListForBatchAppendOutput {
	s.Phone = &v
	return s
}

// SetType sets the Type field's value.
func (s *FailListForBatchAppendOutput) SetType(v string) *FailListForBatchAppendOutput {
	s.Type = &v
	return s
}

type PhoneListForBatchAppendInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Ext *string `max:"255" type:"string" json:",omitempty"`

	Phone *string `type:"string" json:",omitempty"`

	PhoneParamJson *string `type:"string" json:",omitempty"`

	SmsParamJson *string `type:"string" json:",omitempty"`

	TtsContent *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s PhoneListForBatchAppendInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PhoneListForBatchAppendInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *PhoneListForBatchAppendInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "PhoneListForBatchAppendInput"}
	if s.Ext != nil && len(*s.Ext) > 255 {
		invalidParams.Add(request.NewErrParamMaxLen("Ext", 255, *s.Ext))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetExt sets the Ext field's value.
func (s *PhoneListForBatchAppendInput) SetExt(v string) *PhoneListForBatchAppendInput {
	s.Ext = &v
	return s
}

// SetPhone sets the Phone field's value.
func (s *PhoneListForBatchAppendInput) SetPhone(v string) *PhoneListForBatchAppendInput {
	s.Phone = &v
	return s
}

// SetPhoneParamJson sets the PhoneParamJson field's value.
func (s *PhoneListForBatchAppendInput) SetPhoneParamJson(v string) *PhoneListForBatchAppendInput {
	s.PhoneParamJson = &v
	return s
}

// SetSmsParamJson sets the SmsParamJson field's value.
func (s *PhoneListForBatchAppendInput) SetSmsParamJson(v string) *PhoneListForBatchAppendInput {
	s.SmsParamJson = &v
	return s
}

// SetTtsContent sets the TtsContent field's value.
func (s *PhoneListForBatchAppendInput) SetTtsContent(v string) *PhoneListForBatchAppendInput {
	s.TtsContent = &v
	return s
}
