// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vepfs

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opExpandFileSystemCommon = "ExpandFileSystem"

// ExpandFileSystemCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ExpandFileSystemCommon operation. The "output" return
// value will be populated with the ExpandFileSystemCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ExpandFileSystemCommon Request to send the API call to the service.
// the "output" return value is not valid until after ExpandFileSystemCommon Send returns without error.
//
// See ExpandFileSystemCommon for more information on using the ExpandFileSystemCommon
// API call, and error handling.
//
//    // Example sending a request using the ExpandFileSystemCommonRequest method.
//    req, resp := client.ExpandFileSystemCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VEPFS) ExpandFileSystemCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opExpandFileSystemCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ExpandFileSystemCommon API operation for VEPFS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VEPFS's
// API operation ExpandFileSystemCommon for usage and error information.
func (c *VEPFS) ExpandFileSystemCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ExpandFileSystemCommonRequest(input)
	return out, req.Send()
}

// ExpandFileSystemCommonWithContext is the same as ExpandFileSystemCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ExpandFileSystemCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VEPFS) ExpandFileSystemCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ExpandFileSystemCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opExpandFileSystem = "ExpandFileSystem"

// ExpandFileSystemRequest generates a "volcengine/request.Request" representing the
// client's request for the ExpandFileSystem operation. The "output" return
// value will be populated with the ExpandFileSystemCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ExpandFileSystemCommon Request to send the API call to the service.
// the "output" return value is not valid until after ExpandFileSystemCommon Send returns without error.
//
// See ExpandFileSystem for more information on using the ExpandFileSystem
// API call, and error handling.
//
//    // Example sending a request using the ExpandFileSystemRequest method.
//    req, resp := client.ExpandFileSystemRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VEPFS) ExpandFileSystemRequest(input *ExpandFileSystemInput) (req *request.Request, output *ExpandFileSystemOutput) {
	op := &request.Operation{
		Name:       opExpandFileSystem,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ExpandFileSystemInput{}
	}

	output = &ExpandFileSystemOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ExpandFileSystem API operation for VEPFS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VEPFS's
// API operation ExpandFileSystem for usage and error information.
func (c *VEPFS) ExpandFileSystem(input *ExpandFileSystemInput) (*ExpandFileSystemOutput, error) {
	req, out := c.ExpandFileSystemRequest(input)
	return out, req.Send()
}

// ExpandFileSystemWithContext is the same as ExpandFileSystem with the addition of
// the ability to pass a context and additional request options.
//
// See ExpandFileSystem for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VEPFS) ExpandFileSystemWithContext(ctx volcengine.Context, input *ExpandFileSystemInput, opts ...request.Option) (*ExpandFileSystemOutput, error) {
	req, out := c.ExpandFileSystemRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ExpandFileSystemInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// Capacity is a required field
	Capacity *int32 `type:"int32" json:",omitempty" required:"true"`

	EnableRestripe *bool `type:"boolean" json:",omitempty"`

	// FileSystemId is a required field
	FileSystemId *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s ExpandFileSystemInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ExpandFileSystemInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ExpandFileSystemInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ExpandFileSystemInput"}
	if s.Capacity == nil {
		invalidParams.Add(request.NewErrParamRequired("Capacity"))
	}
	if s.FileSystemId == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCapacity sets the Capacity field's value.
func (s *ExpandFileSystemInput) SetCapacity(v int32) *ExpandFileSystemInput {
	s.Capacity = &v
	return s
}

// SetEnableRestripe sets the EnableRestripe field's value.
func (s *ExpandFileSystemInput) SetEnableRestripe(v bool) *ExpandFileSystemInput {
	s.EnableRestripe = &v
	return s
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *ExpandFileSystemInput) SetFileSystemId(v string) *ExpandFileSystemInput {
	s.FileSystemId = &v
	return s
}

type ExpandFileSystemOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	OrderNO *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ExpandFileSystemOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ExpandFileSystemOutput) GoString() string {
	return s.String()
}

// SetOrderNO sets the OrderNO field's value.
func (s *ExpandFileSystemOutput) SetOrderNO(v string) *ExpandFileSystemOutput {
	s.OrderNO = &v
	return s
}
