// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package vepfs

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeFilesetsCommon = "DescribeFilesets"

// DescribeFilesetsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeFilesetsCommon operation. The "output" return
// value will be populated with the DescribeFilesetsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeFilesetsCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeFilesetsCommon Send returns without error.
//
// See DescribeFilesetsCommon for more information on using the DescribeFilesetsCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeFilesetsCommonRequest method.
//    req, resp := client.DescribeFilesetsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VEPFS) DescribeFilesetsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeFilesetsCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeFilesetsCommon API operation for VEPFS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VEPFS's
// API operation DescribeFilesetsCommon for usage and error information.
func (c *VEPFS) DescribeFilesetsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeFilesetsCommonRequest(input)
	return out, req.Send()
}

// DescribeFilesetsCommonWithContext is the same as DescribeFilesetsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFilesetsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VEPFS) DescribeFilesetsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeFilesetsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeFilesets = "DescribeFilesets"

// DescribeFilesetsRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeFilesets operation. The "output" return
// value will be populated with the DescribeFilesetsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeFilesetsCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeFilesetsCommon Send returns without error.
//
// See DescribeFilesets for more information on using the DescribeFilesets
// API call, and error handling.
//
//    // Example sending a request using the DescribeFilesetsRequest method.
//    req, resp := client.DescribeFilesetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VEPFS) DescribeFilesetsRequest(input *DescribeFilesetsInput) (req *request.Request, output *DescribeFilesetsOutput) {
	op := &request.Operation{
		Name:       opDescribeFilesets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeFilesetsInput{}
	}

	output = &DescribeFilesetsOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeFilesets API operation for VEPFS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VEPFS's
// API operation DescribeFilesets for usage and error information.
func (c *VEPFS) DescribeFilesets(input *DescribeFilesetsInput) (*DescribeFilesetsOutput, error) {
	req, out := c.DescribeFilesetsRequest(input)
	return out, req.Send()
}

// DescribeFilesetsWithContext is the same as DescribeFilesets with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeFilesets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VEPFS) DescribeFilesetsWithContext(ctx volcengine.Context, input *DescribeFilesetsInput, opts ...request.Option) (*DescribeFilesetsOutput, error) {
	req, out := c.DescribeFilesetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DescribeFilesetsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// FileSystemId is a required field
	FileSystemId *string `type:"string" json:",omitempty" required:"true"`

	Filters []*FilterForDescribeFilesetsInput `type:"list" json:",omitempty"`

	OrderBy *string `type:"string" json:",omitempty" enum:"EnumOfOrderByForDescribeFilesetsInput"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s DescribeFilesetsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFilesetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeFilesetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeFilesetsInput"}
	if s.FileSystemId == nil {
		invalidParams.Add(request.NewErrParamRequired("FileSystemId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *DescribeFilesetsInput) SetFileSystemId(v string) *DescribeFilesetsInput {
	s.FileSystemId = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeFilesetsInput) SetFilters(v []*FilterForDescribeFilesetsInput) *DescribeFilesetsInput {
	s.Filters = v
	return s
}

// SetOrderBy sets the OrderBy field's value.
func (s *DescribeFilesetsInput) SetOrderBy(v string) *DescribeFilesetsInput {
	s.OrderBy = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *DescribeFilesetsInput) SetPageNumber(v int32) *DescribeFilesetsInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribeFilesetsInput) SetPageSize(v int32) *DescribeFilesetsInput {
	s.PageSize = &v
	return s
}

type DescribeFilesetsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Filesets []*FilesetForDescribeFilesetsOutput `type:"list" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s DescribeFilesetsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeFilesetsOutput) GoString() string {
	return s.String()
}

// SetFilesets sets the Filesets field's value.
func (s *DescribeFilesetsOutput) SetFilesets(v []*FilesetForDescribeFilesetsOutput) *DescribeFilesetsOutput {
	s.Filesets = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *DescribeFilesetsOutput) SetPageNumber(v int32) *DescribeFilesetsOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribeFilesetsOutput) SetPageSize(v int32) *DescribeFilesetsOutput {
	s.PageSize = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *DescribeFilesetsOutput) SetTotalCount(v int32) *DescribeFilesetsOutput {
	s.TotalCount = &v
	return s
}

type FilesetForDescribeFilesetsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BandwidthQos *int32 `type:"int32" json:",omitempty"`

	CapacityLimit *int32 `type:"int32" json:",omitempty"`

	CapacityUsed *int32 `type:"int32" json:",omitempty"`

	CreateTime *string `type:"string" json:",omitempty"`

	FileLimit *int64 `type:"int64" json:",omitempty"`

	FileSystemId *string `type:"string" json:",omitempty"`

	FileUsed *int64 `type:"int64" json:",omitempty"`

	FilesetId *string `type:"string" json:",omitempty"`

	FilesetName *string `type:"string" json:",omitempty"`

	FilesetPath *string `type:"string" json:",omitempty"`

	IOPSQos *int32 `type:"int32" json:",omitempty"`

	MaxInodeNum *int64 `type:"int64" json:",omitempty"`

	Status *string `type:"string" json:",omitempty" enum:"EnumOfStatusForDescribeFilesetsOutput"`
}

// String returns the string representation
func (s FilesetForDescribeFilesetsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FilesetForDescribeFilesetsOutput) GoString() string {
	return s.String()
}

// SetBandwidthQos sets the BandwidthQos field's value.
func (s *FilesetForDescribeFilesetsOutput) SetBandwidthQos(v int32) *FilesetForDescribeFilesetsOutput {
	s.BandwidthQos = &v
	return s
}

// SetCapacityLimit sets the CapacityLimit field's value.
func (s *FilesetForDescribeFilesetsOutput) SetCapacityLimit(v int32) *FilesetForDescribeFilesetsOutput {
	s.CapacityLimit = &v
	return s
}

// SetCapacityUsed sets the CapacityUsed field's value.
func (s *FilesetForDescribeFilesetsOutput) SetCapacityUsed(v int32) *FilesetForDescribeFilesetsOutput {
	s.CapacityUsed = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *FilesetForDescribeFilesetsOutput) SetCreateTime(v string) *FilesetForDescribeFilesetsOutput {
	s.CreateTime = &v
	return s
}

// SetFileLimit sets the FileLimit field's value.
func (s *FilesetForDescribeFilesetsOutput) SetFileLimit(v int64) *FilesetForDescribeFilesetsOutput {
	s.FileLimit = &v
	return s
}

// SetFileSystemId sets the FileSystemId field's value.
func (s *FilesetForDescribeFilesetsOutput) SetFileSystemId(v string) *FilesetForDescribeFilesetsOutput {
	s.FileSystemId = &v
	return s
}

// SetFileUsed sets the FileUsed field's value.
func (s *FilesetForDescribeFilesetsOutput) SetFileUsed(v int64) *FilesetForDescribeFilesetsOutput {
	s.FileUsed = &v
	return s
}

// SetFilesetId sets the FilesetId field's value.
func (s *FilesetForDescribeFilesetsOutput) SetFilesetId(v string) *FilesetForDescribeFilesetsOutput {
	s.FilesetId = &v
	return s
}

// SetFilesetName sets the FilesetName field's value.
func (s *FilesetForDescribeFilesetsOutput) SetFilesetName(v string) *FilesetForDescribeFilesetsOutput {
	s.FilesetName = &v
	return s
}

// SetFilesetPath sets the FilesetPath field's value.
func (s *FilesetForDescribeFilesetsOutput) SetFilesetPath(v string) *FilesetForDescribeFilesetsOutput {
	s.FilesetPath = &v
	return s
}

// SetIOPSQos sets the IOPSQos field's value.
func (s *FilesetForDescribeFilesetsOutput) SetIOPSQos(v int32) *FilesetForDescribeFilesetsOutput {
	s.IOPSQos = &v
	return s
}

// SetMaxInodeNum sets the MaxInodeNum field's value.
func (s *FilesetForDescribeFilesetsOutput) SetMaxInodeNum(v int64) *FilesetForDescribeFilesetsOutput {
	s.MaxInodeNum = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *FilesetForDescribeFilesetsOutput) SetStatus(v string) *FilesetForDescribeFilesetsOutput {
	s.Status = &v
	return s
}

type FilterForDescribeFilesetsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty" enum:"EnumOfKeyForDescribeFilesetsInput"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s FilterForDescribeFilesetsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FilterForDescribeFilesetsInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *FilterForDescribeFilesetsInput) SetKey(v string) *FilterForDescribeFilesetsInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *FilterForDescribeFilesetsInput) SetValue(v string) *FilterForDescribeFilesetsInput {
	s.Value = &v
	return s
}

const (
	// EnumOfKeyForDescribeFilesetsInputFilesetName is a EnumOfKeyForDescribeFilesetsInput enum value
	EnumOfKeyForDescribeFilesetsInputFilesetName = "FilesetName"

	// EnumOfKeyForDescribeFilesetsInputFilesetId is a EnumOfKeyForDescribeFilesetsInput enum value
	EnumOfKeyForDescribeFilesetsInputFilesetId = "FilesetId"

	// EnumOfKeyForDescribeFilesetsInputFilesetPath is a EnumOfKeyForDescribeFilesetsInput enum value
	EnumOfKeyForDescribeFilesetsInputFilesetPath = "FilesetPath"

	// EnumOfKeyForDescribeFilesetsInputStatus is a EnumOfKeyForDescribeFilesetsInput enum value
	EnumOfKeyForDescribeFilesetsInputStatus = "Status"
)

const (
	// EnumOfOrderByForDescribeFilesetsInputCreateTimeDesc is a EnumOfOrderByForDescribeFilesetsInput enum value
	EnumOfOrderByForDescribeFilesetsInputCreateTimeDesc = "CreateTimeDesc"

	// EnumOfOrderByForDescribeFilesetsInputCreateTimeAsc is a EnumOfOrderByForDescribeFilesetsInput enum value
	EnumOfOrderByForDescribeFilesetsInputCreateTimeAsc = "CreateTimeAsc"

	// EnumOfOrderByForDescribeFilesetsInputNameDesc is a EnumOfOrderByForDescribeFilesetsInput enum value
	EnumOfOrderByForDescribeFilesetsInputNameDesc = "NameDesc"

	// EnumOfOrderByForDescribeFilesetsInputNameAsc is a EnumOfOrderByForDescribeFilesetsInput enum value
	EnumOfOrderByForDescribeFilesetsInputNameAsc = "NameAsc"
)

const (
	// EnumOfStatusForDescribeFilesetsOutputCreating is a EnumOfStatusForDescribeFilesetsOutput enum value
	EnumOfStatusForDescribeFilesetsOutputCreating = "Creating"

	// EnumOfStatusForDescribeFilesetsOutputCreateError is a EnumOfStatusForDescribeFilesetsOutput enum value
	EnumOfStatusForDescribeFilesetsOutputCreateError = "CreateError"

	// EnumOfStatusForDescribeFilesetsOutputRunning is a EnumOfStatusForDescribeFilesetsOutput enum value
	EnumOfStatusForDescribeFilesetsOutputRunning = "Running"

	// EnumOfStatusForDescribeFilesetsOutputUpdating is a EnumOfStatusForDescribeFilesetsOutput enum value
	EnumOfStatusForDescribeFilesetsOutputUpdating = "Updating"

	// EnumOfStatusForDescribeFilesetsOutputUpdateError is a EnumOfStatusForDescribeFilesetsOutput enum value
	EnumOfStatusForDescribeFilesetsOutputUpdateError = "UpdateError"

	// EnumOfStatusForDescribeFilesetsOutputDeleting is a EnumOfStatusForDescribeFilesetsOutput enum value
	EnumOfStatusForDescribeFilesetsOutputDeleting = "Deleting"

	// EnumOfStatusForDescribeFilesetsOutputDeleteError is a EnumOfStatusForDescribeFilesetsOutput enum value
	EnumOfStatusForDescribeFilesetsOutputDeleteError = "DeleteError"

	// EnumOfStatusForDescribeFilesetsOutputDeleted is a EnumOfStatusForDescribeFilesetsOutput enum value
	EnumOfStatusForDescribeFilesetsOutputDeleted = "Deleted"

	// EnumOfStatusForDescribeFilesetsOutputError is a EnumOfStatusForDescribeFilesetsOutput enum value
	EnumOfStatusForDescribeFilesetsOutputError = "Error"
)
