// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package veiapi

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListModelServiceCommon = "ListModelService"

// ListModelServiceCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListModelServiceCommon operation. The "output" return
// value will be populated with the ListModelServiceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListModelServiceCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListModelServiceCommon Send returns without error.
//
// See ListModelServiceCommon for more information on using the ListModelServiceCommon
// API call, and error handling.
//
//    // Example sending a request using the ListModelServiceCommonRequest method.
//    req, resp := client.ListModelServiceCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VEIAPI) ListModelServiceCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListModelServiceCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListModelServiceCommon API operation for VEI_API.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VEI_API's
// API operation ListModelServiceCommon for usage and error information.
func (c *VEIAPI) ListModelServiceCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListModelServiceCommonRequest(input)
	return out, req.Send()
}

// ListModelServiceCommonWithContext is the same as ListModelServiceCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListModelServiceCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VEIAPI) ListModelServiceCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListModelServiceCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListModelService = "ListModelService"

// ListModelServiceRequest generates a "volcengine/request.Request" representing the
// client's request for the ListModelService operation. The "output" return
// value will be populated with the ListModelServiceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListModelServiceCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListModelServiceCommon Send returns without error.
//
// See ListModelService for more information on using the ListModelService
// API call, and error handling.
//
//    // Example sending a request using the ListModelServiceRequest method.
//    req, resp := client.ListModelServiceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *VEIAPI) ListModelServiceRequest(input *ListModelServiceInput) (req *request.Request, output *ListModelServiceOutput) {
	op := &request.Operation{
		Name:       opListModelService,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListModelServiceInput{}
	}

	output = &ListModelServiceOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListModelService API operation for VEI_API.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for VEI_API's
// API operation ListModelService for usage and error information.
func (c *VEIAPI) ListModelService(input *ListModelServiceInput) (*ListModelServiceOutput, error) {
	req, out := c.ListModelServiceRequest(input)
	return out, req.Send()
}

// ListModelServiceWithContext is the same as ListModelService with the addition of
// the ability to pass a context and additional request options.
//
// See ListModelService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *VEIAPI) ListModelServiceWithContext(ctx volcengine.Context, input *ListModelServiceInput, opts ...request.Option) (*ListModelServiceOutput, error) {
	req, out := c.ListModelServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ItemForListModelServiceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s ItemForListModelServiceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ItemForListModelServiceOutput) GoString() string {
	return s.String()
}

type ListModelServiceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Name *string `type:"string" json:"name,omitempty"`

	Node_group_ids []*string `type:"list" json:"node_group_ids,omitempty"`

	Node_id *string `type:"string" json:"node_id,omitempty"`

	// Page_index is a required field
	Page_index *int32 `min:"1" type:"int32" json:"page_index,omitempty" required:"true"`

	// Page_size is a required field
	Page_size *int32 `min:"1" type:"int32" json:"page_size,omitempty" required:"true"`

	Project_id *string `type:"string" json:"project_id,omitempty"`

	Status *int32 `type:"int32" json:"status,omitempty"`
}

// String returns the string representation
func (s ListModelServiceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListModelServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListModelServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListModelServiceInput"}
	if s.Page_index == nil {
		invalidParams.Add(request.NewErrParamRequired("Page_index"))
	}
	if s.Page_index != nil && *s.Page_index < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Page_index", 1))
	}
	if s.Page_size == nil {
		invalidParams.Add(request.NewErrParamRequired("Page_size"))
	}
	if s.Page_size != nil && *s.Page_size < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Page_size", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *ListModelServiceInput) SetName(v string) *ListModelServiceInput {
	s.Name = &v
	return s
}

// SetNode_group_ids sets the Node_group_ids field's value.
func (s *ListModelServiceInput) SetNode_group_ids(v []*string) *ListModelServiceInput {
	s.Node_group_ids = v
	return s
}

// SetNode_id sets the Node_id field's value.
func (s *ListModelServiceInput) SetNode_id(v string) *ListModelServiceInput {
	s.Node_id = &v
	return s
}

// SetPage_index sets the Page_index field's value.
func (s *ListModelServiceInput) SetPage_index(v int32) *ListModelServiceInput {
	s.Page_index = &v
	return s
}

// SetPage_size sets the Page_size field's value.
func (s *ListModelServiceInput) SetPage_size(v int32) *ListModelServiceInput {
	s.Page_size = &v
	return s
}

// SetProject_id sets the Project_id field's value.
func (s *ListModelServiceInput) SetProject_id(v string) *ListModelServiceInput {
	s.Project_id = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListModelServiceInput) SetStatus(v int32) *ListModelServiceInput {
	s.Status = &v
	return s
}

type ListModelServiceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Items []*ItemForListModelServiceOutput `type:"list" json:"items,omitempty"`

	Pageinator *PageinatorForListModelServiceOutput `type:"structure" json:"pageinator,omitempty"`
}

// String returns the string representation
func (s ListModelServiceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListModelServiceOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListModelServiceOutput) SetItems(v []*ItemForListModelServiceOutput) *ListModelServiceOutput {
	s.Items = v
	return s
}

// SetPageinator sets the Pageinator field's value.
func (s *ListModelServiceOutput) SetPageinator(v *PageinatorForListModelServiceOutput) *ListModelServiceOutput {
	s.Pageinator = v
	return s
}

type PageinatorForListModelServiceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Index *int32 `type:"int32" json:"index,omitempty"`

	Size *int32 `type:"int32" json:"size,omitempty"`

	Total_items *int32 `type:"int32" json:"total_items,omitempty"`

	Total_pages *int32 `type:"int32" json:"total_pages,omitempty"`
}

// String returns the string representation
func (s PageinatorForListModelServiceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PageinatorForListModelServiceOutput) GoString() string {
	return s.String()
}

// SetIndex sets the Index field's value.
func (s *PageinatorForListModelServiceOutput) SetIndex(v int32) *PageinatorForListModelServiceOutput {
	s.Index = &v
	return s
}

// SetSize sets the Size field's value.
func (s *PageinatorForListModelServiceOutput) SetSize(v int32) *PageinatorForListModelServiceOutput {
	s.Size = &v
	return s
}

// SetTotal_items sets the Total_items field's value.
func (s *PageinatorForListModelServiceOutput) SetTotal_items(v int32) *PageinatorForListModelServiceOutput {
	s.Total_items = &v
	return s
}

// SetTotal_pages sets the Total_pages field's value.
func (s *PageinatorForListModelServiceOutput) SetTotal_pages(v int32) *PageinatorForListModelServiceOutput {
	s.Total_pages = &v
	return s
}
