// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package storageebs

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateAutoSnapshotPolicyCommon = "CreateAutoSnapshotPolicy"

// CreateAutoSnapshotPolicyCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateAutoSnapshotPolicyCommon operation. The "output" return
// value will be populated with the CreateAutoSnapshotPolicyCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateAutoSnapshotPolicyCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateAutoSnapshotPolicyCommon Send returns without error.
//
// See CreateAutoSnapshotPolicyCommon for more information on using the CreateAutoSnapshotPolicyCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateAutoSnapshotPolicyCommonRequest method.
//    req, resp := client.CreateAutoSnapshotPolicyCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *STORAGEEBS) CreateAutoSnapshotPolicyCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateAutoSnapshotPolicyCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// CreateAutoSnapshotPolicyCommon API operation for STORAGE_EBS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for STORAGE_EBS's
// API operation CreateAutoSnapshotPolicyCommon for usage and error information.
func (c *STORAGEEBS) CreateAutoSnapshotPolicyCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateAutoSnapshotPolicyCommonRequest(input)
	return out, req.Send()
}

// CreateAutoSnapshotPolicyCommonWithContext is the same as CreateAutoSnapshotPolicyCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAutoSnapshotPolicyCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *STORAGEEBS) CreateAutoSnapshotPolicyCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateAutoSnapshotPolicyCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateAutoSnapshotPolicy = "CreateAutoSnapshotPolicy"

// CreateAutoSnapshotPolicyRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateAutoSnapshotPolicy operation. The "output" return
// value will be populated with the CreateAutoSnapshotPolicyCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateAutoSnapshotPolicyCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateAutoSnapshotPolicyCommon Send returns without error.
//
// See CreateAutoSnapshotPolicy for more information on using the CreateAutoSnapshotPolicy
// API call, and error handling.
//
//    // Example sending a request using the CreateAutoSnapshotPolicyRequest method.
//    req, resp := client.CreateAutoSnapshotPolicyRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *STORAGEEBS) CreateAutoSnapshotPolicyRequest(input *CreateAutoSnapshotPolicyInput) (req *request.Request, output *CreateAutoSnapshotPolicyOutput) {
	op := &request.Operation{
		Name:       opCreateAutoSnapshotPolicy,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateAutoSnapshotPolicyInput{}
	}

	output = &CreateAutoSnapshotPolicyOutput{}
	req = c.newRequest(op, input, output)

	return
}

// CreateAutoSnapshotPolicy API operation for STORAGE_EBS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for STORAGE_EBS's
// API operation CreateAutoSnapshotPolicy for usage and error information.
func (c *STORAGEEBS) CreateAutoSnapshotPolicy(input *CreateAutoSnapshotPolicyInput) (*CreateAutoSnapshotPolicyOutput, error) {
	req, out := c.CreateAutoSnapshotPolicyRequest(input)
	return out, req.Send()
}

// CreateAutoSnapshotPolicyWithContext is the same as CreateAutoSnapshotPolicy with the addition of
// the ability to pass a context and additional request options.
//
// See CreateAutoSnapshotPolicy for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *STORAGEEBS) CreateAutoSnapshotPolicyWithContext(ctx volcengine.Context, input *CreateAutoSnapshotPolicyInput, opts ...request.Option) (*CreateAutoSnapshotPolicyOutput, error) {
	req, out := c.CreateAutoSnapshotPolicyRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateAutoSnapshotPolicyInput struct {
	_ struct{} `type:"structure"`

	// AutoSnapshotPolicyName is a required field
	AutoSnapshotPolicyName *string `type:"string" required:"true"`

	DestinationRegion *string `type:"string"`

	DestinationRetentionDays *int32 `max:"65536" type:"int32"`

	EnableCopy *bool `type:"boolean"`

	ProjectName *string `type:"string"`

	RepeatDays *int32 `type:"int32"`

	RepeatWeekdays []*string `type:"list"`

	// RetentionDays is a required field
	RetentionDays *int32 `type:"int32" required:"true"`

	Tags []*TagForCreateAutoSnapshotPolicyInput `type:"list"`

	// TimePoints is a required field
	TimePoints []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s CreateAutoSnapshotPolicyInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAutoSnapshotPolicyInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateAutoSnapshotPolicyInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateAutoSnapshotPolicyInput"}
	if s.AutoSnapshotPolicyName == nil {
		invalidParams.Add(request.NewErrParamRequired("AutoSnapshotPolicyName"))
	}
	if s.DestinationRetentionDays != nil && *s.DestinationRetentionDays < -1 {
		invalidParams.Add(request.NewErrParamMinValue("DestinationRetentionDays", -1))
	}
	if s.DestinationRetentionDays != nil && *s.DestinationRetentionDays > 65536 {
		invalidParams.Add(request.NewErrParamMaxValue("DestinationRetentionDays", 65536))
	}
	if s.RetentionDays == nil {
		invalidParams.Add(request.NewErrParamRequired("RetentionDays"))
	}
	if s.TimePoints == nil {
		invalidParams.Add(request.NewErrParamRequired("TimePoints"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoSnapshotPolicyName sets the AutoSnapshotPolicyName field's value.
func (s *CreateAutoSnapshotPolicyInput) SetAutoSnapshotPolicyName(v string) *CreateAutoSnapshotPolicyInput {
	s.AutoSnapshotPolicyName = &v
	return s
}

// SetDestinationRegion sets the DestinationRegion field's value.
func (s *CreateAutoSnapshotPolicyInput) SetDestinationRegion(v string) *CreateAutoSnapshotPolicyInput {
	s.DestinationRegion = &v
	return s
}

// SetDestinationRetentionDays sets the DestinationRetentionDays field's value.
func (s *CreateAutoSnapshotPolicyInput) SetDestinationRetentionDays(v int32) *CreateAutoSnapshotPolicyInput {
	s.DestinationRetentionDays = &v
	return s
}

// SetEnableCopy sets the EnableCopy field's value.
func (s *CreateAutoSnapshotPolicyInput) SetEnableCopy(v bool) *CreateAutoSnapshotPolicyInput {
	s.EnableCopy = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateAutoSnapshotPolicyInput) SetProjectName(v string) *CreateAutoSnapshotPolicyInput {
	s.ProjectName = &v
	return s
}

// SetRepeatDays sets the RepeatDays field's value.
func (s *CreateAutoSnapshotPolicyInput) SetRepeatDays(v int32) *CreateAutoSnapshotPolicyInput {
	s.RepeatDays = &v
	return s
}

// SetRepeatWeekdays sets the RepeatWeekdays field's value.
func (s *CreateAutoSnapshotPolicyInput) SetRepeatWeekdays(v []*string) *CreateAutoSnapshotPolicyInput {
	s.RepeatWeekdays = v
	return s
}

// SetRetentionDays sets the RetentionDays field's value.
func (s *CreateAutoSnapshotPolicyInput) SetRetentionDays(v int32) *CreateAutoSnapshotPolicyInput {
	s.RetentionDays = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateAutoSnapshotPolicyInput) SetTags(v []*TagForCreateAutoSnapshotPolicyInput) *CreateAutoSnapshotPolicyInput {
	s.Tags = v
	return s
}

// SetTimePoints sets the TimePoints field's value.
func (s *CreateAutoSnapshotPolicyInput) SetTimePoints(v []*string) *CreateAutoSnapshotPolicyInput {
	s.TimePoints = v
	return s
}

type CreateAutoSnapshotPolicyOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	AutoSnapshotPolicyId *string `type:"string"`
}

// String returns the string representation
func (s CreateAutoSnapshotPolicyOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateAutoSnapshotPolicyOutput) GoString() string {
	return s.String()
}

// SetAutoSnapshotPolicyId sets the AutoSnapshotPolicyId field's value.
func (s *CreateAutoSnapshotPolicyOutput) SetAutoSnapshotPolicyId(v string) *CreateAutoSnapshotPolicyOutput {
	s.AutoSnapshotPolicyId = &v
	return s
}

type TagForCreateAutoSnapshotPolicyInput struct {
	_ struct{} `type:"structure"`

	Key *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s TagForCreateAutoSnapshotPolicyInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForCreateAutoSnapshotPolicyInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForCreateAutoSnapshotPolicyInput) SetKey(v string) *TagForCreateAutoSnapshotPolicyInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForCreateAutoSnapshotPolicyInput) SetValue(v string) *TagForCreateAutoSnapshotPolicyInput {
	s.Value = &v
	return s
}
