// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package sqs

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opSendMessageCommon = "SendMessage"

// SendMessageCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the SendMessageCommon operation. The "output" return
// value will be populated with the SendMessageCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned SendMessageCommon Request to send the API call to the service.
// the "output" return value is not valid until after SendMessageCommon Send returns without error.
//
// See SendMessageCommon for more information on using the SendMessageCommon
// API call, and error handling.
//
//    // Example sending a request using the SendMessageCommonRequest method.
//    req, resp := client.SendMessageCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SQS) SendMessageCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opSendMessageCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// SendMessageCommon API operation for SQS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for SQS's
// API operation SendMessageCommon for usage and error information.
func (c *SQS) SendMessageCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.SendMessageCommonRequest(input)
	return out, req.Send()
}

// SendMessageCommonWithContext is the same as SendMessageCommon with the addition of
// the ability to pass a context and additional request options.
//
// See SendMessageCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SQS) SendMessageCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.SendMessageCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opSendMessage = "SendMessage"

// SendMessageRequest generates a "volcengine/request.Request" representing the
// client's request for the SendMessage operation. The "output" return
// value will be populated with the SendMessageCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned SendMessageCommon Request to send the API call to the service.
// the "output" return value is not valid until after SendMessageCommon Send returns without error.
//
// See SendMessage for more information on using the SendMessage
// API call, and error handling.
//
//    // Example sending a request using the SendMessageRequest method.
//    req, resp := client.SendMessageRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SQS) SendMessageRequest(input *SendMessageInput) (req *request.Request, output *SendMessageOutput) {
	op := &request.Operation{
		Name:       opSendMessage,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &SendMessageInput{}
	}

	output = &SendMessageOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// SendMessage API operation for SQS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for SQS's
// API operation SendMessage for usage and error information.
func (c *SQS) SendMessage(input *SendMessageInput) (*SendMessageOutput, error) {
	req, out := c.SendMessageRequest(input)
	return out, req.Send()
}

// SendMessageWithContext is the same as SendMessage with the addition of
// the ability to pass a context and additional request options.
//
// See SendMessage for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SQS) SendMessageWithContext(ctx volcengine.Context, input *SendMessageInput, opts ...request.Option) (*SendMessageOutput, error) {
	req, out := c.SendMessageRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type SendMessageInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// MessageBody is a required field
	MessageBody *string `min:"1" max:"262144" type:"string" json:",omitempty" required:"true"`

	// QueueTrn is a required field
	QueueTrn *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s SendMessageInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SendMessageInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *SendMessageInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "SendMessageInput"}
	if s.MessageBody == nil {
		invalidParams.Add(request.NewErrParamRequired("MessageBody"))
	}
	if s.MessageBody != nil && len(*s.MessageBody) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("MessageBody", 1))
	}
	if s.MessageBody != nil && len(*s.MessageBody) > 262144 {
		invalidParams.Add(request.NewErrParamMaxLen("MessageBody", 262144, *s.MessageBody))
	}
	if s.QueueTrn == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueTrn"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMessageBody sets the MessageBody field's value.
func (s *SendMessageInput) SetMessageBody(v string) *SendMessageInput {
	s.MessageBody = &v
	return s
}

// SetQueueTrn sets the QueueTrn field's value.
func (s *SendMessageInput) SetQueueTrn(v string) *SendMessageInput {
	s.QueueTrn = &v
	return s
}

type SendMessageOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	MessageId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s SendMessageOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SendMessageOutput) GoString() string {
	return s.String()
}

// SetMessageId sets the MessageId field's value.
func (s *SendMessageOutput) SetMessageId(v string) *SendMessageOutput {
	s.MessageId = &v
	return s
}
