// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package sqs

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateQueueCommon = "CreateQueue"

// CreateQueueCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateQueueCommon operation. The "output" return
// value will be populated with the CreateQueueCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateQueueCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateQueueCommon Send returns without error.
//
// See CreateQueueCommon for more information on using the CreateQueueCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateQueueCommonRequest method.
//    req, resp := client.CreateQueueCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SQS) CreateQueueCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateQueueCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateQueueCommon API operation for SQS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for SQS's
// API operation CreateQueueCommon for usage and error information.
func (c *SQS) CreateQueueCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateQueueCommonRequest(input)
	return out, req.Send()
}

// CreateQueueCommonWithContext is the same as CreateQueueCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateQueueCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SQS) CreateQueueCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateQueueCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateQueue = "CreateQueue"

// CreateQueueRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateQueue operation. The "output" return
// value will be populated with the CreateQueueCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateQueueCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateQueueCommon Send returns without error.
//
// See CreateQueue for more information on using the CreateQueue
// API call, and error handling.
//
//    // Example sending a request using the CreateQueueRequest method.
//    req, resp := client.CreateQueueRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SQS) CreateQueueRequest(input *CreateQueueInput) (req *request.Request, output *CreateQueueOutput) {
	op := &request.Operation{
		Name:       opCreateQueue,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateQueueInput{}
	}

	output = &CreateQueueOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateQueue API operation for SQS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for SQS's
// API operation CreateQueue for usage and error information.
func (c *SQS) CreateQueue(input *CreateQueueInput) (*CreateQueueOutput, error) {
	req, out := c.CreateQueueRequest(input)
	return out, req.Send()
}

// CreateQueueWithContext is the same as CreateQueue with the addition of
// the ability to pass a context and additional request options.
//
// See CreateQueue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SQS) CreateQueueWithContext(ctx volcengine.Context, input *CreateQueueInput, opts ...request.Option) (*CreateQueueOutput, error) {
	req, out := c.CreateQueueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateQueueInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	MessageRetentionPeriod *int32 `min:"60" max:"604800" type:"int32" json:",omitempty"`

	// QueueDisplayName is a required field
	QueueDisplayName *string `min:"1" max:"255" type:"string" json:",omitempty" required:"true"`

	VisibilityTimeout *int32 `max:"600" type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s CreateQueueInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateQueueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateQueueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateQueueInput"}
	if s.MessageRetentionPeriod != nil && *s.MessageRetentionPeriod < 60 {
		invalidParams.Add(request.NewErrParamMinValue("MessageRetentionPeriod", 60))
	}
	if s.MessageRetentionPeriod != nil && *s.MessageRetentionPeriod > 604800 {
		invalidParams.Add(request.NewErrParamMaxValue("MessageRetentionPeriod", 604800))
	}
	if s.QueueDisplayName == nil {
		invalidParams.Add(request.NewErrParamRequired("QueueDisplayName"))
	}
	if s.QueueDisplayName != nil && len(*s.QueueDisplayName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("QueueDisplayName", 1))
	}
	if s.QueueDisplayName != nil && len(*s.QueueDisplayName) > 255 {
		invalidParams.Add(request.NewErrParamMaxLen("QueueDisplayName", 255, *s.QueueDisplayName))
	}
	if s.VisibilityTimeout != nil && *s.VisibilityTimeout > 600 {
		invalidParams.Add(request.NewErrParamMaxValue("VisibilityTimeout", 600))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMessageRetentionPeriod sets the MessageRetentionPeriod field's value.
func (s *CreateQueueInput) SetMessageRetentionPeriod(v int32) *CreateQueueInput {
	s.MessageRetentionPeriod = &v
	return s
}

// SetQueueDisplayName sets the QueueDisplayName field's value.
func (s *CreateQueueInput) SetQueueDisplayName(v string) *CreateQueueInput {
	s.QueueDisplayName = &v
	return s
}

// SetVisibilityTimeout sets the VisibilityTimeout field's value.
func (s *CreateQueueInput) SetVisibilityTimeout(v int32) *CreateQueueInput {
	s.VisibilityTimeout = &v
	return s
}

type CreateQueueOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	QueueTrn *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateQueueOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateQueueOutput) GoString() string {
	return s.String()
}

// SetQueueTrn sets the QueueTrn field's value.
func (s *CreateQueueOutput) SetQueueTrn(v string) *CreateQueueOutput {
	s.QueueTrn = &v
	return s
}
