// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package speechsaasprod

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opResourcePacksStatusCommon = "ResourcePacksStatus"

// ResourcePacksStatusCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ResourcePacksStatusCommon operation. The "output" return
// value will be populated with the ResourcePacksStatusCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ResourcePacksStatusCommon Request to send the API call to the service.
// the "output" return value is not valid until after ResourcePacksStatusCommon Send returns without error.
//
// See ResourcePacksStatusCommon for more information on using the ResourcePacksStatusCommon
// API call, and error handling.
//
//    // Example sending a request using the ResourcePacksStatusCommonRequest method.
//    req, resp := client.ResourcePacksStatusCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SPEECHSAASPROD) ResourcePacksStatusCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opResourcePacksStatusCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ResourcePacksStatusCommon API operation for SPEECH_SAAS_PROD.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for SPEECH_SAAS_PROD's
// API operation ResourcePacksStatusCommon for usage and error information.
func (c *SPEECHSAASPROD) ResourcePacksStatusCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ResourcePacksStatusCommonRequest(input)
	return out, req.Send()
}

// ResourcePacksStatusCommonWithContext is the same as ResourcePacksStatusCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ResourcePacksStatusCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SPEECHSAASPROD) ResourcePacksStatusCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ResourcePacksStatusCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opResourcePacksStatus = "ResourcePacksStatus"

// ResourcePacksStatusRequest generates a "volcengine/request.Request" representing the
// client's request for the ResourcePacksStatus operation. The "output" return
// value will be populated with the ResourcePacksStatusCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ResourcePacksStatusCommon Request to send the API call to the service.
// the "output" return value is not valid until after ResourcePacksStatusCommon Send returns without error.
//
// See ResourcePacksStatus for more information on using the ResourcePacksStatus
// API call, and error handling.
//
//    // Example sending a request using the ResourcePacksStatusRequest method.
//    req, resp := client.ResourcePacksStatusRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *SPEECHSAASPROD) ResourcePacksStatusRequest(input *ResourcePacksStatusInput) (req *request.Request, output *ResourcePacksStatusOutput) {
	op := &request.Operation{
		Name:       opResourcePacksStatus,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ResourcePacksStatusInput{}
	}

	output = &ResourcePacksStatusOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ResourcePacksStatus API operation for SPEECH_SAAS_PROD.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for SPEECH_SAAS_PROD's
// API operation ResourcePacksStatus for usage and error information.
func (c *SPEECHSAASPROD) ResourcePacksStatus(input *ResourcePacksStatusInput) (*ResourcePacksStatusOutput, error) {
	req, out := c.ResourcePacksStatusRequest(input)
	return out, req.Send()
}

// ResourcePacksStatusWithContext is the same as ResourcePacksStatus with the addition of
// the ability to pass a context and additional request options.
//
// See ResourcePacksStatus for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *SPEECHSAASPROD) ResourcePacksStatusWithContext(ctx volcengine.Context, input *ResourcePacksStatusInput, opts ...request.Option) (*ResourcePacksStatusOutput, error) {
	req, out := c.ResourcePacksStatusRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AttributesForResourcePacksStatusOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CodeAttribute *CodeAttributeForResourcePacksStatusOutput `type:"structure" json:",omitempty"`

	FormalizedFrom *string `type:"string" json:",omitempty"`

	IsForcedExpiresDisplay *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s AttributesForResourcePacksStatusOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AttributesForResourcePacksStatusOutput) GoString() string {
	return s.String()
}

// SetCodeAttribute sets the CodeAttribute field's value.
func (s *AttributesForResourcePacksStatusOutput) SetCodeAttribute(v *CodeAttributeForResourcePacksStatusOutput) *AttributesForResourcePacksStatusOutput {
	s.CodeAttribute = v
	return s
}

// SetFormalizedFrom sets the FormalizedFrom field's value.
func (s *AttributesForResourcePacksStatusOutput) SetFormalizedFrom(v string) *AttributesForResourcePacksStatusOutput {
	s.FormalizedFrom = &v
	return s
}

// SetIsForcedExpiresDisplay sets the IsForcedExpiresDisplay field's value.
func (s *AttributesForResourcePacksStatusOutput) SetIsForcedExpiresDisplay(v bool) *AttributesForResourcePacksStatusOutput {
	s.IsForcedExpiresDisplay = &v
	return s
}

type CodeAttributeForResourcePacksStatusOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CodeAttributeForResourcePacksStatusOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CodeAttributeForResourcePacksStatusOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *CodeAttributeForResourcePacksStatusOutput) SetName(v string) *CodeAttributeForResourcePacksStatusOutput {
	s.Name = &v
	return s
}

type DetailsForResourcePacksStatusOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Aliasable *bool `type:"boolean" json:",omitempty"`

	DemoLink *string `type:"string" json:",omitempty"`

	ExtraApiAllowed *bool `type:"boolean" json:",omitempty"`

	Formalizable *bool `type:"boolean" json:",omitempty"`

	Language *string `type:"string" json:",omitempty"`

	MegattsTraining *MegattsTrainingForResourcePacksStatusOutput `type:"structure" json:",omitempty"`

	RecommendedScenario *string `type:"string" json:",omitempty"`

	ToneNumber *string `type:"string" json:",omitempty"`

	VoiceType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s DetailsForResourcePacksStatusOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DetailsForResourcePacksStatusOutput) GoString() string {
	return s.String()
}

// SetAliasable sets the Aliasable field's value.
func (s *DetailsForResourcePacksStatusOutput) SetAliasable(v bool) *DetailsForResourcePacksStatusOutput {
	s.Aliasable = &v
	return s
}

// SetDemoLink sets the DemoLink field's value.
func (s *DetailsForResourcePacksStatusOutput) SetDemoLink(v string) *DetailsForResourcePacksStatusOutput {
	s.DemoLink = &v
	return s
}

// SetExtraApiAllowed sets the ExtraApiAllowed field's value.
func (s *DetailsForResourcePacksStatusOutput) SetExtraApiAllowed(v bool) *DetailsForResourcePacksStatusOutput {
	s.ExtraApiAllowed = &v
	return s
}

// SetFormalizable sets the Formalizable field's value.
func (s *DetailsForResourcePacksStatusOutput) SetFormalizable(v bool) *DetailsForResourcePacksStatusOutput {
	s.Formalizable = &v
	return s
}

// SetLanguage sets the Language field's value.
func (s *DetailsForResourcePacksStatusOutput) SetLanguage(v string) *DetailsForResourcePacksStatusOutput {
	s.Language = &v
	return s
}

// SetMegattsTraining sets the MegattsTraining field's value.
func (s *DetailsForResourcePacksStatusOutput) SetMegattsTraining(v *MegattsTrainingForResourcePacksStatusOutput) *DetailsForResourcePacksStatusOutput {
	s.MegattsTraining = v
	return s
}

// SetRecommendedScenario sets the RecommendedScenario field's value.
func (s *DetailsForResourcePacksStatusOutput) SetRecommendedScenario(v string) *DetailsForResourcePacksStatusOutput {
	s.RecommendedScenario = &v
	return s
}

// SetToneNumber sets the ToneNumber field's value.
func (s *DetailsForResourcePacksStatusOutput) SetToneNumber(v string) *DetailsForResourcePacksStatusOutput {
	s.ToneNumber = &v
	return s
}

// SetVoiceType sets the VoiceType field's value.
func (s *DetailsForResourcePacksStatusOutput) SetVoiceType(v string) *DetailsForResourcePacksStatusOutput {
	s.VoiceType = &v
	return s
}

type HarvestForResourcePacksStatusOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CropType *string `type:"string" json:",omitempty"`

	CurrentUsage *float64 `type:"float" json:",omitempty"`

	PurchasedAmount *float64 `type:"float" json:",omitempty"`

	ResourceID *string `type:"string" json:",omitempty"`

	Unit *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s HarvestForResourcePacksStatusOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HarvestForResourcePacksStatusOutput) GoString() string {
	return s.String()
}

// SetCropType sets the CropType field's value.
func (s *HarvestForResourcePacksStatusOutput) SetCropType(v string) *HarvestForResourcePacksStatusOutput {
	s.CropType = &v
	return s
}

// SetCurrentUsage sets the CurrentUsage field's value.
func (s *HarvestForResourcePacksStatusOutput) SetCurrentUsage(v float64) *HarvestForResourcePacksStatusOutput {
	s.CurrentUsage = &v
	return s
}

// SetPurchasedAmount sets the PurchasedAmount field's value.
func (s *HarvestForResourcePacksStatusOutput) SetPurchasedAmount(v float64) *HarvestForResourcePacksStatusOutput {
	s.PurchasedAmount = &v
	return s
}

// SetResourceID sets the ResourceID field's value.
func (s *HarvestForResourcePacksStatusOutput) SetResourceID(v string) *HarvestForResourcePacksStatusOutput {
	s.ResourceID = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *HarvestForResourcePacksStatusOutput) SetUnit(v string) *HarvestForResourcePacksStatusOutput {
	s.Unit = &v
	return s
}

type MegattsTrainingForResourcePacksStatusOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AvailableTrainingTimes *int32 `type:"int32" json:",omitempty"`

	CreateTime *int32 `type:"int32" json:",omitempty"`

	IsActivatable *bool `type:"boolean" json:",omitempty"`

	State *string `type:"string" json:",omitempty"`

	Version *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s MegattsTrainingForResourcePacksStatusOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MegattsTrainingForResourcePacksStatusOutput) GoString() string {
	return s.String()
}

// SetAvailableTrainingTimes sets the AvailableTrainingTimes field's value.
func (s *MegattsTrainingForResourcePacksStatusOutput) SetAvailableTrainingTimes(v int32) *MegattsTrainingForResourcePacksStatusOutput {
	s.AvailableTrainingTimes = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *MegattsTrainingForResourcePacksStatusOutput) SetCreateTime(v int32) *MegattsTrainingForResourcePacksStatusOutput {
	s.CreateTime = &v
	return s
}

// SetIsActivatable sets the IsActivatable field's value.
func (s *MegattsTrainingForResourcePacksStatusOutput) SetIsActivatable(v bool) *MegattsTrainingForResourcePacksStatusOutput {
	s.IsActivatable = &v
	return s
}

// SetState sets the State field's value.
func (s *MegattsTrainingForResourcePacksStatusOutput) SetState(v string) *MegattsTrainingForResourcePacksStatusOutput {
	s.State = &v
	return s
}

// SetVersion sets the Version field's value.
func (s *MegattsTrainingForResourcePacksStatusOutput) SetVersion(v string) *MegattsTrainingForResourcePacksStatusOutput {
	s.Version = &v
	return s
}

type PackForResourcePacksStatusOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Alias *string `type:"string" json:",omitempty"`

	Attributes *AttributesForResourcePacksStatusOutput `type:"structure" json:",omitempty"`

	Code *string `type:"string" json:",omitempty"`

	ConfigurationCode *string `type:"string" json:",omitempty"`

	CurrentUsage *string `type:"string" json:",omitempty"`

	Details *DetailsForResourcePacksStatusOutput `type:"structure" json:",omitempty"`

	Expires *string `type:"string" json:",omitempty"`

	GroupName *string `type:"string" json:",omitempty"`

	Harvest *HarvestForResourcePacksStatusOutput `type:"structure" json:",omitempty"`

	InstanceNumber *string `type:"string" json:",omitempty"`

	IsShareable *bool `type:"boolean" json:",omitempty"`

	PackType *string `type:"string" json:",omitempty"`

	PurchasedAmount *string `type:"string" json:",omitempty"`

	RawType *string `type:"string" json:",omitempty"`

	ResourceDisplay *string `type:"string" json:",omitempty"`

	ResourceID *string `type:"string" json:",omitempty"`

	State *string `type:"string" json:",omitempty"`

	TrainID *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s PackForResourcePacksStatusOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PackForResourcePacksStatusOutput) GoString() string {
	return s.String()
}

// SetAlias sets the Alias field's value.
func (s *PackForResourcePacksStatusOutput) SetAlias(v string) *PackForResourcePacksStatusOutput {
	s.Alias = &v
	return s
}

// SetAttributes sets the Attributes field's value.
func (s *PackForResourcePacksStatusOutput) SetAttributes(v *AttributesForResourcePacksStatusOutput) *PackForResourcePacksStatusOutput {
	s.Attributes = v
	return s
}

// SetCode sets the Code field's value.
func (s *PackForResourcePacksStatusOutput) SetCode(v string) *PackForResourcePacksStatusOutput {
	s.Code = &v
	return s
}

// SetConfigurationCode sets the ConfigurationCode field's value.
func (s *PackForResourcePacksStatusOutput) SetConfigurationCode(v string) *PackForResourcePacksStatusOutput {
	s.ConfigurationCode = &v
	return s
}

// SetCurrentUsage sets the CurrentUsage field's value.
func (s *PackForResourcePacksStatusOutput) SetCurrentUsage(v string) *PackForResourcePacksStatusOutput {
	s.CurrentUsage = &v
	return s
}

// SetDetails sets the Details field's value.
func (s *PackForResourcePacksStatusOutput) SetDetails(v *DetailsForResourcePacksStatusOutput) *PackForResourcePacksStatusOutput {
	s.Details = v
	return s
}

// SetExpires sets the Expires field's value.
func (s *PackForResourcePacksStatusOutput) SetExpires(v string) *PackForResourcePacksStatusOutput {
	s.Expires = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *PackForResourcePacksStatusOutput) SetGroupName(v string) *PackForResourcePacksStatusOutput {
	s.GroupName = &v
	return s
}

// SetHarvest sets the Harvest field's value.
func (s *PackForResourcePacksStatusOutput) SetHarvest(v *HarvestForResourcePacksStatusOutput) *PackForResourcePacksStatusOutput {
	s.Harvest = v
	return s
}

// SetInstanceNumber sets the InstanceNumber field's value.
func (s *PackForResourcePacksStatusOutput) SetInstanceNumber(v string) *PackForResourcePacksStatusOutput {
	s.InstanceNumber = &v
	return s
}

// SetIsShareable sets the IsShareable field's value.
func (s *PackForResourcePacksStatusOutput) SetIsShareable(v bool) *PackForResourcePacksStatusOutput {
	s.IsShareable = &v
	return s
}

// SetPackType sets the PackType field's value.
func (s *PackForResourcePacksStatusOutput) SetPackType(v string) *PackForResourcePacksStatusOutput {
	s.PackType = &v
	return s
}

// SetPurchasedAmount sets the PurchasedAmount field's value.
func (s *PackForResourcePacksStatusOutput) SetPurchasedAmount(v string) *PackForResourcePacksStatusOutput {
	s.PurchasedAmount = &v
	return s
}

// SetRawType sets the RawType field's value.
func (s *PackForResourcePacksStatusOutput) SetRawType(v string) *PackForResourcePacksStatusOutput {
	s.RawType = &v
	return s
}

// SetResourceDisplay sets the ResourceDisplay field's value.
func (s *PackForResourcePacksStatusOutput) SetResourceDisplay(v string) *PackForResourcePacksStatusOutput {
	s.ResourceDisplay = &v
	return s
}

// SetResourceID sets the ResourceID field's value.
func (s *PackForResourcePacksStatusOutput) SetResourceID(v string) *PackForResourcePacksStatusOutput {
	s.ResourceID = &v
	return s
}

// SetState sets the State field's value.
func (s *PackForResourcePacksStatusOutput) SetState(v string) *PackForResourcePacksStatusOutput {
	s.State = &v
	return s
}

// SetTrainID sets the TrainID field's value.
func (s *PackForResourcePacksStatusOutput) SetTrainID(v string) *PackForResourcePacksStatusOutput {
	s.TrainID = &v
	return s
}

// SetType sets the Type field's value.
func (s *PackForResourcePacksStatusOutput) SetType(v string) *PackForResourcePacksStatusOutput {
	s.Type = &v
	return s
}

type ResourcePacksStatusInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DisplayRule *string `type:"string" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	// PageSize is a required field
	PageSize *int32 `min:"1" max:"100" type:"int32" json:",omitempty" required:"true"`

	// ProjectName is a required field
	ProjectName *string `type:"string" json:",omitempty" required:"true"`

	ResourceIDs []*string `type:"list" json:",omitempty"`

	TagFilters []*TagFilterForResourcePacksStatusInput `type:"list" json:",omitempty"`

	Types []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ResourcePacksStatusInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourcePacksStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ResourcePacksStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ResourcePacksStatusInput"}
	if s.PageSize == nil {
		invalidParams.Add(request.NewErrParamRequired("PageSize"))
	}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}
	if s.PageSize != nil && *s.PageSize > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("PageSize", 100))
	}
	if s.ProjectName == nil {
		invalidParams.Add(request.NewErrParamRequired("ProjectName"))
	}
	if s.TagFilters != nil {
		for i, v := range s.TagFilters {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "TagFilters", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDisplayRule sets the DisplayRule field's value.
func (s *ResourcePacksStatusInput) SetDisplayRule(v string) *ResourcePacksStatusInput {
	s.DisplayRule = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ResourcePacksStatusInput) SetPageNumber(v int32) *ResourcePacksStatusInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ResourcePacksStatusInput) SetPageSize(v int32) *ResourcePacksStatusInput {
	s.PageSize = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *ResourcePacksStatusInput) SetProjectName(v string) *ResourcePacksStatusInput {
	s.ProjectName = &v
	return s
}

// SetResourceIDs sets the ResourceIDs field's value.
func (s *ResourcePacksStatusInput) SetResourceIDs(v []*string) *ResourcePacksStatusInput {
	s.ResourceIDs = v
	return s
}

// SetTagFilters sets the TagFilters field's value.
func (s *ResourcePacksStatusInput) SetTagFilters(v []*TagFilterForResourcePacksStatusInput) *ResourcePacksStatusInput {
	s.TagFilters = v
	return s
}

// SetTypes sets the Types field's value.
func (s *ResourcePacksStatusInput) SetTypes(v []*string) *ResourcePacksStatusInput {
	s.Types = v
	return s
}

type ResourcePacksStatusOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	MaxResults *int32 `type:"int32" json:",omitempty"`

	NextToken *string `type:"string" json:",omitempty"`

	Packs []*PackForResourcePacksStatusOutput `type:"list" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`

	TotalHarvests []*TotalHarvestForResourcePacksStatusOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ResourcePacksStatusOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourcePacksStatusOutput) GoString() string {
	return s.String()
}

// SetMaxResults sets the MaxResults field's value.
func (s *ResourcePacksStatusOutput) SetMaxResults(v int32) *ResourcePacksStatusOutput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ResourcePacksStatusOutput) SetNextToken(v string) *ResourcePacksStatusOutput {
	s.NextToken = &v
	return s
}

// SetPacks sets the Packs field's value.
func (s *ResourcePacksStatusOutput) SetPacks(v []*PackForResourcePacksStatusOutput) *ResourcePacksStatusOutput {
	s.Packs = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ResourcePacksStatusOutput) SetPageNumber(v int32) *ResourcePacksStatusOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ResourcePacksStatusOutput) SetPageSize(v int32) *ResourcePacksStatusOutput {
	s.PageSize = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ResourcePacksStatusOutput) SetTotalCount(v int32) *ResourcePacksStatusOutput {
	s.TotalCount = &v
	return s
}

// SetTotalHarvests sets the TotalHarvests field's value.
func (s *ResourcePacksStatusOutput) SetTotalHarvests(v []*TotalHarvestForResourcePacksStatusOutput) *ResourcePacksStatusOutput {
	s.TotalHarvests = v
	return s
}

type TagFilterForResourcePacksStatusInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `max:"128" type:"string" json:",omitempty"`

	Values []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s TagFilterForResourcePacksStatusInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagFilterForResourcePacksStatusInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagFilterForResourcePacksStatusInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagFilterForResourcePacksStatusInput"}
	if s.Key != nil && len(*s.Key) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("Key", 128, *s.Key))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKey sets the Key field's value.
func (s *TagFilterForResourcePacksStatusInput) SetKey(v string) *TagFilterForResourcePacksStatusInput {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *TagFilterForResourcePacksStatusInput) SetValues(v []*string) *TagFilterForResourcePacksStatusInput {
	s.Values = v
	return s
}

type TotalHarvestForResourcePacksStatusOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CropType *string `type:"string" json:",omitempty"`

	CurrentUsage *float64 `type:"float" json:",omitempty"`

	PurchasedAmount *float64 `type:"float" json:",omitempty"`

	ResourceID *string `type:"string" json:",omitempty"`

	Unit *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TotalHarvestForResourcePacksStatusOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TotalHarvestForResourcePacksStatusOutput) GoString() string {
	return s.String()
}

// SetCropType sets the CropType field's value.
func (s *TotalHarvestForResourcePacksStatusOutput) SetCropType(v string) *TotalHarvestForResourcePacksStatusOutput {
	s.CropType = &v
	return s
}

// SetCurrentUsage sets the CurrentUsage field's value.
func (s *TotalHarvestForResourcePacksStatusOutput) SetCurrentUsage(v float64) *TotalHarvestForResourcePacksStatusOutput {
	s.CurrentUsage = &v
	return s
}

// SetPurchasedAmount sets the PurchasedAmount field's value.
func (s *TotalHarvestForResourcePacksStatusOutput) SetPurchasedAmount(v float64) *TotalHarvestForResourcePacksStatusOutput {
	s.PurchasedAmount = &v
	return s
}

// SetResourceID sets the ResourceID field's value.
func (s *TotalHarvestForResourcePacksStatusOutput) SetResourceID(v string) *TotalHarvestForResourcePacksStatusOutput {
	s.ResourceID = &v
	return s
}

// SetUnit sets the Unit field's value.
func (s *TotalHarvestForResourcePacksStatusOutput) SetUnit(v string) *TotalHarvestForResourcePacksStatusOutput {
	s.Unit = &v
	return s
}
