// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package rocketmq

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeTopicGroupsCommon = "DescribeTopicGroups"

// DescribeTopicGroupsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeTopicGroupsCommon operation. The "output" return
// value will be populated with the DescribeTopicGroupsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeTopicGroupsCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeTopicGroupsCommon Send returns without error.
//
// See DescribeTopicGroupsCommon for more information on using the DescribeTopicGroupsCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeTopicGroupsCommonRequest method.
//    req, resp := client.DescribeTopicGroupsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ROCKETMQ) DescribeTopicGroupsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeTopicGroupsCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeTopicGroupsCommon API operation for ROCKETMQ.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ROCKETMQ's
// API operation DescribeTopicGroupsCommon for usage and error information.
func (c *ROCKETMQ) DescribeTopicGroupsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeTopicGroupsCommonRequest(input)
	return out, req.Send()
}

// DescribeTopicGroupsCommonWithContext is the same as DescribeTopicGroupsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTopicGroupsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ROCKETMQ) DescribeTopicGroupsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeTopicGroupsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTopicGroups = "DescribeTopicGroups"

// DescribeTopicGroupsRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeTopicGroups operation. The "output" return
// value will be populated with the DescribeTopicGroupsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeTopicGroupsCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeTopicGroupsCommon Send returns without error.
//
// See DescribeTopicGroups for more information on using the DescribeTopicGroups
// API call, and error handling.
//
//    // Example sending a request using the DescribeTopicGroupsRequest method.
//    req, resp := client.DescribeTopicGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ROCKETMQ) DescribeTopicGroupsRequest(input *DescribeTopicGroupsInput) (req *request.Request, output *DescribeTopicGroupsOutput) {
	op := &request.Operation{
		Name:       opDescribeTopicGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTopicGroupsInput{}
	}

	output = &DescribeTopicGroupsOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeTopicGroups API operation for ROCKETMQ.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ROCKETMQ's
// API operation DescribeTopicGroups for usage and error information.
func (c *ROCKETMQ) DescribeTopicGroups(input *DescribeTopicGroupsInput) (*DescribeTopicGroupsOutput, error) {
	req, out := c.DescribeTopicGroupsRequest(input)
	return out, req.Send()
}

// DescribeTopicGroupsWithContext is the same as DescribeTopicGroups with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTopicGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ROCKETMQ) DescribeTopicGroupsWithContext(ctx volcengine.Context, input *DescribeTopicGroupsInput, opts ...request.Option) (*DescribeTopicGroupsOutput, error) {
	req, out := c.DescribeTopicGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DescribeTopicGroupsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	GroupIds []*string `type:"list" json:",omitempty"`

	// InstanceId is a required field
	InstanceId *string `type:"string" json:",omitempty" required:"true"`

	// PageNumber is a required field
	PageNumber *int32 `type:"int32" json:",omitempty" required:"true"`

	// PageSize is a required field
	PageSize *int32 `type:"int32" json:",omitempty" required:"true"`

	// TopicName is a required field
	TopicName *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s DescribeTopicGroupsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTopicGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTopicGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTopicGroupsInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.PageNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PageNumber"))
	}
	if s.PageSize == nil {
		invalidParams.Add(request.NewErrParamRequired("PageSize"))
	}
	if s.TopicName == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupIds sets the GroupIds field's value.
func (s *DescribeTopicGroupsInput) SetGroupIds(v []*string) *DescribeTopicGroupsInput {
	s.GroupIds = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeTopicGroupsInput) SetInstanceId(v string) *DescribeTopicGroupsInput {
	s.InstanceId = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *DescribeTopicGroupsInput) SetPageNumber(v int32) *DescribeTopicGroupsInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribeTopicGroupsInput) SetPageSize(v int32) *DescribeTopicGroupsInput {
	s.PageSize = &v
	return s
}

// SetTopicName sets the TopicName field's value.
func (s *DescribeTopicGroupsInput) SetTopicName(v string) *DescribeTopicGroupsInput {
	s.TopicName = &v
	return s
}

type DescribeTopicGroupsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	GroupsInfo []*GroupsInfoForDescribeTopicGroupsOutput `type:"list" json:",omitempty"`

	Total *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s DescribeTopicGroupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTopicGroupsOutput) GoString() string {
	return s.String()
}

// SetGroupsInfo sets the GroupsInfo field's value.
func (s *DescribeTopicGroupsOutput) SetGroupsInfo(v []*GroupsInfoForDescribeTopicGroupsOutput) *DescribeTopicGroupsOutput {
	s.GroupsInfo = v
	return s
}

// SetTotal sets the Total field's value.
func (s *DescribeTopicGroupsOutput) SetTotal(v int32) *DescribeTopicGroupsOutput {
	s.Total = &v
	return s
}

type GroupsInfoForDescribeTopicGroupsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	GroupId *string `type:"string" json:",omitempty"`

	MessageModel *string `type:"string" json:",omitempty"`

	SubString *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s GroupsInfoForDescribeTopicGroupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupsInfoForDescribeTopicGroupsOutput) GoString() string {
	return s.String()
}

// SetGroupId sets the GroupId field's value.
func (s *GroupsInfoForDescribeTopicGroupsOutput) SetGroupId(v string) *GroupsInfoForDescribeTopicGroupsOutput {
	s.GroupId = &v
	return s
}

// SetMessageModel sets the MessageModel field's value.
func (s *GroupsInfoForDescribeTopicGroupsOutput) SetMessageModel(v string) *GroupsInfoForDescribeTopicGroupsOutput {
	s.MessageModel = &v
	return s
}

// SetSubString sets the SubString field's value.
func (s *GroupsInfoForDescribeTopicGroupsOutput) SetSubString(v string) *GroupsInfoForDescribeTopicGroupsOutput {
	s.SubString = &v
	return s
}
