// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package privatezone

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opQueryResolverEndpointCommon = "QueryResolverEndpoint"

// QueryResolverEndpointCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the QueryResolverEndpointCommon operation. The "output" return
// value will be populated with the QueryResolverEndpointCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned QueryResolverEndpointCommon Request to send the API call to the service.
// the "output" return value is not valid until after QueryResolverEndpointCommon Send returns without error.
//
// See QueryResolverEndpointCommon for more information on using the QueryResolverEndpointCommon
// API call, and error handling.
//
//    // Example sending a request using the QueryResolverEndpointCommonRequest method.
//    req, resp := client.QueryResolverEndpointCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *PRIVATEZONE) QueryResolverEndpointCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opQueryResolverEndpointCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// QueryResolverEndpointCommon API operation for PRIVATE_ZONE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for PRIVATE_ZONE's
// API operation QueryResolverEndpointCommon for usage and error information.
func (c *PRIVATEZONE) QueryResolverEndpointCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.QueryResolverEndpointCommonRequest(input)
	return out, req.Send()
}

// QueryResolverEndpointCommonWithContext is the same as QueryResolverEndpointCommon with the addition of
// the ability to pass a context and additional request options.
//
// See QueryResolverEndpointCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PRIVATEZONE) QueryResolverEndpointCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.QueryResolverEndpointCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opQueryResolverEndpoint = "QueryResolverEndpoint"

// QueryResolverEndpointRequest generates a "volcengine/request.Request" representing the
// client's request for the QueryResolverEndpoint operation. The "output" return
// value will be populated with the QueryResolverEndpointCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned QueryResolverEndpointCommon Request to send the API call to the service.
// the "output" return value is not valid until after QueryResolverEndpointCommon Send returns without error.
//
// See QueryResolverEndpoint for more information on using the QueryResolverEndpoint
// API call, and error handling.
//
//    // Example sending a request using the QueryResolverEndpointRequest method.
//    req, resp := client.QueryResolverEndpointRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *PRIVATEZONE) QueryResolverEndpointRequest(input *QueryResolverEndpointInput) (req *request.Request, output *QueryResolverEndpointOutput) {
	op := &request.Operation{
		Name:       opQueryResolverEndpoint,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &QueryResolverEndpointInput{}
	}

	output = &QueryResolverEndpointOutput{}
	req = c.newRequest(op, input, output)

	return
}

// QueryResolverEndpoint API operation for PRIVATE_ZONE.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for PRIVATE_ZONE's
// API operation QueryResolverEndpoint for usage and error information.
func (c *PRIVATEZONE) QueryResolverEndpoint(input *QueryResolverEndpointInput) (*QueryResolverEndpointOutput, error) {
	req, out := c.QueryResolverEndpointRequest(input)
	return out, req.Send()
}

// QueryResolverEndpointWithContext is the same as QueryResolverEndpoint with the addition of
// the ability to pass a context and additional request options.
//
// See QueryResolverEndpoint for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *PRIVATEZONE) QueryResolverEndpointWithContext(ctx volcengine.Context, input *QueryResolverEndpointInput, opts ...request.Option) (*QueryResolverEndpointOutput, error) {
	req, out := c.QueryResolverEndpointRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type IpConfigForQueryResolverEndpointOutput struct {
	_ struct{} `type:"structure"`

	AzID *string `type:"string"`

	IP *string `type:"string"`

	IPv6 *string `type:"string"`

	SubnetID *string `type:"string"`
}

// String returns the string representation
func (s IpConfigForQueryResolverEndpointOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s IpConfigForQueryResolverEndpointOutput) GoString() string {
	return s.String()
}

// SetAzID sets the AzID field's value.
func (s *IpConfigForQueryResolverEndpointOutput) SetAzID(v string) *IpConfigForQueryResolverEndpointOutput {
	s.AzID = &v
	return s
}

// SetIP sets the IP field's value.
func (s *IpConfigForQueryResolverEndpointOutput) SetIP(v string) *IpConfigForQueryResolverEndpointOutput {
	s.IP = &v
	return s
}

// SetIPv6 sets the IPv6 field's value.
func (s *IpConfigForQueryResolverEndpointOutput) SetIPv6(v string) *IpConfigForQueryResolverEndpointOutput {
	s.IPv6 = &v
	return s
}

// SetSubnetID sets the SubnetID field's value.
func (s *IpConfigForQueryResolverEndpointOutput) SetSubnetID(v string) *IpConfigForQueryResolverEndpointOutput {
	s.SubnetID = &v
	return s
}

type QueryResolverEndpointInput struct {
	_ struct{} `type:"structure"`

	// EndpointID is a required field
	EndpointID *int64 `type:"int64" required:"true"`

	EndpointTrn *string `type:"string"`
}

// String returns the string representation
func (s QueryResolverEndpointInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryResolverEndpointInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *QueryResolverEndpointInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "QueryResolverEndpointInput"}
	if s.EndpointID == nil {
		invalidParams.Add(request.NewErrParamRequired("EndpointID"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEndpointID sets the EndpointID field's value.
func (s *QueryResolverEndpointInput) SetEndpointID(v int64) *QueryResolverEndpointInput {
	s.EndpointID = &v
	return s
}

// SetEndpointTrn sets the EndpointTrn field's value.
func (s *QueryResolverEndpointInput) SetEndpointTrn(v string) *QueryResolverEndpointInput {
	s.EndpointTrn = &v
	return s
}

type QueryResolverEndpointOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	CreatedAt *string `type:"string"`

	Direction *string `type:"string"`

	ID *int64 `type:"int64"`

	IpConfigs []*IpConfigForQueryResolverEndpointOutput `type:"list"`

	Name *string `type:"string"`

	ProjectName *string `type:"string"`

	SecurityGroupID *string `type:"string"`

	Status *string `type:"string"`

	Tags []*TagForQueryResolverEndpointOutput `type:"list"`

	UpdatedAt *string `type:"string"`

	VpcID *string `type:"string"`

	VpcRegion *string `type:"string"`
}

// String returns the string representation
func (s QueryResolverEndpointOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s QueryResolverEndpointOutput) GoString() string {
	return s.String()
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *QueryResolverEndpointOutput) SetCreatedAt(v string) *QueryResolverEndpointOutput {
	s.CreatedAt = &v
	return s
}

// SetDirection sets the Direction field's value.
func (s *QueryResolverEndpointOutput) SetDirection(v string) *QueryResolverEndpointOutput {
	s.Direction = &v
	return s
}

// SetID sets the ID field's value.
func (s *QueryResolverEndpointOutput) SetID(v int64) *QueryResolverEndpointOutput {
	s.ID = &v
	return s
}

// SetIpConfigs sets the IpConfigs field's value.
func (s *QueryResolverEndpointOutput) SetIpConfigs(v []*IpConfigForQueryResolverEndpointOutput) *QueryResolverEndpointOutput {
	s.IpConfigs = v
	return s
}

// SetName sets the Name field's value.
func (s *QueryResolverEndpointOutput) SetName(v string) *QueryResolverEndpointOutput {
	s.Name = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *QueryResolverEndpointOutput) SetProjectName(v string) *QueryResolverEndpointOutput {
	s.ProjectName = &v
	return s
}

// SetSecurityGroupID sets the SecurityGroupID field's value.
func (s *QueryResolverEndpointOutput) SetSecurityGroupID(v string) *QueryResolverEndpointOutput {
	s.SecurityGroupID = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *QueryResolverEndpointOutput) SetStatus(v string) *QueryResolverEndpointOutput {
	s.Status = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *QueryResolverEndpointOutput) SetTags(v []*TagForQueryResolverEndpointOutput) *QueryResolverEndpointOutput {
	s.Tags = v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *QueryResolverEndpointOutput) SetUpdatedAt(v string) *QueryResolverEndpointOutput {
	s.UpdatedAt = &v
	return s
}

// SetVpcID sets the VpcID field's value.
func (s *QueryResolverEndpointOutput) SetVpcID(v string) *QueryResolverEndpointOutput {
	s.VpcID = &v
	return s
}

// SetVpcRegion sets the VpcRegion field's value.
func (s *QueryResolverEndpointOutput) SetVpcRegion(v string) *QueryResolverEndpointOutput {
	s.VpcRegion = &v
	return s
}

type TagForQueryResolverEndpointOutput struct {
	_ struct{} `type:"structure"`

	Key *string `max:"128" type:"string"`

	Value *string `max:"256" type:"string"`
}

// String returns the string representation
func (s TagForQueryResolverEndpointOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForQueryResolverEndpointOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForQueryResolverEndpointOutput) SetKey(v string) *TagForQueryResolverEndpointOutput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForQueryResolverEndpointOutput) SetValue(v string) *TagForQueryResolverEndpointOutput {
	s.Value = &v
	return s
}
