// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package mlplatform20240701

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opUpdateResourceGroupCommon = "UpdateResourceGroup"

// UpdateResourceGroupCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateResourceGroupCommon operation. The "output" return
// value will be populated with the UpdateResourceGroupCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateResourceGroupCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdateResourceGroupCommon Send returns without error.
//
// See UpdateResourceGroupCommon for more information on using the UpdateResourceGroupCommon
// API call, and error handling.
//
//    // Example sending a request using the UpdateResourceGroupCommonRequest method.
//    req, resp := client.UpdateResourceGroupCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MLPLATFORM20240701) UpdateResourceGroupCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opUpdateResourceGroupCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdateResourceGroupCommon API operation for ML_PLATFORM20240701.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ML_PLATFORM20240701's
// API operation UpdateResourceGroupCommon for usage and error information.
func (c *MLPLATFORM20240701) UpdateResourceGroupCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.UpdateResourceGroupCommonRequest(input)
	return out, req.Send()
}

// UpdateResourceGroupCommonWithContext is the same as UpdateResourceGroupCommon with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateResourceGroupCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MLPLATFORM20240701) UpdateResourceGroupCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.UpdateResourceGroupCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateResourceGroup = "UpdateResourceGroup"

// UpdateResourceGroupRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateResourceGroup operation. The "output" return
// value will be populated with the UpdateResourceGroupCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateResourceGroupCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdateResourceGroupCommon Send returns without error.
//
// See UpdateResourceGroup for more information on using the UpdateResourceGroup
// API call, and error handling.
//
//    // Example sending a request using the UpdateResourceGroupRequest method.
//    req, resp := client.UpdateResourceGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MLPLATFORM20240701) UpdateResourceGroupRequest(input *UpdateResourceGroupInput) (req *request.Request, output *UpdateResourceGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateResourceGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateResourceGroupInput{}
	}

	output = &UpdateResourceGroupOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdateResourceGroup API operation for ML_PLATFORM20240701.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ML_PLATFORM20240701's
// API operation UpdateResourceGroup for usage and error information.
func (c *MLPLATFORM20240701) UpdateResourceGroup(input *UpdateResourceGroupInput) (*UpdateResourceGroupOutput, error) {
	req, out := c.UpdateResourceGroupRequest(input)
	return out, req.Send()
}

// UpdateResourceGroupWithContext is the same as UpdateResourceGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateResourceGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MLPLATFORM20240701) UpdateResourceGroupWithContext(ctx volcengine.Context, input *UpdateResourceGroupInput, opts ...request.Option) (*UpdateResourceGroupOutput, error) {
	req, out := c.UpdateResourceGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ComputeResourceForUpdateResourceGroupInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Count *int32 `type:"int32" json:",omitempty"`

	InstanceTypeId *string `type:"string" json:",omitempty"`

	ZoneId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ComputeResourceForUpdateResourceGroupInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ComputeResourceForUpdateResourceGroupInput) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *ComputeResourceForUpdateResourceGroupInput) SetCount(v int32) *ComputeResourceForUpdateResourceGroupInput {
	s.Count = &v
	return s
}

// SetInstanceTypeId sets the InstanceTypeId field's value.
func (s *ComputeResourceForUpdateResourceGroupInput) SetInstanceTypeId(v string) *ComputeResourceForUpdateResourceGroupInput {
	s.InstanceTypeId = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *ComputeResourceForUpdateResourceGroupInput) SetZoneId(v string) *ComputeResourceForUpdateResourceGroupInput {
	s.ZoneId = &v
	return s
}

type ResourceConfigForUpdateResourceGroupInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ComputeResources []*ComputeResourceForUpdateResourceGroupInput `type:"list" json:",omitempty"`

	VolumeResources []*VolumeResourceForUpdateResourceGroupInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ResourceConfigForUpdateResourceGroupInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceConfigForUpdateResourceGroupInput) GoString() string {
	return s.String()
}

// SetComputeResources sets the ComputeResources field's value.
func (s *ResourceConfigForUpdateResourceGroupInput) SetComputeResources(v []*ComputeResourceForUpdateResourceGroupInput) *ResourceConfigForUpdateResourceGroupInput {
	s.ComputeResources = v
	return s
}

// SetVolumeResources sets the VolumeResources field's value.
func (s *ResourceConfigForUpdateResourceGroupInput) SetVolumeResources(v []*VolumeResourceForUpdateResourceGroupInput) *ResourceConfigForUpdateResourceGroupInput {
	s.VolumeResources = v
	return s
}

type SfcsForUpdateResourceGroupInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Replicas *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s SfcsForUpdateResourceGroupInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SfcsForUpdateResourceGroupInput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *SfcsForUpdateResourceGroupInput) SetDescription(v string) *SfcsForUpdateResourceGroupInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *SfcsForUpdateResourceGroupInput) SetName(v string) *SfcsForUpdateResourceGroupInput {
	s.Name = &v
	return s
}

// SetReplicas sets the Replicas field's value.
func (s *SfcsForUpdateResourceGroupInput) SetReplicas(v int64) *SfcsForUpdateResourceGroupInput {
	s.Replicas = &v
	return s
}

type StorageConfigForUpdateResourceGroupInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Sfcs *SfcsForUpdateResourceGroupInput `type:"structure" json:",omitempty"`

	StorageNetworkConfig *StorageNetworkConfigForUpdateResourceGroupInput `type:"structure" json:",omitempty"`

	Vepfs *VepfsForUpdateResourceGroupInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s StorageConfigForUpdateResourceGroupInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageConfigForUpdateResourceGroupInput) GoString() string {
	return s.String()
}

// SetSfcs sets the Sfcs field's value.
func (s *StorageConfigForUpdateResourceGroupInput) SetSfcs(v *SfcsForUpdateResourceGroupInput) *StorageConfigForUpdateResourceGroupInput {
	s.Sfcs = v
	return s
}

// SetStorageNetworkConfig sets the StorageNetworkConfig field's value.
func (s *StorageConfigForUpdateResourceGroupInput) SetStorageNetworkConfig(v *StorageNetworkConfigForUpdateResourceGroupInput) *StorageConfigForUpdateResourceGroupInput {
	s.StorageNetworkConfig = v
	return s
}

// SetVepfs sets the Vepfs field's value.
func (s *StorageConfigForUpdateResourceGroupInput) SetVepfs(v *VepfsForUpdateResourceGroupInput) *StorageConfigForUpdateResourceGroupInput {
	s.Vepfs = v
	return s
}

type StorageNetworkConfigForUpdateResourceGroupInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	SecurityGroupIds []*string `type:"list" json:",omitempty"`

	SubnetIds []*string `type:"list" json:",omitempty"`

	VpcId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s StorageNetworkConfigForUpdateResourceGroupInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageNetworkConfigForUpdateResourceGroupInput) GoString() string {
	return s.String()
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *StorageNetworkConfigForUpdateResourceGroupInput) SetSecurityGroupIds(v []*string) *StorageNetworkConfigForUpdateResourceGroupInput {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *StorageNetworkConfigForUpdateResourceGroupInput) SetSubnetIds(v []*string) *StorageNetworkConfigForUpdateResourceGroupInput {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *StorageNetworkConfigForUpdateResourceGroupInput) SetVpcId(v string) *StorageNetworkConfigForUpdateResourceGroupInput {
	s.VpcId = &v
	return s
}

type UpdateResourceGroupInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Description *string `min:"1" max:"500" type:"string" json:",omitempty"`

	// Id is a required field
	Id *string `type:"string" json:",omitempty" required:"true"`

	Name *string `min:"1" max:"200" type:"string" json:",omitempty"`

	ResourceConfig *ResourceConfigForUpdateResourceGroupInput `type:"structure" json:",omitempty"`

	StorageConfig *StorageConfigForUpdateResourceGroupInput `type:"structure" json:",omitempty"`

	WorkloadNetworkConfig *WorkloadNetworkConfigForUpdateResourceGroupInput `type:"structure" json:",omitempty"`

	WorkloadNetworkMode *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s UpdateResourceGroupInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateResourceGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateResourceGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateResourceGroupInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Description != nil && len(*s.Description) > 500 {
		invalidParams.Add(request.NewErrParamMaxLen("Description", 500, *s.Description))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Name != nil && len(*s.Name) > 200 {
		invalidParams.Add(request.NewErrParamMaxLen("Name", 200, *s.Name))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateResourceGroupInput) SetDescription(v string) *UpdateResourceGroupInput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *UpdateResourceGroupInput) SetId(v string) *UpdateResourceGroupInput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateResourceGroupInput) SetName(v string) *UpdateResourceGroupInput {
	s.Name = &v
	return s
}

// SetResourceConfig sets the ResourceConfig field's value.
func (s *UpdateResourceGroupInput) SetResourceConfig(v *ResourceConfigForUpdateResourceGroupInput) *UpdateResourceGroupInput {
	s.ResourceConfig = v
	return s
}

// SetStorageConfig sets the StorageConfig field's value.
func (s *UpdateResourceGroupInput) SetStorageConfig(v *StorageConfigForUpdateResourceGroupInput) *UpdateResourceGroupInput {
	s.StorageConfig = v
	return s
}

// SetWorkloadNetworkConfig sets the WorkloadNetworkConfig field's value.
func (s *UpdateResourceGroupInput) SetWorkloadNetworkConfig(v *WorkloadNetworkConfigForUpdateResourceGroupInput) *UpdateResourceGroupInput {
	s.WorkloadNetworkConfig = v
	return s
}

// SetWorkloadNetworkMode sets the WorkloadNetworkMode field's value.
func (s *UpdateResourceGroupInput) SetWorkloadNetworkMode(v string) *UpdateResourceGroupInput {
	s.WorkloadNetworkMode = &v
	return s
}

type UpdateResourceGroupOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Id *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s UpdateResourceGroupOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateResourceGroupOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *UpdateResourceGroupOutput) SetId(v string) *UpdateResourceGroupOutput {
	s.Id = &v
	return s
}

type VepfsForUpdateResourceGroupInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	EnablePrefetch *bool `type:"boolean" json:",omitempty"`

	FileSystemIds []*string `type:"list" json:",omitempty"`

	MountServiceId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s VepfsForUpdateResourceGroupInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VepfsForUpdateResourceGroupInput) GoString() string {
	return s.String()
}

// SetEnablePrefetch sets the EnablePrefetch field's value.
func (s *VepfsForUpdateResourceGroupInput) SetEnablePrefetch(v bool) *VepfsForUpdateResourceGroupInput {
	s.EnablePrefetch = &v
	return s
}

// SetFileSystemIds sets the FileSystemIds field's value.
func (s *VepfsForUpdateResourceGroupInput) SetFileSystemIds(v []*string) *VepfsForUpdateResourceGroupInput {
	s.FileSystemIds = v
	return s
}

// SetMountServiceId sets the MountServiceId field's value.
func (s *VepfsForUpdateResourceGroupInput) SetMountServiceId(v string) *VepfsForUpdateResourceGroupInput {
	s.MountServiceId = &v
	return s
}

type VolumeResourceForUpdateResourceGroupInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Size *int32 `type:"int32" json:",omitempty"`

	VolumeTypeId *string `type:"string" json:",omitempty"`

	ZoneId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s VolumeResourceForUpdateResourceGroupInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VolumeResourceForUpdateResourceGroupInput) GoString() string {
	return s.String()
}

// SetSize sets the Size field's value.
func (s *VolumeResourceForUpdateResourceGroupInput) SetSize(v int32) *VolumeResourceForUpdateResourceGroupInput {
	s.Size = &v
	return s
}

// SetVolumeTypeId sets the VolumeTypeId field's value.
func (s *VolumeResourceForUpdateResourceGroupInput) SetVolumeTypeId(v string) *VolumeResourceForUpdateResourceGroupInput {
	s.VolumeTypeId = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *VolumeResourceForUpdateResourceGroupInput) SetZoneId(v string) *VolumeResourceForUpdateResourceGroupInput {
	s.ZoneId = &v
	return s
}

type WorkloadNetworkConfigForUpdateResourceGroupInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	SecurityGroupIds []*string `type:"list" json:",omitempty"`

	SubnetIds []*string `type:"list" json:",omitempty"`

	VpcId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s WorkloadNetworkConfigForUpdateResourceGroupInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkloadNetworkConfigForUpdateResourceGroupInput) GoString() string {
	return s.String()
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *WorkloadNetworkConfigForUpdateResourceGroupInput) SetSecurityGroupIds(v []*string) *WorkloadNetworkConfigForUpdateResourceGroupInput {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *WorkloadNetworkConfigForUpdateResourceGroupInput) SetSubnetIds(v []*string) *WorkloadNetworkConfigForUpdateResourceGroupInput {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *WorkloadNetworkConfigForUpdateResourceGroupInput) SetVpcId(v string) *WorkloadNetworkConfigForUpdateResourceGroupInput {
	s.VpcId = &v
	return s
}
