// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package mlplatform20240701

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListResourceQueuesCommon = "ListResourceQueues"

// ListResourceQueuesCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListResourceQueuesCommon operation. The "output" return
// value will be populated with the ListResourceQueuesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListResourceQueuesCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListResourceQueuesCommon Send returns without error.
//
// See ListResourceQueuesCommon for more information on using the ListResourceQueuesCommon
// API call, and error handling.
//
//    // Example sending a request using the ListResourceQueuesCommonRequest method.
//    req, resp := client.ListResourceQueuesCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MLPLATFORM20240701) ListResourceQueuesCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListResourceQueuesCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListResourceQueuesCommon API operation for ML_PLATFORM20240701.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ML_PLATFORM20240701's
// API operation ListResourceQueuesCommon for usage and error information.
func (c *MLPLATFORM20240701) ListResourceQueuesCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListResourceQueuesCommonRequest(input)
	return out, req.Send()
}

// ListResourceQueuesCommonWithContext is the same as ListResourceQueuesCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListResourceQueuesCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MLPLATFORM20240701) ListResourceQueuesCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListResourceQueuesCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListResourceQueues = "ListResourceQueues"

// ListResourceQueuesRequest generates a "volcengine/request.Request" representing the
// client's request for the ListResourceQueues operation. The "output" return
// value will be populated with the ListResourceQueuesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListResourceQueuesCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListResourceQueuesCommon Send returns without error.
//
// See ListResourceQueues for more information on using the ListResourceQueues
// API call, and error handling.
//
//    // Example sending a request using the ListResourceQueuesRequest method.
//    req, resp := client.ListResourceQueuesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MLPLATFORM20240701) ListResourceQueuesRequest(input *ListResourceQueuesInput) (req *request.Request, output *ListResourceQueuesOutput) {
	op := &request.Operation{
		Name:       opListResourceQueues,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListResourceQueuesInput{}
	}

	output = &ListResourceQueuesOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListResourceQueues API operation for ML_PLATFORM20240701.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ML_PLATFORM20240701's
// API operation ListResourceQueues for usage and error information.
func (c *MLPLATFORM20240701) ListResourceQueues(input *ListResourceQueuesInput) (*ListResourceQueuesOutput, error) {
	req, out := c.ListResourceQueuesRequest(input)
	return out, req.Send()
}

// ListResourceQueuesWithContext is the same as ListResourceQueues with the addition of
// the ability to pass a context and additional request options.
//
// See ListResourceQueues for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MLPLATFORM20240701) ListResourceQueuesWithContext(ctx volcengine.Context, input *ListResourceQueuesInput, opts ...request.Option) (*ListResourceQueuesOutput, error) {
	req, out := c.ListResourceQueuesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AutoCompactGPUResourceRuleForListResourceQueuesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AffectedWorkloadTypes []*string `type:"list" json:",omitempty"`

	CreateTime *string `type:"string" json:",omitempty"`

	CreatorTrn *string `type:"string" json:",omitempty"`

	CronSpecs []*CronSpecForListResourceQueuesOutput `type:"list" json:",omitempty"`

	Enabled *bool `type:"boolean" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	OnUnschedulable *bool `type:"boolean" json:",omitempty"`

	TriggeredTimes *int32 `type:"int32" json:",omitempty"`

	UpdateTime *string `type:"string" json:",omitempty"`

	UpdatorTrn *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s AutoCompactGPUResourceRuleForListResourceQueuesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoCompactGPUResourceRuleForListResourceQueuesOutput) GoString() string {
	return s.String()
}

// SetAffectedWorkloadTypes sets the AffectedWorkloadTypes field's value.
func (s *AutoCompactGPUResourceRuleForListResourceQueuesOutput) SetAffectedWorkloadTypes(v []*string) *AutoCompactGPUResourceRuleForListResourceQueuesOutput {
	s.AffectedWorkloadTypes = v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *AutoCompactGPUResourceRuleForListResourceQueuesOutput) SetCreateTime(v string) *AutoCompactGPUResourceRuleForListResourceQueuesOutput {
	s.CreateTime = &v
	return s
}

// SetCreatorTrn sets the CreatorTrn field's value.
func (s *AutoCompactGPUResourceRuleForListResourceQueuesOutput) SetCreatorTrn(v string) *AutoCompactGPUResourceRuleForListResourceQueuesOutput {
	s.CreatorTrn = &v
	return s
}

// SetCronSpecs sets the CronSpecs field's value.
func (s *AutoCompactGPUResourceRuleForListResourceQueuesOutput) SetCronSpecs(v []*CronSpecForListResourceQueuesOutput) *AutoCompactGPUResourceRuleForListResourceQueuesOutput {
	s.CronSpecs = v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *AutoCompactGPUResourceRuleForListResourceQueuesOutput) SetEnabled(v bool) *AutoCompactGPUResourceRuleForListResourceQueuesOutput {
	s.Enabled = &v
	return s
}

// SetId sets the Id field's value.
func (s *AutoCompactGPUResourceRuleForListResourceQueuesOutput) SetId(v string) *AutoCompactGPUResourceRuleForListResourceQueuesOutput {
	s.Id = &v
	return s
}

// SetOnUnschedulable sets the OnUnschedulable field's value.
func (s *AutoCompactGPUResourceRuleForListResourceQueuesOutput) SetOnUnschedulable(v bool) *AutoCompactGPUResourceRuleForListResourceQueuesOutput {
	s.OnUnschedulable = &v
	return s
}

// SetTriggeredTimes sets the TriggeredTimes field's value.
func (s *AutoCompactGPUResourceRuleForListResourceQueuesOutput) SetTriggeredTimes(v int32) *AutoCompactGPUResourceRuleForListResourceQueuesOutput {
	s.TriggeredTimes = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *AutoCompactGPUResourceRuleForListResourceQueuesOutput) SetUpdateTime(v string) *AutoCompactGPUResourceRuleForListResourceQueuesOutput {
	s.UpdateTime = &v
	return s
}

// SetUpdatorTrn sets the UpdatorTrn field's value.
func (s *AutoCompactGPUResourceRuleForListResourceQueuesOutput) SetUpdatorTrn(v string) *AutoCompactGPUResourceRuleForListResourceQueuesOutput {
	s.UpdatorTrn = &v
	return s
}

type ComputeResourceForListResourceQueuesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Count *int32 `type:"int32" json:",omitempty"`

	InstanceTypeId *string `type:"string" json:",omitempty"`

	ZoneId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ComputeResourceForListResourceQueuesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ComputeResourceForListResourceQueuesOutput) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *ComputeResourceForListResourceQueuesOutput) SetCount(v int32) *ComputeResourceForListResourceQueuesOutput {
	s.Count = &v
	return s
}

// SetInstanceTypeId sets the InstanceTypeId field's value.
func (s *ComputeResourceForListResourceQueuesOutput) SetInstanceTypeId(v string) *ComputeResourceForListResourceQueuesOutput {
	s.InstanceTypeId = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *ComputeResourceForListResourceQueuesOutput) SetZoneId(v string) *ComputeResourceForListResourceQueuesOutput {
	s.ZoneId = &v
	return s
}

type CronSpecForListResourceQueuesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AffectedWorkloadType *string `type:"string" json:",omitempty"`

	Schedule *string `type:"string" json:",omitempty"`

	TimeZone *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CronSpecForListResourceQueuesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CronSpecForListResourceQueuesOutput) GoString() string {
	return s.String()
}

// SetAffectedWorkloadType sets the AffectedWorkloadType field's value.
func (s *CronSpecForListResourceQueuesOutput) SetAffectedWorkloadType(v string) *CronSpecForListResourceQueuesOutput {
	s.AffectedWorkloadType = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *CronSpecForListResourceQueuesOutput) SetSchedule(v string) *CronSpecForListResourceQueuesOutput {
	s.Schedule = &v
	return s
}

// SetTimeZone sets the TimeZone field's value.
func (s *CronSpecForListResourceQueuesOutput) SetTimeZone(v string) *CronSpecForListResourceQueuesOutput {
	s.TimeZone = &v
	return s
}

type GeneralIdleRuleForListResourceQueuesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CreateTime *string `type:"string" json:",omitempty"`

	CreatorTrn *string `type:"string" json:",omitempty"`

	Enabled *bool `type:"boolean" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	IdleShutdownRuleTypes []*string `type:"list" json:",omitempty"`

	MinutePeriod *int32 `type:"int32" json:",omitempty"`

	Period *int32 `type:"int32" json:",omitempty"`

	Threshold *float64 `type:"double" json:",omitempty"`

	TriggeredTimes *int32 `type:"int32" json:",omitempty"`

	UpdateTime *string `type:"string" json:",omitempty"`

	UpdatorTrn *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s GeneralIdleRuleForListResourceQueuesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GeneralIdleRuleForListResourceQueuesOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *GeneralIdleRuleForListResourceQueuesOutput) SetCreateTime(v string) *GeneralIdleRuleForListResourceQueuesOutput {
	s.CreateTime = &v
	return s
}

// SetCreatorTrn sets the CreatorTrn field's value.
func (s *GeneralIdleRuleForListResourceQueuesOutput) SetCreatorTrn(v string) *GeneralIdleRuleForListResourceQueuesOutput {
	s.CreatorTrn = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *GeneralIdleRuleForListResourceQueuesOutput) SetEnabled(v bool) *GeneralIdleRuleForListResourceQueuesOutput {
	s.Enabled = &v
	return s
}

// SetId sets the Id field's value.
func (s *GeneralIdleRuleForListResourceQueuesOutput) SetId(v string) *GeneralIdleRuleForListResourceQueuesOutput {
	s.Id = &v
	return s
}

// SetIdleShutdownRuleTypes sets the IdleShutdownRuleTypes field's value.
func (s *GeneralIdleRuleForListResourceQueuesOutput) SetIdleShutdownRuleTypes(v []*string) *GeneralIdleRuleForListResourceQueuesOutput {
	s.IdleShutdownRuleTypes = v
	return s
}

// SetMinutePeriod sets the MinutePeriod field's value.
func (s *GeneralIdleRuleForListResourceQueuesOutput) SetMinutePeriod(v int32) *GeneralIdleRuleForListResourceQueuesOutput {
	s.MinutePeriod = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *GeneralIdleRuleForListResourceQueuesOutput) SetPeriod(v int32) *GeneralIdleRuleForListResourceQueuesOutput {
	s.Period = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *GeneralIdleRuleForListResourceQueuesOutput) SetThreshold(v float64) *GeneralIdleRuleForListResourceQueuesOutput {
	s.Threshold = &v
	return s
}

// SetTriggeredTimes sets the TriggeredTimes field's value.
func (s *GeneralIdleRuleForListResourceQueuesOutput) SetTriggeredTimes(v int32) *GeneralIdleRuleForListResourceQueuesOutput {
	s.TriggeredTimes = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *GeneralIdleRuleForListResourceQueuesOutput) SetUpdateTime(v string) *GeneralIdleRuleForListResourceQueuesOutput {
	s.UpdateTime = &v
	return s
}

// SetUpdatorTrn sets the UpdatorTrn field's value.
func (s *GeneralIdleRuleForListResourceQueuesOutput) SetUpdatorTrn(v string) *GeneralIdleRuleForListResourceQueuesOutput {
	s.UpdatorTrn = &v
	return s
}

type GpuCountInfoForListResourceQueuesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Count *float64 `type:"double" json:",omitempty"`

	GpuType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s GpuCountInfoForListResourceQueuesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GpuCountInfoForListResourceQueuesOutput) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *GpuCountInfoForListResourceQueuesOutput) SetCount(v float64) *GpuCountInfoForListResourceQueuesOutput {
	s.Count = &v
	return s
}

// SetGpuType sets the GpuType field's value.
func (s *GpuCountInfoForListResourceQueuesOutput) SetGpuType(v string) *GpuCountInfoForListResourceQueuesOutput {
	s.GpuType = &v
	return s
}

type GpuMemoryInfoForListResourceQueuesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	GpuType *string `type:"string" json:",omitempty"`

	MemoryGiB *float64 `type:"double" json:",omitempty"`
}

// String returns the string representation
func (s GpuMemoryInfoForListResourceQueuesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GpuMemoryInfoForListResourceQueuesOutput) GoString() string {
	return s.String()
}

// SetGpuType sets the GpuType field's value.
func (s *GpuMemoryInfoForListResourceQueuesOutput) SetGpuType(v string) *GpuMemoryInfoForListResourceQueuesOutput {
	s.GpuType = &v
	return s
}

// SetMemoryGiB sets the MemoryGiB field's value.
func (s *GpuMemoryInfoForListResourceQueuesOutput) SetMemoryGiB(v float64) *GpuMemoryInfoForListResourceQueuesOutput {
	s.MemoryGiB = &v
	return s
}

type GpuRdmaInfoForListResourceQueuesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Count *int32 `type:"int32" json:",omitempty"`

	GpuType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s GpuRdmaInfoForListResourceQueuesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GpuRdmaInfoForListResourceQueuesOutput) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *GpuRdmaInfoForListResourceQueuesOutput) SetCount(v int32) *GpuRdmaInfoForListResourceQueuesOutput {
	s.Count = &v
	return s
}

// SetGpuType sets the GpuType field's value.
func (s *GpuRdmaInfoForListResourceQueuesOutput) SetGpuType(v string) *GpuRdmaInfoForListResourceQueuesOutput {
	s.GpuType = &v
	return s
}

type GpuUtilizationRuleForListResourceQueuesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CreateTime *string `type:"string" json:",omitempty"`

	CreatorTrn *string `type:"string" json:",omitempty"`

	Enabled *bool `type:"boolean" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	IdleShutdownRuleTypes []*string `type:"list" json:",omitempty"`

	MinutePeriod *int32 `type:"int32" json:",omitempty"`

	Period *int32 `type:"int32" json:",omitempty"`

	Threshold *float64 `type:"double" json:",omitempty"`

	TriggeredTimes *int32 `type:"int32" json:",omitempty"`

	UpdateTime *string `type:"string" json:",omitempty"`

	UpdatorTrn *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s GpuUtilizationRuleForListResourceQueuesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GpuUtilizationRuleForListResourceQueuesOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *GpuUtilizationRuleForListResourceQueuesOutput) SetCreateTime(v string) *GpuUtilizationRuleForListResourceQueuesOutput {
	s.CreateTime = &v
	return s
}

// SetCreatorTrn sets the CreatorTrn field's value.
func (s *GpuUtilizationRuleForListResourceQueuesOutput) SetCreatorTrn(v string) *GpuUtilizationRuleForListResourceQueuesOutput {
	s.CreatorTrn = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *GpuUtilizationRuleForListResourceQueuesOutput) SetEnabled(v bool) *GpuUtilizationRuleForListResourceQueuesOutput {
	s.Enabled = &v
	return s
}

// SetId sets the Id field's value.
func (s *GpuUtilizationRuleForListResourceQueuesOutput) SetId(v string) *GpuUtilizationRuleForListResourceQueuesOutput {
	s.Id = &v
	return s
}

// SetIdleShutdownRuleTypes sets the IdleShutdownRuleTypes field's value.
func (s *GpuUtilizationRuleForListResourceQueuesOutput) SetIdleShutdownRuleTypes(v []*string) *GpuUtilizationRuleForListResourceQueuesOutput {
	s.IdleShutdownRuleTypes = v
	return s
}

// SetMinutePeriod sets the MinutePeriod field's value.
func (s *GpuUtilizationRuleForListResourceQueuesOutput) SetMinutePeriod(v int32) *GpuUtilizationRuleForListResourceQueuesOutput {
	s.MinutePeriod = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *GpuUtilizationRuleForListResourceQueuesOutput) SetPeriod(v int32) *GpuUtilizationRuleForListResourceQueuesOutput {
	s.Period = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *GpuUtilizationRuleForListResourceQueuesOutput) SetThreshold(v float64) *GpuUtilizationRuleForListResourceQueuesOutput {
	s.Threshold = &v
	return s
}

// SetTriggeredTimes sets the TriggeredTimes field's value.
func (s *GpuUtilizationRuleForListResourceQueuesOutput) SetTriggeredTimes(v int32) *GpuUtilizationRuleForListResourceQueuesOutput {
	s.TriggeredTimes = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *GpuUtilizationRuleForListResourceQueuesOutput) SetUpdateTime(v string) *GpuUtilizationRuleForListResourceQueuesOutput {
	s.UpdateTime = &v
	return s
}

// SetUpdatorTrn sets the UpdatorTrn field's value.
func (s *GpuUtilizationRuleForListResourceQueuesOutput) SetUpdatorTrn(v string) *GpuUtilizationRuleForListResourceQueuesOutput {
	s.UpdatorTrn = &v
	return s
}

type ItemForListResourceQueuesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ChargeType *string `type:"string" json:",omitempty" enum:"EnumOfChargeTypeForListResourceQueuesOutput"`

	ComputeResources []*ComputeResourceForListResourceQueuesOutput `type:"list" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	QuotaAllocated *QuotaAllocatedForListResourceQueuesOutput `type:"structure" json:",omitempty"`

	QuotaCapability *QuotaCapabilityForListResourceQueuesOutput `type:"structure" json:",omitempty"`

	ResourceGroupId *string `type:"string" json:",omitempty"`

	Rules *RulesForListResourceQueuesOutput `type:"structure" json:",omitempty"`

	Shareable *bool `type:"boolean" json:",omitempty"`

	SharedQuotaAllocated *SharedQuotaAllocatedForListResourceQueuesOutput `type:"structure" json:",omitempty"`

	Status *StatusForListResourceQueuesOutput `type:"structure" json:",omitempty"`

	SystemQuotaAllocated *SystemQuotaAllocatedForListResourceQueuesOutput `type:"structure" json:",omitempty"`

	VolumeResources []*VolumeResourceForListResourceQueuesOutput `type:"list" json:",omitempty"`

	WorkloadInfos []*WorkloadInfoForListResourceQueuesOutput `type:"list" json:",omitempty"`

	ZoneIds []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ItemForListResourceQueuesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ItemForListResourceQueuesOutput) GoString() string {
	return s.String()
}

// SetChargeType sets the ChargeType field's value.
func (s *ItemForListResourceQueuesOutput) SetChargeType(v string) *ItemForListResourceQueuesOutput {
	s.ChargeType = &v
	return s
}

// SetComputeResources sets the ComputeResources field's value.
func (s *ItemForListResourceQueuesOutput) SetComputeResources(v []*ComputeResourceForListResourceQueuesOutput) *ItemForListResourceQueuesOutput {
	s.ComputeResources = v
	return s
}

// SetDescription sets the Description field's value.
func (s *ItemForListResourceQueuesOutput) SetDescription(v string) *ItemForListResourceQueuesOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *ItemForListResourceQueuesOutput) SetId(v string) *ItemForListResourceQueuesOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ItemForListResourceQueuesOutput) SetName(v string) *ItemForListResourceQueuesOutput {
	s.Name = &v
	return s
}

// SetQuotaAllocated sets the QuotaAllocated field's value.
func (s *ItemForListResourceQueuesOutput) SetQuotaAllocated(v *QuotaAllocatedForListResourceQueuesOutput) *ItemForListResourceQueuesOutput {
	s.QuotaAllocated = v
	return s
}

// SetQuotaCapability sets the QuotaCapability field's value.
func (s *ItemForListResourceQueuesOutput) SetQuotaCapability(v *QuotaCapabilityForListResourceQueuesOutput) *ItemForListResourceQueuesOutput {
	s.QuotaCapability = v
	return s
}

// SetResourceGroupId sets the ResourceGroupId field's value.
func (s *ItemForListResourceQueuesOutput) SetResourceGroupId(v string) *ItemForListResourceQueuesOutput {
	s.ResourceGroupId = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *ItemForListResourceQueuesOutput) SetRules(v *RulesForListResourceQueuesOutput) *ItemForListResourceQueuesOutput {
	s.Rules = v
	return s
}

// SetShareable sets the Shareable field's value.
func (s *ItemForListResourceQueuesOutput) SetShareable(v bool) *ItemForListResourceQueuesOutput {
	s.Shareable = &v
	return s
}

// SetSharedQuotaAllocated sets the SharedQuotaAllocated field's value.
func (s *ItemForListResourceQueuesOutput) SetSharedQuotaAllocated(v *SharedQuotaAllocatedForListResourceQueuesOutput) *ItemForListResourceQueuesOutput {
	s.SharedQuotaAllocated = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ItemForListResourceQueuesOutput) SetStatus(v *StatusForListResourceQueuesOutput) *ItemForListResourceQueuesOutput {
	s.Status = v
	return s
}

// SetSystemQuotaAllocated sets the SystemQuotaAllocated field's value.
func (s *ItemForListResourceQueuesOutput) SetSystemQuotaAllocated(v *SystemQuotaAllocatedForListResourceQueuesOutput) *ItemForListResourceQueuesOutput {
	s.SystemQuotaAllocated = v
	return s
}

// SetVolumeResources sets the VolumeResources field's value.
func (s *ItemForListResourceQueuesOutput) SetVolumeResources(v []*VolumeResourceForListResourceQueuesOutput) *ItemForListResourceQueuesOutput {
	s.VolumeResources = v
	return s
}

// SetWorkloadInfos sets the WorkloadInfos field's value.
func (s *ItemForListResourceQueuesOutput) SetWorkloadInfos(v []*WorkloadInfoForListResourceQueuesOutput) *ItemForListResourceQueuesOutput {
	s.WorkloadInfos = v
	return s
}

// SetZoneIds sets the ZoneIds field's value.
func (s *ItemForListResourceQueuesOutput) SetZoneIds(v []*string) *ItemForListResourceQueuesOutput {
	s.ZoneIds = v
	return s
}

type ListResourceQueuesInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ChargeType *string `type:"string" json:",omitempty" enum:"EnumOfChargeTypeForListResourceQueuesInput"`

	Ids []*string `type:"list" json:",omitempty"`

	NameContains *string `type:"string" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `min:"10" max:"100" type:"int32" json:",omitempty"`

	ResourceGroupIds []*string `type:"list" json:",omitempty"`

	Shareable *bool `type:"boolean" json:",omitempty"`

	SortBy *string `type:"string" json:",omitempty" enum:"EnumOfSortByForListResourceQueuesInput"`

	SortOrder *string `type:"string" json:",omitempty" enum:"EnumOfSortOrderForListResourceQueuesInput"`

	Status []*string `type:"list" json:",omitempty"`

	WorkloadTypes []*string `type:"list" json:",omitempty"`

	ZoneIds []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ListResourceQueuesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourceQueuesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourceQueuesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourceQueuesInput"}
	if s.PageSize != nil && *s.PageSize < 10 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 10))
	}
	if s.PageSize != nil && *s.PageSize > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("PageSize", 100))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChargeType sets the ChargeType field's value.
func (s *ListResourceQueuesInput) SetChargeType(v string) *ListResourceQueuesInput {
	s.ChargeType = &v
	return s
}

// SetIds sets the Ids field's value.
func (s *ListResourceQueuesInput) SetIds(v []*string) *ListResourceQueuesInput {
	s.Ids = v
	return s
}

// SetNameContains sets the NameContains field's value.
func (s *ListResourceQueuesInput) SetNameContains(v string) *ListResourceQueuesInput {
	s.NameContains = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListResourceQueuesInput) SetPageNumber(v int32) *ListResourceQueuesInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListResourceQueuesInput) SetPageSize(v int32) *ListResourceQueuesInput {
	s.PageSize = &v
	return s
}

// SetResourceGroupIds sets the ResourceGroupIds field's value.
func (s *ListResourceQueuesInput) SetResourceGroupIds(v []*string) *ListResourceQueuesInput {
	s.ResourceGroupIds = v
	return s
}

// SetShareable sets the Shareable field's value.
func (s *ListResourceQueuesInput) SetShareable(v bool) *ListResourceQueuesInput {
	s.Shareable = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListResourceQueuesInput) SetSortBy(v string) *ListResourceQueuesInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListResourceQueuesInput) SetSortOrder(v string) *ListResourceQueuesInput {
	s.SortOrder = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListResourceQueuesInput) SetStatus(v []*string) *ListResourceQueuesInput {
	s.Status = v
	return s
}

// SetWorkloadTypes sets the WorkloadTypes field's value.
func (s *ListResourceQueuesInput) SetWorkloadTypes(v []*string) *ListResourceQueuesInput {
	s.WorkloadTypes = v
	return s
}

// SetZoneIds sets the ZoneIds field's value.
func (s *ListResourceQueuesInput) SetZoneIds(v []*string) *ListResourceQueuesInput {
	s.ZoneIds = v
	return s
}

type ListResourceQueuesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Items []*ItemForListResourceQueuesOutput `type:"list" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ListResourceQueuesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourceQueuesOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListResourceQueuesOutput) SetItems(v []*ItemForListResourceQueuesOutput) *ListResourceQueuesOutput {
	s.Items = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListResourceQueuesOutput) SetPageNumber(v int32) *ListResourceQueuesOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListResourceQueuesOutput) SetPageSize(v int32) *ListResourceQueuesOutput {
	s.PageSize = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListResourceQueuesOutput) SetTotalCount(v int32) *ListResourceQueuesOutput {
	s.TotalCount = &v
	return s
}

type QuotaAllocatedForListResourceQueuesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Cpu *float64 `type:"double" json:",omitempty"`

	GpuCount *float64 `type:"double" json:",omitempty"`

	GpuCountInfos []*GpuCountInfoForListResourceQueuesOutput `type:"list" json:",omitempty"`

	GpuMemoryInfos []*GpuMemoryInfoForListResourceQueuesOutput `type:"list" json:",omitempty"`

	GpuRdmaInfos []*GpuRdmaInfoForListResourceQueuesOutput `type:"list" json:",omitempty"`

	MemoryGiB *float64 `type:"double" json:",omitempty"`

	VolumeSizeGiB *float64 `type:"double" json:",omitempty"`

	VolumeSizeInfos []*VolumeSizeInfoForListResourceQueuesOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s QuotaAllocatedForListResourceQueuesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s QuotaAllocatedForListResourceQueuesOutput) GoString() string {
	return s.String()
}

// SetCpu sets the Cpu field's value.
func (s *QuotaAllocatedForListResourceQueuesOutput) SetCpu(v float64) *QuotaAllocatedForListResourceQueuesOutput {
	s.Cpu = &v
	return s
}

// SetGpuCount sets the GpuCount field's value.
func (s *QuotaAllocatedForListResourceQueuesOutput) SetGpuCount(v float64) *QuotaAllocatedForListResourceQueuesOutput {
	s.GpuCount = &v
	return s
}

// SetGpuCountInfos sets the GpuCountInfos field's value.
func (s *QuotaAllocatedForListResourceQueuesOutput) SetGpuCountInfos(v []*GpuCountInfoForListResourceQueuesOutput) *QuotaAllocatedForListResourceQueuesOutput {
	s.GpuCountInfos = v
	return s
}

// SetGpuMemoryInfos sets the GpuMemoryInfos field's value.
func (s *QuotaAllocatedForListResourceQueuesOutput) SetGpuMemoryInfos(v []*GpuMemoryInfoForListResourceQueuesOutput) *QuotaAllocatedForListResourceQueuesOutput {
	s.GpuMemoryInfos = v
	return s
}

// SetGpuRdmaInfos sets the GpuRdmaInfos field's value.
func (s *QuotaAllocatedForListResourceQueuesOutput) SetGpuRdmaInfos(v []*GpuRdmaInfoForListResourceQueuesOutput) *QuotaAllocatedForListResourceQueuesOutput {
	s.GpuRdmaInfos = v
	return s
}

// SetMemoryGiB sets the MemoryGiB field's value.
func (s *QuotaAllocatedForListResourceQueuesOutput) SetMemoryGiB(v float64) *QuotaAllocatedForListResourceQueuesOutput {
	s.MemoryGiB = &v
	return s
}

// SetVolumeSizeGiB sets the VolumeSizeGiB field's value.
func (s *QuotaAllocatedForListResourceQueuesOutput) SetVolumeSizeGiB(v float64) *QuotaAllocatedForListResourceQueuesOutput {
	s.VolumeSizeGiB = &v
	return s
}

// SetVolumeSizeInfos sets the VolumeSizeInfos field's value.
func (s *QuotaAllocatedForListResourceQueuesOutput) SetVolumeSizeInfos(v []*VolumeSizeInfoForListResourceQueuesOutput) *QuotaAllocatedForListResourceQueuesOutput {
	s.VolumeSizeInfos = v
	return s
}

type QuotaCapabilityForListResourceQueuesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Cpu *float64 `type:"double" json:",omitempty"`

	GpuCount *float64 `type:"double" json:",omitempty"`

	GpuCountInfos []*GpuCountInfoForListResourceQueuesOutput `type:"list" json:",omitempty"`

	GpuMemoryInfos []*GpuMemoryInfoForListResourceQueuesOutput `type:"list" json:",omitempty"`

	GpuRdmaInfos []*GpuRdmaInfoForListResourceQueuesOutput `type:"list" json:",omitempty"`

	MemoryGiB *float64 `type:"double" json:",omitempty"`

	VolumeSizeGiB *float64 `type:"double" json:",omitempty"`

	VolumeSizeInfos []*VolumeSizeInfoForListResourceQueuesOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s QuotaCapabilityForListResourceQueuesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s QuotaCapabilityForListResourceQueuesOutput) GoString() string {
	return s.String()
}

// SetCpu sets the Cpu field's value.
func (s *QuotaCapabilityForListResourceQueuesOutput) SetCpu(v float64) *QuotaCapabilityForListResourceQueuesOutput {
	s.Cpu = &v
	return s
}

// SetGpuCount sets the GpuCount field's value.
func (s *QuotaCapabilityForListResourceQueuesOutput) SetGpuCount(v float64) *QuotaCapabilityForListResourceQueuesOutput {
	s.GpuCount = &v
	return s
}

// SetGpuCountInfos sets the GpuCountInfos field's value.
func (s *QuotaCapabilityForListResourceQueuesOutput) SetGpuCountInfos(v []*GpuCountInfoForListResourceQueuesOutput) *QuotaCapabilityForListResourceQueuesOutput {
	s.GpuCountInfos = v
	return s
}

// SetGpuMemoryInfos sets the GpuMemoryInfos field's value.
func (s *QuotaCapabilityForListResourceQueuesOutput) SetGpuMemoryInfos(v []*GpuMemoryInfoForListResourceQueuesOutput) *QuotaCapabilityForListResourceQueuesOutput {
	s.GpuMemoryInfos = v
	return s
}

// SetGpuRdmaInfos sets the GpuRdmaInfos field's value.
func (s *QuotaCapabilityForListResourceQueuesOutput) SetGpuRdmaInfos(v []*GpuRdmaInfoForListResourceQueuesOutput) *QuotaCapabilityForListResourceQueuesOutput {
	s.GpuRdmaInfos = v
	return s
}

// SetMemoryGiB sets the MemoryGiB field's value.
func (s *QuotaCapabilityForListResourceQueuesOutput) SetMemoryGiB(v float64) *QuotaCapabilityForListResourceQueuesOutput {
	s.MemoryGiB = &v
	return s
}

// SetVolumeSizeGiB sets the VolumeSizeGiB field's value.
func (s *QuotaCapabilityForListResourceQueuesOutput) SetVolumeSizeGiB(v float64) *QuotaCapabilityForListResourceQueuesOutput {
	s.VolumeSizeGiB = &v
	return s
}

// SetVolumeSizeInfos sets the VolumeSizeInfos field's value.
func (s *QuotaCapabilityForListResourceQueuesOutput) SetVolumeSizeInfos(v []*VolumeSizeInfoForListResourceQueuesOutput) *QuotaCapabilityForListResourceQueuesOutput {
	s.VolumeSizeInfos = v
	return s
}

type RulesForListResourceQueuesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AutoCompactGPUResourceRule *AutoCompactGPUResourceRuleForListResourceQueuesOutput `type:"structure" json:",omitempty"`

	GeneralIdleRule *GeneralIdleRuleForListResourceQueuesOutput `type:"structure" json:",omitempty"`

	GpuUtilizationRule *GpuUtilizationRuleForListResourceQueuesOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s RulesForListResourceQueuesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RulesForListResourceQueuesOutput) GoString() string {
	return s.String()
}

// SetAutoCompactGPUResourceRule sets the AutoCompactGPUResourceRule field's value.
func (s *RulesForListResourceQueuesOutput) SetAutoCompactGPUResourceRule(v *AutoCompactGPUResourceRuleForListResourceQueuesOutput) *RulesForListResourceQueuesOutput {
	s.AutoCompactGPUResourceRule = v
	return s
}

// SetGeneralIdleRule sets the GeneralIdleRule field's value.
func (s *RulesForListResourceQueuesOutput) SetGeneralIdleRule(v *GeneralIdleRuleForListResourceQueuesOutput) *RulesForListResourceQueuesOutput {
	s.GeneralIdleRule = v
	return s
}

// SetGpuUtilizationRule sets the GpuUtilizationRule field's value.
func (s *RulesForListResourceQueuesOutput) SetGpuUtilizationRule(v *GpuUtilizationRuleForListResourceQueuesOutput) *RulesForListResourceQueuesOutput {
	s.GpuUtilizationRule = v
	return s
}

type SharedQuotaAllocatedForListResourceQueuesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Cpu *float64 `type:"double" json:",omitempty"`

	GpuCount *float64 `type:"double" json:",omitempty"`

	GpuCountInfos []*GpuCountInfoForListResourceQueuesOutput `type:"list" json:",omitempty"`

	GpuMemoryInfos []*GpuMemoryInfoForListResourceQueuesOutput `type:"list" json:",omitempty"`

	GpuRdmaInfos []*GpuRdmaInfoForListResourceQueuesOutput `type:"list" json:",omitempty"`

	MemoryGiB *float64 `type:"double" json:",omitempty"`

	VolumeSizeGiB *float64 `type:"double" json:",omitempty"`

	VolumeSizeInfos []*VolumeSizeInfoForListResourceQueuesOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s SharedQuotaAllocatedForListResourceQueuesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SharedQuotaAllocatedForListResourceQueuesOutput) GoString() string {
	return s.String()
}

// SetCpu sets the Cpu field's value.
func (s *SharedQuotaAllocatedForListResourceQueuesOutput) SetCpu(v float64) *SharedQuotaAllocatedForListResourceQueuesOutput {
	s.Cpu = &v
	return s
}

// SetGpuCount sets the GpuCount field's value.
func (s *SharedQuotaAllocatedForListResourceQueuesOutput) SetGpuCount(v float64) *SharedQuotaAllocatedForListResourceQueuesOutput {
	s.GpuCount = &v
	return s
}

// SetGpuCountInfos sets the GpuCountInfos field's value.
func (s *SharedQuotaAllocatedForListResourceQueuesOutput) SetGpuCountInfos(v []*GpuCountInfoForListResourceQueuesOutput) *SharedQuotaAllocatedForListResourceQueuesOutput {
	s.GpuCountInfos = v
	return s
}

// SetGpuMemoryInfos sets the GpuMemoryInfos field's value.
func (s *SharedQuotaAllocatedForListResourceQueuesOutput) SetGpuMemoryInfos(v []*GpuMemoryInfoForListResourceQueuesOutput) *SharedQuotaAllocatedForListResourceQueuesOutput {
	s.GpuMemoryInfos = v
	return s
}

// SetGpuRdmaInfos sets the GpuRdmaInfos field's value.
func (s *SharedQuotaAllocatedForListResourceQueuesOutput) SetGpuRdmaInfos(v []*GpuRdmaInfoForListResourceQueuesOutput) *SharedQuotaAllocatedForListResourceQueuesOutput {
	s.GpuRdmaInfos = v
	return s
}

// SetMemoryGiB sets the MemoryGiB field's value.
func (s *SharedQuotaAllocatedForListResourceQueuesOutput) SetMemoryGiB(v float64) *SharedQuotaAllocatedForListResourceQueuesOutput {
	s.MemoryGiB = &v
	return s
}

// SetVolumeSizeGiB sets the VolumeSizeGiB field's value.
func (s *SharedQuotaAllocatedForListResourceQueuesOutput) SetVolumeSizeGiB(v float64) *SharedQuotaAllocatedForListResourceQueuesOutput {
	s.VolumeSizeGiB = &v
	return s
}

// SetVolumeSizeInfos sets the VolumeSizeInfos field's value.
func (s *SharedQuotaAllocatedForListResourceQueuesOutput) SetVolumeSizeInfos(v []*VolumeSizeInfoForListResourceQueuesOutput) *SharedQuotaAllocatedForListResourceQueuesOutput {
	s.VolumeSizeInfos = v
	return s
}

type StatusForListResourceQueuesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Message *string `type:"string" json:",omitempty"`

	SecondaryState *string `type:"string" json:",omitempty"`

	State *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s StatusForListResourceQueuesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StatusForListResourceQueuesOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *StatusForListResourceQueuesOutput) SetMessage(v string) *StatusForListResourceQueuesOutput {
	s.Message = &v
	return s
}

// SetSecondaryState sets the SecondaryState field's value.
func (s *StatusForListResourceQueuesOutput) SetSecondaryState(v string) *StatusForListResourceQueuesOutput {
	s.SecondaryState = &v
	return s
}

// SetState sets the State field's value.
func (s *StatusForListResourceQueuesOutput) SetState(v string) *StatusForListResourceQueuesOutput {
	s.State = &v
	return s
}

type SystemQuotaAllocatedForListResourceQueuesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Cpu *float64 `type:"double" json:",omitempty"`

	GpuCount *float64 `type:"double" json:",omitempty"`

	GpuCountInfos []*GpuCountInfoForListResourceQueuesOutput `type:"list" json:",omitempty"`

	GpuMemoryInfos []*GpuMemoryInfoForListResourceQueuesOutput `type:"list" json:",omitempty"`

	GpuRdmaInfos []*GpuRdmaInfoForListResourceQueuesOutput `type:"list" json:",omitempty"`

	MemoryGiB *float64 `type:"double" json:",omitempty"`

	VolumeSizeGiB *float64 `type:"double" json:",omitempty"`

	VolumeSizeInfos []*VolumeSizeInfoForListResourceQueuesOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s SystemQuotaAllocatedForListResourceQueuesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SystemQuotaAllocatedForListResourceQueuesOutput) GoString() string {
	return s.String()
}

// SetCpu sets the Cpu field's value.
func (s *SystemQuotaAllocatedForListResourceQueuesOutput) SetCpu(v float64) *SystemQuotaAllocatedForListResourceQueuesOutput {
	s.Cpu = &v
	return s
}

// SetGpuCount sets the GpuCount field's value.
func (s *SystemQuotaAllocatedForListResourceQueuesOutput) SetGpuCount(v float64) *SystemQuotaAllocatedForListResourceQueuesOutput {
	s.GpuCount = &v
	return s
}

// SetGpuCountInfos sets the GpuCountInfos field's value.
func (s *SystemQuotaAllocatedForListResourceQueuesOutput) SetGpuCountInfos(v []*GpuCountInfoForListResourceQueuesOutput) *SystemQuotaAllocatedForListResourceQueuesOutput {
	s.GpuCountInfos = v
	return s
}

// SetGpuMemoryInfos sets the GpuMemoryInfos field's value.
func (s *SystemQuotaAllocatedForListResourceQueuesOutput) SetGpuMemoryInfos(v []*GpuMemoryInfoForListResourceQueuesOutput) *SystemQuotaAllocatedForListResourceQueuesOutput {
	s.GpuMemoryInfos = v
	return s
}

// SetGpuRdmaInfos sets the GpuRdmaInfos field's value.
func (s *SystemQuotaAllocatedForListResourceQueuesOutput) SetGpuRdmaInfos(v []*GpuRdmaInfoForListResourceQueuesOutput) *SystemQuotaAllocatedForListResourceQueuesOutput {
	s.GpuRdmaInfos = v
	return s
}

// SetMemoryGiB sets the MemoryGiB field's value.
func (s *SystemQuotaAllocatedForListResourceQueuesOutput) SetMemoryGiB(v float64) *SystemQuotaAllocatedForListResourceQueuesOutput {
	s.MemoryGiB = &v
	return s
}

// SetVolumeSizeGiB sets the VolumeSizeGiB field's value.
func (s *SystemQuotaAllocatedForListResourceQueuesOutput) SetVolumeSizeGiB(v float64) *SystemQuotaAllocatedForListResourceQueuesOutput {
	s.VolumeSizeGiB = &v
	return s
}

// SetVolumeSizeInfos sets the VolumeSizeInfos field's value.
func (s *SystemQuotaAllocatedForListResourceQueuesOutput) SetVolumeSizeInfos(v []*VolumeSizeInfoForListResourceQueuesOutput) *SystemQuotaAllocatedForListResourceQueuesOutput {
	s.VolumeSizeInfos = v
	return s
}

type VolumeResourceForListResourceQueuesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Size *int32 `type:"int32" json:",omitempty"`

	VolumeTypeId *string `type:"string" json:",omitempty"`

	ZoneId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s VolumeResourceForListResourceQueuesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VolumeResourceForListResourceQueuesOutput) GoString() string {
	return s.String()
}

// SetSize sets the Size field's value.
func (s *VolumeResourceForListResourceQueuesOutput) SetSize(v int32) *VolumeResourceForListResourceQueuesOutput {
	s.Size = &v
	return s
}

// SetVolumeTypeId sets the VolumeTypeId field's value.
func (s *VolumeResourceForListResourceQueuesOutput) SetVolumeTypeId(v string) *VolumeResourceForListResourceQueuesOutput {
	s.VolumeTypeId = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *VolumeResourceForListResourceQueuesOutput) SetZoneId(v string) *VolumeResourceForListResourceQueuesOutput {
	s.ZoneId = &v
	return s
}

type VolumeSizeInfoForListResourceQueuesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	SizeGiB *int64 `type:"int64" json:",omitempty"`

	VolumeType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s VolumeSizeInfoForListResourceQueuesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VolumeSizeInfoForListResourceQueuesOutput) GoString() string {
	return s.String()
}

// SetSizeGiB sets the SizeGiB field's value.
func (s *VolumeSizeInfoForListResourceQueuesOutput) SetSizeGiB(v int64) *VolumeSizeInfoForListResourceQueuesOutput {
	s.SizeGiB = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *VolumeSizeInfoForListResourceQueuesOutput) SetVolumeType(v string) *VolumeSizeInfoForListResourceQueuesOutput {
	s.VolumeType = &v
	return s
}

type WorkloadInfoForListResourceQueuesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DefaultPriority *int32 `type:"int32" json:",omitempty"`

	WorkloadType *string `type:"string" json:",omitempty" enum:"EnumOfWorkloadTypeForListResourceQueuesOutput"`
}

// String returns the string representation
func (s WorkloadInfoForListResourceQueuesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkloadInfoForListResourceQueuesOutput) GoString() string {
	return s.String()
}

// SetDefaultPriority sets the DefaultPriority field's value.
func (s *WorkloadInfoForListResourceQueuesOutput) SetDefaultPriority(v int32) *WorkloadInfoForListResourceQueuesOutput {
	s.DefaultPriority = &v
	return s
}

// SetWorkloadType sets the WorkloadType field's value.
func (s *WorkloadInfoForListResourceQueuesOutput) SetWorkloadType(v string) *WorkloadInfoForListResourceQueuesOutput {
	s.WorkloadType = &v
	return s
}

const (
	// EnumOfChargeTypeForListResourceQueuesInputPaused is a EnumOfChargeTypeForListResourceQueuesInput enum value
	EnumOfChargeTypeForListResourceQueuesInputPaused = "Paused"

	// EnumOfChargeTypeForListResourceQueuesInputRunning is a EnumOfChargeTypeForListResourceQueuesInput enum value
	EnumOfChargeTypeForListResourceQueuesInputRunning = "Running"

	// EnumOfChargeTypeForListResourceQueuesInputClosed is a EnumOfChargeTypeForListResourceQueuesInput enum value
	EnumOfChargeTypeForListResourceQueuesInputClosed = "Closed"

	// EnumOfChargeTypeForListResourceQueuesInputClosing is a EnumOfChargeTypeForListResourceQueuesInput enum value
	EnumOfChargeTypeForListResourceQueuesInputClosing = "Closing"
)

const (
	// EnumOfChargeTypeForListResourceQueuesOutputPrePaid is a EnumOfChargeTypeForListResourceQueuesOutput enum value
	EnumOfChargeTypeForListResourceQueuesOutputPrePaid = "PrePaid"

	// EnumOfChargeTypeForListResourceQueuesOutputPostPaid is a EnumOfChargeTypeForListResourceQueuesOutput enum value
	EnumOfChargeTypeForListResourceQueuesOutputPostPaid = "PostPaid"
)

const (
	// EnumOfIdleShutdownRuleTypeListForListResourceQueuesOutputCpu is a EnumOfIdleShutdownRuleTypeListForListResourceQueuesOutput enum value
	EnumOfIdleShutdownRuleTypeListForListResourceQueuesOutputCpu = "Cpu"

	// EnumOfIdleShutdownRuleTypeListForListResourceQueuesOutputGpu is a EnumOfIdleShutdownRuleTypeListForListResourceQueuesOutput enum value
	EnumOfIdleShutdownRuleTypeListForListResourceQueuesOutputGpu = " Gpu"
)

const (
	// EnumOfSortByForListResourceQueuesInputCreateTime is a EnumOfSortByForListResourceQueuesInput enum value
	EnumOfSortByForListResourceQueuesInputCreateTime = "CreateTime"
)

const (
	// EnumOfSortOrderForListResourceQueuesInputAscend is a EnumOfSortOrderForListResourceQueuesInput enum value
	EnumOfSortOrderForListResourceQueuesInputAscend = "Ascend"

	// EnumOfSortOrderForListResourceQueuesInputDescend is a EnumOfSortOrderForListResourceQueuesInput enum value
	EnumOfSortOrderForListResourceQueuesInputDescend = "Descend"
)

const (
	// EnumOfStatusListForListResourceQueuesInputPrePaid is a EnumOfStatusListForListResourceQueuesInput enum value
	EnumOfStatusListForListResourceQueuesInputPrePaid = "PrePaid"

	// EnumOfStatusListForListResourceQueuesInputPostPaid is a EnumOfStatusListForListResourceQueuesInput enum value
	EnumOfStatusListForListResourceQueuesInputPostPaid = "PostPaid"
)

const (
	// EnumOfWorkloadTypeForListResourceQueuesOutputJob is a EnumOfWorkloadTypeForListResourceQueuesOutput enum value
	EnumOfWorkloadTypeForListResourceQueuesOutputJob = "Job"

	// EnumOfWorkloadTypeForListResourceQueuesOutputDevInstance is a EnumOfWorkloadTypeForListResourceQueuesOutput enum value
	EnumOfWorkloadTypeForListResourceQueuesOutputDevInstance = "DevInstance"

	// EnumOfWorkloadTypeForListResourceQueuesOutputService is a EnumOfWorkloadTypeForListResourceQueuesOutput enum value
	EnumOfWorkloadTypeForListResourceQueuesOutputService = "Service"
)
