// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package mlplatform20240701

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListResourceGroupsCommon = "ListResourceGroups"

// ListResourceGroupsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListResourceGroupsCommon operation. The "output" return
// value will be populated with the ListResourceGroupsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListResourceGroupsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListResourceGroupsCommon Send returns without error.
//
// See ListResourceGroupsCommon for more information on using the ListResourceGroupsCommon
// API call, and error handling.
//
//    // Example sending a request using the ListResourceGroupsCommonRequest method.
//    req, resp := client.ListResourceGroupsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MLPLATFORM20240701) ListResourceGroupsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListResourceGroupsCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListResourceGroupsCommon API operation for ML_PLATFORM20240701.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ML_PLATFORM20240701's
// API operation ListResourceGroupsCommon for usage and error information.
func (c *MLPLATFORM20240701) ListResourceGroupsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListResourceGroupsCommonRequest(input)
	return out, req.Send()
}

// ListResourceGroupsCommonWithContext is the same as ListResourceGroupsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListResourceGroupsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MLPLATFORM20240701) ListResourceGroupsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListResourceGroupsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListResourceGroups = "ListResourceGroups"

// ListResourceGroupsRequest generates a "volcengine/request.Request" representing the
// client's request for the ListResourceGroups operation. The "output" return
// value will be populated with the ListResourceGroupsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListResourceGroupsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListResourceGroupsCommon Send returns without error.
//
// See ListResourceGroups for more information on using the ListResourceGroups
// API call, and error handling.
//
//    // Example sending a request using the ListResourceGroupsRequest method.
//    req, resp := client.ListResourceGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MLPLATFORM20240701) ListResourceGroupsRequest(input *ListResourceGroupsInput) (req *request.Request, output *ListResourceGroupsOutput) {
	op := &request.Operation{
		Name:       opListResourceGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListResourceGroupsInput{}
	}

	output = &ListResourceGroupsOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListResourceGroups API operation for ML_PLATFORM20240701.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ML_PLATFORM20240701's
// API operation ListResourceGroups for usage and error information.
func (c *MLPLATFORM20240701) ListResourceGroups(input *ListResourceGroupsInput) (*ListResourceGroupsOutput, error) {
	req, out := c.ListResourceGroupsRequest(input)
	return out, req.Send()
}

// ListResourceGroupsWithContext is the same as ListResourceGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListResourceGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MLPLATFORM20240701) ListResourceGroupsWithContext(ctx volcengine.Context, input *ListResourceGroupsInput, opts ...request.Option) (*ListResourceGroupsOutput, error) {
	req, out := c.ListResourceGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ComputeResourceForListResourceGroupsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Count *int32 `type:"int32" json:",omitempty"`

	InstanceTypeId *string `type:"string" json:",omitempty"`

	ZoneId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ComputeResourceForListResourceGroupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ComputeResourceForListResourceGroupsOutput) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *ComputeResourceForListResourceGroupsOutput) SetCount(v int32) *ComputeResourceForListResourceGroupsOutput {
	s.Count = &v
	return s
}

// SetInstanceTypeId sets the InstanceTypeId field's value.
func (s *ComputeResourceForListResourceGroupsOutput) SetInstanceTypeId(v string) *ComputeResourceForListResourceGroupsOutput {
	s.InstanceTypeId = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *ComputeResourceForListResourceGroupsOutput) SetZoneId(v string) *ComputeResourceForListResourceGroupsOutput {
	s.ZoneId = &v
	return s
}

type ItemForListResourceGroupsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ChargeType *string `type:"string" json:",omitempty"`

	Description *string `min:"1" max:"500" type:"string" json:",omitempty"`

	ExpireTime *string `type:"string" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	Name *string `min:"1" max:"200" type:"string" json:",omitempty"`

	PeriodUnit *string `type:"string" json:",omitempty"`

	ResourceAllocated *ResourceAllocatedForListResourceGroupsOutput `type:"structure" json:",omitempty"`

	ResourceCapability *ResourceCapabilityForListResourceGroupsOutput `type:"structure" json:",omitempty"`

	Status *StatusForListResourceGroupsOutput `type:"structure" json:",omitempty"`

	StorageConfig *StorageConfigForListResourceGroupsOutput `type:"structure" json:",omitempty"`

	WorkloadNetworkConfig *WorkloadNetworkConfigForListResourceGroupsOutput `type:"structure" json:",omitempty"`

	WorkloadNetworkMode *string `type:"string" json:",omitempty"`

	ZoneIds []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ItemForListResourceGroupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ItemForListResourceGroupsOutput) GoString() string {
	return s.String()
}

// SetChargeType sets the ChargeType field's value.
func (s *ItemForListResourceGroupsOutput) SetChargeType(v string) *ItemForListResourceGroupsOutput {
	s.ChargeType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ItemForListResourceGroupsOutput) SetDescription(v string) *ItemForListResourceGroupsOutput {
	s.Description = &v
	return s
}

// SetExpireTime sets the ExpireTime field's value.
func (s *ItemForListResourceGroupsOutput) SetExpireTime(v string) *ItemForListResourceGroupsOutput {
	s.ExpireTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *ItemForListResourceGroupsOutput) SetId(v string) *ItemForListResourceGroupsOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *ItemForListResourceGroupsOutput) SetName(v string) *ItemForListResourceGroupsOutput {
	s.Name = &v
	return s
}

// SetPeriodUnit sets the PeriodUnit field's value.
func (s *ItemForListResourceGroupsOutput) SetPeriodUnit(v string) *ItemForListResourceGroupsOutput {
	s.PeriodUnit = &v
	return s
}

// SetResourceAllocated sets the ResourceAllocated field's value.
func (s *ItemForListResourceGroupsOutput) SetResourceAllocated(v *ResourceAllocatedForListResourceGroupsOutput) *ItemForListResourceGroupsOutput {
	s.ResourceAllocated = v
	return s
}

// SetResourceCapability sets the ResourceCapability field's value.
func (s *ItemForListResourceGroupsOutput) SetResourceCapability(v *ResourceCapabilityForListResourceGroupsOutput) *ItemForListResourceGroupsOutput {
	s.ResourceCapability = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ItemForListResourceGroupsOutput) SetStatus(v *StatusForListResourceGroupsOutput) *ItemForListResourceGroupsOutput {
	s.Status = v
	return s
}

// SetStorageConfig sets the StorageConfig field's value.
func (s *ItemForListResourceGroupsOutput) SetStorageConfig(v *StorageConfigForListResourceGroupsOutput) *ItemForListResourceGroupsOutput {
	s.StorageConfig = v
	return s
}

// SetWorkloadNetworkConfig sets the WorkloadNetworkConfig field's value.
func (s *ItemForListResourceGroupsOutput) SetWorkloadNetworkConfig(v *WorkloadNetworkConfigForListResourceGroupsOutput) *ItemForListResourceGroupsOutput {
	s.WorkloadNetworkConfig = v
	return s
}

// SetWorkloadNetworkMode sets the WorkloadNetworkMode field's value.
func (s *ItemForListResourceGroupsOutput) SetWorkloadNetworkMode(v string) *ItemForListResourceGroupsOutput {
	s.WorkloadNetworkMode = &v
	return s
}

// SetZoneIds sets the ZoneIds field's value.
func (s *ItemForListResourceGroupsOutput) SetZoneIds(v []*string) *ItemForListResourceGroupsOutput {
	s.ZoneIds = v
	return s
}

type ListResourceGroupsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ChargeType *string `type:"string" json:",omitempty"`

	Ids []*string `type:"list" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	NameContains *string `type:"string" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `min:"10" max:"100" type:"int32" json:",omitempty"`

	SortBy *string `type:"string" json:",omitempty" enum:"EnumOfSortByForListResourceGroupsInput"`

	SortOrder *string `type:"string" json:",omitempty" enum:"EnumOfSortOrderForListResourceGroupsInput"`

	States []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ListResourceGroupsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourceGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListResourceGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListResourceGroupsInput"}
	if s.PageSize != nil && *s.PageSize < 10 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 10))
	}
	if s.PageSize != nil && *s.PageSize > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("PageSize", 100))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetChargeType sets the ChargeType field's value.
func (s *ListResourceGroupsInput) SetChargeType(v string) *ListResourceGroupsInput {
	s.ChargeType = &v
	return s
}

// SetIds sets the Ids field's value.
func (s *ListResourceGroupsInput) SetIds(v []*string) *ListResourceGroupsInput {
	s.Ids = v
	return s
}

// SetName sets the Name field's value.
func (s *ListResourceGroupsInput) SetName(v string) *ListResourceGroupsInput {
	s.Name = &v
	return s
}

// SetNameContains sets the NameContains field's value.
func (s *ListResourceGroupsInput) SetNameContains(v string) *ListResourceGroupsInput {
	s.NameContains = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListResourceGroupsInput) SetPageNumber(v int32) *ListResourceGroupsInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListResourceGroupsInput) SetPageSize(v int32) *ListResourceGroupsInput {
	s.PageSize = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListResourceGroupsInput) SetSortBy(v string) *ListResourceGroupsInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListResourceGroupsInput) SetSortOrder(v string) *ListResourceGroupsInput {
	s.SortOrder = &v
	return s
}

// SetStates sets the States field's value.
func (s *ListResourceGroupsInput) SetStates(v []*string) *ListResourceGroupsInput {
	s.States = v
	return s
}

type ListResourceGroupsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Items []*ItemForListResourceGroupsOutput `type:"list" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ListResourceGroupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListResourceGroupsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListResourceGroupsOutput) SetItems(v []*ItemForListResourceGroupsOutput) *ListResourceGroupsOutput {
	s.Items = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListResourceGroupsOutput) SetPageNumber(v int32) *ListResourceGroupsOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListResourceGroupsOutput) SetPageSize(v int32) *ListResourceGroupsOutput {
	s.PageSize = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListResourceGroupsOutput) SetTotalCount(v int32) *ListResourceGroupsOutput {
	s.TotalCount = &v
	return s
}

type ResourceAllocatedForListResourceGroupsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ComputeResources []*ComputeResourceForListResourceGroupsOutput `type:"list" json:",omitempty"`

	VolumeResources []*VolumeResourceForListResourceGroupsOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ResourceAllocatedForListResourceGroupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceAllocatedForListResourceGroupsOutput) GoString() string {
	return s.String()
}

// SetComputeResources sets the ComputeResources field's value.
func (s *ResourceAllocatedForListResourceGroupsOutput) SetComputeResources(v []*ComputeResourceForListResourceGroupsOutput) *ResourceAllocatedForListResourceGroupsOutput {
	s.ComputeResources = v
	return s
}

// SetVolumeResources sets the VolumeResources field's value.
func (s *ResourceAllocatedForListResourceGroupsOutput) SetVolumeResources(v []*VolumeResourceForListResourceGroupsOutput) *ResourceAllocatedForListResourceGroupsOutput {
	s.VolumeResources = v
	return s
}

type ResourceCapabilityForListResourceGroupsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ComputeResources []*ComputeResourceForListResourceGroupsOutput `type:"list" json:",omitempty"`

	VolumeResources []*VolumeResourceForListResourceGroupsOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ResourceCapabilityForListResourceGroupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceCapabilityForListResourceGroupsOutput) GoString() string {
	return s.String()
}

// SetComputeResources sets the ComputeResources field's value.
func (s *ResourceCapabilityForListResourceGroupsOutput) SetComputeResources(v []*ComputeResourceForListResourceGroupsOutput) *ResourceCapabilityForListResourceGroupsOutput {
	s.ComputeResources = v
	return s
}

// SetVolumeResources sets the VolumeResources field's value.
func (s *ResourceCapabilityForListResourceGroupsOutput) SetVolumeResources(v []*VolumeResourceForListResourceGroupsOutput) *ResourceCapabilityForListResourceGroupsOutput {
	s.VolumeResources = v
	return s
}

type SfcsForListResourceGroupsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Replicas *int64 `type:"int64" json:",omitempty"`

	Status *string `type:"string" json:",omitempty"`

	ZoneId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s SfcsForListResourceGroupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SfcsForListResourceGroupsOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *SfcsForListResourceGroupsOutput) SetDescription(v string) *SfcsForListResourceGroupsOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *SfcsForListResourceGroupsOutput) SetId(v string) *SfcsForListResourceGroupsOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *SfcsForListResourceGroupsOutput) SetName(v string) *SfcsForListResourceGroupsOutput {
	s.Name = &v
	return s
}

// SetReplicas sets the Replicas field's value.
func (s *SfcsForListResourceGroupsOutput) SetReplicas(v int64) *SfcsForListResourceGroupsOutput {
	s.Replicas = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *SfcsForListResourceGroupsOutput) SetStatus(v string) *SfcsForListResourceGroupsOutput {
	s.Status = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *SfcsForListResourceGroupsOutput) SetZoneId(v string) *SfcsForListResourceGroupsOutput {
	s.ZoneId = &v
	return s
}

type StatusForListResourceGroupsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Message *string `type:"string" json:",omitempty"`

	SecondaryState *string `type:"string" json:",omitempty"`

	State *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s StatusForListResourceGroupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StatusForListResourceGroupsOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *StatusForListResourceGroupsOutput) SetMessage(v string) *StatusForListResourceGroupsOutput {
	s.Message = &v
	return s
}

// SetSecondaryState sets the SecondaryState field's value.
func (s *StatusForListResourceGroupsOutput) SetSecondaryState(v string) *StatusForListResourceGroupsOutput {
	s.SecondaryState = &v
	return s
}

// SetState sets the State field's value.
func (s *StatusForListResourceGroupsOutput) SetState(v string) *StatusForListResourceGroupsOutput {
	s.State = &v
	return s
}

type StorageConfigForListResourceGroupsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Sfcs *SfcsForListResourceGroupsOutput `type:"structure" json:",omitempty"`

	StorageNetworkConfig *StorageNetworkConfigForListResourceGroupsOutput `type:"structure" json:",omitempty"`

	Vepfs *VepfsForListResourceGroupsOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s StorageConfigForListResourceGroupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageConfigForListResourceGroupsOutput) GoString() string {
	return s.String()
}

// SetSfcs sets the Sfcs field's value.
func (s *StorageConfigForListResourceGroupsOutput) SetSfcs(v *SfcsForListResourceGroupsOutput) *StorageConfigForListResourceGroupsOutput {
	s.Sfcs = v
	return s
}

// SetStorageNetworkConfig sets the StorageNetworkConfig field's value.
func (s *StorageConfigForListResourceGroupsOutput) SetStorageNetworkConfig(v *StorageNetworkConfigForListResourceGroupsOutput) *StorageConfigForListResourceGroupsOutput {
	s.StorageNetworkConfig = v
	return s
}

// SetVepfs sets the Vepfs field's value.
func (s *StorageConfigForListResourceGroupsOutput) SetVepfs(v *VepfsForListResourceGroupsOutput) *StorageConfigForListResourceGroupsOutput {
	s.Vepfs = v
	return s
}

type StorageNetworkConfigForListResourceGroupsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	SecurityGroupIds []*string `type:"list" json:",omitempty"`

	SubnetIds []*string `type:"list" json:",omitempty"`

	VpcId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s StorageNetworkConfigForListResourceGroupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageNetworkConfigForListResourceGroupsOutput) GoString() string {
	return s.String()
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *StorageNetworkConfigForListResourceGroupsOutput) SetSecurityGroupIds(v []*string) *StorageNetworkConfigForListResourceGroupsOutput {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *StorageNetworkConfigForListResourceGroupsOutput) SetSubnetIds(v []*string) *StorageNetworkConfigForListResourceGroupsOutput {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *StorageNetworkConfigForListResourceGroupsOutput) SetVpcId(v string) *StorageNetworkConfigForListResourceGroupsOutput {
	s.VpcId = &v
	return s
}

type VepfsForListResourceGroupsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	FileSystemIds []*string `type:"list" json:",omitempty"`

	MountServiceId *string `type:"string" json:",omitempty"`

	PrefetchEnabled *bool `type:"boolean" json:",omitempty"`

	UnavailableNodeCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s VepfsForListResourceGroupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VepfsForListResourceGroupsOutput) GoString() string {
	return s.String()
}

// SetFileSystemIds sets the FileSystemIds field's value.
func (s *VepfsForListResourceGroupsOutput) SetFileSystemIds(v []*string) *VepfsForListResourceGroupsOutput {
	s.FileSystemIds = v
	return s
}

// SetMountServiceId sets the MountServiceId field's value.
func (s *VepfsForListResourceGroupsOutput) SetMountServiceId(v string) *VepfsForListResourceGroupsOutput {
	s.MountServiceId = &v
	return s
}

// SetPrefetchEnabled sets the PrefetchEnabled field's value.
func (s *VepfsForListResourceGroupsOutput) SetPrefetchEnabled(v bool) *VepfsForListResourceGroupsOutput {
	s.PrefetchEnabled = &v
	return s
}

// SetUnavailableNodeCount sets the UnavailableNodeCount field's value.
func (s *VepfsForListResourceGroupsOutput) SetUnavailableNodeCount(v int32) *VepfsForListResourceGroupsOutput {
	s.UnavailableNodeCount = &v
	return s
}

type VolumeResourceForListResourceGroupsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Size *int32 `type:"int32" json:",omitempty"`

	VolumeTypeId *string `type:"string" json:",omitempty"`

	ZoneId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s VolumeResourceForListResourceGroupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VolumeResourceForListResourceGroupsOutput) GoString() string {
	return s.String()
}

// SetSize sets the Size field's value.
func (s *VolumeResourceForListResourceGroupsOutput) SetSize(v int32) *VolumeResourceForListResourceGroupsOutput {
	s.Size = &v
	return s
}

// SetVolumeTypeId sets the VolumeTypeId field's value.
func (s *VolumeResourceForListResourceGroupsOutput) SetVolumeTypeId(v string) *VolumeResourceForListResourceGroupsOutput {
	s.VolumeTypeId = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *VolumeResourceForListResourceGroupsOutput) SetZoneId(v string) *VolumeResourceForListResourceGroupsOutput {
	s.ZoneId = &v
	return s
}

type WorkloadNetworkConfigForListResourceGroupsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	SecurityGroupIds []*string `type:"list" json:",omitempty"`

	SubnetIds []*string `type:"list" json:",omitempty"`

	VpcId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s WorkloadNetworkConfigForListResourceGroupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkloadNetworkConfigForListResourceGroupsOutput) GoString() string {
	return s.String()
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *WorkloadNetworkConfigForListResourceGroupsOutput) SetSecurityGroupIds(v []*string) *WorkloadNetworkConfigForListResourceGroupsOutput {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *WorkloadNetworkConfigForListResourceGroupsOutput) SetSubnetIds(v []*string) *WorkloadNetworkConfigForListResourceGroupsOutput {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *WorkloadNetworkConfigForListResourceGroupsOutput) SetVpcId(v string) *WorkloadNetworkConfigForListResourceGroupsOutput {
	s.VpcId = &v
	return s
}

const (
	// EnumOfSortByForListResourceGroupsInputCreateTime is a EnumOfSortByForListResourceGroupsInput enum value
	EnumOfSortByForListResourceGroupsInputCreateTime = "CreateTime"
)

const (
	// EnumOfSortOrderForListResourceGroupsInputAscend is a EnumOfSortOrderForListResourceGroupsInput enum value
	EnumOfSortOrderForListResourceGroupsInputAscend = "Ascend"

	// EnumOfSortOrderForListResourceGroupsInputDescend is a EnumOfSortOrderForListResourceGroupsInput enum value
	EnumOfSortOrderForListResourceGroupsInputDescend = "Descend"
)
