// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package mlplatform20240701

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListDevInstancesCommon = "ListDevInstances"

// ListDevInstancesCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListDevInstancesCommon operation. The "output" return
// value will be populated with the ListDevInstancesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListDevInstancesCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListDevInstancesCommon Send returns without error.
//
// See ListDevInstancesCommon for more information on using the ListDevInstancesCommon
// API call, and error handling.
//
//    // Example sending a request using the ListDevInstancesCommonRequest method.
//    req, resp := client.ListDevInstancesCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MLPLATFORM20240701) ListDevInstancesCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListDevInstancesCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListDevInstancesCommon API operation for ML_PLATFORM20240701.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ML_PLATFORM20240701's
// API operation ListDevInstancesCommon for usage and error information.
func (c *MLPLATFORM20240701) ListDevInstancesCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListDevInstancesCommonRequest(input)
	return out, req.Send()
}

// ListDevInstancesCommonWithContext is the same as ListDevInstancesCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListDevInstancesCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MLPLATFORM20240701) ListDevInstancesCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListDevInstancesCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDevInstances = "ListDevInstances"

// ListDevInstancesRequest generates a "volcengine/request.Request" representing the
// client's request for the ListDevInstances operation. The "output" return
// value will be populated with the ListDevInstancesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListDevInstancesCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListDevInstancesCommon Send returns without error.
//
// See ListDevInstances for more information on using the ListDevInstances
// API call, and error handling.
//
//    // Example sending a request using the ListDevInstancesRequest method.
//    req, resp := client.ListDevInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MLPLATFORM20240701) ListDevInstancesRequest(input *ListDevInstancesInput) (req *request.Request, output *ListDevInstancesOutput) {
	op := &request.Operation{
		Name:       opListDevInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListDevInstancesInput{}
	}

	output = &ListDevInstancesOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListDevInstances API operation for ML_PLATFORM20240701.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ML_PLATFORM20240701's
// API operation ListDevInstances for usage and error information.
func (c *MLPLATFORM20240701) ListDevInstances(input *ListDevInstancesInput) (*ListDevInstancesOutput, error) {
	req, out := c.ListDevInstancesRequest(input)
	return out, req.Send()
}

// ListDevInstancesWithContext is the same as ListDevInstances with the addition of
// the ability to pass a context and additional request options.
//
// See ListDevInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MLPLATFORM20240701) ListDevInstancesWithContext(ctx volcengine.Context, input *ListDevInstancesInput, opts ...request.Option) (*ListDevInstancesOutput, error) {
	req, out := c.ListDevInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CfsForListDevInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	FileSystemName *string `type:"string" json:",omitempty"`

	NamespaceId *string `type:"string" json:",omitempty"`

	Options *OptionsForListDevInstancesOutput `type:"structure" json:",omitempty"`

	Tos *TosForListDevInstancesOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s CfsForListDevInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CfsForListDevInstancesOutput) GoString() string {
	return s.String()
}

// SetFileSystemName sets the FileSystemName field's value.
func (s *CfsForListDevInstancesOutput) SetFileSystemName(v string) *CfsForListDevInstancesOutput {
	s.FileSystemName = &v
	return s
}

// SetNamespaceId sets the NamespaceId field's value.
func (s *CfsForListDevInstancesOutput) SetNamespaceId(v string) *CfsForListDevInstancesOutput {
	s.NamespaceId = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *CfsForListDevInstancesOutput) SetOptions(v *OptionsForListDevInstancesOutput) *CfsForListDevInstancesOutput {
	s.Options = v
	return s
}

// SetTos sets the Tos field's value.
func (s *CfsForListDevInstancesOutput) SetTos(v *TosForListDevInstancesOutput) *CfsForListDevInstancesOutput {
	s.Tos = v
	return s
}

type ConfigForListDevInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Cfs *CfsForListDevInstancesOutput `type:"structure" json:",omitempty"`

	Nas *NasForListDevInstancesOutput `type:"structure" json:",omitempty"`

	Sfcs *SfcsForListDevInstancesOutput `type:"structure" json:",omitempty"`

	Tos *TosForListDevInstancesOutput `type:"structure" json:",omitempty"`

	Vepfs *VepfsForListDevInstancesOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s ConfigForListDevInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigForListDevInstancesOutput) GoString() string {
	return s.String()
}

// SetCfs sets the Cfs field's value.
func (s *ConfigForListDevInstancesOutput) SetCfs(v *CfsForListDevInstancesOutput) *ConfigForListDevInstancesOutput {
	s.Cfs = v
	return s
}

// SetNas sets the Nas field's value.
func (s *ConfigForListDevInstancesOutput) SetNas(v *NasForListDevInstancesOutput) *ConfigForListDevInstancesOutput {
	s.Nas = v
	return s
}

// SetSfcs sets the Sfcs field's value.
func (s *ConfigForListDevInstancesOutput) SetSfcs(v *SfcsForListDevInstancesOutput) *ConfigForListDevInstancesOutput {
	s.Sfcs = v
	return s
}

// SetTos sets the Tos field's value.
func (s *ConfigForListDevInstancesOutput) SetTos(v *TosForListDevInstancesOutput) *ConfigForListDevInstancesOutput {
	s.Tos = v
	return s
}

// SetVepfs sets the Vepfs field's value.
func (s *ConfigForListDevInstancesOutput) SetVepfs(v *VepfsForListDevInstancesOutput) *ConfigForListDevInstancesOutput {
	s.Vepfs = v
	return s
}

type ConvertOptionsForListDevInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	InternalSync *int64 `type:"int64" json:",omitempty"`

	Replicas *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s ConvertOptionsForListDevInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertOptionsForListDevInstancesOutput) GoString() string {
	return s.String()
}

// SetInternalSync sets the InternalSync field's value.
func (s *ConvertOptionsForListDevInstancesOutput) SetInternalSync(v int64) *ConvertOptionsForListDevInstancesOutput {
	s.InternalSync = &v
	return s
}

// SetReplicas sets the Replicas field's value.
func (s *ConvertOptionsForListDevInstancesOutput) SetReplicas(v int64) *ConvertOptionsForListDevInstancesOutput {
	s.Replicas = &v
	return s
}

type CredentialForListDevInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	RegistryToken *string `type:"string" json:",omitempty"`

	RegistryUsername *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CredentialForListDevInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CredentialForListDevInstancesOutput) GoString() string {
	return s.String()
}

// SetRegistryToken sets the RegistryToken field's value.
func (s *CredentialForListDevInstancesOutput) SetRegistryToken(v string) *CredentialForListDevInstancesOutput {
	s.RegistryToken = &v
	return s
}

// SetRegistryUsername sets the RegistryUsername field's value.
func (s *CredentialForListDevInstancesOutput) SetRegistryUsername(v string) *CredentialForListDevInstancesOutput {
	s.RegistryUsername = &v
	return s
}

type FlexibleResourceClaimForListDevInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Cpu *float64 `type:"double" json:",omitempty"`

	Family *string `type:"string" json:",omitempty"`

	GpuCount *float64 `type:"double" json:",omitempty"`

	GpuType *string `type:"string" json:",omitempty"`

	MemoryGiB *float64 `type:"double" json:",omitempty"`

	RdmaEniCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s FlexibleResourceClaimForListDevInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FlexibleResourceClaimForListDevInstancesOutput) GoString() string {
	return s.String()
}

// SetCpu sets the Cpu field's value.
func (s *FlexibleResourceClaimForListDevInstancesOutput) SetCpu(v float64) *FlexibleResourceClaimForListDevInstancesOutput {
	s.Cpu = &v
	return s
}

// SetFamily sets the Family field's value.
func (s *FlexibleResourceClaimForListDevInstancesOutput) SetFamily(v string) *FlexibleResourceClaimForListDevInstancesOutput {
	s.Family = &v
	return s
}

// SetGpuCount sets the GpuCount field's value.
func (s *FlexibleResourceClaimForListDevInstancesOutput) SetGpuCount(v float64) *FlexibleResourceClaimForListDevInstancesOutput {
	s.GpuCount = &v
	return s
}

// SetGpuType sets the GpuType field's value.
func (s *FlexibleResourceClaimForListDevInstancesOutput) SetGpuType(v string) *FlexibleResourceClaimForListDevInstancesOutput {
	s.GpuType = &v
	return s
}

// SetMemoryGiB sets the MemoryGiB field's value.
func (s *FlexibleResourceClaimForListDevInstancesOutput) SetMemoryGiB(v float64) *FlexibleResourceClaimForListDevInstancesOutput {
	s.MemoryGiB = &v
	return s
}

// SetRdmaEniCount sets the RdmaEniCount field's value.
func (s *FlexibleResourceClaimForListDevInstancesOutput) SetRdmaEniCount(v int32) *FlexibleResourceClaimForListDevInstancesOutput {
	s.RdmaEniCount = &v
	return s
}

type ImageForListDevInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Credential *CredentialForListDevInstancesOutput `type:"structure" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`

	Url *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ImageForListDevInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ImageForListDevInstancesOutput) GoString() string {
	return s.String()
}

// SetCredential sets the Credential field's value.
func (s *ImageForListDevInstancesOutput) SetCredential(v *CredentialForListDevInstancesOutput) *ImageForListDevInstancesOutput {
	s.Credential = v
	return s
}

// SetType sets the Type field's value.
func (s *ImageForListDevInstancesOutput) SetType(v string) *ImageForListDevInstancesOutput {
	s.Type = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *ImageForListDevInstancesOutput) SetUrl(v string) *ImageForListDevInstancesOutput {
	s.Url = &v
	return s
}

type ListDevInstancesInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CreateUserIds []*int32 `type:"list" json:",omitempty"`

	IdContains *string `type:"string" json:",omitempty"`

	Ids []*string `type:"list" json:",omitempty"`

	NameContains *string `type:"string" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `min:"10" max:"100" type:"int32" json:",omitempty"`

	Relationship *string `type:"string" json:",omitempty" enum:"EnumOfRelationshipForListDevInstancesInput"`

	ResourceGroupIds []*string `type:"list" json:",omitempty"`

	ResourceQueueIds []*string `type:"list" json:",omitempty"`

	SortBy *string `type:"string" json:",omitempty" enum:"EnumOfSortByForListDevInstancesInput"`

	SortOrder *string `type:"string" json:",omitempty" enum:"EnumOfSortOrderForListDevInstancesInput"`

	States []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ListDevInstancesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDevInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDevInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDevInstancesInput"}
	if s.PageSize != nil && *s.PageSize < 10 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 10))
	}
	if s.PageSize != nil && *s.PageSize > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("PageSize", 100))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCreateUserIds sets the CreateUserIds field's value.
func (s *ListDevInstancesInput) SetCreateUserIds(v []*int32) *ListDevInstancesInput {
	s.CreateUserIds = v
	return s
}

// SetIdContains sets the IdContains field's value.
func (s *ListDevInstancesInput) SetIdContains(v string) *ListDevInstancesInput {
	s.IdContains = &v
	return s
}

// SetIds sets the Ids field's value.
func (s *ListDevInstancesInput) SetIds(v []*string) *ListDevInstancesInput {
	s.Ids = v
	return s
}

// SetNameContains sets the NameContains field's value.
func (s *ListDevInstancesInput) SetNameContains(v string) *ListDevInstancesInput {
	s.NameContains = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListDevInstancesInput) SetPageNumber(v int32) *ListDevInstancesInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListDevInstancesInput) SetPageSize(v int32) *ListDevInstancesInput {
	s.PageSize = &v
	return s
}

// SetRelationship sets the Relationship field's value.
func (s *ListDevInstancesInput) SetRelationship(v string) *ListDevInstancesInput {
	s.Relationship = &v
	return s
}

// SetResourceGroupIds sets the ResourceGroupIds field's value.
func (s *ListDevInstancesInput) SetResourceGroupIds(v []*string) *ListDevInstancesInput {
	s.ResourceGroupIds = v
	return s
}

// SetResourceQueueIds sets the ResourceQueueIds field's value.
func (s *ListDevInstancesInput) SetResourceQueueIds(v []*string) *ListDevInstancesInput {
	s.ResourceQueueIds = v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListDevInstancesInput) SetSortBy(v string) *ListDevInstancesInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListDevInstancesInput) SetSortOrder(v string) *ListDevInstancesInput {
	s.SortOrder = &v
	return s
}

// SetStates sets the States field's value.
func (s *ListDevInstancesInput) SetStates(v []*string) *ListDevInstancesInput {
	s.States = v
	return s
}

type ListDevInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	List []*ListForListDevInstancesOutput `type:"list" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ListDevInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDevInstancesOutput) GoString() string {
	return s.String()
}

// SetList sets the List field's value.
func (s *ListDevInstancesOutput) SetList(v []*ListForListDevInstancesOutput) *ListDevInstancesOutput {
	s.List = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListDevInstancesOutput) SetPageNumber(v int32) *ListDevInstancesOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListDevInstancesOutput) SetPageSize(v int32) *ListDevInstancesOutput {
	s.PageSize = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListDevInstancesOutput) SetTotalCount(v int32) *ListDevInstancesOutput {
	s.TotalCount = &v
	return s
}

type ListForListDevInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AllowImageBuild *bool `type:"boolean" json:",omitempty"`

	CreateTime *string `type:"string" json:",omitempty"`

	CreatorTrn *string `type:"string" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	ExpectedStopTime *string `type:"string" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	Image *ImageForListDevInstancesOutput `type:"structure" json:",omitempty"`

	IsBuildingImage *bool `type:"boolean" json:",omitempty"`

	LaunchTime *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	NodeAffinitySpec *NodeAffinitySpecForListDevInstancesOutput `type:"structure" json:",omitempty"`

	NumaAffinity *string `type:"string" json:",omitempty"`

	NumaStatus *string `type:"string" json:",omitempty"`

	Ports []*PortForListDevInstancesOutput `type:"list" json:",omitempty"`

	ResourceClaim *ResourceClaimForListDevInstancesOutput `type:"structure" json:",omitempty"`

	ResourceQueueId *string `type:"string" json:",omitempty"`

	SshPublicKey *string `type:"string" json:",omitempty"`

	Status *StatusForListDevInstancesOutput `type:"structure" json:",omitempty"`

	StopTime *string `type:"string" json:",omitempty"`

	StoppedTime *string `type:"string" json:",omitempty"`

	Storages []*StorageForListDevInstancesOutput `type:"list" json:",omitempty"`

	UpdateTime *string `type:"string" json:",omitempty"`

	Volume *VolumeForListDevInstancesOutput `type:"structure" json:",omitempty"`

	ZoneID *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ListForListDevInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListForListDevInstancesOutput) GoString() string {
	return s.String()
}

// SetAllowImageBuild sets the AllowImageBuild field's value.
func (s *ListForListDevInstancesOutput) SetAllowImageBuild(v bool) *ListForListDevInstancesOutput {
	s.AllowImageBuild = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *ListForListDevInstancesOutput) SetCreateTime(v string) *ListForListDevInstancesOutput {
	s.CreateTime = &v
	return s
}

// SetCreatorTrn sets the CreatorTrn field's value.
func (s *ListForListDevInstancesOutput) SetCreatorTrn(v string) *ListForListDevInstancesOutput {
	s.CreatorTrn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ListForListDevInstancesOutput) SetDescription(v string) *ListForListDevInstancesOutput {
	s.Description = &v
	return s
}

// SetExpectedStopTime sets the ExpectedStopTime field's value.
func (s *ListForListDevInstancesOutput) SetExpectedStopTime(v string) *ListForListDevInstancesOutput {
	s.ExpectedStopTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *ListForListDevInstancesOutput) SetId(v string) *ListForListDevInstancesOutput {
	s.Id = &v
	return s
}

// SetImage sets the Image field's value.
func (s *ListForListDevInstancesOutput) SetImage(v *ImageForListDevInstancesOutput) *ListForListDevInstancesOutput {
	s.Image = v
	return s
}

// SetIsBuildingImage sets the IsBuildingImage field's value.
func (s *ListForListDevInstancesOutput) SetIsBuildingImage(v bool) *ListForListDevInstancesOutput {
	s.IsBuildingImage = &v
	return s
}

// SetLaunchTime sets the LaunchTime field's value.
func (s *ListForListDevInstancesOutput) SetLaunchTime(v string) *ListForListDevInstancesOutput {
	s.LaunchTime = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListForListDevInstancesOutput) SetName(v string) *ListForListDevInstancesOutput {
	s.Name = &v
	return s
}

// SetNodeAffinitySpec sets the NodeAffinitySpec field's value.
func (s *ListForListDevInstancesOutput) SetNodeAffinitySpec(v *NodeAffinitySpecForListDevInstancesOutput) *ListForListDevInstancesOutput {
	s.NodeAffinitySpec = v
	return s
}

// SetNumaAffinity sets the NumaAffinity field's value.
func (s *ListForListDevInstancesOutput) SetNumaAffinity(v string) *ListForListDevInstancesOutput {
	s.NumaAffinity = &v
	return s
}

// SetNumaStatus sets the NumaStatus field's value.
func (s *ListForListDevInstancesOutput) SetNumaStatus(v string) *ListForListDevInstancesOutput {
	s.NumaStatus = &v
	return s
}

// SetPorts sets the Ports field's value.
func (s *ListForListDevInstancesOutput) SetPorts(v []*PortForListDevInstancesOutput) *ListForListDevInstancesOutput {
	s.Ports = v
	return s
}

// SetResourceClaim sets the ResourceClaim field's value.
func (s *ListForListDevInstancesOutput) SetResourceClaim(v *ResourceClaimForListDevInstancesOutput) *ListForListDevInstancesOutput {
	s.ResourceClaim = v
	return s
}

// SetResourceQueueId sets the ResourceQueueId field's value.
func (s *ListForListDevInstancesOutput) SetResourceQueueId(v string) *ListForListDevInstancesOutput {
	s.ResourceQueueId = &v
	return s
}

// SetSshPublicKey sets the SshPublicKey field's value.
func (s *ListForListDevInstancesOutput) SetSshPublicKey(v string) *ListForListDevInstancesOutput {
	s.SshPublicKey = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListForListDevInstancesOutput) SetStatus(v *StatusForListDevInstancesOutput) *ListForListDevInstancesOutput {
	s.Status = v
	return s
}

// SetStopTime sets the StopTime field's value.
func (s *ListForListDevInstancesOutput) SetStopTime(v string) *ListForListDevInstancesOutput {
	s.StopTime = &v
	return s
}

// SetStoppedTime sets the StoppedTime field's value.
func (s *ListForListDevInstancesOutput) SetStoppedTime(v string) *ListForListDevInstancesOutput {
	s.StoppedTime = &v
	return s
}

// SetStorages sets the Storages field's value.
func (s *ListForListDevInstancesOutput) SetStorages(v []*StorageForListDevInstancesOutput) *ListForListDevInstancesOutput {
	s.Storages = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ListForListDevInstancesOutput) SetUpdateTime(v string) *ListForListDevInstancesOutput {
	s.UpdateTime = &v
	return s
}

// SetVolume sets the Volume field's value.
func (s *ListForListDevInstancesOutput) SetVolume(v *VolumeForListDevInstancesOutput) *ListForListDevInstancesOutput {
	s.Volume = v
	return s
}

// SetZoneID sets the ZoneID field's value.
func (s *ListForListDevInstancesOutput) SetZoneID(v string) *ListForListDevInstancesOutput {
	s.ZoneID = &v
	return s
}

type NasForListDevInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Addr *string `type:"string" json:",omitempty"`

	FileSystemName *string `type:"string" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	NasType *string `type:"string" json:",omitempty"`

	SubPath *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s NasForListDevInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NasForListDevInstancesOutput) GoString() string {
	return s.String()
}

// SetAddr sets the Addr field's value.
func (s *NasForListDevInstancesOutput) SetAddr(v string) *NasForListDevInstancesOutput {
	s.Addr = &v
	return s
}

// SetFileSystemName sets the FileSystemName field's value.
func (s *NasForListDevInstancesOutput) SetFileSystemName(v string) *NasForListDevInstancesOutput {
	s.FileSystemName = &v
	return s
}

// SetId sets the Id field's value.
func (s *NasForListDevInstancesOutput) SetId(v string) *NasForListDevInstancesOutput {
	s.Id = &v
	return s
}

// SetNasType sets the NasType field's value.
func (s *NasForListDevInstancesOutput) SetNasType(v string) *NasForListDevInstancesOutput {
	s.NasType = &v
	return s
}

// SetSubPath sets the SubPath field's value.
func (s *NasForListDevInstancesOutput) SetSubPath(v string) *NasForListDevInstancesOutput {
	s.SubPath = &v
	return s
}

type NodeAffinitySpecForListDevInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	GPUCPUNodePreference *string `type:"string" json:",omitempty" enum:"EnumOfGPUCPUNodePreferenceForListDevInstancesOutput"`

	StrategyType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s NodeAffinitySpecForListDevInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeAffinitySpecForListDevInstancesOutput) GoString() string {
	return s.String()
}

// SetGPUCPUNodePreference sets the GPUCPUNodePreference field's value.
func (s *NodeAffinitySpecForListDevInstancesOutput) SetGPUCPUNodePreference(v string) *NodeAffinitySpecForListDevInstancesOutput {
	s.GPUCPUNodePreference = &v
	return s
}

// SetStrategyType sets the StrategyType field's value.
func (s *NodeAffinitySpecForListDevInstancesOutput) SetStrategyType(v string) *NodeAffinitySpecForListDevInstancesOutput {
	s.StrategyType = &v
	return s
}

type OptionsForListDevInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	InternalSync *int64 `type:"int64" json:",omitempty"`

	MetaCacheCapacity *int64 `type:"int64" json:",omitempty"`

	MetaCacheExpiryMinutes *int64 `type:"int64" json:",omitempty"`

	MetaCacheExpiryMsec *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s OptionsForListDevInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OptionsForListDevInstancesOutput) GoString() string {
	return s.String()
}

// SetInternalSync sets the InternalSync field's value.
func (s *OptionsForListDevInstancesOutput) SetInternalSync(v int64) *OptionsForListDevInstancesOutput {
	s.InternalSync = &v
	return s
}

// SetMetaCacheCapacity sets the MetaCacheCapacity field's value.
func (s *OptionsForListDevInstancesOutput) SetMetaCacheCapacity(v int64) *OptionsForListDevInstancesOutput {
	s.MetaCacheCapacity = &v
	return s
}

// SetMetaCacheExpiryMinutes sets the MetaCacheExpiryMinutes field's value.
func (s *OptionsForListDevInstancesOutput) SetMetaCacheExpiryMinutes(v int64) *OptionsForListDevInstancesOutput {
	s.MetaCacheExpiryMinutes = &v
	return s
}

// SetMetaCacheExpiryMsec sets the MetaCacheExpiryMsec field's value.
func (s *OptionsForListDevInstancesOutput) SetMetaCacheExpiryMsec(v int64) *OptionsForListDevInstancesOutput {
	s.MetaCacheExpiryMsec = &v
	return s
}

type PortForListDevInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	APIGPrivateUrl *string `type:"string" json:",omitempty"`

	APIGPublicUrl *string `type:"string" json:",omitempty"`

	EnablePublicNetworkAccess *bool `type:"boolean" json:",omitempty"`

	EniIp *string `type:"string" json:",omitempty"`

	EniPort *int32 `type:"int32" json:",omitempty"`

	ExternalIp *string `type:"string" json:",omitempty"`

	ExternalPort *int32 `type:"int32" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Status *StatusForListDevInstancesOutput `type:"structure" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s PortForListDevInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PortForListDevInstancesOutput) GoString() string {
	return s.String()
}

// SetAPIGPrivateUrl sets the APIGPrivateUrl field's value.
func (s *PortForListDevInstancesOutput) SetAPIGPrivateUrl(v string) *PortForListDevInstancesOutput {
	s.APIGPrivateUrl = &v
	return s
}

// SetAPIGPublicUrl sets the APIGPublicUrl field's value.
func (s *PortForListDevInstancesOutput) SetAPIGPublicUrl(v string) *PortForListDevInstancesOutput {
	s.APIGPublicUrl = &v
	return s
}

// SetEnablePublicNetworkAccess sets the EnablePublicNetworkAccess field's value.
func (s *PortForListDevInstancesOutput) SetEnablePublicNetworkAccess(v bool) *PortForListDevInstancesOutput {
	s.EnablePublicNetworkAccess = &v
	return s
}

// SetEniIp sets the EniIp field's value.
func (s *PortForListDevInstancesOutput) SetEniIp(v string) *PortForListDevInstancesOutput {
	s.EniIp = &v
	return s
}

// SetEniPort sets the EniPort field's value.
func (s *PortForListDevInstancesOutput) SetEniPort(v int32) *PortForListDevInstancesOutput {
	s.EniPort = &v
	return s
}

// SetExternalIp sets the ExternalIp field's value.
func (s *PortForListDevInstancesOutput) SetExternalIp(v string) *PortForListDevInstancesOutput {
	s.ExternalIp = &v
	return s
}

// SetExternalPort sets the ExternalPort field's value.
func (s *PortForListDevInstancesOutput) SetExternalPort(v int32) *PortForListDevInstancesOutput {
	s.ExternalPort = &v
	return s
}

// SetName sets the Name field's value.
func (s *PortForListDevInstancesOutput) SetName(v string) *PortForListDevInstancesOutput {
	s.Name = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *PortForListDevInstancesOutput) SetStatus(v *StatusForListDevInstancesOutput) *PortForListDevInstancesOutput {
	s.Status = v
	return s
}

// SetType sets the Type field's value.
func (s *PortForListDevInstancesOutput) SetType(v string) *PortForListDevInstancesOutput {
	s.Type = &v
	return s
}

type ResourceClaimForListDevInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	FlexibleResourceClaim *FlexibleResourceClaimForListDevInstancesOutput `type:"structure" json:",omitempty"`

	InstanceTypeId *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`

	ZoneId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ResourceClaimForListDevInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceClaimForListDevInstancesOutput) GoString() string {
	return s.String()
}

// SetFlexibleResourceClaim sets the FlexibleResourceClaim field's value.
func (s *ResourceClaimForListDevInstancesOutput) SetFlexibleResourceClaim(v *FlexibleResourceClaimForListDevInstancesOutput) *ResourceClaimForListDevInstancesOutput {
	s.FlexibleResourceClaim = v
	return s
}

// SetInstanceTypeId sets the InstanceTypeId field's value.
func (s *ResourceClaimForListDevInstancesOutput) SetInstanceTypeId(v string) *ResourceClaimForListDevInstancesOutput {
	s.InstanceTypeId = &v
	return s
}

// SetType sets the Type field's value.
func (s *ResourceClaimForListDevInstancesOutput) SetType(v string) *ResourceClaimForListDevInstancesOutput {
	s.Type = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *ResourceClaimForListDevInstancesOutput) SetZoneId(v string) *ResourceClaimForListDevInstancesOutput {
	s.ZoneId = &v
	return s
}

type SfcsForListDevInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CachePolicyId *string `type:"string" json:",omitempty"`

	FileSystemName *string `type:"string" json:",omitempty"`

	Options *ConvertOptionsForListDevInstancesOutput `type:"structure" json:",omitempty"`

	Tos *TosForListDevInstancesOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s SfcsForListDevInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SfcsForListDevInstancesOutput) GoString() string {
	return s.String()
}

// SetCachePolicyId sets the CachePolicyId field's value.
func (s *SfcsForListDevInstancesOutput) SetCachePolicyId(v string) *SfcsForListDevInstancesOutput {
	s.CachePolicyId = &v
	return s
}

// SetFileSystemName sets the FileSystemName field's value.
func (s *SfcsForListDevInstancesOutput) SetFileSystemName(v string) *SfcsForListDevInstancesOutput {
	s.FileSystemName = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *SfcsForListDevInstancesOutput) SetOptions(v *ConvertOptionsForListDevInstancesOutput) *SfcsForListDevInstancesOutput {
	s.Options = v
	return s
}

// SetTos sets the Tos field's value.
func (s *SfcsForListDevInstancesOutput) SetTos(v *TosForListDevInstancesOutput) *SfcsForListDevInstancesOutput {
	s.Tos = v
	return s
}

type StatusForListDevInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Message *string `type:"string" json:",omitempty"`

	SecondaryState *string `type:"string" json:",omitempty"`

	State *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s StatusForListDevInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StatusForListDevInstancesOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *StatusForListDevInstancesOutput) SetMessage(v string) *StatusForListDevInstancesOutput {
	s.Message = &v
	return s
}

// SetSecondaryState sets the SecondaryState field's value.
func (s *StatusForListDevInstancesOutput) SetSecondaryState(v string) *StatusForListDevInstancesOutput {
	s.SecondaryState = &v
	return s
}

// SetState sets the State field's value.
func (s *StatusForListDevInstancesOutput) SetState(v string) *StatusForListDevInstancesOutput {
	s.State = &v
	return s
}

type StorageForListDevInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Config *ConfigForListDevInstancesOutput `type:"structure" json:",omitempty"`

	MountPath *string `type:"string" json:",omitempty"`

	ReadOnly *bool `type:"boolean" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s StorageForListDevInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageForListDevInstancesOutput) GoString() string {
	return s.String()
}

// SetConfig sets the Config field's value.
func (s *StorageForListDevInstancesOutput) SetConfig(v *ConfigForListDevInstancesOutput) *StorageForListDevInstancesOutput {
	s.Config = v
	return s
}

// SetMountPath sets the MountPath field's value.
func (s *StorageForListDevInstancesOutput) SetMountPath(v string) *StorageForListDevInstancesOutput {
	s.MountPath = &v
	return s
}

// SetReadOnly sets the ReadOnly field's value.
func (s *StorageForListDevInstancesOutput) SetReadOnly(v bool) *StorageForListDevInstancesOutput {
	s.ReadOnly = &v
	return s
}

// SetType sets the Type field's value.
func (s *StorageForListDevInstancesOutput) SetType(v string) *StorageForListDevInstancesOutput {
	s.Type = &v
	return s
}

type TosForListDevInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Bucket *string `type:"string" json:",omitempty"`

	Prefix *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TosForListDevInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TosForListDevInstancesOutput) GoString() string {
	return s.String()
}

// SetBucket sets the Bucket field's value.
func (s *TosForListDevInstancesOutput) SetBucket(v string) *TosForListDevInstancesOutput {
	s.Bucket = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *TosForListDevInstancesOutput) SetPrefix(v string) *TosForListDevInstancesOutput {
	s.Prefix = &v
	return s
}

type VepfsForListDevInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	FileSystemName *string `type:"string" json:",omitempty"`

	HostPath *string `type:"string" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	SubPath *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s VepfsForListDevInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VepfsForListDevInstancesOutput) GoString() string {
	return s.String()
}

// SetFileSystemName sets the FileSystemName field's value.
func (s *VepfsForListDevInstancesOutput) SetFileSystemName(v string) *VepfsForListDevInstancesOutput {
	s.FileSystemName = &v
	return s
}

// SetHostPath sets the HostPath field's value.
func (s *VepfsForListDevInstancesOutput) SetHostPath(v string) *VepfsForListDevInstancesOutput {
	s.HostPath = &v
	return s
}

// SetId sets the Id field's value.
func (s *VepfsForListDevInstancesOutput) SetId(v string) *VepfsForListDevInstancesOutput {
	s.Id = &v
	return s
}

// SetSubPath sets the SubPath field's value.
func (s *VepfsForListDevInstancesOutput) SetSubPath(v string) *VepfsForListDevInstancesOutput {
	s.SubPath = &v
	return s
}

type VolumeForListDevInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	Size *int32 `type:"int32" json:",omitempty"`

	Status *StatusForListDevInstancesOutput `type:"structure" json:",omitempty"`

	Used *string `type:"string" json:",omitempty"`

	VolumeTypeId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s VolumeForListDevInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VolumeForListDevInstancesOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *VolumeForListDevInstancesOutput) SetId(v string) *VolumeForListDevInstancesOutput {
	s.Id = &v
	return s
}

// SetSize sets the Size field's value.
func (s *VolumeForListDevInstancesOutput) SetSize(v int32) *VolumeForListDevInstancesOutput {
	s.Size = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *VolumeForListDevInstancesOutput) SetStatus(v *StatusForListDevInstancesOutput) *VolumeForListDevInstancesOutput {
	s.Status = v
	return s
}

// SetUsed sets the Used field's value.
func (s *VolumeForListDevInstancesOutput) SetUsed(v string) *VolumeForListDevInstancesOutput {
	s.Used = &v
	return s
}

// SetVolumeTypeId sets the VolumeTypeId field's value.
func (s *VolumeForListDevInstancesOutput) SetVolumeTypeId(v string) *VolumeForListDevInstancesOutput {
	s.VolumeTypeId = &v
	return s
}

const (
	// EnumOfGPUCPUNodePreferenceForListDevInstancesOutputGpurequired is a EnumOfGPUCPUNodePreferenceForListDevInstancesOutput enum value
	EnumOfGPUCPUNodePreferenceForListDevInstancesOutputGpurequired = "GPURequired"

	// EnumOfGPUCPUNodePreferenceForListDevInstancesOutputGpupreferred is a EnumOfGPUCPUNodePreferenceForListDevInstancesOutput enum value
	EnumOfGPUCPUNodePreferenceForListDevInstancesOutputGpupreferred = "GPUPreferred"

	// EnumOfGPUCPUNodePreferenceForListDevInstancesOutputCpurequired is a EnumOfGPUCPUNodePreferenceForListDevInstancesOutput enum value
	EnumOfGPUCPUNodePreferenceForListDevInstancesOutputCpurequired = "CPURequired"

	// EnumOfGPUCPUNodePreferenceForListDevInstancesOutputCpupreferred is a EnumOfGPUCPUNodePreferenceForListDevInstancesOutput enum value
	EnumOfGPUCPUNodePreferenceForListDevInstancesOutputCpupreferred = "CPUPreferred"
)

const (
	// EnumOfRelationshipForListDevInstancesInputCreated is a EnumOfRelationshipForListDevInstancesInput enum value
	EnumOfRelationshipForListDevInstancesInputCreated = "Created"

	// EnumOfRelationshipForListDevInstancesInputOwned is a EnumOfRelationshipForListDevInstancesInput enum value
	EnumOfRelationshipForListDevInstancesInputOwned = "Owned"
)

const (
	// EnumOfSortByForListDevInstancesInputCreateTime is a EnumOfSortByForListDevInstancesInput enum value
	EnumOfSortByForListDevInstancesInputCreateTime = "CreateTime"
)

const (
	// EnumOfSortOrderForListDevInstancesInputAscend is a EnumOfSortOrderForListDevInstancesInput enum value
	EnumOfSortOrderForListDevInstancesInputAscend = "Ascend"

	// EnumOfSortOrderForListDevInstancesInputDescend is a EnumOfSortOrderForListDevInstancesInput enum value
	EnumOfSortOrderForListDevInstancesInputDescend = "Descend"
)

const (
	// EnumOfStateListForListDevInstancesInputPending is a EnumOfStateListForListDevInstancesInput enum value
	EnumOfStateListForListDevInstancesInputPending = "Pending"

	// EnumOfStateListForListDevInstancesInputDeploying is a EnumOfStateListForListDevInstancesInput enum value
	EnumOfStateListForListDevInstancesInputDeploying = "Deploying"

	// EnumOfStateListForListDevInstancesInputRunning is a EnumOfStateListForListDevInstancesInput enum value
	EnumOfStateListForListDevInstancesInputRunning = "Running"

	// EnumOfStateListForListDevInstancesInputStopping is a EnumOfStateListForListDevInstancesInput enum value
	EnumOfStateListForListDevInstancesInputStopping = "Stopping"

	// EnumOfStateListForListDevInstancesInputStopped is a EnumOfStateListForListDevInstancesInput enum value
	EnumOfStateListForListDevInstancesInputStopped = "Stopped"

	// EnumOfStateListForListDevInstancesInputDeleting is a EnumOfStateListForListDevInstancesInput enum value
	EnumOfStateListForListDevInstancesInputDeleting = "Deleting"

	// EnumOfStateListForListDevInstancesInputAbnormal is a EnumOfStateListForListDevInstancesInput enum value
	EnumOfStateListForListDevInstancesInputAbnormal = "Abnormal"

	// EnumOfStateListForListDevInstancesInputFailed is a EnumOfStateListForListDevInstancesInput enum value
	EnumOfStateListForListDevInstancesInputFailed = "Failed"

	// EnumOfStateListForListDevInstancesInputUpgrading is a EnumOfStateListForListDevInstancesInput enum value
	EnumOfStateListForListDevInstancesInputUpgrading = "Upgrading"
)
