// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package mlplatform20240701

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opGetServiceCommon = "GetService"

// GetServiceCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the GetServiceCommon operation. The "output" return
// value will be populated with the GetServiceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GetServiceCommon Request to send the API call to the service.
// the "output" return value is not valid until after GetServiceCommon Send returns without error.
//
// See GetServiceCommon for more information on using the GetServiceCommon
// API call, and error handling.
//
//    // Example sending a request using the GetServiceCommonRequest method.
//    req, resp := client.GetServiceCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MLPLATFORM20240701) GetServiceCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opGetServiceCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// GetServiceCommon API operation for ML_PLATFORM20240701.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ML_PLATFORM20240701's
// API operation GetServiceCommon for usage and error information.
func (c *MLPLATFORM20240701) GetServiceCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.GetServiceCommonRequest(input)
	return out, req.Send()
}

// GetServiceCommonWithContext is the same as GetServiceCommon with the addition of
// the ability to pass a context and additional request options.
//
// See GetServiceCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MLPLATFORM20240701) GetServiceCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.GetServiceCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetService = "GetService"

// GetServiceRequest generates a "volcengine/request.Request" representing the
// client's request for the GetService operation. The "output" return
// value will be populated with the GetServiceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GetServiceCommon Request to send the API call to the service.
// the "output" return value is not valid until after GetServiceCommon Send returns without error.
//
// See GetService for more information on using the GetService
// API call, and error handling.
//
//    // Example sending a request using the GetServiceRequest method.
//    req, resp := client.GetServiceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MLPLATFORM20240701) GetServiceRequest(input *GetServiceInput) (req *request.Request, output *GetServiceOutput) {
	op := &request.Operation{
		Name:       opGetService,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetServiceInput{}
	}

	output = &GetServiceOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// GetService API operation for ML_PLATFORM20240701.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ML_PLATFORM20240701's
// API operation GetService for usage and error information.
func (c *MLPLATFORM20240701) GetService(input *GetServiceInput) (*GetServiceOutput, error) {
	req, out := c.GetServiceRequest(input)
	return out, req.Send()
}

// GetServiceWithContext is the same as GetService with the addition of
// the ability to pass a context and additional request options.
//
// See GetService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MLPLATFORM20240701) GetServiceWithContext(ctx volcengine.Context, input *GetServiceInput, opts ...request.Option) (*GetServiceOutput, error) {
	req, out := c.GetServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ApigConfigForGetServiceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	InstanceID *string `type:"string" json:",omitempty"`

	UpstreamConfig *UpstreamConfigForGetServiceOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s ApigConfigForGetServiceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ApigConfigForGetServiceOutput) GoString() string {
	return s.String()
}

// SetInstanceID sets the InstanceID field's value.
func (s *ApigConfigForGetServiceOutput) SetInstanceID(v string) *ApigConfigForGetServiceOutput {
	s.InstanceID = &v
	return s
}

// SetUpstreamConfig sets the UpstreamConfig field's value.
func (s *ApigConfigForGetServiceOutput) SetUpstreamConfig(v *UpstreamConfigForGetServiceOutput) *ApigConfigForGetServiceOutput {
	s.UpstreamConfig = v
	return s
}

type CLBConfigForGetServiceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	InstanceId *string `type:"string" json:",omitempty"`

	Scheduler *string `type:"string" json:",omitempty" enum:"EnumOfSchedulerForGetServiceOutput"`
}

// String returns the string representation
func (s CLBConfigForGetServiceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CLBConfigForGetServiceOutput) GoString() string {
	return s.String()
}

// SetInstanceId sets the InstanceId field's value.
func (s *CLBConfigForGetServiceOutput) SetInstanceId(v string) *CLBConfigForGetServiceOutput {
	s.InstanceId = &v
	return s
}

// SetScheduler sets the Scheduler field's value.
func (s *CLBConfigForGetServiceOutput) SetScheduler(v string) *CLBConfigForGetServiceOutput {
	s.Scheduler = &v
	return s
}

type ConsistentHashConfigForGetServiceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	HashKeyType *string `type:"string" json:",omitempty" enum:"EnumOfHashKeyTypeForGetServiceOutput"`

	HttpHeaderName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ConsistentHashConfigForGetServiceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConsistentHashConfigForGetServiceOutput) GoString() string {
	return s.String()
}

// SetHashKeyType sets the HashKeyType field's value.
func (s *ConsistentHashConfigForGetServiceOutput) SetHashKeyType(v string) *ConsistentHashConfigForGetServiceOutput {
	s.HashKeyType = &v
	return s
}

// SetHttpHeaderName sets the HttpHeaderName field's value.
func (s *ConsistentHashConfigForGetServiceOutput) SetHttpHeaderName(v string) *ConsistentHashConfigForGetServiceOutput {
	s.HttpHeaderName = &v
	return s
}

type ConvertConvertConvertWeightForGetServiceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DeploymentId *string `type:"string" json:",omitempty"`

	Weight *int32 `max:"10" type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ConvertConvertConvertWeightForGetServiceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertConvertConvertWeightForGetServiceOutput) GoString() string {
	return s.String()
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *ConvertConvertConvertWeightForGetServiceOutput) SetDeploymentId(v string) *ConvertConvertConvertWeightForGetServiceOutput {
	s.DeploymentId = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *ConvertConvertConvertWeightForGetServiceOutput) SetWeight(v int32) *ConvertConvertConvertWeightForGetServiceOutput {
	s.Weight = &v
	return s
}

type ConvertStatusForGetServiceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Message *string `type:"string" json:",omitempty"`

	SecondaryState *string `type:"string" json:",omitempty"`

	State *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ConvertStatusForGetServiceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertStatusForGetServiceOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *ConvertStatusForGetServiceOutput) SetMessage(v string) *ConvertStatusForGetServiceOutput {
	s.Message = &v
	return s
}

// SetSecondaryState sets the SecondaryState field's value.
func (s *ConvertStatusForGetServiceOutput) SetSecondaryState(v string) *ConvertStatusForGetServiceOutput {
	s.SecondaryState = &v
	return s
}

// SetState sets the State field's value.
func (s *ConvertStatusForGetServiceOutput) SetState(v string) *ConvertStatusForGetServiceOutput {
	s.State = &v
	return s
}

type ConvertTrafficConfigForGetServiceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enables []*string `type:"list" json:",omitempty"`

	MirrorTrafficPolicy *MirrorTrafficPolicyForGetServiceOutput `type:"structure" json:",omitempty"`

	Mode *string `type:"string" json:",omitempty" enum:"EnumOfModeForGetServiceOutput"`

	Weights []*ConvertConvertConvertWeightForGetServiceOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ConvertTrafficConfigForGetServiceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertTrafficConfigForGetServiceOutput) GoString() string {
	return s.String()
}

// SetEnables sets the Enables field's value.
func (s *ConvertTrafficConfigForGetServiceOutput) SetEnables(v []*string) *ConvertTrafficConfigForGetServiceOutput {
	s.Enables = v
	return s
}

// SetMirrorTrafficPolicy sets the MirrorTrafficPolicy field's value.
func (s *ConvertTrafficConfigForGetServiceOutput) SetMirrorTrafficPolicy(v *MirrorTrafficPolicyForGetServiceOutput) *ConvertTrafficConfigForGetServiceOutput {
	s.MirrorTrafficPolicy = v
	return s
}

// SetMode sets the Mode field's value.
func (s *ConvertTrafficConfigForGetServiceOutput) SetMode(v string) *ConvertTrafficConfigForGetServiceOutput {
	s.Mode = &v
	return s
}

// SetWeights sets the Weights field's value.
func (s *ConvertTrafficConfigForGetServiceOutput) SetWeights(v []*ConvertConvertConvertWeightForGetServiceOutput) *ConvertTrafficConfigForGetServiceOutput {
	s.Weights = v
	return s
}

type ConvertWeightForGetServiceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DeploymentId *string `type:"string" json:",omitempty"`

	Weight *int32 `max:"10" type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ConvertWeightForGetServiceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertWeightForGetServiceOutput) GoString() string {
	return s.String()
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *ConvertWeightForGetServiceOutput) SetDeploymentId(v string) *ConvertWeightForGetServiceOutput {
	s.DeploymentId = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *ConvertWeightForGetServiceOutput) SetWeight(v int32) *ConvertWeightForGetServiceOutput {
	s.Weight = &v
	return s
}

type DeploymentForGetServiceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CreateTime *string `type:"string" json:",omitempty"`

	CreatedBy *string `type:"string" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	RoleStatus []*RoleStatusForGetServiceOutput `type:"list" json:",omitempty"`

	ServiceId *string `type:"string" json:",omitempty"`

	Status *ConvertStatusForGetServiceOutput `type:"structure" json:",omitempty"`

	UpdateTime *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s DeploymentForGetServiceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DeploymentForGetServiceOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *DeploymentForGetServiceOutput) SetCreateTime(v string) *DeploymentForGetServiceOutput {
	s.CreateTime = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *DeploymentForGetServiceOutput) SetCreatedBy(v string) *DeploymentForGetServiceOutput {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DeploymentForGetServiceOutput) SetDescription(v string) *DeploymentForGetServiceOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *DeploymentForGetServiceOutput) SetId(v string) *DeploymentForGetServiceOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *DeploymentForGetServiceOutput) SetName(v string) *DeploymentForGetServiceOutput {
	s.Name = &v
	return s
}

// SetRoleStatus sets the RoleStatus field's value.
func (s *DeploymentForGetServiceOutput) SetRoleStatus(v []*RoleStatusForGetServiceOutput) *DeploymentForGetServiceOutput {
	s.RoleStatus = v
	return s
}

// SetServiceId sets the ServiceId field's value.
func (s *DeploymentForGetServiceOutput) SetServiceId(v string) *DeploymentForGetServiceOutput {
	s.ServiceId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *DeploymentForGetServiceOutput) SetStatus(v *ConvertStatusForGetServiceOutput) *DeploymentForGetServiceOutput {
	s.Status = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *DeploymentForGetServiceOutput) SetUpdateTime(v string) *DeploymentForGetServiceOutput {
	s.UpdateTime = &v
	return s
}

type GetServiceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	HistoryVersionLimit *int32 `max:"100" type:"int32" json:",omitempty"`

	// Id is a required field
	Id *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s GetServiceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetServiceInput"}
	if s.HistoryVersionLimit != nil && *s.HistoryVersionLimit > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("HistoryVersionLimit", 100))
	}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetHistoryVersionLimit sets the HistoryVersionLimit field's value.
func (s *GetServiceInput) SetHistoryVersionLimit(v int32) *GetServiceInput {
	s.HistoryVersionLimit = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetServiceInput) SetId(v string) *GetServiceInput {
	s.Id = &v
	return s
}

type GetServiceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	ApigConfig *ApigConfigForGetServiceOutput `type:"structure" json:",omitempty"`

	CLBConfig *CLBConfigForGetServiceOutput `type:"structure" json:",omitempty"`

	CreateTime *string `type:"string" json:",omitempty"`

	CreatedBy *string `type:"string" json:",omitempty"`

	Deployments []*DeploymentForGetServiceOutput `type:"list" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	HistoryVersions []*HistoryVersionForGetServiceOutput `type:"list" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Ports []*PortForGetServiceOutput `type:"list" json:",omitempty"`

	Status *ConvertStatusForGetServiceOutput `type:"structure" json:",omitempty"`

	TrafficConfig *ConvertTrafficConfigForGetServiceOutput `type:"structure" json:",omitempty"`

	UpdateTime *string `type:"string" json:",omitempty"`

	VpcId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s GetServiceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GetServiceOutput) GoString() string {
	return s.String()
}

// SetApigConfig sets the ApigConfig field's value.
func (s *GetServiceOutput) SetApigConfig(v *ApigConfigForGetServiceOutput) *GetServiceOutput {
	s.ApigConfig = v
	return s
}

// SetCLBConfig sets the CLBConfig field's value.
func (s *GetServiceOutput) SetCLBConfig(v *CLBConfigForGetServiceOutput) *GetServiceOutput {
	s.CLBConfig = v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *GetServiceOutput) SetCreateTime(v string) *GetServiceOutput {
	s.CreateTime = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *GetServiceOutput) SetCreatedBy(v string) *GetServiceOutput {
	s.CreatedBy = &v
	return s
}

// SetDeployments sets the Deployments field's value.
func (s *GetServiceOutput) SetDeployments(v []*DeploymentForGetServiceOutput) *GetServiceOutput {
	s.Deployments = v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetServiceOutput) SetDescription(v string) *GetServiceOutput {
	s.Description = &v
	return s
}

// SetHistoryVersions sets the HistoryVersions field's value.
func (s *GetServiceOutput) SetHistoryVersions(v []*HistoryVersionForGetServiceOutput) *GetServiceOutput {
	s.HistoryVersions = v
	return s
}

// SetId sets the Id field's value.
func (s *GetServiceOutput) SetId(v string) *GetServiceOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetServiceOutput) SetName(v string) *GetServiceOutput {
	s.Name = &v
	return s
}

// SetPorts sets the Ports field's value.
func (s *GetServiceOutput) SetPorts(v []*PortForGetServiceOutput) *GetServiceOutput {
	s.Ports = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetServiceOutput) SetStatus(v *ConvertStatusForGetServiceOutput) *GetServiceOutput {
	s.Status = v
	return s
}

// SetTrafficConfig sets the TrafficConfig field's value.
func (s *GetServiceOutput) SetTrafficConfig(v *ConvertTrafficConfigForGetServiceOutput) *GetServiceOutput {
	s.TrafficConfig = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *GetServiceOutput) SetUpdateTime(v string) *GetServiceOutput {
	s.UpdateTime = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *GetServiceOutput) SetVpcId(v string) *GetServiceOutput {
	s.VpcId = &v
	return s
}

type HistoryVersionForGetServiceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ApigConfig *ApigConfigForGetServiceOutput `type:"structure" json:",omitempty"`

	CLBConfig *CLBConfigForGetServiceOutput `type:"structure" json:",omitempty"`

	ChangeType *string `type:"string" json:",omitempty" enum:"EnumOfChangeTypeForGetServiceOutput"`

	CreateTime *string `type:"string" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	Ports []*PortForGetServiceOutput `type:"list" json:",omitempty"`

	TrafficConfig *TrafficConfigForGetServiceOutput `type:"structure" json:",omitempty"`

	VpcId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s HistoryVersionForGetServiceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HistoryVersionForGetServiceOutput) GoString() string {
	return s.String()
}

// SetApigConfig sets the ApigConfig field's value.
func (s *HistoryVersionForGetServiceOutput) SetApigConfig(v *ApigConfigForGetServiceOutput) *HistoryVersionForGetServiceOutput {
	s.ApigConfig = v
	return s
}

// SetCLBConfig sets the CLBConfig field's value.
func (s *HistoryVersionForGetServiceOutput) SetCLBConfig(v *CLBConfigForGetServiceOutput) *HistoryVersionForGetServiceOutput {
	s.CLBConfig = v
	return s
}

// SetChangeType sets the ChangeType field's value.
func (s *HistoryVersionForGetServiceOutput) SetChangeType(v string) *HistoryVersionForGetServiceOutput {
	s.ChangeType = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *HistoryVersionForGetServiceOutput) SetCreateTime(v string) *HistoryVersionForGetServiceOutput {
	s.CreateTime = &v
	return s
}

// SetId sets the Id field's value.
func (s *HistoryVersionForGetServiceOutput) SetId(v string) *HistoryVersionForGetServiceOutput {
	s.Id = &v
	return s
}

// SetPorts sets the Ports field's value.
func (s *HistoryVersionForGetServiceOutput) SetPorts(v []*PortForGetServiceOutput) *HistoryVersionForGetServiceOutput {
	s.Ports = v
	return s
}

// SetTrafficConfig sets the TrafficConfig field's value.
func (s *HistoryVersionForGetServiceOutput) SetTrafficConfig(v *TrafficConfigForGetServiceOutput) *HistoryVersionForGetServiceOutput {
	s.TrafficConfig = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *HistoryVersionForGetServiceOutput) SetVpcId(v string) *HistoryVersionForGetServiceOutput {
	s.VpcId = &v
	return s
}

type MirrorTrafficPolicyForGetServiceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Percent *int32 `type:"int32" json:",omitempty"`

	SourceDeploymentId *string `type:"string" json:",omitempty"`

	TargetDeploymentId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s MirrorTrafficPolicyForGetServiceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MirrorTrafficPolicyForGetServiceOutput) GoString() string {
	return s.String()
}

// SetPercent sets the Percent field's value.
func (s *MirrorTrafficPolicyForGetServiceOutput) SetPercent(v int32) *MirrorTrafficPolicyForGetServiceOutput {
	s.Percent = &v
	return s
}

// SetSourceDeploymentId sets the SourceDeploymentId field's value.
func (s *MirrorTrafficPolicyForGetServiceOutput) SetSourceDeploymentId(v string) *MirrorTrafficPolicyForGetServiceOutput {
	s.SourceDeploymentId = &v
	return s
}

// SetTargetDeploymentId sets the TargetDeploymentId field's value.
func (s *MirrorTrafficPolicyForGetServiceOutput) SetTargetDeploymentId(v string) *MirrorTrafficPolicyForGetServiceOutput {
	s.TargetDeploymentId = &v
	return s
}

type PortForGetServiceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ExposePort *string `type:"string" json:",omitempty"`

	ListenPort *string `type:"string" json:",omitempty"`

	Path *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty" enum:"EnumOfTypeForGetServiceOutput"`
}

// String returns the string representation
func (s PortForGetServiceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PortForGetServiceOutput) GoString() string {
	return s.String()
}

// SetExposePort sets the ExposePort field's value.
func (s *PortForGetServiceOutput) SetExposePort(v string) *PortForGetServiceOutput {
	s.ExposePort = &v
	return s
}

// SetListenPort sets the ListenPort field's value.
func (s *PortForGetServiceOutput) SetListenPort(v string) *PortForGetServiceOutput {
	s.ListenPort = &v
	return s
}

// SetPath sets the Path field's value.
func (s *PortForGetServiceOutput) SetPath(v string) *PortForGetServiceOutput {
	s.Path = &v
	return s
}

// SetType sets the Type field's value.
func (s *PortForGetServiceOutput) SetType(v string) *PortForGetServiceOutput {
	s.Type = &v
	return s
}

type RoleStatusForGetServiceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	Status *StatusForGetServiceOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s RoleStatusForGetServiceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RoleStatusForGetServiceOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *RoleStatusForGetServiceOutput) SetId(v string) *RoleStatusForGetServiceOutput {
	s.Id = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RoleStatusForGetServiceOutput) SetStatus(v *StatusForGetServiceOutput) *RoleStatusForGetServiceOutput {
	s.Status = v
	return s
}

type StatusForGetServiceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AvailableReplicas *int32 `type:"int32" json:",omitempty"`

	ExpectedReplicias *int32 `type:"int32" json:",omitempty"`

	ExpectedUpdatedReplicas *int32 `type:"int32" json:",omitempty"`

	TotalReplicas *int32 `type:"int32" json:",omitempty"`

	UpdatedAvailableReplicas *int32 `type:"int32" json:",omitempty"`

	UpdatedReplicas *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s StatusForGetServiceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StatusForGetServiceOutput) GoString() string {
	return s.String()
}

// SetAvailableReplicas sets the AvailableReplicas field's value.
func (s *StatusForGetServiceOutput) SetAvailableReplicas(v int32) *StatusForGetServiceOutput {
	s.AvailableReplicas = &v
	return s
}

// SetExpectedReplicias sets the ExpectedReplicias field's value.
func (s *StatusForGetServiceOutput) SetExpectedReplicias(v int32) *StatusForGetServiceOutput {
	s.ExpectedReplicias = &v
	return s
}

// SetExpectedUpdatedReplicas sets the ExpectedUpdatedReplicas field's value.
func (s *StatusForGetServiceOutput) SetExpectedUpdatedReplicas(v int32) *StatusForGetServiceOutput {
	s.ExpectedUpdatedReplicas = &v
	return s
}

// SetTotalReplicas sets the TotalReplicas field's value.
func (s *StatusForGetServiceOutput) SetTotalReplicas(v int32) *StatusForGetServiceOutput {
	s.TotalReplicas = &v
	return s
}

// SetUpdatedAvailableReplicas sets the UpdatedAvailableReplicas field's value.
func (s *StatusForGetServiceOutput) SetUpdatedAvailableReplicas(v int32) *StatusForGetServiceOutput {
	s.UpdatedAvailableReplicas = &v
	return s
}

// SetUpdatedReplicas sets the UpdatedReplicas field's value.
func (s *StatusForGetServiceOutput) SetUpdatedReplicas(v int32) *StatusForGetServiceOutput {
	s.UpdatedReplicas = &v
	return s
}

type TrafficConfigForGetServiceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enables []*string `type:"list" json:",omitempty"`

	MirrorTrafficPolicy *MirrorTrafficPolicyForGetServiceOutput `type:"structure" json:",omitempty"`

	Mode *string `type:"string" json:",omitempty" enum:"EnumOfModeForGetServiceOutput"`

	Weights []*ConvertWeightForGetServiceOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s TrafficConfigForGetServiceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TrafficConfigForGetServiceOutput) GoString() string {
	return s.String()
}

// SetEnables sets the Enables field's value.
func (s *TrafficConfigForGetServiceOutput) SetEnables(v []*string) *TrafficConfigForGetServiceOutput {
	s.Enables = v
	return s
}

// SetMirrorTrafficPolicy sets the MirrorTrafficPolicy field's value.
func (s *TrafficConfigForGetServiceOutput) SetMirrorTrafficPolicy(v *MirrorTrafficPolicyForGetServiceOutput) *TrafficConfigForGetServiceOutput {
	s.MirrorTrafficPolicy = v
	return s
}

// SetMode sets the Mode field's value.
func (s *TrafficConfigForGetServiceOutput) SetMode(v string) *TrafficConfigForGetServiceOutput {
	s.Mode = &v
	return s
}

// SetWeights sets the Weights field's value.
func (s *TrafficConfigForGetServiceOutput) SetWeights(v []*ConvertWeightForGetServiceOutput) *TrafficConfigForGetServiceOutput {
	s.Weights = v
	return s
}

type UpstreamConfigForGetServiceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ConsistentHashConfig *ConsistentHashConfigForGetServiceOutput `type:"structure" json:",omitempty"`

	LoadBalancePolicy *string `type:"string" json:",omitempty" enum:"EnumOfLoadBalancePolicyForGetServiceOutput"`
}

// String returns the string representation
func (s UpstreamConfigForGetServiceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpstreamConfigForGetServiceOutput) GoString() string {
	return s.String()
}

// SetConsistentHashConfig sets the ConsistentHashConfig field's value.
func (s *UpstreamConfigForGetServiceOutput) SetConsistentHashConfig(v *ConsistentHashConfigForGetServiceOutput) *UpstreamConfigForGetServiceOutput {
	s.ConsistentHashConfig = v
	return s
}

// SetLoadBalancePolicy sets the LoadBalancePolicy field's value.
func (s *UpstreamConfigForGetServiceOutput) SetLoadBalancePolicy(v string) *UpstreamConfigForGetServiceOutput {
	s.LoadBalancePolicy = &v
	return s
}

const (
	// EnumOfChangeTypeForGetServiceOutputCreateService is a EnumOfChangeTypeForGetServiceOutput enum value
	EnumOfChangeTypeForGetServiceOutputCreateService = "CreateService"

	// EnumOfChangeTypeForGetServiceOutputUpdateService is a EnumOfChangeTypeForGetServiceOutput enum value
	EnumOfChangeTypeForGetServiceOutputUpdateService = "UpdateService"

	// EnumOfChangeTypeForGetServiceOutputMigrateService is a EnumOfChangeTypeForGetServiceOutput enum value
	EnumOfChangeTypeForGetServiceOutputMigrateService = "MigrateService"

	// EnumOfChangeTypeForGetServiceOutputStopService is a EnumOfChangeTypeForGetServiceOutput enum value
	EnumOfChangeTypeForGetServiceOutputStopService = "StopService"

	// EnumOfChangeTypeForGetServiceOutputStartService is a EnumOfChangeTypeForGetServiceOutput enum value
	EnumOfChangeTypeForGetServiceOutputStartService = "StartService"

	// EnumOfChangeTypeForGetServiceOutputDeleteService is a EnumOfChangeTypeForGetServiceOutput enum value
	EnumOfChangeTypeForGetServiceOutputDeleteService = "DeleteService"

	// EnumOfChangeTypeForGetServiceOutputCreateDeployment is a EnumOfChangeTypeForGetServiceOutput enum value
	EnumOfChangeTypeForGetServiceOutputCreateDeployment = "CreateDeployment"

	// EnumOfChangeTypeForGetServiceOutputUpdateDeployment is a EnumOfChangeTypeForGetServiceOutput enum value
	EnumOfChangeTypeForGetServiceOutputUpdateDeployment = "UpdateDeployment"

	// EnumOfChangeTypeForGetServiceOutputMigrateDeployment is a EnumOfChangeTypeForGetServiceOutput enum value
	EnumOfChangeTypeForGetServiceOutputMigrateDeployment = "MigrateDeployment"

	// EnumOfChangeTypeForGetServiceOutputStopDeployment is a EnumOfChangeTypeForGetServiceOutput enum value
	EnumOfChangeTypeForGetServiceOutputStopDeployment = "StopDeployment"

	// EnumOfChangeTypeForGetServiceOutputStartDeployment is a EnumOfChangeTypeForGetServiceOutput enum value
	EnumOfChangeTypeForGetServiceOutputStartDeployment = "StartDeployment"

	// EnumOfChangeTypeForGetServiceOutputScaleDeployment is a EnumOfChangeTypeForGetServiceOutput enum value
	EnumOfChangeTypeForGetServiceOutputScaleDeployment = "ScaleDeployment"

	// EnumOfChangeTypeForGetServiceOutputDeleteDeployment is a EnumOfChangeTypeForGetServiceOutput enum value
	EnumOfChangeTypeForGetServiceOutputDeleteDeployment = "DeleteDeployment"
)

const (
	// EnumOfHashKeyTypeForGetServiceOutputHttpHeaderName is a EnumOfHashKeyTypeForGetServiceOutput enum value
	EnumOfHashKeyTypeForGetServiceOutputHttpHeaderName = "HttpHeaderName"
)

const (
	// EnumOfLoadBalancePolicyForGetServiceOutputRoundRobin is a EnumOfLoadBalancePolicyForGetServiceOutput enum value
	EnumOfLoadBalancePolicyForGetServiceOutputRoundRobin = "ROUND_ROBIN"

	// EnumOfLoadBalancePolicyForGetServiceOutputLeastConn is a EnumOfLoadBalancePolicyForGetServiceOutput enum value
	EnumOfLoadBalancePolicyForGetServiceOutputLeastConn = "LEAST_CONN"

	// EnumOfLoadBalancePolicyForGetServiceOutputRandom is a EnumOfLoadBalancePolicyForGetServiceOutput enum value
	EnumOfLoadBalancePolicyForGetServiceOutputRandom = "RANDOM"

	// EnumOfLoadBalancePolicyForGetServiceOutputConsistentHash is a EnumOfLoadBalancePolicyForGetServiceOutput enum value
	EnumOfLoadBalancePolicyForGetServiceOutputConsistentHash = "CONSISTENT_HASH"
)

const (
	// EnumOfModeForGetServiceOutputDefault is a EnumOfModeForGetServiceOutput enum value
	EnumOfModeForGetServiceOutputDefault = "Default"

	// EnumOfModeForGetServiceOutputWeight is a EnumOfModeForGetServiceOutput enum value
	EnumOfModeForGetServiceOutputWeight = "Weight"
)

const (
	// EnumOfSchedulerForGetServiceOutputWrr is a EnumOfSchedulerForGetServiceOutput enum value
	EnumOfSchedulerForGetServiceOutputWrr = "wrr"

	// EnumOfSchedulerForGetServiceOutputWlc is a EnumOfSchedulerForGetServiceOutput enum value
	EnumOfSchedulerForGetServiceOutputWlc = "wlc"

	// EnumOfSchedulerForGetServiceOutputSh is a EnumOfSchedulerForGetServiceOutput enum value
	EnumOfSchedulerForGetServiceOutputSh = "sh"
)

const (
	// EnumOfTypeForGetServiceOutputHttp11 is a EnumOfTypeForGetServiceOutput enum value
	EnumOfTypeForGetServiceOutputHttp11 = "HTTP/1.1"

	// EnumOfTypeForGetServiceOutputHttp2 is a EnumOfTypeForGetServiceOutput enum value
	EnumOfTypeForGetServiceOutputHttp2 = "HTTP2"

	// EnumOfTypeForGetServiceOutputGrpc is a EnumOfTypeForGetServiceOutput enum value
	EnumOfTypeForGetServiceOutputGrpc = "GRPC"

	// EnumOfTypeForGetServiceOutputMetrics is a EnumOfTypeForGetServiceOutput enum value
	EnumOfTypeForGetServiceOutputMetrics = "Metrics"

	// EnumOfTypeForGetServiceOutputOther is a EnumOfTypeForGetServiceOutput enum value
	EnumOfTypeForGetServiceOutputOther = "Other"
)
