// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package mlplatform20240701

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opGetResourceQueueCommon = "GetResourceQueue"

// GetResourceQueueCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the GetResourceQueueCommon operation. The "output" return
// value will be populated with the GetResourceQueueCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GetResourceQueueCommon Request to send the API call to the service.
// the "output" return value is not valid until after GetResourceQueueCommon Send returns without error.
//
// See GetResourceQueueCommon for more information on using the GetResourceQueueCommon
// API call, and error handling.
//
//    // Example sending a request using the GetResourceQueueCommonRequest method.
//    req, resp := client.GetResourceQueueCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MLPLATFORM20240701) GetResourceQueueCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opGetResourceQueueCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// GetResourceQueueCommon API operation for ML_PLATFORM20240701.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ML_PLATFORM20240701's
// API operation GetResourceQueueCommon for usage and error information.
func (c *MLPLATFORM20240701) GetResourceQueueCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.GetResourceQueueCommonRequest(input)
	return out, req.Send()
}

// GetResourceQueueCommonWithContext is the same as GetResourceQueueCommon with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourceQueueCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MLPLATFORM20240701) GetResourceQueueCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.GetResourceQueueCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetResourceQueue = "GetResourceQueue"

// GetResourceQueueRequest generates a "volcengine/request.Request" representing the
// client's request for the GetResourceQueue operation. The "output" return
// value will be populated with the GetResourceQueueCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GetResourceQueueCommon Request to send the API call to the service.
// the "output" return value is not valid until after GetResourceQueueCommon Send returns without error.
//
// See GetResourceQueue for more information on using the GetResourceQueue
// API call, and error handling.
//
//    // Example sending a request using the GetResourceQueueRequest method.
//    req, resp := client.GetResourceQueueRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MLPLATFORM20240701) GetResourceQueueRequest(input *GetResourceQueueInput) (req *request.Request, output *GetResourceQueueOutput) {
	op := &request.Operation{
		Name:       opGetResourceQueue,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetResourceQueueInput{}
	}

	output = &GetResourceQueueOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// GetResourceQueue API operation for ML_PLATFORM20240701.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ML_PLATFORM20240701's
// API operation GetResourceQueue for usage and error information.
func (c *MLPLATFORM20240701) GetResourceQueue(input *GetResourceQueueInput) (*GetResourceQueueOutput, error) {
	req, out := c.GetResourceQueueRequest(input)
	return out, req.Send()
}

// GetResourceQueueWithContext is the same as GetResourceQueue with the addition of
// the ability to pass a context and additional request options.
//
// See GetResourceQueue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MLPLATFORM20240701) GetResourceQueueWithContext(ctx volcengine.Context, input *GetResourceQueueInput, opts ...request.Option) (*GetResourceQueueOutput, error) {
	req, out := c.GetResourceQueueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AutoCompactGPUResourceRuleForGetResourceQueueOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AffectedWorkloadTypes []*string `type:"list" json:",omitempty"`

	CreateTime *string `type:"string" json:",omitempty"`

	CreatorTrn *string `type:"string" json:",omitempty"`

	CronSpecs []*CronSpecForGetResourceQueueOutput `type:"list" json:",omitempty"`

	Enabled *bool `type:"boolean" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	OnUnschedulable *bool `type:"boolean" json:",omitempty"`

	TriggeredTimes *int32 `type:"int32" json:",omitempty"`

	UpdateTime *string `type:"string" json:",omitempty"`

	UpdatorTrn *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s AutoCompactGPUResourceRuleForGetResourceQueueOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AutoCompactGPUResourceRuleForGetResourceQueueOutput) GoString() string {
	return s.String()
}

// SetAffectedWorkloadTypes sets the AffectedWorkloadTypes field's value.
func (s *AutoCompactGPUResourceRuleForGetResourceQueueOutput) SetAffectedWorkloadTypes(v []*string) *AutoCompactGPUResourceRuleForGetResourceQueueOutput {
	s.AffectedWorkloadTypes = v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *AutoCompactGPUResourceRuleForGetResourceQueueOutput) SetCreateTime(v string) *AutoCompactGPUResourceRuleForGetResourceQueueOutput {
	s.CreateTime = &v
	return s
}

// SetCreatorTrn sets the CreatorTrn field's value.
func (s *AutoCompactGPUResourceRuleForGetResourceQueueOutput) SetCreatorTrn(v string) *AutoCompactGPUResourceRuleForGetResourceQueueOutput {
	s.CreatorTrn = &v
	return s
}

// SetCronSpecs sets the CronSpecs field's value.
func (s *AutoCompactGPUResourceRuleForGetResourceQueueOutput) SetCronSpecs(v []*CronSpecForGetResourceQueueOutput) *AutoCompactGPUResourceRuleForGetResourceQueueOutput {
	s.CronSpecs = v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *AutoCompactGPUResourceRuleForGetResourceQueueOutput) SetEnabled(v bool) *AutoCompactGPUResourceRuleForGetResourceQueueOutput {
	s.Enabled = &v
	return s
}

// SetId sets the Id field's value.
func (s *AutoCompactGPUResourceRuleForGetResourceQueueOutput) SetId(v string) *AutoCompactGPUResourceRuleForGetResourceQueueOutput {
	s.Id = &v
	return s
}

// SetOnUnschedulable sets the OnUnschedulable field's value.
func (s *AutoCompactGPUResourceRuleForGetResourceQueueOutput) SetOnUnschedulable(v bool) *AutoCompactGPUResourceRuleForGetResourceQueueOutput {
	s.OnUnschedulable = &v
	return s
}

// SetTriggeredTimes sets the TriggeredTimes field's value.
func (s *AutoCompactGPUResourceRuleForGetResourceQueueOutput) SetTriggeredTimes(v int32) *AutoCompactGPUResourceRuleForGetResourceQueueOutput {
	s.TriggeredTimes = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *AutoCompactGPUResourceRuleForGetResourceQueueOutput) SetUpdateTime(v string) *AutoCompactGPUResourceRuleForGetResourceQueueOutput {
	s.UpdateTime = &v
	return s
}

// SetUpdatorTrn sets the UpdatorTrn field's value.
func (s *AutoCompactGPUResourceRuleForGetResourceQueueOutput) SetUpdatorTrn(v string) *AutoCompactGPUResourceRuleForGetResourceQueueOutput {
	s.UpdatorTrn = &v
	return s
}

type ComputeResourceForGetResourceQueueOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Count *int32 `type:"int32" json:",omitempty"`

	InstanceTypeId *string `type:"string" json:",omitempty"`

	ZoneId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ComputeResourceForGetResourceQueueOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ComputeResourceForGetResourceQueueOutput) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *ComputeResourceForGetResourceQueueOutput) SetCount(v int32) *ComputeResourceForGetResourceQueueOutput {
	s.Count = &v
	return s
}

// SetInstanceTypeId sets the InstanceTypeId field's value.
func (s *ComputeResourceForGetResourceQueueOutput) SetInstanceTypeId(v string) *ComputeResourceForGetResourceQueueOutput {
	s.InstanceTypeId = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *ComputeResourceForGetResourceQueueOutput) SetZoneId(v string) *ComputeResourceForGetResourceQueueOutput {
	s.ZoneId = &v
	return s
}

type CronSpecForGetResourceQueueOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AffectedWorkloadType *string `type:"string" json:",omitempty"`

	Schedule *string `type:"string" json:",omitempty"`

	TimeZone *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CronSpecForGetResourceQueueOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CronSpecForGetResourceQueueOutput) GoString() string {
	return s.String()
}

// SetAffectedWorkloadType sets the AffectedWorkloadType field's value.
func (s *CronSpecForGetResourceQueueOutput) SetAffectedWorkloadType(v string) *CronSpecForGetResourceQueueOutput {
	s.AffectedWorkloadType = &v
	return s
}

// SetSchedule sets the Schedule field's value.
func (s *CronSpecForGetResourceQueueOutput) SetSchedule(v string) *CronSpecForGetResourceQueueOutput {
	s.Schedule = &v
	return s
}

// SetTimeZone sets the TimeZone field's value.
func (s *CronSpecForGetResourceQueueOutput) SetTimeZone(v string) *CronSpecForGetResourceQueueOutput {
	s.TimeZone = &v
	return s
}

type GeneralIdleRuleForGetResourceQueueOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CreateTime *string `type:"string" json:",omitempty"`

	CreatorTrn *string `type:"string" json:",omitempty"`

	Enabled *bool `type:"boolean" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	IdleShutdownRuleTypes []*string `type:"list" json:",omitempty"`

	MinutePeriod *int32 `type:"int32" json:",omitempty"`

	Period *int32 `type:"int32" json:",omitempty"`

	Threshold *float64 `type:"double" json:",omitempty"`

	TriggeredTimes *int32 `type:"int32" json:",omitempty"`

	UpdateTime *string `type:"string" json:",omitempty"`

	UpdatorTrn *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s GeneralIdleRuleForGetResourceQueueOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GeneralIdleRuleForGetResourceQueueOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *GeneralIdleRuleForGetResourceQueueOutput) SetCreateTime(v string) *GeneralIdleRuleForGetResourceQueueOutput {
	s.CreateTime = &v
	return s
}

// SetCreatorTrn sets the CreatorTrn field's value.
func (s *GeneralIdleRuleForGetResourceQueueOutput) SetCreatorTrn(v string) *GeneralIdleRuleForGetResourceQueueOutput {
	s.CreatorTrn = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *GeneralIdleRuleForGetResourceQueueOutput) SetEnabled(v bool) *GeneralIdleRuleForGetResourceQueueOutput {
	s.Enabled = &v
	return s
}

// SetId sets the Id field's value.
func (s *GeneralIdleRuleForGetResourceQueueOutput) SetId(v string) *GeneralIdleRuleForGetResourceQueueOutput {
	s.Id = &v
	return s
}

// SetIdleShutdownRuleTypes sets the IdleShutdownRuleTypes field's value.
func (s *GeneralIdleRuleForGetResourceQueueOutput) SetIdleShutdownRuleTypes(v []*string) *GeneralIdleRuleForGetResourceQueueOutput {
	s.IdleShutdownRuleTypes = v
	return s
}

// SetMinutePeriod sets the MinutePeriod field's value.
func (s *GeneralIdleRuleForGetResourceQueueOutput) SetMinutePeriod(v int32) *GeneralIdleRuleForGetResourceQueueOutput {
	s.MinutePeriod = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *GeneralIdleRuleForGetResourceQueueOutput) SetPeriod(v int32) *GeneralIdleRuleForGetResourceQueueOutput {
	s.Period = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *GeneralIdleRuleForGetResourceQueueOutput) SetThreshold(v float64) *GeneralIdleRuleForGetResourceQueueOutput {
	s.Threshold = &v
	return s
}

// SetTriggeredTimes sets the TriggeredTimes field's value.
func (s *GeneralIdleRuleForGetResourceQueueOutput) SetTriggeredTimes(v int32) *GeneralIdleRuleForGetResourceQueueOutput {
	s.TriggeredTimes = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *GeneralIdleRuleForGetResourceQueueOutput) SetUpdateTime(v string) *GeneralIdleRuleForGetResourceQueueOutput {
	s.UpdateTime = &v
	return s
}

// SetUpdatorTrn sets the UpdatorTrn field's value.
func (s *GeneralIdleRuleForGetResourceQueueOutput) SetUpdatorTrn(v string) *GeneralIdleRuleForGetResourceQueueOutput {
	s.UpdatorTrn = &v
	return s
}

type GetResourceQueueInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// Id is a required field
	Id *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s GetResourceQueueInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourceQueueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetResourceQueueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetResourceQueueInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetResourceQueueInput) SetId(v string) *GetResourceQueueInput {
	s.Id = &v
	return s
}

type GetResourceQueueOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	ChargeType *string `type:"string" json:",omitempty"`

	ComputeResources []*ComputeResourceForGetResourceQueueOutput `type:"list" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	QuotaAllocated *QuotaAllocatedForGetResourceQueueOutput `type:"structure" json:",omitempty"`

	QuotaCapability *QuotaCapabilityForGetResourceQueueOutput `type:"structure" json:",omitempty"`

	ResourceGroupId *string `type:"string" json:",omitempty"`

	Rules *RulesForGetResourceQueueOutput `type:"structure" json:",omitempty"`

	Shareable *bool `type:"boolean" json:",omitempty"`

	SharedQuotaAllocated *SharedQuotaAllocatedForGetResourceQueueOutput `type:"structure" json:",omitempty"`

	Status *StatusForGetResourceQueueOutput `type:"structure" json:",omitempty"`

	SystemQuotaAllocated *SystemQuotaAllocatedForGetResourceQueueOutput `type:"structure" json:",omitempty"`

	VolumeResources []*VolumeResourceForGetResourceQueueOutput `type:"list" json:",omitempty"`

	WorkloadInfos []*WorkloadInfoForGetResourceQueueOutput `type:"list" json:",omitempty"`

	ZoneIds []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s GetResourceQueueOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GetResourceQueueOutput) GoString() string {
	return s.String()
}

// SetChargeType sets the ChargeType field's value.
func (s *GetResourceQueueOutput) SetChargeType(v string) *GetResourceQueueOutput {
	s.ChargeType = &v
	return s
}

// SetComputeResources sets the ComputeResources field's value.
func (s *GetResourceQueueOutput) SetComputeResources(v []*ComputeResourceForGetResourceQueueOutput) *GetResourceQueueOutput {
	s.ComputeResources = v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetResourceQueueOutput) SetDescription(v string) *GetResourceQueueOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetResourceQueueOutput) SetId(v string) *GetResourceQueueOutput {
	s.Id = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetResourceQueueOutput) SetName(v string) *GetResourceQueueOutput {
	s.Name = &v
	return s
}

// SetQuotaAllocated sets the QuotaAllocated field's value.
func (s *GetResourceQueueOutput) SetQuotaAllocated(v *QuotaAllocatedForGetResourceQueueOutput) *GetResourceQueueOutput {
	s.QuotaAllocated = v
	return s
}

// SetQuotaCapability sets the QuotaCapability field's value.
func (s *GetResourceQueueOutput) SetQuotaCapability(v *QuotaCapabilityForGetResourceQueueOutput) *GetResourceQueueOutput {
	s.QuotaCapability = v
	return s
}

// SetResourceGroupId sets the ResourceGroupId field's value.
func (s *GetResourceQueueOutput) SetResourceGroupId(v string) *GetResourceQueueOutput {
	s.ResourceGroupId = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *GetResourceQueueOutput) SetRules(v *RulesForGetResourceQueueOutput) *GetResourceQueueOutput {
	s.Rules = v
	return s
}

// SetShareable sets the Shareable field's value.
func (s *GetResourceQueueOutput) SetShareable(v bool) *GetResourceQueueOutput {
	s.Shareable = &v
	return s
}

// SetSharedQuotaAllocated sets the SharedQuotaAllocated field's value.
func (s *GetResourceQueueOutput) SetSharedQuotaAllocated(v *SharedQuotaAllocatedForGetResourceQueueOutput) *GetResourceQueueOutput {
	s.SharedQuotaAllocated = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetResourceQueueOutput) SetStatus(v *StatusForGetResourceQueueOutput) *GetResourceQueueOutput {
	s.Status = v
	return s
}

// SetSystemQuotaAllocated sets the SystemQuotaAllocated field's value.
func (s *GetResourceQueueOutput) SetSystemQuotaAllocated(v *SystemQuotaAllocatedForGetResourceQueueOutput) *GetResourceQueueOutput {
	s.SystemQuotaAllocated = v
	return s
}

// SetVolumeResources sets the VolumeResources field's value.
func (s *GetResourceQueueOutput) SetVolumeResources(v []*VolumeResourceForGetResourceQueueOutput) *GetResourceQueueOutput {
	s.VolumeResources = v
	return s
}

// SetWorkloadInfos sets the WorkloadInfos field's value.
func (s *GetResourceQueueOutput) SetWorkloadInfos(v []*WorkloadInfoForGetResourceQueueOutput) *GetResourceQueueOutput {
	s.WorkloadInfos = v
	return s
}

// SetZoneIds sets the ZoneIds field's value.
func (s *GetResourceQueueOutput) SetZoneIds(v []*string) *GetResourceQueueOutput {
	s.ZoneIds = v
	return s
}

type GpuCountInfoForGetResourceQueueOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Count *float64 `type:"double" json:",omitempty"`

	GpuType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s GpuCountInfoForGetResourceQueueOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GpuCountInfoForGetResourceQueueOutput) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *GpuCountInfoForGetResourceQueueOutput) SetCount(v float64) *GpuCountInfoForGetResourceQueueOutput {
	s.Count = &v
	return s
}

// SetGpuType sets the GpuType field's value.
func (s *GpuCountInfoForGetResourceQueueOutput) SetGpuType(v string) *GpuCountInfoForGetResourceQueueOutput {
	s.GpuType = &v
	return s
}

type GpuMemoryInfoForGetResourceQueueOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	GpuType *string `type:"string" json:",omitempty"`

	MemoryGiB *float64 `type:"double" json:",omitempty"`
}

// String returns the string representation
func (s GpuMemoryInfoForGetResourceQueueOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GpuMemoryInfoForGetResourceQueueOutput) GoString() string {
	return s.String()
}

// SetGpuType sets the GpuType field's value.
func (s *GpuMemoryInfoForGetResourceQueueOutput) SetGpuType(v string) *GpuMemoryInfoForGetResourceQueueOutput {
	s.GpuType = &v
	return s
}

// SetMemoryGiB sets the MemoryGiB field's value.
func (s *GpuMemoryInfoForGetResourceQueueOutput) SetMemoryGiB(v float64) *GpuMemoryInfoForGetResourceQueueOutput {
	s.MemoryGiB = &v
	return s
}

type GpuRdmaInfoForGetResourceQueueOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Count *int32 `type:"int32" json:",omitempty"`

	GpuType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s GpuRdmaInfoForGetResourceQueueOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GpuRdmaInfoForGetResourceQueueOutput) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *GpuRdmaInfoForGetResourceQueueOutput) SetCount(v int32) *GpuRdmaInfoForGetResourceQueueOutput {
	s.Count = &v
	return s
}

// SetGpuType sets the GpuType field's value.
func (s *GpuRdmaInfoForGetResourceQueueOutput) SetGpuType(v string) *GpuRdmaInfoForGetResourceQueueOutput {
	s.GpuType = &v
	return s
}

type GpuUtilizationRuleForGetResourceQueueOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CreateTime *string `type:"string" json:",omitempty"`

	CreatorTrn *string `type:"string" json:",omitempty"`

	Enabled *bool `type:"boolean" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	IdleShutdownRuleTypes []*string `type:"list" json:",omitempty"`

	MinutePeriod *int32 `type:"int32" json:",omitempty"`

	Period *int32 `type:"int32" json:",omitempty"`

	Threshold *float64 `type:"double" json:",omitempty"`

	TriggeredTimes *int32 `type:"int32" json:",omitempty"`

	UpdateTime *string `type:"string" json:",omitempty"`

	UpdatorTrn *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s GpuUtilizationRuleForGetResourceQueueOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GpuUtilizationRuleForGetResourceQueueOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *GpuUtilizationRuleForGetResourceQueueOutput) SetCreateTime(v string) *GpuUtilizationRuleForGetResourceQueueOutput {
	s.CreateTime = &v
	return s
}

// SetCreatorTrn sets the CreatorTrn field's value.
func (s *GpuUtilizationRuleForGetResourceQueueOutput) SetCreatorTrn(v string) *GpuUtilizationRuleForGetResourceQueueOutput {
	s.CreatorTrn = &v
	return s
}

// SetEnabled sets the Enabled field's value.
func (s *GpuUtilizationRuleForGetResourceQueueOutput) SetEnabled(v bool) *GpuUtilizationRuleForGetResourceQueueOutput {
	s.Enabled = &v
	return s
}

// SetId sets the Id field's value.
func (s *GpuUtilizationRuleForGetResourceQueueOutput) SetId(v string) *GpuUtilizationRuleForGetResourceQueueOutput {
	s.Id = &v
	return s
}

// SetIdleShutdownRuleTypes sets the IdleShutdownRuleTypes field's value.
func (s *GpuUtilizationRuleForGetResourceQueueOutput) SetIdleShutdownRuleTypes(v []*string) *GpuUtilizationRuleForGetResourceQueueOutput {
	s.IdleShutdownRuleTypes = v
	return s
}

// SetMinutePeriod sets the MinutePeriod field's value.
func (s *GpuUtilizationRuleForGetResourceQueueOutput) SetMinutePeriod(v int32) *GpuUtilizationRuleForGetResourceQueueOutput {
	s.MinutePeriod = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *GpuUtilizationRuleForGetResourceQueueOutput) SetPeriod(v int32) *GpuUtilizationRuleForGetResourceQueueOutput {
	s.Period = &v
	return s
}

// SetThreshold sets the Threshold field's value.
func (s *GpuUtilizationRuleForGetResourceQueueOutput) SetThreshold(v float64) *GpuUtilizationRuleForGetResourceQueueOutput {
	s.Threshold = &v
	return s
}

// SetTriggeredTimes sets the TriggeredTimes field's value.
func (s *GpuUtilizationRuleForGetResourceQueueOutput) SetTriggeredTimes(v int32) *GpuUtilizationRuleForGetResourceQueueOutput {
	s.TriggeredTimes = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *GpuUtilizationRuleForGetResourceQueueOutput) SetUpdateTime(v string) *GpuUtilizationRuleForGetResourceQueueOutput {
	s.UpdateTime = &v
	return s
}

// SetUpdatorTrn sets the UpdatorTrn field's value.
func (s *GpuUtilizationRuleForGetResourceQueueOutput) SetUpdatorTrn(v string) *GpuUtilizationRuleForGetResourceQueueOutput {
	s.UpdatorTrn = &v
	return s
}

type QuotaAllocatedForGetResourceQueueOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Cpu *float64 `type:"double" json:",omitempty"`

	GpuCount *float64 `type:"double" json:",omitempty"`

	GpuCountInfos []*GpuCountInfoForGetResourceQueueOutput `type:"list" json:",omitempty"`

	GpuMemoryInfos []*GpuMemoryInfoForGetResourceQueueOutput `type:"list" json:",omitempty"`

	GpuRdmaInfos []*GpuRdmaInfoForGetResourceQueueOutput `type:"list" json:",omitempty"`

	MemoryGiB *float64 `type:"double" json:",omitempty"`

	VolumeSizeGiB *float64 `type:"double" json:",omitempty"`

	VolumeSizeInfos []*VolumeSizeInfoForGetResourceQueueOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s QuotaAllocatedForGetResourceQueueOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s QuotaAllocatedForGetResourceQueueOutput) GoString() string {
	return s.String()
}

// SetCpu sets the Cpu field's value.
func (s *QuotaAllocatedForGetResourceQueueOutput) SetCpu(v float64) *QuotaAllocatedForGetResourceQueueOutput {
	s.Cpu = &v
	return s
}

// SetGpuCount sets the GpuCount field's value.
func (s *QuotaAllocatedForGetResourceQueueOutput) SetGpuCount(v float64) *QuotaAllocatedForGetResourceQueueOutput {
	s.GpuCount = &v
	return s
}

// SetGpuCountInfos sets the GpuCountInfos field's value.
func (s *QuotaAllocatedForGetResourceQueueOutput) SetGpuCountInfos(v []*GpuCountInfoForGetResourceQueueOutput) *QuotaAllocatedForGetResourceQueueOutput {
	s.GpuCountInfos = v
	return s
}

// SetGpuMemoryInfos sets the GpuMemoryInfos field's value.
func (s *QuotaAllocatedForGetResourceQueueOutput) SetGpuMemoryInfos(v []*GpuMemoryInfoForGetResourceQueueOutput) *QuotaAllocatedForGetResourceQueueOutput {
	s.GpuMemoryInfos = v
	return s
}

// SetGpuRdmaInfos sets the GpuRdmaInfos field's value.
func (s *QuotaAllocatedForGetResourceQueueOutput) SetGpuRdmaInfos(v []*GpuRdmaInfoForGetResourceQueueOutput) *QuotaAllocatedForGetResourceQueueOutput {
	s.GpuRdmaInfos = v
	return s
}

// SetMemoryGiB sets the MemoryGiB field's value.
func (s *QuotaAllocatedForGetResourceQueueOutput) SetMemoryGiB(v float64) *QuotaAllocatedForGetResourceQueueOutput {
	s.MemoryGiB = &v
	return s
}

// SetVolumeSizeGiB sets the VolumeSizeGiB field's value.
func (s *QuotaAllocatedForGetResourceQueueOutput) SetVolumeSizeGiB(v float64) *QuotaAllocatedForGetResourceQueueOutput {
	s.VolumeSizeGiB = &v
	return s
}

// SetVolumeSizeInfos sets the VolumeSizeInfos field's value.
func (s *QuotaAllocatedForGetResourceQueueOutput) SetVolumeSizeInfos(v []*VolumeSizeInfoForGetResourceQueueOutput) *QuotaAllocatedForGetResourceQueueOutput {
	s.VolumeSizeInfos = v
	return s
}

type QuotaCapabilityForGetResourceQueueOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Cpu *float64 `type:"double" json:",omitempty"`

	GpuCount *float64 `type:"double" json:",omitempty"`

	GpuCountInfos []*GpuCountInfoForGetResourceQueueOutput `type:"list" json:",omitempty"`

	GpuMemoryInfos []*GpuMemoryInfoForGetResourceQueueOutput `type:"list" json:",omitempty"`

	GpuRdmaInfos []*GpuRdmaInfoForGetResourceQueueOutput `type:"list" json:",omitempty"`

	MemoryGiB *float64 `type:"double" json:",omitempty"`

	VolumeSizeGiB *float64 `type:"double" json:",omitempty"`

	VolumeSizeInfos []*VolumeSizeInfoForGetResourceQueueOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s QuotaCapabilityForGetResourceQueueOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s QuotaCapabilityForGetResourceQueueOutput) GoString() string {
	return s.String()
}

// SetCpu sets the Cpu field's value.
func (s *QuotaCapabilityForGetResourceQueueOutput) SetCpu(v float64) *QuotaCapabilityForGetResourceQueueOutput {
	s.Cpu = &v
	return s
}

// SetGpuCount sets the GpuCount field's value.
func (s *QuotaCapabilityForGetResourceQueueOutput) SetGpuCount(v float64) *QuotaCapabilityForGetResourceQueueOutput {
	s.GpuCount = &v
	return s
}

// SetGpuCountInfos sets the GpuCountInfos field's value.
func (s *QuotaCapabilityForGetResourceQueueOutput) SetGpuCountInfos(v []*GpuCountInfoForGetResourceQueueOutput) *QuotaCapabilityForGetResourceQueueOutput {
	s.GpuCountInfos = v
	return s
}

// SetGpuMemoryInfos sets the GpuMemoryInfos field's value.
func (s *QuotaCapabilityForGetResourceQueueOutput) SetGpuMemoryInfos(v []*GpuMemoryInfoForGetResourceQueueOutput) *QuotaCapabilityForGetResourceQueueOutput {
	s.GpuMemoryInfos = v
	return s
}

// SetGpuRdmaInfos sets the GpuRdmaInfos field's value.
func (s *QuotaCapabilityForGetResourceQueueOutput) SetGpuRdmaInfos(v []*GpuRdmaInfoForGetResourceQueueOutput) *QuotaCapabilityForGetResourceQueueOutput {
	s.GpuRdmaInfos = v
	return s
}

// SetMemoryGiB sets the MemoryGiB field's value.
func (s *QuotaCapabilityForGetResourceQueueOutput) SetMemoryGiB(v float64) *QuotaCapabilityForGetResourceQueueOutput {
	s.MemoryGiB = &v
	return s
}

// SetVolumeSizeGiB sets the VolumeSizeGiB field's value.
func (s *QuotaCapabilityForGetResourceQueueOutput) SetVolumeSizeGiB(v float64) *QuotaCapabilityForGetResourceQueueOutput {
	s.VolumeSizeGiB = &v
	return s
}

// SetVolumeSizeInfos sets the VolumeSizeInfos field's value.
func (s *QuotaCapabilityForGetResourceQueueOutput) SetVolumeSizeInfos(v []*VolumeSizeInfoForGetResourceQueueOutput) *QuotaCapabilityForGetResourceQueueOutput {
	s.VolumeSizeInfos = v
	return s
}

type RulesForGetResourceQueueOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AutoCompactGPUResourceRule *AutoCompactGPUResourceRuleForGetResourceQueueOutput `type:"structure" json:",omitempty"`

	GeneralIdleRule *GeneralIdleRuleForGetResourceQueueOutput `type:"structure" json:",omitempty"`

	GpuUtilizationRule *GpuUtilizationRuleForGetResourceQueueOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s RulesForGetResourceQueueOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RulesForGetResourceQueueOutput) GoString() string {
	return s.String()
}

// SetAutoCompactGPUResourceRule sets the AutoCompactGPUResourceRule field's value.
func (s *RulesForGetResourceQueueOutput) SetAutoCompactGPUResourceRule(v *AutoCompactGPUResourceRuleForGetResourceQueueOutput) *RulesForGetResourceQueueOutput {
	s.AutoCompactGPUResourceRule = v
	return s
}

// SetGeneralIdleRule sets the GeneralIdleRule field's value.
func (s *RulesForGetResourceQueueOutput) SetGeneralIdleRule(v *GeneralIdleRuleForGetResourceQueueOutput) *RulesForGetResourceQueueOutput {
	s.GeneralIdleRule = v
	return s
}

// SetGpuUtilizationRule sets the GpuUtilizationRule field's value.
func (s *RulesForGetResourceQueueOutput) SetGpuUtilizationRule(v *GpuUtilizationRuleForGetResourceQueueOutput) *RulesForGetResourceQueueOutput {
	s.GpuUtilizationRule = v
	return s
}

type SharedQuotaAllocatedForGetResourceQueueOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Cpu *float64 `type:"double" json:",omitempty"`

	GpuCount *float64 `type:"double" json:",omitempty"`

	GpuCountInfos []*GpuCountInfoForGetResourceQueueOutput `type:"list" json:",omitempty"`

	GpuMemoryInfos []*GpuMemoryInfoForGetResourceQueueOutput `type:"list" json:",omitempty"`

	GpuRdmaInfos []*GpuRdmaInfoForGetResourceQueueOutput `type:"list" json:",omitempty"`

	MemoryGiB *float64 `type:"double" json:",omitempty"`

	VolumeSizeGiB *float64 `type:"double" json:",omitempty"`

	VolumeSizeInfos []*VolumeSizeInfoForGetResourceQueueOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s SharedQuotaAllocatedForGetResourceQueueOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SharedQuotaAllocatedForGetResourceQueueOutput) GoString() string {
	return s.String()
}

// SetCpu sets the Cpu field's value.
func (s *SharedQuotaAllocatedForGetResourceQueueOutput) SetCpu(v float64) *SharedQuotaAllocatedForGetResourceQueueOutput {
	s.Cpu = &v
	return s
}

// SetGpuCount sets the GpuCount field's value.
func (s *SharedQuotaAllocatedForGetResourceQueueOutput) SetGpuCount(v float64) *SharedQuotaAllocatedForGetResourceQueueOutput {
	s.GpuCount = &v
	return s
}

// SetGpuCountInfos sets the GpuCountInfos field's value.
func (s *SharedQuotaAllocatedForGetResourceQueueOutput) SetGpuCountInfos(v []*GpuCountInfoForGetResourceQueueOutput) *SharedQuotaAllocatedForGetResourceQueueOutput {
	s.GpuCountInfos = v
	return s
}

// SetGpuMemoryInfos sets the GpuMemoryInfos field's value.
func (s *SharedQuotaAllocatedForGetResourceQueueOutput) SetGpuMemoryInfos(v []*GpuMemoryInfoForGetResourceQueueOutput) *SharedQuotaAllocatedForGetResourceQueueOutput {
	s.GpuMemoryInfos = v
	return s
}

// SetGpuRdmaInfos sets the GpuRdmaInfos field's value.
func (s *SharedQuotaAllocatedForGetResourceQueueOutput) SetGpuRdmaInfos(v []*GpuRdmaInfoForGetResourceQueueOutput) *SharedQuotaAllocatedForGetResourceQueueOutput {
	s.GpuRdmaInfos = v
	return s
}

// SetMemoryGiB sets the MemoryGiB field's value.
func (s *SharedQuotaAllocatedForGetResourceQueueOutput) SetMemoryGiB(v float64) *SharedQuotaAllocatedForGetResourceQueueOutput {
	s.MemoryGiB = &v
	return s
}

// SetVolumeSizeGiB sets the VolumeSizeGiB field's value.
func (s *SharedQuotaAllocatedForGetResourceQueueOutput) SetVolumeSizeGiB(v float64) *SharedQuotaAllocatedForGetResourceQueueOutput {
	s.VolumeSizeGiB = &v
	return s
}

// SetVolumeSizeInfos sets the VolumeSizeInfos field's value.
func (s *SharedQuotaAllocatedForGetResourceQueueOutput) SetVolumeSizeInfos(v []*VolumeSizeInfoForGetResourceQueueOutput) *SharedQuotaAllocatedForGetResourceQueueOutput {
	s.VolumeSizeInfos = v
	return s
}

type StatusForGetResourceQueueOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Message *string `type:"string" json:",omitempty"`

	SecondaryState *string `type:"string" json:",omitempty"`

	State *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s StatusForGetResourceQueueOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StatusForGetResourceQueueOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *StatusForGetResourceQueueOutput) SetMessage(v string) *StatusForGetResourceQueueOutput {
	s.Message = &v
	return s
}

// SetSecondaryState sets the SecondaryState field's value.
func (s *StatusForGetResourceQueueOutput) SetSecondaryState(v string) *StatusForGetResourceQueueOutput {
	s.SecondaryState = &v
	return s
}

// SetState sets the State field's value.
func (s *StatusForGetResourceQueueOutput) SetState(v string) *StatusForGetResourceQueueOutput {
	s.State = &v
	return s
}

type SystemQuotaAllocatedForGetResourceQueueOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Cpu *float64 `type:"double" json:",omitempty"`

	GpuCount *float64 `type:"double" json:",omitempty"`

	GpuCountInfos []*GpuCountInfoForGetResourceQueueOutput `type:"list" json:",omitempty"`

	GpuMemoryInfos []*GpuMemoryInfoForGetResourceQueueOutput `type:"list" json:",omitempty"`

	GpuRdmaInfos []*GpuRdmaInfoForGetResourceQueueOutput `type:"list" json:",omitempty"`

	MemoryGiB *float64 `type:"double" json:",omitempty"`

	VolumeSizeGiB *float64 `type:"double" json:",omitempty"`

	VolumeSizeInfos []*VolumeSizeInfoForGetResourceQueueOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s SystemQuotaAllocatedForGetResourceQueueOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SystemQuotaAllocatedForGetResourceQueueOutput) GoString() string {
	return s.String()
}

// SetCpu sets the Cpu field's value.
func (s *SystemQuotaAllocatedForGetResourceQueueOutput) SetCpu(v float64) *SystemQuotaAllocatedForGetResourceQueueOutput {
	s.Cpu = &v
	return s
}

// SetGpuCount sets the GpuCount field's value.
func (s *SystemQuotaAllocatedForGetResourceQueueOutput) SetGpuCount(v float64) *SystemQuotaAllocatedForGetResourceQueueOutput {
	s.GpuCount = &v
	return s
}

// SetGpuCountInfos sets the GpuCountInfos field's value.
func (s *SystemQuotaAllocatedForGetResourceQueueOutput) SetGpuCountInfos(v []*GpuCountInfoForGetResourceQueueOutput) *SystemQuotaAllocatedForGetResourceQueueOutput {
	s.GpuCountInfos = v
	return s
}

// SetGpuMemoryInfos sets the GpuMemoryInfos field's value.
func (s *SystemQuotaAllocatedForGetResourceQueueOutput) SetGpuMemoryInfos(v []*GpuMemoryInfoForGetResourceQueueOutput) *SystemQuotaAllocatedForGetResourceQueueOutput {
	s.GpuMemoryInfos = v
	return s
}

// SetGpuRdmaInfos sets the GpuRdmaInfos field's value.
func (s *SystemQuotaAllocatedForGetResourceQueueOutput) SetGpuRdmaInfos(v []*GpuRdmaInfoForGetResourceQueueOutput) *SystemQuotaAllocatedForGetResourceQueueOutput {
	s.GpuRdmaInfos = v
	return s
}

// SetMemoryGiB sets the MemoryGiB field's value.
func (s *SystemQuotaAllocatedForGetResourceQueueOutput) SetMemoryGiB(v float64) *SystemQuotaAllocatedForGetResourceQueueOutput {
	s.MemoryGiB = &v
	return s
}

// SetVolumeSizeGiB sets the VolumeSizeGiB field's value.
func (s *SystemQuotaAllocatedForGetResourceQueueOutput) SetVolumeSizeGiB(v float64) *SystemQuotaAllocatedForGetResourceQueueOutput {
	s.VolumeSizeGiB = &v
	return s
}

// SetVolumeSizeInfos sets the VolumeSizeInfos field's value.
func (s *SystemQuotaAllocatedForGetResourceQueueOutput) SetVolumeSizeInfos(v []*VolumeSizeInfoForGetResourceQueueOutput) *SystemQuotaAllocatedForGetResourceQueueOutput {
	s.VolumeSizeInfos = v
	return s
}

type VolumeResourceForGetResourceQueueOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Size *int32 `type:"int32" json:",omitempty"`

	VolumeTypeId *string `type:"string" json:",omitempty"`

	ZoneId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s VolumeResourceForGetResourceQueueOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VolumeResourceForGetResourceQueueOutput) GoString() string {
	return s.String()
}

// SetSize sets the Size field's value.
func (s *VolumeResourceForGetResourceQueueOutput) SetSize(v int32) *VolumeResourceForGetResourceQueueOutput {
	s.Size = &v
	return s
}

// SetVolumeTypeId sets the VolumeTypeId field's value.
func (s *VolumeResourceForGetResourceQueueOutput) SetVolumeTypeId(v string) *VolumeResourceForGetResourceQueueOutput {
	s.VolumeTypeId = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *VolumeResourceForGetResourceQueueOutput) SetZoneId(v string) *VolumeResourceForGetResourceQueueOutput {
	s.ZoneId = &v
	return s
}

type VolumeSizeInfoForGetResourceQueueOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	SizeGiB *int64 `type:"int64" json:",omitempty"`

	VolumeType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s VolumeSizeInfoForGetResourceQueueOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VolumeSizeInfoForGetResourceQueueOutput) GoString() string {
	return s.String()
}

// SetSizeGiB sets the SizeGiB field's value.
func (s *VolumeSizeInfoForGetResourceQueueOutput) SetSizeGiB(v int64) *VolumeSizeInfoForGetResourceQueueOutput {
	s.SizeGiB = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *VolumeSizeInfoForGetResourceQueueOutput) SetVolumeType(v string) *VolumeSizeInfoForGetResourceQueueOutput {
	s.VolumeType = &v
	return s
}

type WorkloadInfoForGetResourceQueueOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DefaultPriority *int32 `type:"int32" json:",omitempty"`

	WorkloadType *string `type:"string" json:",omitempty" enum:"EnumOfWorkloadTypeForGetResourceQueueOutput"`
}

// String returns the string representation
func (s WorkloadInfoForGetResourceQueueOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkloadInfoForGetResourceQueueOutput) GoString() string {
	return s.String()
}

// SetDefaultPriority sets the DefaultPriority field's value.
func (s *WorkloadInfoForGetResourceQueueOutput) SetDefaultPriority(v int32) *WorkloadInfoForGetResourceQueueOutput {
	s.DefaultPriority = &v
	return s
}

// SetWorkloadType sets the WorkloadType field's value.
func (s *WorkloadInfoForGetResourceQueueOutput) SetWorkloadType(v string) *WorkloadInfoForGetResourceQueueOutput {
	s.WorkloadType = &v
	return s
}

const (
	// EnumOfIdleShutdownRuleTypeListForGetResourceQueueOutputCpu is a EnumOfIdleShutdownRuleTypeListForGetResourceQueueOutput enum value
	EnumOfIdleShutdownRuleTypeListForGetResourceQueueOutputCpu = "Cpu"

	// EnumOfIdleShutdownRuleTypeListForGetResourceQueueOutputGpu is a EnumOfIdleShutdownRuleTypeListForGetResourceQueueOutput enum value
	EnumOfIdleShutdownRuleTypeListForGetResourceQueueOutputGpu = " Gpu"
)

const (
	// EnumOfWorkloadTypeForGetResourceQueueOutputJob is a EnumOfWorkloadTypeForGetResourceQueueOutput enum value
	EnumOfWorkloadTypeForGetResourceQueueOutputJob = "Job"

	// EnumOfWorkloadTypeForGetResourceQueueOutputDevInstance is a EnumOfWorkloadTypeForGetResourceQueueOutput enum value
	EnumOfWorkloadTypeForGetResourceQueueOutputDevInstance = "DevInstance"

	// EnumOfWorkloadTypeForGetResourceQueueOutputService is a EnumOfWorkloadTypeForGetResourceQueueOutput enum value
	EnumOfWorkloadTypeForGetResourceQueueOutputService = "Service"
)
