// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package mlplatform20240701

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opGetJobCommon = "GetJob"

// GetJobCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the GetJobCommon operation. The "output" return
// value will be populated with the GetJobCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GetJobCommon Request to send the API call to the service.
// the "output" return value is not valid until after GetJobCommon Send returns without error.
//
// See GetJobCommon for more information on using the GetJobCommon
// API call, and error handling.
//
//    // Example sending a request using the GetJobCommonRequest method.
//    req, resp := client.GetJobCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MLPLATFORM20240701) GetJobCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opGetJobCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// GetJobCommon API operation for ML_PLATFORM20240701.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ML_PLATFORM20240701's
// API operation GetJobCommon for usage and error information.
func (c *MLPLATFORM20240701) GetJobCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.GetJobCommonRequest(input)
	return out, req.Send()
}

// GetJobCommonWithContext is the same as GetJobCommon with the addition of
// the ability to pass a context and additional request options.
//
// See GetJobCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MLPLATFORM20240701) GetJobCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.GetJobCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetJob = "GetJob"

// GetJobRequest generates a "volcengine/request.Request" representing the
// client's request for the GetJob operation. The "output" return
// value will be populated with the GetJobCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GetJobCommon Request to send the API call to the service.
// the "output" return value is not valid until after GetJobCommon Send returns without error.
//
// See GetJob for more information on using the GetJob
// API call, and error handling.
//
//    // Example sending a request using the GetJobRequest method.
//    req, resp := client.GetJobRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MLPLATFORM20240701) GetJobRequest(input *GetJobInput) (req *request.Request, output *GetJobOutput) {
	op := &request.Operation{
		Name:       opGetJob,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetJobInput{}
	}

	output = &GetJobOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// GetJob API operation for ML_PLATFORM20240701.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ML_PLATFORM20240701's
// API operation GetJob for usage and error information.
func (c *MLPLATFORM20240701) GetJob(input *GetJobInput) (*GetJobOutput, error) {
	req, out := c.GetJobRequest(input)
	return out, req.Send()
}

// GetJobWithContext is the same as GetJob with the addition of
// the ability to pass a context and additional request options.
//
// See GetJob for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MLPLATFORM20240701) GetJobWithContext(ctx volcengine.Context, input *GetJobInput, opts ...request.Option) (*GetJobOutput, error) {
	req, out := c.GetJobRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CfsForGetJobOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	FileSystemName *string `type:"string" json:",omitempty"`

	NamespaceId *string `type:"string" json:",omitempty"`

	Options *OptionsForGetJobOutput `type:"structure" json:",omitempty"`

	Tos *TosForGetJobOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s CfsForGetJobOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CfsForGetJobOutput) GoString() string {
	return s.String()
}

// SetFileSystemName sets the FileSystemName field's value.
func (s *CfsForGetJobOutput) SetFileSystemName(v string) *CfsForGetJobOutput {
	s.FileSystemName = &v
	return s
}

// SetNamespaceId sets the NamespaceId field's value.
func (s *CfsForGetJobOutput) SetNamespaceId(v string) *CfsForGetJobOutput {
	s.NamespaceId = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *CfsForGetJobOutput) SetOptions(v *OptionsForGetJobOutput) *CfsForGetJobOutput {
	s.Options = v
	return s
}

// SetTos sets the Tos field's value.
func (s *CfsForGetJobOutput) SetTos(v *TosForGetJobOutput) *CfsForGetJobOutput {
	s.Tos = v
	return s
}

type CodeForGetJobOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	LocalPath *string `type:"string" json:",omitempty"`

	MountPath *string `type:"string" json:",omitempty"`

	SavedPath *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CodeForGetJobOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CodeForGetJobOutput) GoString() string {
	return s.String()
}

// SetLocalPath sets the LocalPath field's value.
func (s *CodeForGetJobOutput) SetLocalPath(v string) *CodeForGetJobOutput {
	s.LocalPath = &v
	return s
}

// SetMountPath sets the MountPath field's value.
func (s *CodeForGetJobOutput) SetMountPath(v string) *CodeForGetJobOutput {
	s.MountPath = &v
	return s
}

// SetSavedPath sets the SavedPath field's value.
func (s *CodeForGetJobOutput) SetSavedPath(v string) *CodeForGetJobOutput {
	s.SavedPath = &v
	return s
}

type ConfigForGetJobOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Cfs *CfsForGetJobOutput `type:"structure" json:",omitempty"`

	Nas *NasForGetJobOutput `type:"structure" json:",omitempty"`

	Sfcs *SfcsForGetJobOutput `type:"structure" json:",omitempty"`

	Tos *TosForGetJobOutput `type:"structure" json:",omitempty"`

	Vepfs *VepfsForGetJobOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s ConfigForGetJobOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigForGetJobOutput) GoString() string {
	return s.String()
}

// SetCfs sets the Cfs field's value.
func (s *ConfigForGetJobOutput) SetCfs(v *CfsForGetJobOutput) *ConfigForGetJobOutput {
	s.Cfs = v
	return s
}

// SetNas sets the Nas field's value.
func (s *ConfigForGetJobOutput) SetNas(v *NasForGetJobOutput) *ConfigForGetJobOutput {
	s.Nas = v
	return s
}

// SetSfcs sets the Sfcs field's value.
func (s *ConfigForGetJobOutput) SetSfcs(v *SfcsForGetJobOutput) *ConfigForGetJobOutput {
	s.Sfcs = v
	return s
}

// SetTos sets the Tos field's value.
func (s *ConfigForGetJobOutput) SetTos(v *TosForGetJobOutput) *ConfigForGetJobOutput {
	s.Tos = v
	return s
}

// SetVepfs sets the Vepfs field's value.
func (s *ConfigForGetJobOutput) SetVepfs(v *VepfsForGetJobOutput) *ConfigForGetJobOutput {
	s.Vepfs = v
	return s
}

type ConvertOptionsForGetJobOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	InternalSync *int64 `type:"int64" json:",omitempty"`

	Replicas *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s ConvertOptionsForGetJobOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertOptionsForGetJobOutput) GoString() string {
	return s.String()
}

// SetInternalSync sets the InternalSync field's value.
func (s *ConvertOptionsForGetJobOutput) SetInternalSync(v int64) *ConvertOptionsForGetJobOutput {
	s.InternalSync = &v
	return s
}

// SetReplicas sets the Replicas field's value.
func (s *ConvertOptionsForGetJobOutput) SetReplicas(v int64) *ConvertOptionsForGetJobOutput {
	s.Replicas = &v
	return s
}

type CredentialForGetJobOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	RegistryToken *string `type:"string" json:",omitempty"`

	RegistryUsername *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CredentialForGetJobOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CredentialForGetJobOutput) GoString() string {
	return s.String()
}

// SetRegistryToken sets the RegistryToken field's value.
func (s *CredentialForGetJobOutput) SetRegistryToken(v string) *CredentialForGetJobOutput {
	s.RegistryToken = &v
	return s
}

// SetRegistryUsername sets the RegistryUsername field's value.
func (s *CredentialForGetJobOutput) SetRegistryUsername(v string) *CredentialForGetJobOutput {
	s.RegistryUsername = &v
	return s
}

type CustomMetricServiceForGetJobOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Path *string `type:"string" json:",omitempty"`

	Port *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CustomMetricServiceForGetJobOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomMetricServiceForGetJobOutput) GoString() string {
	return s.String()
}

// SetPath sets the Path field's value.
func (s *CustomMetricServiceForGetJobOutput) SetPath(v string) *CustomMetricServiceForGetJobOutput {
	s.Path = &v
	return s
}

// SetPort sets the Port field's value.
func (s *CustomMetricServiceForGetJobOutput) SetPort(v string) *CustomMetricServiceForGetJobOutput {
	s.Port = &v
	return s
}

type DiagnoseConfigForGetJobOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DetectionIntervalSeconds *int64 `type:"int64" json:",omitempty"`

	FirstDetectionWaitSeconds *int64 `type:"int64" json:",omitempty"`

	Name *string `type:"string" json:",omitempty" enum:"EnumOfNameForGetJobOutput"`

	Triggers []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s DiagnoseConfigForGetJobOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DiagnoseConfigForGetJobOutput) GoString() string {
	return s.String()
}

// SetDetectionIntervalSeconds sets the DetectionIntervalSeconds field's value.
func (s *DiagnoseConfigForGetJobOutput) SetDetectionIntervalSeconds(v int64) *DiagnoseConfigForGetJobOutput {
	s.DetectionIntervalSeconds = &v
	return s
}

// SetFirstDetectionWaitSeconds sets the FirstDetectionWaitSeconds field's value.
func (s *DiagnoseConfigForGetJobOutput) SetFirstDetectionWaitSeconds(v int64) *DiagnoseConfigForGetJobOutput {
	s.FirstDetectionWaitSeconds = &v
	return s
}

// SetName sets the Name field's value.
func (s *DiagnoseConfigForGetJobOutput) SetName(v string) *DiagnoseConfigForGetJobOutput {
	s.Name = &v
	return s
}

// SetTriggers sets the Triggers field's value.
func (s *DiagnoseConfigForGetJobOutput) SetTriggers(v []*string) *DiagnoseConfigForGetJobOutput {
	s.Triggers = v
	return s
}

type EnvForGetJobOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	IsPrivate *bool `type:"boolean" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s EnvForGetJobOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s EnvForGetJobOutput) GoString() string {
	return s.String()
}

// SetIsPrivate sets the IsPrivate field's value.
func (s *EnvForGetJobOutput) SetIsPrivate(v bool) *EnvForGetJobOutput {
	s.IsPrivate = &v
	return s
}

// SetName sets the Name field's value.
func (s *EnvForGetJobOutput) SetName(v string) *EnvForGetJobOutput {
	s.Name = &v
	return s
}

// SetValue sets the Value field's value.
func (s *EnvForGetJobOutput) SetValue(v string) *EnvForGetJobOutput {
	s.Value = &v
	return s
}

type FlexibleResourceClaimForGetJobOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Cpu *float64 `type:"double" json:",omitempty"`

	Family *string `type:"string" json:",omitempty"`

	GpuCount *float64 `type:"double" json:",omitempty"`

	GpuType *string `type:"string" json:",omitempty"`

	MemoryGiB *float64 `type:"double" json:",omitempty"`

	RdmaEniCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s FlexibleResourceClaimForGetJobOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FlexibleResourceClaimForGetJobOutput) GoString() string {
	return s.String()
}

// SetCpu sets the Cpu field's value.
func (s *FlexibleResourceClaimForGetJobOutput) SetCpu(v float64) *FlexibleResourceClaimForGetJobOutput {
	s.Cpu = &v
	return s
}

// SetFamily sets the Family field's value.
func (s *FlexibleResourceClaimForGetJobOutput) SetFamily(v string) *FlexibleResourceClaimForGetJobOutput {
	s.Family = &v
	return s
}

// SetGpuCount sets the GpuCount field's value.
func (s *FlexibleResourceClaimForGetJobOutput) SetGpuCount(v float64) *FlexibleResourceClaimForGetJobOutput {
	s.GpuCount = &v
	return s
}

// SetGpuType sets the GpuType field's value.
func (s *FlexibleResourceClaimForGetJobOutput) SetGpuType(v string) *FlexibleResourceClaimForGetJobOutput {
	s.GpuType = &v
	return s
}

// SetMemoryGiB sets the MemoryGiB field's value.
func (s *FlexibleResourceClaimForGetJobOutput) SetMemoryGiB(v float64) *FlexibleResourceClaimForGetJobOutput {
	s.MemoryGiB = &v
	return s
}

// SetRdmaEniCount sets the RdmaEniCount field's value.
func (s *FlexibleResourceClaimForGetJobOutput) SetRdmaEniCount(v int32) *FlexibleResourceClaimForGetJobOutput {
	s.RdmaEniCount = &v
	return s
}

type GetJobInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// Id is a required field
	Id *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s GetJobInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetJobInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetJobInput"}
	if s.Id == nil {
		invalidParams.Add(request.NewErrParamRequired("Id"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetId sets the Id field's value.
func (s *GetJobInput) SetId(v string) *GetJobInput {
	s.Id = &v
	return s
}

type GetJobOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	CreateTime *string `type:"string" json:",omitempty"`

	CreatedBy *string `type:"string" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	DiagnoseConfig []*DiagnoseConfigForGetJobOutput `type:"list" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	InitialId *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	ObservableConfig *ObservableConfigForGetJobOutput `type:"structure" json:",omitempty"`

	PrivateNetworkConfig *PrivateNetworkConfigForGetJobOutput `type:"structure" json:",omitempty"`

	ResourceConfig *ResourceConfigForGetJobOutput `type:"structure" json:",omitempty"`

	RetryConfig *RetryConfigForGetJobOutput `type:"structure" json:",omitempty"`

	RuntimeConfig *RuntimeConfigForGetJobOutput `type:"structure" json:",omitempty"`

	Status *StatusForGetJobOutput `type:"structure" json:",omitempty"`

	StopReason *string `type:"string" json:",omitempty"`

	StorageConfig *StorageConfigForGetJobOutput `type:"structure" json:",omitempty"`

	UpdateTime *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s GetJobOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GetJobOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *GetJobOutput) SetCreateTime(v string) *GetJobOutput {
	s.CreateTime = &v
	return s
}

// SetCreatedBy sets the CreatedBy field's value.
func (s *GetJobOutput) SetCreatedBy(v string) *GetJobOutput {
	s.CreatedBy = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetJobOutput) SetDescription(v string) *GetJobOutput {
	s.Description = &v
	return s
}

// SetDiagnoseConfig sets the DiagnoseConfig field's value.
func (s *GetJobOutput) SetDiagnoseConfig(v []*DiagnoseConfigForGetJobOutput) *GetJobOutput {
	s.DiagnoseConfig = v
	return s
}

// SetId sets the Id field's value.
func (s *GetJobOutput) SetId(v string) *GetJobOutput {
	s.Id = &v
	return s
}

// SetInitialId sets the InitialId field's value.
func (s *GetJobOutput) SetInitialId(v string) *GetJobOutput {
	s.InitialId = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetJobOutput) SetName(v string) *GetJobOutput {
	s.Name = &v
	return s
}

// SetObservableConfig sets the ObservableConfig field's value.
func (s *GetJobOutput) SetObservableConfig(v *ObservableConfigForGetJobOutput) *GetJobOutput {
	s.ObservableConfig = v
	return s
}

// SetPrivateNetworkConfig sets the PrivateNetworkConfig field's value.
func (s *GetJobOutput) SetPrivateNetworkConfig(v *PrivateNetworkConfigForGetJobOutput) *GetJobOutput {
	s.PrivateNetworkConfig = v
	return s
}

// SetResourceConfig sets the ResourceConfig field's value.
func (s *GetJobOutput) SetResourceConfig(v *ResourceConfigForGetJobOutput) *GetJobOutput {
	s.ResourceConfig = v
	return s
}

// SetRetryConfig sets the RetryConfig field's value.
func (s *GetJobOutput) SetRetryConfig(v *RetryConfigForGetJobOutput) *GetJobOutput {
	s.RetryConfig = v
	return s
}

// SetRuntimeConfig sets the RuntimeConfig field's value.
func (s *GetJobOutput) SetRuntimeConfig(v *RuntimeConfigForGetJobOutput) *GetJobOutput {
	s.RuntimeConfig = v
	return s
}

// SetStatus sets the Status field's value.
func (s *GetJobOutput) SetStatus(v *StatusForGetJobOutput) *GetJobOutput {
	s.Status = v
	return s
}

// SetStopReason sets the StopReason field's value.
func (s *GetJobOutput) SetStopReason(v string) *GetJobOutput {
	s.StopReason = &v
	return s
}

// SetStorageConfig sets the StorageConfig field's value.
func (s *GetJobOutput) SetStorageConfig(v *StorageConfigForGetJobOutput) *GetJobOutput {
	s.StorageConfig = v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *GetJobOutput) SetUpdateTime(v string) *GetJobOutput {
	s.UpdateTime = &v
	return s
}

type ImageForGetJobOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Credential *CredentialForGetJobOutput `type:"structure" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`

	Url *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ImageForGetJobOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ImageForGetJobOutput) GoString() string {
	return s.String()
}

// SetCredential sets the Credential field's value.
func (s *ImageForGetJobOutput) SetCredential(v *CredentialForGetJobOutput) *ImageForGetJobOutput {
	s.Credential = v
	return s
}

// SetType sets the Type field's value.
func (s *ImageForGetJobOutput) SetType(v string) *ImageForGetJobOutput {
	s.Type = &v
	return s
}

// SetUrl sets the Url field's value.
func (s *ImageForGetJobOutput) SetUrl(v string) *ImageForGetJobOutput {
	s.Url = &v
	return s
}

type NasForGetJobOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Addr *string `type:"string" json:",omitempty"`

	FileSystemName *string `type:"string" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	NasType *string `type:"string" json:",omitempty"`

	SubPath *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s NasForGetJobOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NasForGetJobOutput) GoString() string {
	return s.String()
}

// SetAddr sets the Addr field's value.
func (s *NasForGetJobOutput) SetAddr(v string) *NasForGetJobOutput {
	s.Addr = &v
	return s
}

// SetFileSystemName sets the FileSystemName field's value.
func (s *NasForGetJobOutput) SetFileSystemName(v string) *NasForGetJobOutput {
	s.FileSystemName = &v
	return s
}

// SetId sets the Id field's value.
func (s *NasForGetJobOutput) SetId(v string) *NasForGetJobOutput {
	s.Id = &v
	return s
}

// SetNasType sets the NasType field's value.
func (s *NasForGetJobOutput) SetNasType(v string) *NasForGetJobOutput {
	s.NasType = &v
	return s
}

// SetSubPath sets the SubPath field's value.
func (s *NasForGetJobOutput) SetSubPath(v string) *NasForGetJobOutput {
	s.SubPath = &v
	return s
}

type NodeAffinitySpecForGetJobOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	GPUCPUNodePreference *string `type:"string" json:",omitempty" enum:"EnumOfGPUCPUNodePreferenceForGetJobOutput"`

	StrategyType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s NodeAffinitySpecForGetJobOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NodeAffinitySpecForGetJobOutput) GoString() string {
	return s.String()
}

// SetGPUCPUNodePreference sets the GPUCPUNodePreference field's value.
func (s *NodeAffinitySpecForGetJobOutput) SetGPUCPUNodePreference(v string) *NodeAffinitySpecForGetJobOutput {
	s.GPUCPUNodePreference = &v
	return s
}

// SetStrategyType sets the StrategyType field's value.
func (s *NodeAffinitySpecForGetJobOutput) SetStrategyType(v string) *NodeAffinitySpecForGetJobOutput {
	s.StrategyType = &v
	return s
}

type ObservableConfigForGetJobOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CustomMetricService *CustomMetricServiceForGetJobOutput `type:"structure" json:",omitempty"`

	DashboardPrivateUrl *string `type:"string" json:",omitempty"`

	DashboardPublicUrl *string `type:"string" json:",omitempty"`

	TensorboardStorage *TensorboardStorageForGetJobOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s ObservableConfigForGetJobOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ObservableConfigForGetJobOutput) GoString() string {
	return s.String()
}

// SetCustomMetricService sets the CustomMetricService field's value.
func (s *ObservableConfigForGetJobOutput) SetCustomMetricService(v *CustomMetricServiceForGetJobOutput) *ObservableConfigForGetJobOutput {
	s.CustomMetricService = v
	return s
}

// SetDashboardPrivateUrl sets the DashboardPrivateUrl field's value.
func (s *ObservableConfigForGetJobOutput) SetDashboardPrivateUrl(v string) *ObservableConfigForGetJobOutput {
	s.DashboardPrivateUrl = &v
	return s
}

// SetDashboardPublicUrl sets the DashboardPublicUrl field's value.
func (s *ObservableConfigForGetJobOutput) SetDashboardPublicUrl(v string) *ObservableConfigForGetJobOutput {
	s.DashboardPublicUrl = &v
	return s
}

// SetTensorboardStorage sets the TensorboardStorage field's value.
func (s *ObservableConfigForGetJobOutput) SetTensorboardStorage(v *TensorboardStorageForGetJobOutput) *ObservableConfigForGetJobOutput {
	s.TensorboardStorage = v
	return s
}

type OptionsForGetJobOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	InternalSync *int64 `type:"int64" json:",omitempty"`

	MetaCacheCapacity *int64 `type:"int64" json:",omitempty"`

	MetaCacheExpiryMinutes *int64 `type:"int64" json:",omitempty"`

	MetaCacheExpiryMsec *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s OptionsForGetJobOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OptionsForGetJobOutput) GoString() string {
	return s.String()
}

// SetInternalSync sets the InternalSync field's value.
func (s *OptionsForGetJobOutput) SetInternalSync(v int64) *OptionsForGetJobOutput {
	s.InternalSync = &v
	return s
}

// SetMetaCacheCapacity sets the MetaCacheCapacity field's value.
func (s *OptionsForGetJobOutput) SetMetaCacheCapacity(v int64) *OptionsForGetJobOutput {
	s.MetaCacheCapacity = &v
	return s
}

// SetMetaCacheExpiryMinutes sets the MetaCacheExpiryMinutes field's value.
func (s *OptionsForGetJobOutput) SetMetaCacheExpiryMinutes(v int64) *OptionsForGetJobOutput {
	s.MetaCacheExpiryMinutes = &v
	return s
}

// SetMetaCacheExpiryMsec sets the MetaCacheExpiryMsec field's value.
func (s *OptionsForGetJobOutput) SetMetaCacheExpiryMsec(v int64) *OptionsForGetJobOutput {
	s.MetaCacheExpiryMsec = &v
	return s
}

type PrivateNetworkConfigForGetJobOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	SecurityGroupIds []*string `type:"list" json:",omitempty"`

	SubnetIds []*string `type:"list" json:",omitempty"`

	VpcId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s PrivateNetworkConfigForGetJobOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PrivateNetworkConfigForGetJobOutput) GoString() string {
	return s.String()
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *PrivateNetworkConfigForGetJobOutput) SetSecurityGroupIds(v []*string) *PrivateNetworkConfigForGetJobOutput {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *PrivateNetworkConfigForGetJobOutput) SetSubnetIds(v []*string) *PrivateNetworkConfigForGetJobOutput {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *PrivateNetworkConfigForGetJobOutput) SetVpcId(v string) *PrivateNetworkConfigForGetJobOutput {
	s.VpcId = &v
	return s
}

type ResourceConfigForGetJobOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	HoldingTimeSeconds *int64 `type:"int64" json:",omitempty"`

	MaxRuntimeSeconds *int64 `type:"int64" json:",omitempty"`

	NumaAffinity *string `type:"string" json:",omitempty"`

	OnlyUseSuspectedNode *bool `type:"boolean" json:",omitempty"`

	Preemptible *bool `type:"boolean" json:",omitempty"`

	Priority *int32 `type:"int32" json:",omitempty"`

	ResourceQueueId *string `type:"string" json:",omitempty"`

	ResourceReservation *bool `type:"boolean" json:",omitempty"`

	ResourceReservationPlanId *string `type:"string" json:",omitempty"`

	Roles []*RoleForGetJobOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ResourceConfigForGetJobOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceConfigForGetJobOutput) GoString() string {
	return s.String()
}

// SetHoldingTimeSeconds sets the HoldingTimeSeconds field's value.
func (s *ResourceConfigForGetJobOutput) SetHoldingTimeSeconds(v int64) *ResourceConfigForGetJobOutput {
	s.HoldingTimeSeconds = &v
	return s
}

// SetMaxRuntimeSeconds sets the MaxRuntimeSeconds field's value.
func (s *ResourceConfigForGetJobOutput) SetMaxRuntimeSeconds(v int64) *ResourceConfigForGetJobOutput {
	s.MaxRuntimeSeconds = &v
	return s
}

// SetNumaAffinity sets the NumaAffinity field's value.
func (s *ResourceConfigForGetJobOutput) SetNumaAffinity(v string) *ResourceConfigForGetJobOutput {
	s.NumaAffinity = &v
	return s
}

// SetOnlyUseSuspectedNode sets the OnlyUseSuspectedNode field's value.
func (s *ResourceConfigForGetJobOutput) SetOnlyUseSuspectedNode(v bool) *ResourceConfigForGetJobOutput {
	s.OnlyUseSuspectedNode = &v
	return s
}

// SetPreemptible sets the Preemptible field's value.
func (s *ResourceConfigForGetJobOutput) SetPreemptible(v bool) *ResourceConfigForGetJobOutput {
	s.Preemptible = &v
	return s
}

// SetPriority sets the Priority field's value.
func (s *ResourceConfigForGetJobOutput) SetPriority(v int32) *ResourceConfigForGetJobOutput {
	s.Priority = &v
	return s
}

// SetResourceQueueId sets the ResourceQueueId field's value.
func (s *ResourceConfigForGetJobOutput) SetResourceQueueId(v string) *ResourceConfigForGetJobOutput {
	s.ResourceQueueId = &v
	return s
}

// SetResourceReservation sets the ResourceReservation field's value.
func (s *ResourceConfigForGetJobOutput) SetResourceReservation(v bool) *ResourceConfigForGetJobOutput {
	s.ResourceReservation = &v
	return s
}

// SetResourceReservationPlanId sets the ResourceReservationPlanId field's value.
func (s *ResourceConfigForGetJobOutput) SetResourceReservationPlanId(v string) *ResourceConfigForGetJobOutput {
	s.ResourceReservationPlanId = &v
	return s
}

// SetRoles sets the Roles field's value.
func (s *ResourceConfigForGetJobOutput) SetRoles(v []*RoleForGetJobOutput) *ResourceConfigForGetJobOutput {
	s.Roles = v
	return s
}

type ResourceForGetJobOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	FlexibleResourceClaim *FlexibleResourceClaimForGetJobOutput `type:"structure" json:",omitempty"`

	InstanceTypeId *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`

	ZoneId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ResourceForGetJobOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceForGetJobOutput) GoString() string {
	return s.String()
}

// SetFlexibleResourceClaim sets the FlexibleResourceClaim field's value.
func (s *ResourceForGetJobOutput) SetFlexibleResourceClaim(v *FlexibleResourceClaimForGetJobOutput) *ResourceForGetJobOutput {
	s.FlexibleResourceClaim = v
	return s
}

// SetInstanceTypeId sets the InstanceTypeId field's value.
func (s *ResourceForGetJobOutput) SetInstanceTypeId(v string) *ResourceForGetJobOutput {
	s.InstanceTypeId = &v
	return s
}

// SetType sets the Type field's value.
func (s *ResourceForGetJobOutput) SetType(v string) *ResourceForGetJobOutput {
	s.Type = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *ResourceForGetJobOutput) SetZoneId(v string) *ResourceForGetJobOutput {
	s.ZoneId = &v
	return s
}

type RetryConfigForGetJobOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	IntervalSeconds *int64 `type:"int64" json:",omitempty"`

	MaxRetryTimes *int64 `type:"int64" json:",omitempty"`

	Triggers []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s RetryConfigForGetJobOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RetryConfigForGetJobOutput) GoString() string {
	return s.String()
}

// SetIntervalSeconds sets the IntervalSeconds field's value.
func (s *RetryConfigForGetJobOutput) SetIntervalSeconds(v int64) *RetryConfigForGetJobOutput {
	s.IntervalSeconds = &v
	return s
}

// SetMaxRetryTimes sets the MaxRetryTimes field's value.
func (s *RetryConfigForGetJobOutput) SetMaxRetryTimes(v int64) *RetryConfigForGetJobOutput {
	s.MaxRetryTimes = &v
	return s
}

// SetTriggers sets the Triggers field's value.
func (s *RetryConfigForGetJobOutput) SetTriggers(v []*string) *RetryConfigForGetJobOutput {
	s.Triggers = v
	return s
}

type RoleForGetJobOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	NodeAffinitySpec *NodeAffinitySpecForGetJobOutput `type:"structure" json:",omitempty"`

	Replicas *int64 `type:"int64" json:",omitempty"`

	Resource *ResourceForGetJobOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s RoleForGetJobOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RoleForGetJobOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *RoleForGetJobOutput) SetName(v string) *RoleForGetJobOutput {
	s.Name = &v
	return s
}

// SetNodeAffinitySpec sets the NodeAffinitySpec field's value.
func (s *RoleForGetJobOutput) SetNodeAffinitySpec(v *NodeAffinitySpecForGetJobOutput) *RoleForGetJobOutput {
	s.NodeAffinitySpec = v
	return s
}

// SetReplicas sets the Replicas field's value.
func (s *RoleForGetJobOutput) SetReplicas(v int64) *RoleForGetJobOutput {
	s.Replicas = &v
	return s
}

// SetResource sets the Resource field's value.
func (s *RoleForGetJobOutput) SetResource(v *ResourceForGetJobOutput) *RoleForGetJobOutput {
	s.Resource = v
	return s
}

type RuntimeConfigForGetJobOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AdvanceArgs *string `type:"string" json:",omitempty"`

	Code *CodeForGetJobOutput `type:"structure" json:",omitempty"`

	Command *string `type:"string" json:",omitempty"`

	Envs []*EnvForGetJobOutput `type:"list" json:",omitempty"`

	Framework *string `type:"string" json:",omitempty" enum:"EnumOfFrameworkForGetJobOutput"`

	Image *ImageForGetJobOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s RuntimeConfigForGetJobOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RuntimeConfigForGetJobOutput) GoString() string {
	return s.String()
}

// SetAdvanceArgs sets the AdvanceArgs field's value.
func (s *RuntimeConfigForGetJobOutput) SetAdvanceArgs(v string) *RuntimeConfigForGetJobOutput {
	s.AdvanceArgs = &v
	return s
}

// SetCode sets the Code field's value.
func (s *RuntimeConfigForGetJobOutput) SetCode(v *CodeForGetJobOutput) *RuntimeConfigForGetJobOutput {
	s.Code = v
	return s
}

// SetCommand sets the Command field's value.
func (s *RuntimeConfigForGetJobOutput) SetCommand(v string) *RuntimeConfigForGetJobOutput {
	s.Command = &v
	return s
}

// SetEnvs sets the Envs field's value.
func (s *RuntimeConfigForGetJobOutput) SetEnvs(v []*EnvForGetJobOutput) *RuntimeConfigForGetJobOutput {
	s.Envs = v
	return s
}

// SetFramework sets the Framework field's value.
func (s *RuntimeConfigForGetJobOutput) SetFramework(v string) *RuntimeConfigForGetJobOutput {
	s.Framework = &v
	return s
}

// SetImage sets the Image field's value.
func (s *RuntimeConfigForGetJobOutput) SetImage(v *ImageForGetJobOutput) *RuntimeConfigForGetJobOutput {
	s.Image = v
	return s
}

type SfcsForGetJobOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CachePolicyId *string `type:"string" json:",omitempty"`

	FileSystemName *string `type:"string" json:",omitempty"`

	Options *ConvertOptionsForGetJobOutput `type:"structure" json:",omitempty"`

	Tos *TosForGetJobOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s SfcsForGetJobOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SfcsForGetJobOutput) GoString() string {
	return s.String()
}

// SetCachePolicyId sets the CachePolicyId field's value.
func (s *SfcsForGetJobOutput) SetCachePolicyId(v string) *SfcsForGetJobOutput {
	s.CachePolicyId = &v
	return s
}

// SetFileSystemName sets the FileSystemName field's value.
func (s *SfcsForGetJobOutput) SetFileSystemName(v string) *SfcsForGetJobOutput {
	s.FileSystemName = &v
	return s
}

// SetOptions sets the Options field's value.
func (s *SfcsForGetJobOutput) SetOptions(v *ConvertOptionsForGetJobOutput) *SfcsForGetJobOutput {
	s.Options = v
	return s
}

// SetTos sets the Tos field's value.
func (s *SfcsForGetJobOutput) SetTos(v *TosForGetJobOutput) *SfcsForGetJobOutput {
	s.Tos = v
	return s
}

type StatusForGetJobOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ConsumeRetriedTimes *bool `type:"boolean" json:",omitempty"`

	DiagnoseMessage *string `type:"string" json:",omitempty"`

	DiagnoseState *string `type:"string" json:",omitempty" enum:"EnumOfDiagnoseStateForGetJobOutput"`

	EndTime *string `type:"string" json:",omitempty"`

	HoldingEndTime *string `type:"string" json:",omitempty"`

	Message *string `type:"string" json:",omitempty"`

	RetriedTimes *int64 `type:"int64" json:",omitempty"`

	RetryTrigger *string `type:"string" json:",omitempty" enum:"EnumOfRetryTriggerForGetJobOutput"`

	SecondaryState *string `type:"string" json:",omitempty" enum:"EnumOfSecondaryStateForGetJobOutput"`

	StartTime *string `type:"string" json:",omitempty"`

	State *string `type:"string" json:",omitempty" enum:"EnumOfStateForGetJobOutput"`
}

// String returns the string representation
func (s StatusForGetJobOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StatusForGetJobOutput) GoString() string {
	return s.String()
}

// SetConsumeRetriedTimes sets the ConsumeRetriedTimes field's value.
func (s *StatusForGetJobOutput) SetConsumeRetriedTimes(v bool) *StatusForGetJobOutput {
	s.ConsumeRetriedTimes = &v
	return s
}

// SetDiagnoseMessage sets the DiagnoseMessage field's value.
func (s *StatusForGetJobOutput) SetDiagnoseMessage(v string) *StatusForGetJobOutput {
	s.DiagnoseMessage = &v
	return s
}

// SetDiagnoseState sets the DiagnoseState field's value.
func (s *StatusForGetJobOutput) SetDiagnoseState(v string) *StatusForGetJobOutput {
	s.DiagnoseState = &v
	return s
}

// SetEndTime sets the EndTime field's value.
func (s *StatusForGetJobOutput) SetEndTime(v string) *StatusForGetJobOutput {
	s.EndTime = &v
	return s
}

// SetHoldingEndTime sets the HoldingEndTime field's value.
func (s *StatusForGetJobOutput) SetHoldingEndTime(v string) *StatusForGetJobOutput {
	s.HoldingEndTime = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *StatusForGetJobOutput) SetMessage(v string) *StatusForGetJobOutput {
	s.Message = &v
	return s
}

// SetRetriedTimes sets the RetriedTimes field's value.
func (s *StatusForGetJobOutput) SetRetriedTimes(v int64) *StatusForGetJobOutput {
	s.RetriedTimes = &v
	return s
}

// SetRetryTrigger sets the RetryTrigger field's value.
func (s *StatusForGetJobOutput) SetRetryTrigger(v string) *StatusForGetJobOutput {
	s.RetryTrigger = &v
	return s
}

// SetSecondaryState sets the SecondaryState field's value.
func (s *StatusForGetJobOutput) SetSecondaryState(v string) *StatusForGetJobOutput {
	s.SecondaryState = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *StatusForGetJobOutput) SetStartTime(v string) *StatusForGetJobOutput {
	s.StartTime = &v
	return s
}

// SetState sets the State field's value.
func (s *StatusForGetJobOutput) SetState(v string) *StatusForGetJobOutput {
	s.State = &v
	return s
}

type StorageConfigForGetJobOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	SidecarMemoryRatio *float64 `type:"double" json:",omitempty"`

	Storages []*StorageForGetJobOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s StorageConfigForGetJobOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageConfigForGetJobOutput) GoString() string {
	return s.String()
}

// SetSidecarMemoryRatio sets the SidecarMemoryRatio field's value.
func (s *StorageConfigForGetJobOutput) SetSidecarMemoryRatio(v float64) *StorageConfigForGetJobOutput {
	s.SidecarMemoryRatio = &v
	return s
}

// SetStorages sets the Storages field's value.
func (s *StorageConfigForGetJobOutput) SetStorages(v []*StorageForGetJobOutput) *StorageConfigForGetJobOutput {
	s.Storages = v
	return s
}

type StorageForGetJobOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Config *ConfigForGetJobOutput `type:"structure" json:",omitempty"`

	MountPath *string `type:"string" json:",omitempty"`

	ReadOnly *bool `type:"boolean" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s StorageForGetJobOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageForGetJobOutput) GoString() string {
	return s.String()
}

// SetConfig sets the Config field's value.
func (s *StorageForGetJobOutput) SetConfig(v *ConfigForGetJobOutput) *StorageForGetJobOutput {
	s.Config = v
	return s
}

// SetMountPath sets the MountPath field's value.
func (s *StorageForGetJobOutput) SetMountPath(v string) *StorageForGetJobOutput {
	s.MountPath = &v
	return s
}

// SetReadOnly sets the ReadOnly field's value.
func (s *StorageForGetJobOutput) SetReadOnly(v bool) *StorageForGetJobOutput {
	s.ReadOnly = &v
	return s
}

// SetType sets the Type field's value.
func (s *StorageForGetJobOutput) SetType(v string) *StorageForGetJobOutput {
	s.Type = &v
	return s
}

type TensorboardStorageForGetJobOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Config *ConfigForGetJobOutput `type:"structure" json:",omitempty"`

	MountPath *string `type:"string" json:",omitempty"`

	ReadOnly *bool `type:"boolean" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TensorboardStorageForGetJobOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TensorboardStorageForGetJobOutput) GoString() string {
	return s.String()
}

// SetConfig sets the Config field's value.
func (s *TensorboardStorageForGetJobOutput) SetConfig(v *ConfigForGetJobOutput) *TensorboardStorageForGetJobOutput {
	s.Config = v
	return s
}

// SetMountPath sets the MountPath field's value.
func (s *TensorboardStorageForGetJobOutput) SetMountPath(v string) *TensorboardStorageForGetJobOutput {
	s.MountPath = &v
	return s
}

// SetReadOnly sets the ReadOnly field's value.
func (s *TensorboardStorageForGetJobOutput) SetReadOnly(v bool) *TensorboardStorageForGetJobOutput {
	s.ReadOnly = &v
	return s
}

// SetType sets the Type field's value.
func (s *TensorboardStorageForGetJobOutput) SetType(v string) *TensorboardStorageForGetJobOutput {
	s.Type = &v
	return s
}

type TosForGetJobOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Bucket *string `type:"string" json:",omitempty"`

	Prefix *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TosForGetJobOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TosForGetJobOutput) GoString() string {
	return s.String()
}

// SetBucket sets the Bucket field's value.
func (s *TosForGetJobOutput) SetBucket(v string) *TosForGetJobOutput {
	s.Bucket = &v
	return s
}

// SetPrefix sets the Prefix field's value.
func (s *TosForGetJobOutput) SetPrefix(v string) *TosForGetJobOutput {
	s.Prefix = &v
	return s
}

type VepfsForGetJobOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	FileSystemName *string `type:"string" json:",omitempty"`

	HostPath *string `type:"string" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	SubPath *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s VepfsForGetJobOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VepfsForGetJobOutput) GoString() string {
	return s.String()
}

// SetFileSystemName sets the FileSystemName field's value.
func (s *VepfsForGetJobOutput) SetFileSystemName(v string) *VepfsForGetJobOutput {
	s.FileSystemName = &v
	return s
}

// SetHostPath sets the HostPath field's value.
func (s *VepfsForGetJobOutput) SetHostPath(v string) *VepfsForGetJobOutput {
	s.HostPath = &v
	return s
}

// SetId sets the Id field's value.
func (s *VepfsForGetJobOutput) SetId(v string) *VepfsForGetJobOutput {
	s.Id = &v
	return s
}

// SetSubPath sets the SubPath field's value.
func (s *VepfsForGetJobOutput) SetSubPath(v string) *VepfsForGetJobOutput {
	s.SubPath = &v
	return s
}

const (
	// EnumOfDiagnoseStateForGetJobOutputWaiting is a EnumOfDiagnoseStateForGetJobOutput enum value
	EnumOfDiagnoseStateForGetJobOutputWaiting = "Waiting"

	// EnumOfDiagnoseStateForGetJobOutputRunning is a EnumOfDiagnoseStateForGetJobOutput enum value
	EnumOfDiagnoseStateForGetJobOutputRunning = "Running"

	// EnumOfDiagnoseStateForGetJobOutputPassed is a EnumOfDiagnoseStateForGetJobOutput enum value
	EnumOfDiagnoseStateForGetJobOutputPassed = "Passed"

	// EnumOfDiagnoseStateForGetJobOutputFailed is a EnumOfDiagnoseStateForGetJobOutput enum value
	EnumOfDiagnoseStateForGetJobOutputFailed = "Failed"

	// EnumOfDiagnoseStateForGetJobOutputAbnormal is a EnumOfDiagnoseStateForGetJobOutput enum value
	EnumOfDiagnoseStateForGetJobOutputAbnormal = "Abnormal"
)

const (
	// EnumOfFrameworkForGetJobOutputPyTorch is a EnumOfFrameworkForGetJobOutput enum value
	EnumOfFrameworkForGetJobOutputPyTorch = "PyTorch"

	// EnumOfFrameworkForGetJobOutputMpi is a EnumOfFrameworkForGetJobOutput enum value
	EnumOfFrameworkForGetJobOutputMpi = "MPI"

	// EnumOfFrameworkForGetJobOutputRay is a EnumOfFrameworkForGetJobOutput enum value
	EnumOfFrameworkForGetJobOutputRay = "Ray"

	// EnumOfFrameworkForGetJobOutputTensorFlow is a EnumOfFrameworkForGetJobOutput enum value
	EnumOfFrameworkForGetJobOutputTensorFlow = "TensorFlow"

	// EnumOfFrameworkForGetJobOutputCustom is a EnumOfFrameworkForGetJobOutput enum value
	EnumOfFrameworkForGetJobOutputCustom = "Custom"
)

const (
	// EnumOfGPUCPUNodePreferenceForGetJobOutputGpurequired is a EnumOfGPUCPUNodePreferenceForGetJobOutput enum value
	EnumOfGPUCPUNodePreferenceForGetJobOutputGpurequired = "GPURequired"

	// EnumOfGPUCPUNodePreferenceForGetJobOutputGpupreferred is a EnumOfGPUCPUNodePreferenceForGetJobOutput enum value
	EnumOfGPUCPUNodePreferenceForGetJobOutputGpupreferred = "GPUPreferred"

	// EnumOfGPUCPUNodePreferenceForGetJobOutputCpurequired is a EnumOfGPUCPUNodePreferenceForGetJobOutput enum value
	EnumOfGPUCPUNodePreferenceForGetJobOutputCpurequired = "CPURequired"

	// EnumOfGPUCPUNodePreferenceForGetJobOutputCpupreferred is a EnumOfGPUCPUNodePreferenceForGetJobOutput enum value
	EnumOfGPUCPUNodePreferenceForGetJobOutputCpupreferred = "CPUPreferred"
)

const (
	// EnumOfNameForGetJobOutputEnvironmentalDiagnosis is a EnumOfNameForGetJobOutput enum value
	EnumOfNameForGetJobOutputEnvironmentalDiagnosis = "EnvironmentalDiagnosis"

	// EnumOfNameForGetJobOutputPythonDetection is a EnumOfNameForGetJobOutput enum value
	EnumOfNameForGetJobOutputPythonDetection = "PythonDetection"

	// EnumOfNameForGetJobOutputLogDetection is a EnumOfNameForGetJobOutput enum value
	EnumOfNameForGetJobOutputLogDetection = "LogDetection"
)

const (
	// EnumOfRetryTriggerForGetJobOutputJobFailed is a EnumOfRetryTriggerForGetJobOutput enum value
	EnumOfRetryTriggerForGetJobOutputJobFailed = "JobFailed"

	// EnumOfRetryTriggerForGetJobOutputMachineFailure is a EnumOfRetryTriggerForGetJobOutput enum value
	EnumOfRetryTriggerForGetJobOutputMachineFailure = "MachineFailure"

	// EnumOfRetryTriggerForGetJobOutputInstanceReclaimed is a EnumOfRetryTriggerForGetJobOutput enum value
	EnumOfRetryTriggerForGetJobOutputInstanceReclaimed = "InstanceReclaimed"

	// EnumOfRetryTriggerForGetJobOutputAutoGpucompacted is a EnumOfRetryTriggerForGetJobOutput enum value
	EnumOfRetryTriggerForGetJobOutputAutoGpucompacted = "AutoGPUCompacted"

	// EnumOfRetryTriggerForGetJobOutputEnvironmentalDiagnosisFailed is a EnumOfRetryTriggerForGetJobOutput enum value
	EnumOfRetryTriggerForGetJobOutputEnvironmentalDiagnosisFailed = "EnvironmentalDiagnosisFailed"

	// EnumOfRetryTriggerForGetJobOutputPythonDetectionFailed is a EnumOfRetryTriggerForGetJobOutput enum value
	EnumOfRetryTriggerForGetJobOutputPythonDetectionFailed = "PythonDetectionFailed"

	// EnumOfRetryTriggerForGetJobOutputLogDetectionFailed is a EnumOfRetryTriggerForGetJobOutput enum value
	EnumOfRetryTriggerForGetJobOutputLogDetectionFailed = "LogDetectionFailed"
)

const (
	// EnumOfSecondaryStateForGetJobOutputCompletedHolding is a EnumOfSecondaryStateForGetJobOutput enum value
	EnumOfSecondaryStateForGetJobOutputCompletedHolding = "CompletedHolding"

	// EnumOfSecondaryStateForGetJobOutputFailedHolding is a EnumOfSecondaryStateForGetJobOutput enum value
	EnumOfSecondaryStateForGetJobOutputFailedHolding = "FailedHolding"

	// EnumOfSecondaryStateForGetJobOutputNodeWentDown is a EnumOfSecondaryStateForGetJobOutput enum value
	EnumOfSecondaryStateForGetJobOutputNodeWentDown = "NodeWentDown"

	// EnumOfSecondaryStateForGetJobOutputMachineFault is a EnumOfSecondaryStateForGetJobOutput enum value
	EnumOfSecondaryStateForGetJobOutputMachineFault = "MachineFault"

	// EnumOfSecondaryStateForGetJobOutputMachineSuspected is a EnumOfSecondaryStateForGetJobOutput enum value
	EnumOfSecondaryStateForGetJobOutputMachineSuspected = "MachineSuspected"

	// EnumOfSecondaryStateForGetJobOutputMachineRegular is a EnumOfSecondaryStateForGetJobOutput enum value
	EnumOfSecondaryStateForGetJobOutputMachineRegular = "MachineRegular"

	// EnumOfSecondaryStateForGetJobOutputPodOomkilled is a EnumOfSecondaryStateForGetJobOutput enum value
	EnumOfSecondaryStateForGetJobOutputPodOomkilled = "PodOOMKilled"

	// EnumOfSecondaryStateForGetJobOutputPodReclaimed is a EnumOfSecondaryStateForGetJobOutput enum value
	EnumOfSecondaryStateForGetJobOutputPodReclaimed = "PodReclaimed"

	// EnumOfSecondaryStateForGetJobOutputPodAutoGpucompacted is a EnumOfSecondaryStateForGetJobOutput enum value
	EnumOfSecondaryStateForGetJobOutputPodAutoGpucompacted = "PodAutoGPUCompacted"

	// EnumOfSecondaryStateForGetJobOutputPodEvictByQos is a EnumOfSecondaryStateForGetJobOutput enum value
	EnumOfSecondaryStateForGetJobOutputPodEvictByQos = "PodEvictByQOS"

	// EnumOfSecondaryStateForGetJobOutputPodEvictByGpupreemptCpu is a EnumOfSecondaryStateForGetJobOutput enum value
	EnumOfSecondaryStateForGetJobOutputPodEvictByGpupreemptCpu = "PodEvictByGPUPreemptCPU"

	// EnumOfSecondaryStateForGetJobOutputDiagnosisEnvDiagFailed is a EnumOfSecondaryStateForGetJobOutput enum value
	EnumOfSecondaryStateForGetJobOutputDiagnosisEnvDiagFailed = "DiagnosisEnvDiagFailed"
)

const (
	// EnumOfStateForGetJobOutputCreating is a EnumOfStateForGetJobOutput enum value
	EnumOfStateForGetJobOutputCreating = "Creating"

	// EnumOfStateForGetJobOutputWaiting is a EnumOfStateForGetJobOutput enum value
	EnumOfStateForGetJobOutputWaiting = "Waiting"

	// EnumOfStateForGetJobOutputQueueing is a EnumOfStateForGetJobOutput enum value
	EnumOfStateForGetJobOutputQueueing = "Queueing"

	// EnumOfStateForGetJobOutputDeploying is a EnumOfStateForGetJobOutput enum value
	EnumOfStateForGetJobOutputDeploying = "Deploying"

	// EnumOfStateForGetJobOutputRunning is a EnumOfStateForGetJobOutput enum value
	EnumOfStateForGetJobOutputRunning = "Running"

	// EnumOfStateForGetJobOutputCompleted is a EnumOfStateForGetJobOutput enum value
	EnumOfStateForGetJobOutputCompleted = "Completed"

	// EnumOfStateForGetJobOutputFailed is a EnumOfStateForGetJobOutput enum value
	EnumOfStateForGetJobOutputFailed = "Failed"

	// EnumOfStateForGetJobOutputStopping is a EnumOfStateForGetJobOutput enum value
	EnumOfStateForGetJobOutputStopping = "Stopping"

	// EnumOfStateForGetJobOutputStopped is a EnumOfStateForGetJobOutput enum value
	EnumOfStateForGetJobOutputStopped = "Stopped"
)

const (
	// EnumOfTriggerListForGetJobOutputBeforeStart is a EnumOfTriggerListForGetJobOutput enum value
	EnumOfTriggerListForGetJobOutputBeforeStart = "BeforeStart"

	// EnumOfTriggerListForGetJobOutputJobRunning is a EnumOfTriggerListForGetJobOutput enum value
	EnumOfTriggerListForGetJobOutputJobRunning = "JobRunning"

	// EnumOfTriggerListForGetJobOutputJobFailed is a EnumOfTriggerListForGetJobOutput enum value
	EnumOfTriggerListForGetJobOutputJobFailed = "JobFailed"

	// EnumOfTriggerListForGetJobOutputStopByUser is a EnumOfTriggerListForGetJobOutput enum value
	EnumOfTriggerListForGetJobOutputStopByUser = "StopByUser"
)
