// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package mlplatform20240701

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateServiceCommon = "CreateService"

// CreateServiceCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateServiceCommon operation. The "output" return
// value will be populated with the CreateServiceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateServiceCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateServiceCommon Send returns without error.
//
// See CreateServiceCommon for more information on using the CreateServiceCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateServiceCommonRequest method.
//    req, resp := client.CreateServiceCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MLPLATFORM20240701) CreateServiceCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateServiceCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateServiceCommon API operation for ML_PLATFORM20240701.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ML_PLATFORM20240701's
// API operation CreateServiceCommon for usage and error information.
func (c *MLPLATFORM20240701) CreateServiceCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateServiceCommonRequest(input)
	return out, req.Send()
}

// CreateServiceCommonWithContext is the same as CreateServiceCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateServiceCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MLPLATFORM20240701) CreateServiceCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateServiceCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateService = "CreateService"

// CreateServiceRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateService operation. The "output" return
// value will be populated with the CreateServiceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateServiceCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateServiceCommon Send returns without error.
//
// See CreateService for more information on using the CreateService
// API call, and error handling.
//
//    // Example sending a request using the CreateServiceRequest method.
//    req, resp := client.CreateServiceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MLPLATFORM20240701) CreateServiceRequest(input *CreateServiceInput) (req *request.Request, output *CreateServiceOutput) {
	op := &request.Operation{
		Name:       opCreateService,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateServiceInput{}
	}

	output = &CreateServiceOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateService API operation for ML_PLATFORM20240701.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ML_PLATFORM20240701's
// API operation CreateService for usage and error information.
func (c *MLPLATFORM20240701) CreateService(input *CreateServiceInput) (*CreateServiceOutput, error) {
	req, out := c.CreateServiceRequest(input)
	return out, req.Send()
}

// CreateServiceWithContext is the same as CreateService with the addition of
// the ability to pass a context and additional request options.
//
// See CreateService for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MLPLATFORM20240701) CreateServiceWithContext(ctx volcengine.Context, input *CreateServiceInput, opts ...request.Option) (*CreateServiceOutput, error) {
	req, out := c.CreateServiceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ApigConfigForCreateServiceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	InstanceID *string `type:"string" json:",omitempty"`

	UpstreamConfig *UpstreamConfigForCreateServiceInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s ApigConfigForCreateServiceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ApigConfigForCreateServiceInput) GoString() string {
	return s.String()
}

// SetInstanceID sets the InstanceID field's value.
func (s *ApigConfigForCreateServiceInput) SetInstanceID(v string) *ApigConfigForCreateServiceInput {
	s.InstanceID = &v
	return s
}

// SetUpstreamConfig sets the UpstreamConfig field's value.
func (s *ApigConfigForCreateServiceInput) SetUpstreamConfig(v *UpstreamConfigForCreateServiceInput) *ApigConfigForCreateServiceInput {
	s.UpstreamConfig = v
	return s
}

type CLBConfigForCreateServiceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	InstanceId *string `type:"string" json:",omitempty"`

	Scheduler *string `type:"string" json:",omitempty" enum:"EnumOfSchedulerForCreateServiceInput"`
}

// String returns the string representation
func (s CLBConfigForCreateServiceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CLBConfigForCreateServiceInput) GoString() string {
	return s.String()
}

// SetInstanceId sets the InstanceId field's value.
func (s *CLBConfigForCreateServiceInput) SetInstanceId(v string) *CLBConfigForCreateServiceInput {
	s.InstanceId = &v
	return s
}

// SetScheduler sets the Scheduler field's value.
func (s *CLBConfigForCreateServiceInput) SetScheduler(v string) *CLBConfigForCreateServiceInput {
	s.Scheduler = &v
	return s
}

type ConsistentHashConfigForCreateServiceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	HashKeyType *string `type:"string" json:",omitempty" enum:"EnumOfHashKeyTypeForCreateServiceInput"`

	HttpHeaderName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ConsistentHashConfigForCreateServiceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConsistentHashConfigForCreateServiceInput) GoString() string {
	return s.String()
}

// SetHashKeyType sets the HashKeyType field's value.
func (s *ConsistentHashConfigForCreateServiceInput) SetHashKeyType(v string) *ConsistentHashConfigForCreateServiceInput {
	s.HashKeyType = &v
	return s
}

// SetHttpHeaderName sets the HttpHeaderName field's value.
func (s *ConsistentHashConfigForCreateServiceInput) SetHttpHeaderName(v string) *ConsistentHashConfigForCreateServiceInput {
	s.HttpHeaderName = &v
	return s
}

type ConvertWeightForCreateServiceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DeploymentId *string `type:"string" json:",omitempty"`

	Weight *int32 `max:"10" type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ConvertWeightForCreateServiceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertWeightForCreateServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ConvertWeightForCreateServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ConvertWeightForCreateServiceInput"}
	if s.Weight != nil && *s.Weight > 10 {
		invalidParams.Add(request.NewErrParamMaxValue("Weight", 10))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeploymentId sets the DeploymentId field's value.
func (s *ConvertWeightForCreateServiceInput) SetDeploymentId(v string) *ConvertWeightForCreateServiceInput {
	s.DeploymentId = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *ConvertWeightForCreateServiceInput) SetWeight(v int32) *ConvertWeightForCreateServiceInput {
	s.Weight = &v
	return s
}

type CreateServiceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ApigConfig *ApigConfigForCreateServiceInput `type:"structure" json:",omitempty"`

	CLBConfig *CLBConfigForCreateServiceInput `type:"structure" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	DryRun *bool `type:"boolean" json:",omitempty"`

	Ports []*PortForCreateServiceInput `type:"list" json:",omitempty"`

	// ResourceGroupId is a required field
	ResourceGroupId *string `type:"string" json:",omitempty" required:"true"`

	// ServiceName is a required field
	ServiceName *string `type:"string" json:",omitempty" required:"true"`

	TrafficConfig *TrafficConfigForCreateServiceInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s CreateServiceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateServiceInput"}
	if s.ResourceGroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceGroupId"))
	}
	if s.ServiceName == nil {
		invalidParams.Add(request.NewErrParamRequired("ServiceName"))
	}
	if s.TrafficConfig != nil {
		if err := s.TrafficConfig.Validate(); err != nil {
			invalidParams.AddNested("TrafficConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApigConfig sets the ApigConfig field's value.
func (s *CreateServiceInput) SetApigConfig(v *ApigConfigForCreateServiceInput) *CreateServiceInput {
	s.ApigConfig = v
	return s
}

// SetCLBConfig sets the CLBConfig field's value.
func (s *CreateServiceInput) SetCLBConfig(v *CLBConfigForCreateServiceInput) *CreateServiceInput {
	s.CLBConfig = v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateServiceInput) SetDescription(v string) *CreateServiceInput {
	s.Description = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *CreateServiceInput) SetDryRun(v bool) *CreateServiceInput {
	s.DryRun = &v
	return s
}

// SetPorts sets the Ports field's value.
func (s *CreateServiceInput) SetPorts(v []*PortForCreateServiceInput) *CreateServiceInput {
	s.Ports = v
	return s
}

// SetResourceGroupId sets the ResourceGroupId field's value.
func (s *CreateServiceInput) SetResourceGroupId(v string) *CreateServiceInput {
	s.ResourceGroupId = &v
	return s
}

// SetServiceName sets the ServiceName field's value.
func (s *CreateServiceInput) SetServiceName(v string) *CreateServiceInput {
	s.ServiceName = &v
	return s
}

// SetTrafficConfig sets the TrafficConfig field's value.
func (s *CreateServiceInput) SetTrafficConfig(v *TrafficConfigForCreateServiceInput) *CreateServiceInput {
	s.TrafficConfig = v
	return s
}

type CreateServiceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Id *string `type:"string" json:",omitempty"`

	Status *StatusForCreateServiceOutput `type:"structure" json:",omitempty"`

	VersionId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateServiceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateServiceOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *CreateServiceOutput) SetId(v string) *CreateServiceOutput {
	s.Id = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *CreateServiceOutput) SetStatus(v *StatusForCreateServiceOutput) *CreateServiceOutput {
	s.Status = v
	return s
}

// SetVersionId sets the VersionId field's value.
func (s *CreateServiceOutput) SetVersionId(v string) *CreateServiceOutput {
	s.VersionId = &v
	return s
}

type MirrorTrafficPolicyForCreateServiceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Percent *int32 `type:"int32" json:",omitempty"`

	SourceDeploymentId *string `type:"string" json:",omitempty"`

	TargetDeploymentId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s MirrorTrafficPolicyForCreateServiceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MirrorTrafficPolicyForCreateServiceInput) GoString() string {
	return s.String()
}

// SetPercent sets the Percent field's value.
func (s *MirrorTrafficPolicyForCreateServiceInput) SetPercent(v int32) *MirrorTrafficPolicyForCreateServiceInput {
	s.Percent = &v
	return s
}

// SetSourceDeploymentId sets the SourceDeploymentId field's value.
func (s *MirrorTrafficPolicyForCreateServiceInput) SetSourceDeploymentId(v string) *MirrorTrafficPolicyForCreateServiceInput {
	s.SourceDeploymentId = &v
	return s
}

// SetTargetDeploymentId sets the TargetDeploymentId field's value.
func (s *MirrorTrafficPolicyForCreateServiceInput) SetTargetDeploymentId(v string) *MirrorTrafficPolicyForCreateServiceInput {
	s.TargetDeploymentId = &v
	return s
}

type PortForCreateServiceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ExposePort *string `type:"string" json:",omitempty"`

	ListenPort *string `type:"string" json:",omitempty"`

	Path *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty" enum:"EnumOfTypeForCreateServiceInput"`
}

// String returns the string representation
func (s PortForCreateServiceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PortForCreateServiceInput) GoString() string {
	return s.String()
}

// SetExposePort sets the ExposePort field's value.
func (s *PortForCreateServiceInput) SetExposePort(v string) *PortForCreateServiceInput {
	s.ExposePort = &v
	return s
}

// SetListenPort sets the ListenPort field's value.
func (s *PortForCreateServiceInput) SetListenPort(v string) *PortForCreateServiceInput {
	s.ListenPort = &v
	return s
}

// SetPath sets the Path field's value.
func (s *PortForCreateServiceInput) SetPath(v string) *PortForCreateServiceInput {
	s.Path = &v
	return s
}

// SetType sets the Type field's value.
func (s *PortForCreateServiceInput) SetType(v string) *PortForCreateServiceInput {
	s.Type = &v
	return s
}

type StatusForCreateServiceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Message *string `type:"string" json:",omitempty"`

	SecondaryState *string `type:"string" json:",omitempty"`

	State *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s StatusForCreateServiceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StatusForCreateServiceOutput) GoString() string {
	return s.String()
}

// SetMessage sets the Message field's value.
func (s *StatusForCreateServiceOutput) SetMessage(v string) *StatusForCreateServiceOutput {
	s.Message = &v
	return s
}

// SetSecondaryState sets the SecondaryState field's value.
func (s *StatusForCreateServiceOutput) SetSecondaryState(v string) *StatusForCreateServiceOutput {
	s.SecondaryState = &v
	return s
}

// SetState sets the State field's value.
func (s *StatusForCreateServiceOutput) SetState(v string) *StatusForCreateServiceOutput {
	s.State = &v
	return s
}

type TrafficConfigForCreateServiceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enables []*string `type:"list" json:",omitempty"`

	MirrorTrafficPolicy *MirrorTrafficPolicyForCreateServiceInput `type:"structure" json:",omitempty"`

	Mode *string `type:"string" json:",omitempty" enum:"EnumOfModeForCreateServiceInput"`

	Weights []*ConvertWeightForCreateServiceInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s TrafficConfigForCreateServiceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TrafficConfigForCreateServiceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TrafficConfigForCreateServiceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TrafficConfigForCreateServiceInput"}
	if s.Weights != nil {
		for i, v := range s.Weights {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Weights", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEnables sets the Enables field's value.
func (s *TrafficConfigForCreateServiceInput) SetEnables(v []*string) *TrafficConfigForCreateServiceInput {
	s.Enables = v
	return s
}

// SetMirrorTrafficPolicy sets the MirrorTrafficPolicy field's value.
func (s *TrafficConfigForCreateServiceInput) SetMirrorTrafficPolicy(v *MirrorTrafficPolicyForCreateServiceInput) *TrafficConfigForCreateServiceInput {
	s.MirrorTrafficPolicy = v
	return s
}

// SetMode sets the Mode field's value.
func (s *TrafficConfigForCreateServiceInput) SetMode(v string) *TrafficConfigForCreateServiceInput {
	s.Mode = &v
	return s
}

// SetWeights sets the Weights field's value.
func (s *TrafficConfigForCreateServiceInput) SetWeights(v []*ConvertWeightForCreateServiceInput) *TrafficConfigForCreateServiceInput {
	s.Weights = v
	return s
}

type UpstreamConfigForCreateServiceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ConsistentHashConfig *ConsistentHashConfigForCreateServiceInput `type:"structure" json:",omitempty"`

	LoadBalancePolicy *string `type:"string" json:",omitempty" enum:"EnumOfLoadBalancePolicyForCreateServiceInput"`
}

// String returns the string representation
func (s UpstreamConfigForCreateServiceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpstreamConfigForCreateServiceInput) GoString() string {
	return s.String()
}

// SetConsistentHashConfig sets the ConsistentHashConfig field's value.
func (s *UpstreamConfigForCreateServiceInput) SetConsistentHashConfig(v *ConsistentHashConfigForCreateServiceInput) *UpstreamConfigForCreateServiceInput {
	s.ConsistentHashConfig = v
	return s
}

// SetLoadBalancePolicy sets the LoadBalancePolicy field's value.
func (s *UpstreamConfigForCreateServiceInput) SetLoadBalancePolicy(v string) *UpstreamConfigForCreateServiceInput {
	s.LoadBalancePolicy = &v
	return s
}

const (
	// EnumOfHashKeyTypeForCreateServiceInputHttpHeaderName is a EnumOfHashKeyTypeForCreateServiceInput enum value
	EnumOfHashKeyTypeForCreateServiceInputHttpHeaderName = "HttpHeaderName"
)

const (
	// EnumOfLoadBalancePolicyForCreateServiceInputRoundRobin is a EnumOfLoadBalancePolicyForCreateServiceInput enum value
	EnumOfLoadBalancePolicyForCreateServiceInputRoundRobin = "ROUND_ROBIN"

	// EnumOfLoadBalancePolicyForCreateServiceInputLeastConn is a EnumOfLoadBalancePolicyForCreateServiceInput enum value
	EnumOfLoadBalancePolicyForCreateServiceInputLeastConn = "LEAST_CONN"

	// EnumOfLoadBalancePolicyForCreateServiceInputRandom is a EnumOfLoadBalancePolicyForCreateServiceInput enum value
	EnumOfLoadBalancePolicyForCreateServiceInputRandom = "RANDOM"

	// EnumOfLoadBalancePolicyForCreateServiceInputConsistentHash is a EnumOfLoadBalancePolicyForCreateServiceInput enum value
	EnumOfLoadBalancePolicyForCreateServiceInputConsistentHash = "CONSISTENT_HASH"
)

const (
	// EnumOfModeForCreateServiceInputDefault is a EnumOfModeForCreateServiceInput enum value
	EnumOfModeForCreateServiceInputDefault = "Default"

	// EnumOfModeForCreateServiceInputWeight is a EnumOfModeForCreateServiceInput enum value
	EnumOfModeForCreateServiceInputWeight = "Weight"
)

const (
	// EnumOfSchedulerForCreateServiceInputWrr is a EnumOfSchedulerForCreateServiceInput enum value
	EnumOfSchedulerForCreateServiceInputWrr = "wrr"

	// EnumOfSchedulerForCreateServiceInputWlc is a EnumOfSchedulerForCreateServiceInput enum value
	EnumOfSchedulerForCreateServiceInputWlc = "wlc"

	// EnumOfSchedulerForCreateServiceInputSh is a EnumOfSchedulerForCreateServiceInput enum value
	EnumOfSchedulerForCreateServiceInputSh = "sh"
)

const (
	// EnumOfTypeForCreateServiceInputHttp11 is a EnumOfTypeForCreateServiceInput enum value
	EnumOfTypeForCreateServiceInputHttp11 = "HTTP/1.1"

	// EnumOfTypeForCreateServiceInputHttp2 is a EnumOfTypeForCreateServiceInput enum value
	EnumOfTypeForCreateServiceInputHttp2 = "HTTP2"

	// EnumOfTypeForCreateServiceInputGrpc is a EnumOfTypeForCreateServiceInput enum value
	EnumOfTypeForCreateServiceInputGrpc = "GRPC"

	// EnumOfTypeForCreateServiceInputMetrics is a EnumOfTypeForCreateServiceInput enum value
	EnumOfTypeForCreateServiceInputMetrics = "Metrics"

	// EnumOfTypeForCreateServiceInputOther is a EnumOfTypeForCreateServiceInput enum value
	EnumOfTypeForCreateServiceInputOther = "Other"
)
