// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package mlplatform20240701

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateResourceGroupCommon = "CreateResourceGroup"

// CreateResourceGroupCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateResourceGroupCommon operation. The "output" return
// value will be populated with the CreateResourceGroupCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateResourceGroupCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateResourceGroupCommon Send returns without error.
//
// See CreateResourceGroupCommon for more information on using the CreateResourceGroupCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateResourceGroupCommonRequest method.
//    req, resp := client.CreateResourceGroupCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MLPLATFORM20240701) CreateResourceGroupCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateResourceGroupCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateResourceGroupCommon API operation for ML_PLATFORM20240701.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ML_PLATFORM20240701's
// API operation CreateResourceGroupCommon for usage and error information.
func (c *MLPLATFORM20240701) CreateResourceGroupCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateResourceGroupCommonRequest(input)
	return out, req.Send()
}

// CreateResourceGroupCommonWithContext is the same as CreateResourceGroupCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResourceGroupCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MLPLATFORM20240701) CreateResourceGroupCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateResourceGroupCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateResourceGroup = "CreateResourceGroup"

// CreateResourceGroupRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateResourceGroup operation. The "output" return
// value will be populated with the CreateResourceGroupCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateResourceGroupCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateResourceGroupCommon Send returns without error.
//
// See CreateResourceGroup for more information on using the CreateResourceGroup
// API call, and error handling.
//
//    // Example sending a request using the CreateResourceGroupRequest method.
//    req, resp := client.CreateResourceGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *MLPLATFORM20240701) CreateResourceGroupRequest(input *CreateResourceGroupInput) (req *request.Request, output *CreateResourceGroupOutput) {
	op := &request.Operation{
		Name:       opCreateResourceGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateResourceGroupInput{}
	}

	output = &CreateResourceGroupOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateResourceGroup API operation for ML_PLATFORM20240701.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ML_PLATFORM20240701's
// API operation CreateResourceGroup for usage and error information.
func (c *MLPLATFORM20240701) CreateResourceGroup(input *CreateResourceGroupInput) (*CreateResourceGroupOutput, error) {
	req, out := c.CreateResourceGroupRequest(input)
	return out, req.Send()
}

// CreateResourceGroupWithContext is the same as CreateResourceGroup with the addition of
// the ability to pass a context and additional request options.
//
// See CreateResourceGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *MLPLATFORM20240701) CreateResourceGroupWithContext(ctx volcengine.Context, input *CreateResourceGroupInput, opts ...request.Option) (*CreateResourceGroupOutput, error) {
	req, out := c.CreateResourceGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ComputeResourceForCreateResourceGroupInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Count *int32 `type:"int32" json:",omitempty"`

	InstanceTypeId *string `type:"string" json:",omitempty"`

	ZoneId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ComputeResourceForCreateResourceGroupInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ComputeResourceForCreateResourceGroupInput) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *ComputeResourceForCreateResourceGroupInput) SetCount(v int32) *ComputeResourceForCreateResourceGroupInput {
	s.Count = &v
	return s
}

// SetInstanceTypeId sets the InstanceTypeId field's value.
func (s *ComputeResourceForCreateResourceGroupInput) SetInstanceTypeId(v string) *ComputeResourceForCreateResourceGroupInput {
	s.InstanceTypeId = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *ComputeResourceForCreateResourceGroupInput) SetZoneId(v string) *ComputeResourceForCreateResourceGroupInput {
	s.ZoneId = &v
	return s
}

type CreateResourceGroupInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AutoRenew *bool `type:"boolean" json:",omitempty"`

	AutoRenewPeriod *int32 `min:"1" type:"int32" json:",omitempty"`

	// ChargeType is a required field
	ChargeType *string `type:"string" json:",omitempty" required:"true" enum:"EnumOfChargeTypeForCreateResourceGroupInput"`

	Description *string `min:"1" max:"500" type:"string" json:",omitempty"`

	DryRun *bool `type:"boolean" json:",omitempty"`

	MGpuEnabled *bool `type:"boolean" json:",omitempty"`

	// Name is a required field
	Name *string `min:"1" max:"200" type:"string" json:",omitempty" required:"true"`

	Period *int32 `min:"1" type:"int32" json:",omitempty"`

	PeriodUnit *string `type:"string" json:",omitempty" enum:"EnumOfPeriodUnitForCreateResourceGroupInput"`

	ResourceConfig *ResourceConfigForCreateResourceGroupInput `type:"structure" json:",omitempty"`

	StorageConfig *StorageConfigForCreateResourceGroupInput `type:"structure" json:",omitempty"`

	WorkloadNetworkConfig *WorkloadNetworkConfigForCreateResourceGroupInput `type:"structure" json:",omitempty"`

	WorkloadNetworkMode *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateResourceGroupInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResourceGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateResourceGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateResourceGroupInput"}
	if s.AutoRenewPeriod != nil && *s.AutoRenewPeriod < 1 {
		invalidParams.Add(request.NewErrParamMinValue("AutoRenewPeriod", 1))
	}
	if s.ChargeType == nil {
		invalidParams.Add(request.NewErrParamRequired("ChargeType"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Description != nil && len(*s.Description) > 500 {
		invalidParams.Add(request.NewErrParamMaxLen("Description", 500, *s.Description))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Name != nil && len(*s.Name) > 200 {
		invalidParams.Add(request.NewErrParamMaxLen("Name", 200, *s.Name))
	}
	if s.Period != nil && *s.Period < 1 {
		invalidParams.Add(request.NewErrParamMinValue("Period", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoRenew sets the AutoRenew field's value.
func (s *CreateResourceGroupInput) SetAutoRenew(v bool) *CreateResourceGroupInput {
	s.AutoRenew = &v
	return s
}

// SetAutoRenewPeriod sets the AutoRenewPeriod field's value.
func (s *CreateResourceGroupInput) SetAutoRenewPeriod(v int32) *CreateResourceGroupInput {
	s.AutoRenewPeriod = &v
	return s
}

// SetChargeType sets the ChargeType field's value.
func (s *CreateResourceGroupInput) SetChargeType(v string) *CreateResourceGroupInput {
	s.ChargeType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateResourceGroupInput) SetDescription(v string) *CreateResourceGroupInput {
	s.Description = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *CreateResourceGroupInput) SetDryRun(v bool) *CreateResourceGroupInput {
	s.DryRun = &v
	return s
}

// SetMGpuEnabled sets the MGpuEnabled field's value.
func (s *CreateResourceGroupInput) SetMGpuEnabled(v bool) *CreateResourceGroupInput {
	s.MGpuEnabled = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateResourceGroupInput) SetName(v string) *CreateResourceGroupInput {
	s.Name = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *CreateResourceGroupInput) SetPeriod(v int32) *CreateResourceGroupInput {
	s.Period = &v
	return s
}

// SetPeriodUnit sets the PeriodUnit field's value.
func (s *CreateResourceGroupInput) SetPeriodUnit(v string) *CreateResourceGroupInput {
	s.PeriodUnit = &v
	return s
}

// SetResourceConfig sets the ResourceConfig field's value.
func (s *CreateResourceGroupInput) SetResourceConfig(v *ResourceConfigForCreateResourceGroupInput) *CreateResourceGroupInput {
	s.ResourceConfig = v
	return s
}

// SetStorageConfig sets the StorageConfig field's value.
func (s *CreateResourceGroupInput) SetStorageConfig(v *StorageConfigForCreateResourceGroupInput) *CreateResourceGroupInput {
	s.StorageConfig = v
	return s
}

// SetWorkloadNetworkConfig sets the WorkloadNetworkConfig field's value.
func (s *CreateResourceGroupInput) SetWorkloadNetworkConfig(v *WorkloadNetworkConfigForCreateResourceGroupInput) *CreateResourceGroupInput {
	s.WorkloadNetworkConfig = v
	return s
}

// SetWorkloadNetworkMode sets the WorkloadNetworkMode field's value.
func (s *CreateResourceGroupInput) SetWorkloadNetworkMode(v string) *CreateResourceGroupInput {
	s.WorkloadNetworkMode = &v
	return s
}

type CreateResourceGroupOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Id *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateResourceGroupOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateResourceGroupOutput) GoString() string {
	return s.String()
}

// SetId sets the Id field's value.
func (s *CreateResourceGroupOutput) SetId(v string) *CreateResourceGroupOutput {
	s.Id = &v
	return s
}

type ResourceConfigForCreateResourceGroupInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ComputeResources []*ComputeResourceForCreateResourceGroupInput `type:"list" json:",omitempty"`

	VolumeResources []*VolumeResourceForCreateResourceGroupInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ResourceConfigForCreateResourceGroupInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceConfigForCreateResourceGroupInput) GoString() string {
	return s.String()
}

// SetComputeResources sets the ComputeResources field's value.
func (s *ResourceConfigForCreateResourceGroupInput) SetComputeResources(v []*ComputeResourceForCreateResourceGroupInput) *ResourceConfigForCreateResourceGroupInput {
	s.ComputeResources = v
	return s
}

// SetVolumeResources sets the VolumeResources field's value.
func (s *ResourceConfigForCreateResourceGroupInput) SetVolumeResources(v []*VolumeResourceForCreateResourceGroupInput) *ResourceConfigForCreateResourceGroupInput {
	s.VolumeResources = v
	return s
}

type SfcsForCreateResourceGroupInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Replicas *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s SfcsForCreateResourceGroupInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SfcsForCreateResourceGroupInput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *SfcsForCreateResourceGroupInput) SetDescription(v string) *SfcsForCreateResourceGroupInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *SfcsForCreateResourceGroupInput) SetName(v string) *SfcsForCreateResourceGroupInput {
	s.Name = &v
	return s
}

// SetReplicas sets the Replicas field's value.
func (s *SfcsForCreateResourceGroupInput) SetReplicas(v int64) *SfcsForCreateResourceGroupInput {
	s.Replicas = &v
	return s
}

type StorageConfigForCreateResourceGroupInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Sfcs *SfcsForCreateResourceGroupInput `type:"structure" json:",omitempty"`

	StorageNetworkConfig *StorageNetworkConfigForCreateResourceGroupInput `type:"structure" json:",omitempty"`

	Vepfs *VepfsForCreateResourceGroupInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s StorageConfigForCreateResourceGroupInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageConfigForCreateResourceGroupInput) GoString() string {
	return s.String()
}

// SetSfcs sets the Sfcs field's value.
func (s *StorageConfigForCreateResourceGroupInput) SetSfcs(v *SfcsForCreateResourceGroupInput) *StorageConfigForCreateResourceGroupInput {
	s.Sfcs = v
	return s
}

// SetStorageNetworkConfig sets the StorageNetworkConfig field's value.
func (s *StorageConfigForCreateResourceGroupInput) SetStorageNetworkConfig(v *StorageNetworkConfigForCreateResourceGroupInput) *StorageConfigForCreateResourceGroupInput {
	s.StorageNetworkConfig = v
	return s
}

// SetVepfs sets the Vepfs field's value.
func (s *StorageConfigForCreateResourceGroupInput) SetVepfs(v *VepfsForCreateResourceGroupInput) *StorageConfigForCreateResourceGroupInput {
	s.Vepfs = v
	return s
}

type StorageNetworkConfigForCreateResourceGroupInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	SecurityGroupIds []*string `type:"list" json:",omitempty"`

	SubnetIds []*string `type:"list" json:",omitempty"`

	VpcId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s StorageNetworkConfigForCreateResourceGroupInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageNetworkConfigForCreateResourceGroupInput) GoString() string {
	return s.String()
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *StorageNetworkConfigForCreateResourceGroupInput) SetSecurityGroupIds(v []*string) *StorageNetworkConfigForCreateResourceGroupInput {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *StorageNetworkConfigForCreateResourceGroupInput) SetSubnetIds(v []*string) *StorageNetworkConfigForCreateResourceGroupInput {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *StorageNetworkConfigForCreateResourceGroupInput) SetVpcId(v string) *StorageNetworkConfigForCreateResourceGroupInput {
	s.VpcId = &v
	return s
}

type VepfsForCreateResourceGroupInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	EnablePrefetch *bool `type:"boolean" json:",omitempty"`

	FileSystemIds []*string `type:"list" json:",omitempty"`

	MountServiceId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s VepfsForCreateResourceGroupInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VepfsForCreateResourceGroupInput) GoString() string {
	return s.String()
}

// SetEnablePrefetch sets the EnablePrefetch field's value.
func (s *VepfsForCreateResourceGroupInput) SetEnablePrefetch(v bool) *VepfsForCreateResourceGroupInput {
	s.EnablePrefetch = &v
	return s
}

// SetFileSystemIds sets the FileSystemIds field's value.
func (s *VepfsForCreateResourceGroupInput) SetFileSystemIds(v []*string) *VepfsForCreateResourceGroupInput {
	s.FileSystemIds = v
	return s
}

// SetMountServiceId sets the MountServiceId field's value.
func (s *VepfsForCreateResourceGroupInput) SetMountServiceId(v string) *VepfsForCreateResourceGroupInput {
	s.MountServiceId = &v
	return s
}

type VolumeResourceForCreateResourceGroupInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Size *int32 `type:"int32" json:",omitempty"`

	VolumeTypeId *string `type:"string" json:",omitempty"`

	ZoneId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s VolumeResourceForCreateResourceGroupInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VolumeResourceForCreateResourceGroupInput) GoString() string {
	return s.String()
}

// SetSize sets the Size field's value.
func (s *VolumeResourceForCreateResourceGroupInput) SetSize(v int32) *VolumeResourceForCreateResourceGroupInput {
	s.Size = &v
	return s
}

// SetVolumeTypeId sets the VolumeTypeId field's value.
func (s *VolumeResourceForCreateResourceGroupInput) SetVolumeTypeId(v string) *VolumeResourceForCreateResourceGroupInput {
	s.VolumeTypeId = &v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *VolumeResourceForCreateResourceGroupInput) SetZoneId(v string) *VolumeResourceForCreateResourceGroupInput {
	s.ZoneId = &v
	return s
}

type WorkloadNetworkConfigForCreateResourceGroupInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	SecurityGroupIds []*string `type:"list" json:",omitempty"`

	SubnetIds []*string `type:"list" json:",omitempty"`

	VpcId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s WorkloadNetworkConfigForCreateResourceGroupInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s WorkloadNetworkConfigForCreateResourceGroupInput) GoString() string {
	return s.String()
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *WorkloadNetworkConfigForCreateResourceGroupInput) SetSecurityGroupIds(v []*string) *WorkloadNetworkConfigForCreateResourceGroupInput {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetIds sets the SubnetIds field's value.
func (s *WorkloadNetworkConfigForCreateResourceGroupInput) SetSubnetIds(v []*string) *WorkloadNetworkConfigForCreateResourceGroupInput {
	s.SubnetIds = v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *WorkloadNetworkConfigForCreateResourceGroupInput) SetVpcId(v string) *WorkloadNetworkConfigForCreateResourceGroupInput {
	s.VpcId = &v
	return s
}

const (
	// EnumOfChargeTypeForCreateResourceGroupInputPrePaid is a EnumOfChargeTypeForCreateResourceGroupInput enum value
	EnumOfChargeTypeForCreateResourceGroupInputPrePaid = "PrePaid"

	// EnumOfChargeTypeForCreateResourceGroupInputPostPaid is a EnumOfChargeTypeForCreateResourceGroupInput enum value
	EnumOfChargeTypeForCreateResourceGroupInputPostPaid = "PostPaid"

	// EnumOfChargeTypeForCreateResourceGroupInputOnDemand is a EnumOfChargeTypeForCreateResourceGroupInput enum value
	EnumOfChargeTypeForCreateResourceGroupInputOnDemand = "OnDemand"
)

const (
	// EnumOfPeriodUnitForCreateResourceGroupInputDay is a EnumOfPeriodUnitForCreateResourceGroupInput enum value
	EnumOfPeriodUnitForCreateResourceGroupInputDay = "Day"

	// EnumOfPeriodUnitForCreateResourceGroupInputMonth is a EnumOfPeriodUnitForCreateResourceGroupInput enum value
	EnumOfPeriodUnitForCreateResourceGroupInputMonth = "Month"
)
