// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opScheduleKeyDeletionCommon = "ScheduleKeyDeletion"

// ScheduleKeyDeletionCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ScheduleKeyDeletionCommon operation. The "output" return
// value will be populated with the ScheduleKeyDeletionCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ScheduleKeyDeletionCommon Request to send the API call to the service.
// the "output" return value is not valid until after ScheduleKeyDeletionCommon Send returns without error.
//
// See ScheduleKeyDeletionCommon for more information on using the ScheduleKeyDeletionCommon
// API call, and error handling.
//
//    // Example sending a request using the ScheduleKeyDeletionCommonRequest method.
//    req, resp := client.ScheduleKeyDeletionCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) ScheduleKeyDeletionCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opScheduleKeyDeletionCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ScheduleKeyDeletionCommon API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation ScheduleKeyDeletionCommon for usage and error information.
func (c *KMS) ScheduleKeyDeletionCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ScheduleKeyDeletionCommonRequest(input)
	return out, req.Send()
}

// ScheduleKeyDeletionCommonWithContext is the same as ScheduleKeyDeletionCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ScheduleKeyDeletionCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) ScheduleKeyDeletionCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ScheduleKeyDeletionCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opScheduleKeyDeletion = "ScheduleKeyDeletion"

// ScheduleKeyDeletionRequest generates a "volcengine/request.Request" representing the
// client's request for the ScheduleKeyDeletion operation. The "output" return
// value will be populated with the ScheduleKeyDeletionCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ScheduleKeyDeletionCommon Request to send the API call to the service.
// the "output" return value is not valid until after ScheduleKeyDeletionCommon Send returns without error.
//
// See ScheduleKeyDeletion for more information on using the ScheduleKeyDeletion
// API call, and error handling.
//
//    // Example sending a request using the ScheduleKeyDeletionRequest method.
//    req, resp := client.ScheduleKeyDeletionRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) ScheduleKeyDeletionRequest(input *ScheduleKeyDeletionInput) (req *request.Request, output *ScheduleKeyDeletionOutput) {
	op := &request.Operation{
		Name:       opScheduleKeyDeletion,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ScheduleKeyDeletionInput{}
	}

	output = &ScheduleKeyDeletionOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ScheduleKeyDeletion API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation ScheduleKeyDeletion for usage and error information.
func (c *KMS) ScheduleKeyDeletion(input *ScheduleKeyDeletionInput) (*ScheduleKeyDeletionOutput, error) {
	req, out := c.ScheduleKeyDeletionRequest(input)
	return out, req.Send()
}

// ScheduleKeyDeletionWithContext is the same as ScheduleKeyDeletion with the addition of
// the ability to pass a context and additional request options.
//
// See ScheduleKeyDeletion for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) ScheduleKeyDeletionWithContext(ctx volcengine.Context, input *ScheduleKeyDeletionInput, opts ...request.Option) (*ScheduleKeyDeletionOutput, error) {
	req, out := c.ScheduleKeyDeletionRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ScheduleKeyDeletionInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	KeyID *string `type:"string" json:",omitempty"`

	KeyName *string `min:"2" max:"31" type:"string" json:",omitempty"`

	KeyringName *string `min:"2" max:"31" type:"string" json:",omitempty"`

	PendingWindowInDays *int32 `min:"7" max:"30" type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ScheduleKeyDeletionInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ScheduleKeyDeletionInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduleKeyDeletionInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScheduleKeyDeletionInput"}
	if s.KeyName != nil && len(*s.KeyName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("KeyName", 2))
	}
	if s.KeyName != nil && len(*s.KeyName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("KeyName", 31, *s.KeyName))
	}
	if s.KeyringName != nil && len(*s.KeyringName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("KeyringName", 2))
	}
	if s.KeyringName != nil && len(*s.KeyringName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("KeyringName", 31, *s.KeyringName))
	}
	if s.PendingWindowInDays != nil && *s.PendingWindowInDays < 7 {
		invalidParams.Add(request.NewErrParamMinValue("PendingWindowInDays", 7))
	}
	if s.PendingWindowInDays != nil && *s.PendingWindowInDays > 30 {
		invalidParams.Add(request.NewErrParamMaxValue("PendingWindowInDays", 30))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetKeyID sets the KeyID field's value.
func (s *ScheduleKeyDeletionInput) SetKeyID(v string) *ScheduleKeyDeletionInput {
	s.KeyID = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *ScheduleKeyDeletionInput) SetKeyName(v string) *ScheduleKeyDeletionInput {
	s.KeyName = &v
	return s
}

// SetKeyringName sets the KeyringName field's value.
func (s *ScheduleKeyDeletionInput) SetKeyringName(v string) *ScheduleKeyDeletionInput {
	s.KeyringName = &v
	return s
}

// SetPendingWindowInDays sets the PendingWindowInDays field's value.
func (s *ScheduleKeyDeletionInput) SetPendingWindowInDays(v int32) *ScheduleKeyDeletionInput {
	s.PendingWindowInDays = &v
	return s
}

type ScheduleKeyDeletionOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata
}

// String returns the string representation
func (s ScheduleKeyDeletionOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ScheduleKeyDeletionOutput) GoString() string {
	return s.String()
}
