// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opGetSecretValueCommon = "GetSecretValue"

// GetSecretValueCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the GetSecretValueCommon operation. The "output" return
// value will be populated with the GetSecretValueCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GetSecretValueCommon Request to send the API call to the service.
// the "output" return value is not valid until after GetSecretValueCommon Send returns without error.
//
// See GetSecretValueCommon for more information on using the GetSecretValueCommon
// API call, and error handling.
//
//    // Example sending a request using the GetSecretValueCommonRequest method.
//    req, resp := client.GetSecretValueCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) GetSecretValueCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opGetSecretValueCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// GetSecretValueCommon API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation GetSecretValueCommon for usage and error information.
func (c *KMS) GetSecretValueCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.GetSecretValueCommonRequest(input)
	return out, req.Send()
}

// GetSecretValueCommonWithContext is the same as GetSecretValueCommon with the addition of
// the ability to pass a context and additional request options.
//
// See GetSecretValueCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) GetSecretValueCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.GetSecretValueCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetSecretValue = "GetSecretValue"

// GetSecretValueRequest generates a "volcengine/request.Request" representing the
// client's request for the GetSecretValue operation. The "output" return
// value will be populated with the GetSecretValueCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GetSecretValueCommon Request to send the API call to the service.
// the "output" return value is not valid until after GetSecretValueCommon Send returns without error.
//
// See GetSecretValue for more information on using the GetSecretValue
// API call, and error handling.
//
//    // Example sending a request using the GetSecretValueRequest method.
//    req, resp := client.GetSecretValueRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) GetSecretValueRequest(input *GetSecretValueInput) (req *request.Request, output *GetSecretValueOutput) {
	op := &request.Operation{
		Name:       opGetSecretValue,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSecretValueInput{}
	}

	output = &GetSecretValueOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// GetSecretValue API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation GetSecretValue for usage and error information.
func (c *KMS) GetSecretValue(input *GetSecretValueInput) (*GetSecretValueOutput, error) {
	req, out := c.GetSecretValueRequest(input)
	return out, req.Send()
}

// GetSecretValueWithContext is the same as GetSecretValue with the addition of
// the ability to pass a context and additional request options.
//
// See GetSecretValue for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) GetSecretValueWithContext(ctx volcengine.Context, input *GetSecretValueInput, opts ...request.Option) (*GetSecretValueOutput, error) {
	req, out := c.GetSecretValueRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type GetSecretValueInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// SecretName is a required field
	SecretName *string `min:"2" max:"128" type:"string" json:",omitempty" required:"true"`

	VersionID *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s GetSecretValueInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSecretValueInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSecretValueInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetSecretValueInput"}
	if s.SecretName == nil {
		invalidParams.Add(request.NewErrParamRequired("SecretName"))
	}
	if s.SecretName != nil && len(*s.SecretName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("SecretName", 2))
	}
	if s.SecretName != nil && len(*s.SecretName) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("SecretName", 128, *s.SecretName))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSecretName sets the SecretName field's value.
func (s *GetSecretValueInput) SetSecretName(v string) *GetSecretValueInput {
	s.SecretName = &v
	return s
}

// SetVersionID sets the VersionID field's value.
func (s *GetSecretValueInput) SetVersionID(v string) *GetSecretValueInput {
	s.VersionID = &v
	return s
}

type GetSecretValueOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	CreationDate *int64 `type:"int64" json:",omitempty"`

	SecretValue *string `type:"string" json:",omitempty"`

	VersionID *string `type:"string" json:",omitempty"`

	VersionStage *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s GetSecretValueOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GetSecretValueOutput) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *GetSecretValueOutput) SetCreationDate(v int64) *GetSecretValueOutput {
	s.CreationDate = &v
	return s
}

// SetSecretValue sets the SecretValue field's value.
func (s *GetSecretValueOutput) SetSecretValue(v string) *GetSecretValueOutput {
	s.SecretValue = &v
	return s
}

// SetVersionID sets the VersionID field's value.
func (s *GetSecretValueOutput) SetVersionID(v string) *GetSecretValueOutput {
	s.VersionID = &v
	return s
}

// SetVersionStage sets the VersionStage field's value.
func (s *GetSecretValueOutput) SetVersionStage(v string) *GetSecretValueOutput {
	s.VersionStage = &v
	return s
}
