// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDisconnectCustomKeyStoreCommon = "DisconnectCustomKeyStore"

// DisconnectCustomKeyStoreCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DisconnectCustomKeyStoreCommon operation. The "output" return
// value will be populated with the DisconnectCustomKeyStoreCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DisconnectCustomKeyStoreCommon Request to send the API call to the service.
// the "output" return value is not valid until after DisconnectCustomKeyStoreCommon Send returns without error.
//
// See DisconnectCustomKeyStoreCommon for more information on using the DisconnectCustomKeyStoreCommon
// API call, and error handling.
//
//    // Example sending a request using the DisconnectCustomKeyStoreCommonRequest method.
//    req, resp := client.DisconnectCustomKeyStoreCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) DisconnectCustomKeyStoreCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDisconnectCustomKeyStoreCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DisconnectCustomKeyStoreCommon API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation DisconnectCustomKeyStoreCommon for usage and error information.
func (c *KMS) DisconnectCustomKeyStoreCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DisconnectCustomKeyStoreCommonRequest(input)
	return out, req.Send()
}

// DisconnectCustomKeyStoreCommonWithContext is the same as DisconnectCustomKeyStoreCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DisconnectCustomKeyStoreCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) DisconnectCustomKeyStoreCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DisconnectCustomKeyStoreCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDisconnectCustomKeyStore = "DisconnectCustomKeyStore"

// DisconnectCustomKeyStoreRequest generates a "volcengine/request.Request" representing the
// client's request for the DisconnectCustomKeyStore operation. The "output" return
// value will be populated with the DisconnectCustomKeyStoreCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DisconnectCustomKeyStoreCommon Request to send the API call to the service.
// the "output" return value is not valid until after DisconnectCustomKeyStoreCommon Send returns without error.
//
// See DisconnectCustomKeyStore for more information on using the DisconnectCustomKeyStore
// API call, and error handling.
//
//    // Example sending a request using the DisconnectCustomKeyStoreRequest method.
//    req, resp := client.DisconnectCustomKeyStoreRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) DisconnectCustomKeyStoreRequest(input *DisconnectCustomKeyStoreInput) (req *request.Request, output *DisconnectCustomKeyStoreOutput) {
	op := &request.Operation{
		Name:       opDisconnectCustomKeyStore,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DisconnectCustomKeyStoreInput{}
	}

	output = &DisconnectCustomKeyStoreOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DisconnectCustomKeyStore API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation DisconnectCustomKeyStore for usage and error information.
func (c *KMS) DisconnectCustomKeyStore(input *DisconnectCustomKeyStoreInput) (*DisconnectCustomKeyStoreOutput, error) {
	req, out := c.DisconnectCustomKeyStoreRequest(input)
	return out, req.Send()
}

// DisconnectCustomKeyStoreWithContext is the same as DisconnectCustomKeyStore with the addition of
// the ability to pass a context and additional request options.
//
// See DisconnectCustomKeyStore for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) DisconnectCustomKeyStoreWithContext(ctx volcengine.Context, input *DisconnectCustomKeyStoreInput, opts ...request.Option) (*DisconnectCustomKeyStoreOutput, error) {
	req, out := c.DisconnectCustomKeyStoreRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DisconnectCustomKeyStoreInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// CustomKeyStoreID is a required field
	CustomKeyStoreID *string `min:"36" max:"36" type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s DisconnectCustomKeyStoreInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DisconnectCustomKeyStoreInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DisconnectCustomKeyStoreInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DisconnectCustomKeyStoreInput"}
	if s.CustomKeyStoreID == nil {
		invalidParams.Add(request.NewErrParamRequired("CustomKeyStoreID"))
	}
	if s.CustomKeyStoreID != nil && len(*s.CustomKeyStoreID) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CustomKeyStoreID", 36))
	}
	if s.CustomKeyStoreID != nil && len(*s.CustomKeyStoreID) > 36 {
		invalidParams.Add(request.NewErrParamMaxLen("CustomKeyStoreID", 36, *s.CustomKeyStoreID))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCustomKeyStoreID sets the CustomKeyStoreID field's value.
func (s *DisconnectCustomKeyStoreInput) SetCustomKeyStoreID(v string) *DisconnectCustomKeyStoreInput {
	s.CustomKeyStoreID = &v
	return s
}

type DisconnectCustomKeyStoreOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata
}

// String returns the string representation
func (s DisconnectCustomKeyStoreOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DisconnectCustomKeyStoreOutput) GoString() string {
	return s.String()
}
