// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeSecretsCommon = "DescribeSecrets"

// DescribeSecretsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeSecretsCommon operation. The "output" return
// value will be populated with the DescribeSecretsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeSecretsCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeSecretsCommon Send returns without error.
//
// See DescribeSecretsCommon for more information on using the DescribeSecretsCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeSecretsCommonRequest method.
//    req, resp := client.DescribeSecretsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) DescribeSecretsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeSecretsCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeSecretsCommon API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation DescribeSecretsCommon for usage and error information.
func (c *KMS) DescribeSecretsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeSecretsCommonRequest(input)
	return out, req.Send()
}

// DescribeSecretsCommonWithContext is the same as DescribeSecretsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSecretsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) DescribeSecretsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeSecretsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeSecrets = "DescribeSecrets"

// DescribeSecretsRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeSecrets operation. The "output" return
// value will be populated with the DescribeSecretsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeSecretsCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeSecretsCommon Send returns without error.
//
// See DescribeSecrets for more information on using the DescribeSecrets
// API call, and error handling.
//
//    // Example sending a request using the DescribeSecretsRequest method.
//    req, resp := client.DescribeSecretsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) DescribeSecretsRequest(input *DescribeSecretsInput) (req *request.Request, output *DescribeSecretsOutput) {
	op := &request.Operation{
		Name:       opDescribeSecrets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeSecretsInput{}
	}

	output = &DescribeSecretsOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeSecrets API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation DescribeSecrets for usage and error information.
func (c *KMS) DescribeSecrets(input *DescribeSecretsInput) (*DescribeSecretsOutput, error) {
	req, out := c.DescribeSecretsRequest(input)
	return out, req.Send()
}

// DescribeSecretsWithContext is the same as DescribeSecrets with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeSecrets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) DescribeSecretsWithContext(ctx volcengine.Context, input *DescribeSecretsInput, opts ...request.Option) (*DescribeSecretsOutput, error) {
	req, out := c.DescribeSecretsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DescribeSecretsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CurrentPage *int32 `min:"1" type:"int32" json:",omitempty"`

	Filters *string `max:"2048" type:"string" json:",omitempty"`

	PageSize *int32 `min:"1" max:"100" type:"int32" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s DescribeSecretsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSecretsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeSecretsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeSecretsInput"}
	if s.CurrentPage != nil && *s.CurrentPage < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CurrentPage", 1))
	}
	if s.Filters != nil && len(*s.Filters) > 2048 {
		invalidParams.Add(request.NewErrParamMaxLen("Filters", 2048, *s.Filters))
	}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}
	if s.PageSize != nil && *s.PageSize > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("PageSize", 100))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCurrentPage sets the CurrentPage field's value.
func (s *DescribeSecretsInput) SetCurrentPage(v int32) *DescribeSecretsInput {
	s.CurrentPage = &v
	return s
}

// SetFilters sets the Filters field's value.
func (s *DescribeSecretsInput) SetFilters(v string) *DescribeSecretsInput {
	s.Filters = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribeSecretsInput) SetPageSize(v int32) *DescribeSecretsInput {
	s.PageSize = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *DescribeSecretsInput) SetProjectName(v string) *DescribeSecretsInput {
	s.ProjectName = &v
	return s
}

type DescribeSecretsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	PageInfo *PageInfoForDescribeSecretsOutput `type:"structure" json:",omitempty"`

	Secrets []*SecretForDescribeSecretsOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s DescribeSecretsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeSecretsOutput) GoString() string {
	return s.String()
}

// SetPageInfo sets the PageInfo field's value.
func (s *DescribeSecretsOutput) SetPageInfo(v *PageInfoForDescribeSecretsOutput) *DescribeSecretsOutput {
	s.PageInfo = v
	return s
}

// SetSecrets sets the Secrets field's value.
func (s *DescribeSecretsOutput) SetSecrets(v []*SecretForDescribeSecretsOutput) *DescribeSecretsOutput {
	s.Secrets = v
	return s
}

type PageInfoForDescribeSecretsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Count *int32 `type:"int32" json:",omitempty"`

	CurrentPage *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s PageInfoForDescribeSecretsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PageInfoForDescribeSecretsOutput) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *PageInfoForDescribeSecretsOutput) SetCount(v int32) *PageInfoForDescribeSecretsOutput {
	s.Count = &v
	return s
}

// SetCurrentPage sets the CurrentPage field's value.
func (s *PageInfoForDescribeSecretsOutput) SetCurrentPage(v int32) *PageInfoForDescribeSecretsOutput {
	s.CurrentPage = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *PageInfoForDescribeSecretsOutput) SetPageSize(v int32) *PageInfoForDescribeSecretsOutput {
	s.PageSize = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *PageInfoForDescribeSecretsOutput) SetTotalCount(v int32) *PageInfoForDescribeSecretsOutput {
	s.TotalCount = &v
	return s
}

type SecretForDescribeSecretsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CreationDate *int64 `type:"int64" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	EncryptionKey *string `type:"string" json:",omitempty"`

	ExtendedConfig *string `max:"1024" type:"string" json:",omitempty"`

	ID *string `type:"string" json:",omitempty"`

	LastRotationTime *string `type:"string" json:",omitempty"`

	Managed *bool `type:"boolean" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`

	RotationInterval *int32 `type:"int32" json:",omitempty"`

	RotationState *string `type:"string" json:",omitempty"`

	ScheduleDeleteTime *string `type:"string" json:",omitempty"`

	ScheduleRotationTime *string `type:"string" json:",omitempty"`

	SecretName *string `type:"string" json:",omitempty"`

	SecretState *string `type:"string" json:",omitempty" enum:"EnumOfSecretStateForDescribeSecretsOutput"`

	SecretType *string `type:"string" json:",omitempty" enum:"EnumOfSecretTypeForDescribeSecretsOutput"`

	Trn *string `type:"string" json:",omitempty"`

	UID *string `type:"string" json:",omitempty"`

	UpdateDate *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s SecretForDescribeSecretsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SecretForDescribeSecretsOutput) GoString() string {
	return s.String()
}

// SetCreationDate sets the CreationDate field's value.
func (s *SecretForDescribeSecretsOutput) SetCreationDate(v int64) *SecretForDescribeSecretsOutput {
	s.CreationDate = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *SecretForDescribeSecretsOutput) SetDescription(v string) *SecretForDescribeSecretsOutput {
	s.Description = &v
	return s
}

// SetEncryptionKey sets the EncryptionKey field's value.
func (s *SecretForDescribeSecretsOutput) SetEncryptionKey(v string) *SecretForDescribeSecretsOutput {
	s.EncryptionKey = &v
	return s
}

// SetExtendedConfig sets the ExtendedConfig field's value.
func (s *SecretForDescribeSecretsOutput) SetExtendedConfig(v string) *SecretForDescribeSecretsOutput {
	s.ExtendedConfig = &v
	return s
}

// SetID sets the ID field's value.
func (s *SecretForDescribeSecretsOutput) SetID(v string) *SecretForDescribeSecretsOutput {
	s.ID = &v
	return s
}

// SetLastRotationTime sets the LastRotationTime field's value.
func (s *SecretForDescribeSecretsOutput) SetLastRotationTime(v string) *SecretForDescribeSecretsOutput {
	s.LastRotationTime = &v
	return s
}

// SetManaged sets the Managed field's value.
func (s *SecretForDescribeSecretsOutput) SetManaged(v bool) *SecretForDescribeSecretsOutput {
	s.Managed = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *SecretForDescribeSecretsOutput) SetProjectName(v string) *SecretForDescribeSecretsOutput {
	s.ProjectName = &v
	return s
}

// SetRotationInterval sets the RotationInterval field's value.
func (s *SecretForDescribeSecretsOutput) SetRotationInterval(v int32) *SecretForDescribeSecretsOutput {
	s.RotationInterval = &v
	return s
}

// SetRotationState sets the RotationState field's value.
func (s *SecretForDescribeSecretsOutput) SetRotationState(v string) *SecretForDescribeSecretsOutput {
	s.RotationState = &v
	return s
}

// SetScheduleDeleteTime sets the ScheduleDeleteTime field's value.
func (s *SecretForDescribeSecretsOutput) SetScheduleDeleteTime(v string) *SecretForDescribeSecretsOutput {
	s.ScheduleDeleteTime = &v
	return s
}

// SetScheduleRotationTime sets the ScheduleRotationTime field's value.
func (s *SecretForDescribeSecretsOutput) SetScheduleRotationTime(v string) *SecretForDescribeSecretsOutput {
	s.ScheduleRotationTime = &v
	return s
}

// SetSecretName sets the SecretName field's value.
func (s *SecretForDescribeSecretsOutput) SetSecretName(v string) *SecretForDescribeSecretsOutput {
	s.SecretName = &v
	return s
}

// SetSecretState sets the SecretState field's value.
func (s *SecretForDescribeSecretsOutput) SetSecretState(v string) *SecretForDescribeSecretsOutput {
	s.SecretState = &v
	return s
}

// SetSecretType sets the SecretType field's value.
func (s *SecretForDescribeSecretsOutput) SetSecretType(v string) *SecretForDescribeSecretsOutput {
	s.SecretType = &v
	return s
}

// SetTrn sets the Trn field's value.
func (s *SecretForDescribeSecretsOutput) SetTrn(v string) *SecretForDescribeSecretsOutput {
	s.Trn = &v
	return s
}

// SetUID sets the UID field's value.
func (s *SecretForDescribeSecretsOutput) SetUID(v string) *SecretForDescribeSecretsOutput {
	s.UID = &v
	return s
}

// SetUpdateDate sets the UpdateDate field's value.
func (s *SecretForDescribeSecretsOutput) SetUpdateDate(v int64) *SecretForDescribeSecretsOutput {
	s.UpdateDate = &v
	return s
}

const (
	// EnumOfSecretStateForDescribeSecretsOutputEnable is a EnumOfSecretStateForDescribeSecretsOutput enum value
	EnumOfSecretStateForDescribeSecretsOutputEnable = "Enable"

	// EnumOfSecretStateForDescribeSecretsOutputDisable is a EnumOfSecretStateForDescribeSecretsOutput enum value
	EnumOfSecretStateForDescribeSecretsOutputDisable = "Disable"

	// EnumOfSecretStateForDescribeSecretsOutputPendingDelete is a EnumOfSecretStateForDescribeSecretsOutput enum value
	EnumOfSecretStateForDescribeSecretsOutputPendingDelete = "PendingDelete"
)

const (
	// EnumOfSecretTypeForDescribeSecretsOutputGeneric is a EnumOfSecretTypeForDescribeSecretsOutput enum value
	EnumOfSecretTypeForDescribeSecretsOutputGeneric = "Generic"

	// EnumOfSecretTypeForDescribeSecretsOutputIam is a EnumOfSecretTypeForDescribeSecretsOutput enum value
	EnumOfSecretTypeForDescribeSecretsOutputIam = "IAM"

	// EnumOfSecretTypeForDescribeSecretsOutputRds is a EnumOfSecretTypeForDescribeSecretsOutput enum value
	EnumOfSecretTypeForDescribeSecretsOutputRds = "RDS"

	// EnumOfSecretTypeForDescribeSecretsOutputRedis is a EnumOfSecretTypeForDescribeSecretsOutput enum value
	EnumOfSecretTypeForDescribeSecretsOutputRedis = "Redis"

	// EnumOfSecretTypeForDescribeSecretsOutputEcs is a EnumOfSecretTypeForDescribeSecretsOutput enum value
	EnumOfSecretTypeForDescribeSecretsOutputEcs = "ECS"
)
