// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeCustomKeyStoresCommon = "DescribeCustomKeyStores"

// DescribeCustomKeyStoresCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeCustomKeyStoresCommon operation. The "output" return
// value will be populated with the DescribeCustomKeyStoresCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeCustomKeyStoresCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeCustomKeyStoresCommon Send returns without error.
//
// See DescribeCustomKeyStoresCommon for more information on using the DescribeCustomKeyStoresCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeCustomKeyStoresCommonRequest method.
//    req, resp := client.DescribeCustomKeyStoresCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) DescribeCustomKeyStoresCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeCustomKeyStoresCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeCustomKeyStoresCommon API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation DescribeCustomKeyStoresCommon for usage and error information.
func (c *KMS) DescribeCustomKeyStoresCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeCustomKeyStoresCommonRequest(input)
	return out, req.Send()
}

// DescribeCustomKeyStoresCommonWithContext is the same as DescribeCustomKeyStoresCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCustomKeyStoresCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) DescribeCustomKeyStoresCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeCustomKeyStoresCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeCustomKeyStores = "DescribeCustomKeyStores"

// DescribeCustomKeyStoresRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeCustomKeyStores operation. The "output" return
// value will be populated with the DescribeCustomKeyStoresCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeCustomKeyStoresCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeCustomKeyStoresCommon Send returns without error.
//
// See DescribeCustomKeyStores for more information on using the DescribeCustomKeyStores
// API call, and error handling.
//
//    // Example sending a request using the DescribeCustomKeyStoresRequest method.
//    req, resp := client.DescribeCustomKeyStoresRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) DescribeCustomKeyStoresRequest(input *DescribeCustomKeyStoresInput) (req *request.Request, output *DescribeCustomKeyStoresOutput) {
	op := &request.Operation{
		Name:       opDescribeCustomKeyStores,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeCustomKeyStoresInput{}
	}

	output = &DescribeCustomKeyStoresOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeCustomKeyStores API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation DescribeCustomKeyStores for usage and error information.
func (c *KMS) DescribeCustomKeyStores(input *DescribeCustomKeyStoresInput) (*DescribeCustomKeyStoresOutput, error) {
	req, out := c.DescribeCustomKeyStoresRequest(input)
	return out, req.Send()
}

// DescribeCustomKeyStoresWithContext is the same as DescribeCustomKeyStores with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeCustomKeyStores for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) DescribeCustomKeyStoresWithContext(ctx volcengine.Context, input *DescribeCustomKeyStoresInput, opts ...request.Option) (*DescribeCustomKeyStoresOutput, error) {
	req, out := c.DescribeCustomKeyStoresRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CustomKeyStoreForDescribeCustomKeyStoresOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ConnectionErrorCode *string `type:"string" json:",omitempty"`

	ConnectionState *string `type:"string" json:",omitempty" enum:"EnumOfConnectionStateForDescribeCustomKeyStoresOutput"`

	CreationDate *int64 `type:"int64" json:",omitempty"`

	CustomKeyStoreName *string `type:"string" json:",omitempty"`

	CustomKeyStoreType *string `type:"string" json:",omitempty" enum:"EnumOfCustomKeyStoreTypeForDescribeCustomKeyStoresOutput"`

	ID *string `type:"string" json:",omitempty"`

	TrustAnchorCertificate *string `type:"string" json:",omitempty"`

	UID *string `type:"string" json:",omitempty"`

	UpdateDate *int64 `type:"int64" json:",omitempty"`

	XksProxyConfiguration *XksProxyConfigurationForDescribeCustomKeyStoresOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s CustomKeyStoreForDescribeCustomKeyStoresOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomKeyStoreForDescribeCustomKeyStoresOutput) GoString() string {
	return s.String()
}

// SetConnectionErrorCode sets the ConnectionErrorCode field's value.
func (s *CustomKeyStoreForDescribeCustomKeyStoresOutput) SetConnectionErrorCode(v string) *CustomKeyStoreForDescribeCustomKeyStoresOutput {
	s.ConnectionErrorCode = &v
	return s
}

// SetConnectionState sets the ConnectionState field's value.
func (s *CustomKeyStoreForDescribeCustomKeyStoresOutput) SetConnectionState(v string) *CustomKeyStoreForDescribeCustomKeyStoresOutput {
	s.ConnectionState = &v
	return s
}

// SetCreationDate sets the CreationDate field's value.
func (s *CustomKeyStoreForDescribeCustomKeyStoresOutput) SetCreationDate(v int64) *CustomKeyStoreForDescribeCustomKeyStoresOutput {
	s.CreationDate = &v
	return s
}

// SetCustomKeyStoreName sets the CustomKeyStoreName field's value.
func (s *CustomKeyStoreForDescribeCustomKeyStoresOutput) SetCustomKeyStoreName(v string) *CustomKeyStoreForDescribeCustomKeyStoresOutput {
	s.CustomKeyStoreName = &v
	return s
}

// SetCustomKeyStoreType sets the CustomKeyStoreType field's value.
func (s *CustomKeyStoreForDescribeCustomKeyStoresOutput) SetCustomKeyStoreType(v string) *CustomKeyStoreForDescribeCustomKeyStoresOutput {
	s.CustomKeyStoreType = &v
	return s
}

// SetID sets the ID field's value.
func (s *CustomKeyStoreForDescribeCustomKeyStoresOutput) SetID(v string) *CustomKeyStoreForDescribeCustomKeyStoresOutput {
	s.ID = &v
	return s
}

// SetTrustAnchorCertificate sets the TrustAnchorCertificate field's value.
func (s *CustomKeyStoreForDescribeCustomKeyStoresOutput) SetTrustAnchorCertificate(v string) *CustomKeyStoreForDescribeCustomKeyStoresOutput {
	s.TrustAnchorCertificate = &v
	return s
}

// SetUID sets the UID field's value.
func (s *CustomKeyStoreForDescribeCustomKeyStoresOutput) SetUID(v string) *CustomKeyStoreForDescribeCustomKeyStoresOutput {
	s.UID = &v
	return s
}

// SetUpdateDate sets the UpdateDate field's value.
func (s *CustomKeyStoreForDescribeCustomKeyStoresOutput) SetUpdateDate(v int64) *CustomKeyStoreForDescribeCustomKeyStoresOutput {
	s.UpdateDate = &v
	return s
}

// SetXksProxyConfiguration sets the XksProxyConfiguration field's value.
func (s *CustomKeyStoreForDescribeCustomKeyStoresOutput) SetXksProxyConfiguration(v *XksProxyConfigurationForDescribeCustomKeyStoresOutput) *CustomKeyStoreForDescribeCustomKeyStoresOutput {
	s.XksProxyConfiguration = v
	return s
}

type DescribeCustomKeyStoresInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CurrentPage *int32 `min:"1" type:"int32" json:",omitempty"`

	CustomKeyStoreID *string `min:"36" max:"36" type:"string" json:",omitempty"`

	CustomKeyStoreName *string `min:"2" max:"31" type:"string" json:",omitempty"`

	PageSize *int32 `min:"1" max:"100" type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s DescribeCustomKeyStoresInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCustomKeyStoresInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeCustomKeyStoresInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeCustomKeyStoresInput"}
	if s.CurrentPage != nil && *s.CurrentPage < 1 {
		invalidParams.Add(request.NewErrParamMinValue("CurrentPage", 1))
	}
	if s.CustomKeyStoreID != nil && len(*s.CustomKeyStoreID) < 36 {
		invalidParams.Add(request.NewErrParamMinLen("CustomKeyStoreID", 36))
	}
	if s.CustomKeyStoreID != nil && len(*s.CustomKeyStoreID) > 36 {
		invalidParams.Add(request.NewErrParamMaxLen("CustomKeyStoreID", 36, *s.CustomKeyStoreID))
	}
	if s.CustomKeyStoreName != nil && len(*s.CustomKeyStoreName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("CustomKeyStoreName", 2))
	}
	if s.CustomKeyStoreName != nil && len(*s.CustomKeyStoreName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("CustomKeyStoreName", 31, *s.CustomKeyStoreName))
	}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}
	if s.PageSize != nil && *s.PageSize > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("PageSize", 100))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCurrentPage sets the CurrentPage field's value.
func (s *DescribeCustomKeyStoresInput) SetCurrentPage(v int32) *DescribeCustomKeyStoresInput {
	s.CurrentPage = &v
	return s
}

// SetCustomKeyStoreID sets the CustomKeyStoreID field's value.
func (s *DescribeCustomKeyStoresInput) SetCustomKeyStoreID(v string) *DescribeCustomKeyStoresInput {
	s.CustomKeyStoreID = &v
	return s
}

// SetCustomKeyStoreName sets the CustomKeyStoreName field's value.
func (s *DescribeCustomKeyStoresInput) SetCustomKeyStoreName(v string) *DescribeCustomKeyStoresInput {
	s.CustomKeyStoreName = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribeCustomKeyStoresInput) SetPageSize(v int32) *DescribeCustomKeyStoresInput {
	s.PageSize = &v
	return s
}

type DescribeCustomKeyStoresOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	CustomKeyStores []*CustomKeyStoreForDescribeCustomKeyStoresOutput `type:"list" json:",omitempty"`

	PageInfo *PageInfoForDescribeCustomKeyStoresOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s DescribeCustomKeyStoresOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeCustomKeyStoresOutput) GoString() string {
	return s.String()
}

// SetCustomKeyStores sets the CustomKeyStores field's value.
func (s *DescribeCustomKeyStoresOutput) SetCustomKeyStores(v []*CustomKeyStoreForDescribeCustomKeyStoresOutput) *DescribeCustomKeyStoresOutput {
	s.CustomKeyStores = v
	return s
}

// SetPageInfo sets the PageInfo field's value.
func (s *DescribeCustomKeyStoresOutput) SetPageInfo(v *PageInfoForDescribeCustomKeyStoresOutput) *DescribeCustomKeyStoresOutput {
	s.PageInfo = v
	return s
}

type PageInfoForDescribeCustomKeyStoresOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Count *int32 `type:"int32" json:",omitempty"`

	CurrentPage *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s PageInfoForDescribeCustomKeyStoresOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PageInfoForDescribeCustomKeyStoresOutput) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *PageInfoForDescribeCustomKeyStoresOutput) SetCount(v int32) *PageInfoForDescribeCustomKeyStoresOutput {
	s.Count = &v
	return s
}

// SetCurrentPage sets the CurrentPage field's value.
func (s *PageInfoForDescribeCustomKeyStoresOutput) SetCurrentPage(v int32) *PageInfoForDescribeCustomKeyStoresOutput {
	s.CurrentPage = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *PageInfoForDescribeCustomKeyStoresOutput) SetPageSize(v int32) *PageInfoForDescribeCustomKeyStoresOutput {
	s.PageSize = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *PageInfoForDescribeCustomKeyStoresOutput) SetTotalCount(v int32) *PageInfoForDescribeCustomKeyStoresOutput {
	s.TotalCount = &v
	return s
}

type XksProxyConfigurationForDescribeCustomKeyStoresOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AccessKey *string `type:"string" json:",omitempty"`

	Connectivity *string `type:"string" json:",omitempty"`

	UriEndpoint *string `type:"string" json:",omitempty"`

	UriPath *string `type:"string" json:",omitempty"`

	VpcEndpointServiceName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s XksProxyConfigurationForDescribeCustomKeyStoresOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s XksProxyConfigurationForDescribeCustomKeyStoresOutput) GoString() string {
	return s.String()
}

// SetAccessKey sets the AccessKey field's value.
func (s *XksProxyConfigurationForDescribeCustomKeyStoresOutput) SetAccessKey(v string) *XksProxyConfigurationForDescribeCustomKeyStoresOutput {
	s.AccessKey = &v
	return s
}

// SetConnectivity sets the Connectivity field's value.
func (s *XksProxyConfigurationForDescribeCustomKeyStoresOutput) SetConnectivity(v string) *XksProxyConfigurationForDescribeCustomKeyStoresOutput {
	s.Connectivity = &v
	return s
}

// SetUriEndpoint sets the UriEndpoint field's value.
func (s *XksProxyConfigurationForDescribeCustomKeyStoresOutput) SetUriEndpoint(v string) *XksProxyConfigurationForDescribeCustomKeyStoresOutput {
	s.UriEndpoint = &v
	return s
}

// SetUriPath sets the UriPath field's value.
func (s *XksProxyConfigurationForDescribeCustomKeyStoresOutput) SetUriPath(v string) *XksProxyConfigurationForDescribeCustomKeyStoresOutput {
	s.UriPath = &v
	return s
}

// SetVpcEndpointServiceName sets the VpcEndpointServiceName field's value.
func (s *XksProxyConfigurationForDescribeCustomKeyStoresOutput) SetVpcEndpointServiceName(v string) *XksProxyConfigurationForDescribeCustomKeyStoresOutput {
	s.VpcEndpointServiceName = &v
	return s
}

const (
	// EnumOfConnectionStateForDescribeCustomKeyStoresOutputConnected is a EnumOfConnectionStateForDescribeCustomKeyStoresOutput enum value
	EnumOfConnectionStateForDescribeCustomKeyStoresOutputConnected = "CONNECTED"

	// EnumOfConnectionStateForDescribeCustomKeyStoresOutputConnecting is a EnumOfConnectionStateForDescribeCustomKeyStoresOutput enum value
	EnumOfConnectionStateForDescribeCustomKeyStoresOutputConnecting = "CONNECTING"

	// EnumOfConnectionStateForDescribeCustomKeyStoresOutputFailed is a EnumOfConnectionStateForDescribeCustomKeyStoresOutput enum value
	EnumOfConnectionStateForDescribeCustomKeyStoresOutputFailed = "FAILED"

	// EnumOfConnectionStateForDescribeCustomKeyStoresOutputDisconnected is a EnumOfConnectionStateForDescribeCustomKeyStoresOutput enum value
	EnumOfConnectionStateForDescribeCustomKeyStoresOutputDisconnected = "DISCONNECTED"

	// EnumOfConnectionStateForDescribeCustomKeyStoresOutputDisconnecting is a EnumOfConnectionStateForDescribeCustomKeyStoresOutput enum value
	EnumOfConnectionStateForDescribeCustomKeyStoresOutputDisconnecting = "DISCONNECTING"
)

const (
	// EnumOfCustomKeyStoreTypeForDescribeCustomKeyStoresOutputExternalKeyStore is a EnumOfCustomKeyStoreTypeForDescribeCustomKeyStoresOutput enum value
	EnumOfCustomKeyStoreTypeForDescribeCustomKeyStoresOutputExternalKeyStore = "ExternalKeyStore"
)
