// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package kms

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opAsymmetricSignCommon = "AsymmetricSign"

// AsymmetricSignCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the AsymmetricSignCommon operation. The "output" return
// value will be populated with the AsymmetricSignCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned AsymmetricSignCommon Request to send the API call to the service.
// the "output" return value is not valid until after AsymmetricSignCommon Send returns without error.
//
// See AsymmetricSignCommon for more information on using the AsymmetricSignCommon
// API call, and error handling.
//
//    // Example sending a request using the AsymmetricSignCommonRequest method.
//    req, resp := client.AsymmetricSignCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) AsymmetricSignCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opAsymmetricSignCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// AsymmetricSignCommon API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation AsymmetricSignCommon for usage and error information.
func (c *KMS) AsymmetricSignCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.AsymmetricSignCommonRequest(input)
	return out, req.Send()
}

// AsymmetricSignCommonWithContext is the same as AsymmetricSignCommon with the addition of
// the ability to pass a context and additional request options.
//
// See AsymmetricSignCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) AsymmetricSignCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.AsymmetricSignCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAsymmetricSign = "AsymmetricSign"

// AsymmetricSignRequest generates a "volcengine/request.Request" representing the
// client's request for the AsymmetricSign operation. The "output" return
// value will be populated with the AsymmetricSignCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned AsymmetricSignCommon Request to send the API call to the service.
// the "output" return value is not valid until after AsymmetricSignCommon Send returns without error.
//
// See AsymmetricSign for more information on using the AsymmetricSign
// API call, and error handling.
//
//    // Example sending a request using the AsymmetricSignRequest method.
//    req, resp := client.AsymmetricSignRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KMS) AsymmetricSignRequest(input *AsymmetricSignInput) (req *request.Request, output *AsymmetricSignOutput) {
	op := &request.Operation{
		Name:       opAsymmetricSign,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AsymmetricSignInput{}
	}

	output = &AsymmetricSignOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// AsymmetricSign API operation for KMS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KMS's
// API operation AsymmetricSign for usage and error information.
func (c *KMS) AsymmetricSign(input *AsymmetricSignInput) (*AsymmetricSignOutput, error) {
	req, out := c.AsymmetricSignRequest(input)
	return out, req.Send()
}

// AsymmetricSignWithContext is the same as AsymmetricSign with the addition of
// the ability to pass a context and additional request options.
//
// See AsymmetricSign for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KMS) AsymmetricSignWithContext(ctx volcengine.Context, input *AsymmetricSignInput, opts ...request.Option) (*AsymmetricSignOutput, error) {
	req, out := c.AsymmetricSignRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AsymmetricSignInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// Algorithm is a required field
	Algorithm *string `type:"string" json:",omitempty" required:"true"`

	KeyID *string `type:"string" json:",omitempty"`

	KeyName *string `min:"2" max:"31" type:"string" json:",omitempty"`

	KeyringName *string `min:"2" max:"31" type:"string" json:",omitempty"`

	// Message is a required field
	Message *string `type:"string" json:",omitempty" required:"true"`

	MessageType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s AsymmetricSignInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AsymmetricSignInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AsymmetricSignInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AsymmetricSignInput"}
	if s.Algorithm == nil {
		invalidParams.Add(request.NewErrParamRequired("Algorithm"))
	}
	if s.KeyName != nil && len(*s.KeyName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("KeyName", 2))
	}
	if s.KeyName != nil && len(*s.KeyName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("KeyName", 31, *s.KeyName))
	}
	if s.KeyringName != nil && len(*s.KeyringName) < 2 {
		invalidParams.Add(request.NewErrParamMinLen("KeyringName", 2))
	}
	if s.KeyringName != nil && len(*s.KeyringName) > 31 {
		invalidParams.Add(request.NewErrParamMaxLen("KeyringName", 31, *s.KeyringName))
	}
	if s.Message == nil {
		invalidParams.Add(request.NewErrParamRequired("Message"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAlgorithm sets the Algorithm field's value.
func (s *AsymmetricSignInput) SetAlgorithm(v string) *AsymmetricSignInput {
	s.Algorithm = &v
	return s
}

// SetKeyID sets the KeyID field's value.
func (s *AsymmetricSignInput) SetKeyID(v string) *AsymmetricSignInput {
	s.KeyID = &v
	return s
}

// SetKeyName sets the KeyName field's value.
func (s *AsymmetricSignInput) SetKeyName(v string) *AsymmetricSignInput {
	s.KeyName = &v
	return s
}

// SetKeyringName sets the KeyringName field's value.
func (s *AsymmetricSignInput) SetKeyringName(v string) *AsymmetricSignInput {
	s.KeyringName = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *AsymmetricSignInput) SetMessage(v string) *AsymmetricSignInput {
	s.Message = &v
	return s
}

// SetMessageType sets the MessageType field's value.
func (s *AsymmetricSignInput) SetMessageType(v string) *AsymmetricSignInput {
	s.MessageType = &v
	return s
}

type AsymmetricSignOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	KeyID *string `type:"string" json:",omitempty"`

	Signature *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s AsymmetricSignOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AsymmetricSignOutput) GoString() string {
	return s.String()
}

// SetKeyID sets the KeyID field's value.
func (s *AsymmetricSignOutput) SetKeyID(v string) *AsymmetricSignOutput {
	s.KeyID = &v
	return s
}

// SetSignature sets the Signature field's value.
func (s *AsymmetricSignOutput) SetSignature(v string) *AsymmetricSignOutput {
	s.Signature = &v
	return s
}
