// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package kafka

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeTopicPartitionsCommon = "DescribeTopicPartitions"

// DescribeTopicPartitionsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeTopicPartitionsCommon operation. The "output" return
// value will be populated with the DescribeTopicPartitionsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeTopicPartitionsCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeTopicPartitionsCommon Send returns without error.
//
// See DescribeTopicPartitionsCommon for more information on using the DescribeTopicPartitionsCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeTopicPartitionsCommonRequest method.
//    req, resp := client.DescribeTopicPartitionsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KAFKA) DescribeTopicPartitionsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeTopicPartitionsCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeTopicPartitionsCommon API operation for KAFKA.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KAFKA's
// API operation DescribeTopicPartitionsCommon for usage and error information.
func (c *KAFKA) DescribeTopicPartitionsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeTopicPartitionsCommonRequest(input)
	return out, req.Send()
}

// DescribeTopicPartitionsCommonWithContext is the same as DescribeTopicPartitionsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTopicPartitionsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KAFKA) DescribeTopicPartitionsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeTopicPartitionsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeTopicPartitions = "DescribeTopicPartitions"

// DescribeTopicPartitionsRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeTopicPartitions operation. The "output" return
// value will be populated with the DescribeTopicPartitionsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeTopicPartitionsCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeTopicPartitionsCommon Send returns without error.
//
// See DescribeTopicPartitions for more information on using the DescribeTopicPartitions
// API call, and error handling.
//
//    // Example sending a request using the DescribeTopicPartitionsRequest method.
//    req, resp := client.DescribeTopicPartitionsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *KAFKA) DescribeTopicPartitionsRequest(input *DescribeTopicPartitionsInput) (req *request.Request, output *DescribeTopicPartitionsOutput) {
	op := &request.Operation{
		Name:       opDescribeTopicPartitions,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTopicPartitionsInput{}
	}

	output = &DescribeTopicPartitionsOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeTopicPartitions API operation for KAFKA.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for KAFKA's
// API operation DescribeTopicPartitions for usage and error information.
func (c *KAFKA) DescribeTopicPartitions(input *DescribeTopicPartitionsInput) (*DescribeTopicPartitionsOutput, error) {
	req, out := c.DescribeTopicPartitionsRequest(input)
	return out, req.Send()
}

// DescribeTopicPartitionsWithContext is the same as DescribeTopicPartitions with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeTopicPartitions for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *KAFKA) DescribeTopicPartitionsWithContext(ctx volcengine.Context, input *DescribeTopicPartitionsInput, opts ...request.Option) (*DescribeTopicPartitionsOutput, error) {
	req, out := c.DescribeTopicPartitionsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type DescribeTopicPartitionsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// InstanceId is a required field
	InstanceId *string `type:"string" json:",omitempty" required:"true"`

	// PageNumber is a required field
	PageNumber *int32 `type:"int32" json:",omitempty" required:"true"`

	// PageSize is a required field
	PageSize *int32 `type:"int32" json:",omitempty" required:"true"`

	PartitionIds []*int32 `type:"list" json:",omitempty"`

	// TopicName is a required field
	TopicName *string `type:"string" json:",omitempty" required:"true"`

	UnderInsyncOnly *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s DescribeTopicPartitionsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTopicPartitionsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTopicPartitionsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeTopicPartitionsInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}
	if s.PageNumber == nil {
		invalidParams.Add(request.NewErrParamRequired("PageNumber"))
	}
	if s.PageSize == nil {
		invalidParams.Add(request.NewErrParamRequired("PageSize"))
	}
	if s.TopicName == nil {
		invalidParams.Add(request.NewErrParamRequired("TopicName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeTopicPartitionsInput) SetInstanceId(v string) *DescribeTopicPartitionsInput {
	s.InstanceId = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *DescribeTopicPartitionsInput) SetPageNumber(v int32) *DescribeTopicPartitionsInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribeTopicPartitionsInput) SetPageSize(v int32) *DescribeTopicPartitionsInput {
	s.PageSize = &v
	return s
}

// SetPartitionIds sets the PartitionIds field's value.
func (s *DescribeTopicPartitionsInput) SetPartitionIds(v []*int32) *DescribeTopicPartitionsInput {
	s.PartitionIds = v
	return s
}

// SetTopicName sets the TopicName field's value.
func (s *DescribeTopicPartitionsInput) SetTopicName(v string) *DescribeTopicPartitionsInput {
	s.TopicName = &v
	return s
}

// SetUnderInsyncOnly sets the UnderInsyncOnly field's value.
func (s *DescribeTopicPartitionsInput) SetUnderInsyncOnly(v bool) *DescribeTopicPartitionsInput {
	s.UnderInsyncOnly = &v
	return s
}

type DescribeTopicPartitionsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	PartitionsInfo []*PartitionsInfoForDescribeTopicPartitionsOutput `type:"list" json:",omitempty"`

	Total *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s DescribeTopicPartitionsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeTopicPartitionsOutput) GoString() string {
	return s.String()
}

// SetPartitionsInfo sets the PartitionsInfo field's value.
func (s *DescribeTopicPartitionsOutput) SetPartitionsInfo(v []*PartitionsInfoForDescribeTopicPartitionsOutput) *DescribeTopicPartitionsOutput {
	s.PartitionsInfo = v
	return s
}

// SetTotal sets the Total field's value.
func (s *DescribeTopicPartitionsOutput) SetTotal(v int32) *DescribeTopicPartitionsOutput {
	s.Total = &v
	return s
}

type PartitionsInfoForDescribeTopicPartitionsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	EndOffset *int64 `type:"int64" json:",omitempty"`

	InsyncReplicas []*int32 `type:"list" json:",omitempty"`

	Leader *int32 `type:"int32" json:",omitempty"`

	MessageCount *int64 `type:"int64" json:",omitempty"`

	PartitionId *int32 `type:"int32" json:",omitempty"`

	Replicas []*int32 `type:"list" json:",omitempty"`

	StartOffset *int64 `type:"int64" json:",omitempty"`

	UnderInsyncReplicas []*int32 `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s PartitionsInfoForDescribeTopicPartitionsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PartitionsInfoForDescribeTopicPartitionsOutput) GoString() string {
	return s.String()
}

// SetEndOffset sets the EndOffset field's value.
func (s *PartitionsInfoForDescribeTopicPartitionsOutput) SetEndOffset(v int64) *PartitionsInfoForDescribeTopicPartitionsOutput {
	s.EndOffset = &v
	return s
}

// SetInsyncReplicas sets the InsyncReplicas field's value.
func (s *PartitionsInfoForDescribeTopicPartitionsOutput) SetInsyncReplicas(v []*int32) *PartitionsInfoForDescribeTopicPartitionsOutput {
	s.InsyncReplicas = v
	return s
}

// SetLeader sets the Leader field's value.
func (s *PartitionsInfoForDescribeTopicPartitionsOutput) SetLeader(v int32) *PartitionsInfoForDescribeTopicPartitionsOutput {
	s.Leader = &v
	return s
}

// SetMessageCount sets the MessageCount field's value.
func (s *PartitionsInfoForDescribeTopicPartitionsOutput) SetMessageCount(v int64) *PartitionsInfoForDescribeTopicPartitionsOutput {
	s.MessageCount = &v
	return s
}

// SetPartitionId sets the PartitionId field's value.
func (s *PartitionsInfoForDescribeTopicPartitionsOutput) SetPartitionId(v int32) *PartitionsInfoForDescribeTopicPartitionsOutput {
	s.PartitionId = &v
	return s
}

// SetReplicas sets the Replicas field's value.
func (s *PartitionsInfoForDescribeTopicPartitionsOutput) SetReplicas(v []*int32) *PartitionsInfoForDescribeTopicPartitionsOutput {
	s.Replicas = v
	return s
}

// SetStartOffset sets the StartOffset field's value.
func (s *PartitionsInfoForDescribeTopicPartitionsOutput) SetStartOffset(v int64) *PartitionsInfoForDescribeTopicPartitionsOutput {
	s.StartOffset = &v
	return s
}

// SetUnderInsyncReplicas sets the UnderInsyncReplicas field's value.
func (s *PartitionsInfoForDescribeTopicPartitionsOutput) SetUnderInsyncReplicas(v []*int32) *PartitionsInfoForDescribeTopicPartitionsOutput {
	s.UnderInsyncReplicas = v
	return s
}
