// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package gtm

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListPoolsCommon = "ListPools"

// ListPoolsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListPoolsCommon operation. The "output" return
// value will be populated with the ListPoolsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListPoolsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListPoolsCommon Send returns without error.
//
// See ListPoolsCommon for more information on using the ListPoolsCommon
// API call, and error handling.
//
//    // Example sending a request using the ListPoolsCommonRequest method.
//    req, resp := client.ListPoolsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *GTM) ListPoolsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListPoolsCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// ListPoolsCommon API operation for GTM.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for GTM's
// API operation ListPoolsCommon for usage and error information.
func (c *GTM) ListPoolsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListPoolsCommonRequest(input)
	return out, req.Send()
}

// ListPoolsCommonWithContext is the same as ListPoolsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListPoolsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GTM) ListPoolsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListPoolsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPools = "ListPools"

// ListPoolsRequest generates a "volcengine/request.Request" representing the
// client's request for the ListPools operation. The "output" return
// value will be populated with the ListPoolsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListPoolsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListPoolsCommon Send returns without error.
//
// See ListPools for more information on using the ListPools
// API call, and error handling.
//
//    // Example sending a request using the ListPoolsRequest method.
//    req, resp := client.ListPoolsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *GTM) ListPoolsRequest(input *ListPoolsInput) (req *request.Request, output *ListPoolsOutput) {
	op := &request.Operation{
		Name:       opListPools,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListPoolsInput{}
	}

	output = &ListPoolsOutput{}
	req = c.newRequest(op, input, output)

	return
}

// ListPools API operation for GTM.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for GTM's
// API operation ListPools for usage and error information.
func (c *GTM) ListPools(input *ListPoolsInput) (*ListPoolsOutput, error) {
	req, out := c.ListPoolsRequest(input)
	return out, req.Send()
}

// ListPoolsWithContext is the same as ListPools with the addition of
// the ability to pass a context and additional request options.
//
// See ListPools for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GTM) ListPoolsWithContext(ctx volcengine.Context, input *ListPoolsInput, opts ...request.Option) (*ListPoolsOutput, error) {
	req, out := c.ListPoolsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AddressForListPoolsOutput struct {
	_ struct{} `type:"structure"`

	Geo *string `type:"string"`

	Mode *string `type:"string"`

	RectifiedGeos []*string `type:"list"`

	Value *string `type:"string"`

	Weight *int32 `type:"int32"`
}

// String returns the string representation
func (s AddressForListPoolsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AddressForListPoolsOutput) GoString() string {
	return s.String()
}

// SetGeo sets the Geo field's value.
func (s *AddressForListPoolsOutput) SetGeo(v string) *AddressForListPoolsOutput {
	s.Geo = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *AddressForListPoolsOutput) SetMode(v string) *AddressForListPoolsOutput {
	s.Mode = &v
	return s
}

// SetRectifiedGeos sets the RectifiedGeos field's value.
func (s *AddressForListPoolsOutput) SetRectifiedGeos(v []*string) *AddressForListPoolsOutput {
	s.RectifiedGeos = v
	return s
}

// SetValue sets the Value field's value.
func (s *AddressForListPoolsOutput) SetValue(v string) *AddressForListPoolsOutput {
	s.Value = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *AddressForListPoolsOutput) SetWeight(v int32) *AddressForListPoolsOutput {
	s.Weight = &v
	return s
}

type DataForListPoolsOutput struct {
	_ struct{} `type:"structure"`

	AddrType *string `type:"string"`

	Addresses []*AddressForListPoolsOutput `type:"list"`

	Capacity *int32 `type:"int32"`

	CapacityMode *string `type:"string" enum:"EnumOfCapacityModeForListPoolsOutput"`

	CreateTime *string `type:"string"`

	Deletable *bool `type:"boolean"`

	Name *string `type:"string"`

	PoolId *string `type:"string"`

	Remark *string `type:"string"`

	UpdateTime *string `type:"string"`
}

// String returns the string representation
func (s DataForListPoolsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DataForListPoolsOutput) GoString() string {
	return s.String()
}

// SetAddrType sets the AddrType field's value.
func (s *DataForListPoolsOutput) SetAddrType(v string) *DataForListPoolsOutput {
	s.AddrType = &v
	return s
}

// SetAddresses sets the Addresses field's value.
func (s *DataForListPoolsOutput) SetAddresses(v []*AddressForListPoolsOutput) *DataForListPoolsOutput {
	s.Addresses = v
	return s
}

// SetCapacity sets the Capacity field's value.
func (s *DataForListPoolsOutput) SetCapacity(v int32) *DataForListPoolsOutput {
	s.Capacity = &v
	return s
}

// SetCapacityMode sets the CapacityMode field's value.
func (s *DataForListPoolsOutput) SetCapacityMode(v string) *DataForListPoolsOutput {
	s.CapacityMode = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *DataForListPoolsOutput) SetCreateTime(v string) *DataForListPoolsOutput {
	s.CreateTime = &v
	return s
}

// SetDeletable sets the Deletable field's value.
func (s *DataForListPoolsOutput) SetDeletable(v bool) *DataForListPoolsOutput {
	s.Deletable = &v
	return s
}

// SetName sets the Name field's value.
func (s *DataForListPoolsOutput) SetName(v string) *DataForListPoolsOutput {
	s.Name = &v
	return s
}

// SetPoolId sets the PoolId field's value.
func (s *DataForListPoolsOutput) SetPoolId(v string) *DataForListPoolsOutput {
	s.PoolId = &v
	return s
}

// SetRemark sets the Remark field's value.
func (s *DataForListPoolsOutput) SetRemark(v string) *DataForListPoolsOutput {
	s.Remark = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *DataForListPoolsOutput) SetUpdateTime(v string) *DataForListPoolsOutput {
	s.UpdateTime = &v
	return s
}

type ListPoolsInput struct {
	_ struct{} `type:"structure"`

	AddrType *string `type:"string"`

	Address *string `type:"string"`

	// GtmId is a required field
	GtmId *string `type:"string" required:"true"`

	Name *string `type:"string"`

	PageNumber *int32 `type:"int32"`

	PageSize *int32 `type:"int32"`

	PoolId *string `type:"string"`

	Remark *string `type:"string"`

	SearchMode *string `type:"string"`

	SortBy *string `type:"string"`

	SortOrder *string `type:"string"`
}

// String returns the string representation
func (s ListPoolsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPoolsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPoolsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPoolsInput"}
	if s.GtmId == nil {
		invalidParams.Add(request.NewErrParamRequired("GtmId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddrType sets the AddrType field's value.
func (s *ListPoolsInput) SetAddrType(v string) *ListPoolsInput {
	s.AddrType = &v
	return s
}

// SetAddress sets the Address field's value.
func (s *ListPoolsInput) SetAddress(v string) *ListPoolsInput {
	s.Address = &v
	return s
}

// SetGtmId sets the GtmId field's value.
func (s *ListPoolsInput) SetGtmId(v string) *ListPoolsInput {
	s.GtmId = &v
	return s
}

// SetName sets the Name field's value.
func (s *ListPoolsInput) SetName(v string) *ListPoolsInput {
	s.Name = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListPoolsInput) SetPageNumber(v int32) *ListPoolsInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListPoolsInput) SetPageSize(v int32) *ListPoolsInput {
	s.PageSize = &v
	return s
}

// SetPoolId sets the PoolId field's value.
func (s *ListPoolsInput) SetPoolId(v string) *ListPoolsInput {
	s.PoolId = &v
	return s
}

// SetRemark sets the Remark field's value.
func (s *ListPoolsInput) SetRemark(v string) *ListPoolsInput {
	s.Remark = &v
	return s
}

// SetSearchMode sets the SearchMode field's value.
func (s *ListPoolsInput) SetSearchMode(v string) *ListPoolsInput {
	s.SearchMode = &v
	return s
}

// SetSortBy sets the SortBy field's value.
func (s *ListPoolsInput) SetSortBy(v string) *ListPoolsInput {
	s.SortBy = &v
	return s
}

// SetSortOrder sets the SortOrder field's value.
func (s *ListPoolsInput) SetSortOrder(v string) *ListPoolsInput {
	s.SortOrder = &v
	return s
}

type ListPoolsOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	Data []*DataForListPoolsOutput `type:"list"`

	PageNumber *int32 `type:"int32"`

	PageSize *int32 `type:"int32"`

	TotalCount *int32 `type:"int32"`
}

// String returns the string representation
func (s ListPoolsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPoolsOutput) GoString() string {
	return s.String()
}

// SetData sets the Data field's value.
func (s *ListPoolsOutput) SetData(v []*DataForListPoolsOutput) *ListPoolsOutput {
	s.Data = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListPoolsOutput) SetPageNumber(v int32) *ListPoolsOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListPoolsOutput) SetPageSize(v int32) *ListPoolsOutput {
	s.PageSize = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListPoolsOutput) SetTotalCount(v int32) *ListPoolsOutput {
	s.TotalCount = &v
	return s
}

const (
	// EnumOfCapacityModeForListPoolsOutputPool is a EnumOfCapacityModeForListPoolsOutput enum value
	EnumOfCapacityModeForListPoolsOutputPool = "pool"

	// EnumOfCapacityModeForListPoolsOutputAddress is a EnumOfCapacityModeForListPoolsOutput enum value
	EnumOfCapacityModeForListPoolsOutputAddress = "address"
)
