// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package gtm

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opGetPoolCommon = "GetPool"

// GetPoolCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the GetPoolCommon operation. The "output" return
// value will be populated with the GetPoolCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GetPoolCommon Request to send the API call to the service.
// the "output" return value is not valid until after GetPoolCommon Send returns without error.
//
// See GetPoolCommon for more information on using the GetPoolCommon
// API call, and error handling.
//
//    // Example sending a request using the GetPoolCommonRequest method.
//    req, resp := client.GetPoolCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *GTM) GetPoolCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opGetPoolCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// GetPoolCommon API operation for GTM.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for GTM's
// API operation GetPoolCommon for usage and error information.
func (c *GTM) GetPoolCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.GetPoolCommonRequest(input)
	return out, req.Send()
}

// GetPoolCommonWithContext is the same as GetPoolCommon with the addition of
// the ability to pass a context and additional request options.
//
// See GetPoolCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GTM) GetPoolCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.GetPoolCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetPool = "GetPool"

// GetPoolRequest generates a "volcengine/request.Request" representing the
// client's request for the GetPool operation. The "output" return
// value will be populated with the GetPoolCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned GetPoolCommon Request to send the API call to the service.
// the "output" return value is not valid until after GetPoolCommon Send returns without error.
//
// See GetPool for more information on using the GetPool
// API call, and error handling.
//
//    // Example sending a request using the GetPoolRequest method.
//    req, resp := client.GetPoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *GTM) GetPoolRequest(input *GetPoolInput) (req *request.Request, output *GetPoolOutput) {
	op := &request.Operation{
		Name:       opGetPool,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetPoolInput{}
	}

	output = &GetPoolOutput{}
	req = c.newRequest(op, input, output)

	return
}

// GetPool API operation for GTM.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for GTM's
// API operation GetPool for usage and error information.
func (c *GTM) GetPool(input *GetPoolInput) (*GetPoolOutput, error) {
	req, out := c.GetPoolRequest(input)
	return out, req.Send()
}

// GetPoolWithContext is the same as GetPool with the addition of
// the ability to pass a context and additional request options.
//
// See GetPool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GTM) GetPoolWithContext(ctx volcengine.Context, input *GetPoolInput, opts ...request.Option) (*GetPoolOutput, error) {
	req, out := c.GetPoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AddressForGetPoolOutput struct {
	_ struct{} `type:"structure"`

	Geo *string `type:"string"`

	Mode *string `type:"string"`

	RectifiedGeos []*string `type:"list"`

	Value *string `type:"string"`

	Weight *int32 `type:"int32"`
}

// String returns the string representation
func (s AddressForGetPoolOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AddressForGetPoolOutput) GoString() string {
	return s.String()
}

// SetGeo sets the Geo field's value.
func (s *AddressForGetPoolOutput) SetGeo(v string) *AddressForGetPoolOutput {
	s.Geo = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *AddressForGetPoolOutput) SetMode(v string) *AddressForGetPoolOutput {
	s.Mode = &v
	return s
}

// SetRectifiedGeos sets the RectifiedGeos field's value.
func (s *AddressForGetPoolOutput) SetRectifiedGeos(v []*string) *AddressForGetPoolOutput {
	s.RectifiedGeos = v
	return s
}

// SetValue sets the Value field's value.
func (s *AddressForGetPoolOutput) SetValue(v string) *AddressForGetPoolOutput {
	s.Value = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *AddressForGetPoolOutput) SetWeight(v int32) *AddressForGetPoolOutput {
	s.Weight = &v
	return s
}

type GetPoolInput struct {
	_ struct{} `type:"structure"`

	// GtmId is a required field
	GtmId *string `type:"string" required:"true"`

	// PoolId is a required field
	PoolId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s GetPoolInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetPoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetPoolInput"}
	if s.GtmId == nil {
		invalidParams.Add(request.NewErrParamRequired("GtmId"))
	}
	if s.PoolId == nil {
		invalidParams.Add(request.NewErrParamRequired("PoolId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGtmId sets the GtmId field's value.
func (s *GetPoolInput) SetGtmId(v string) *GetPoolInput {
	s.GtmId = &v
	return s
}

// SetPoolId sets the PoolId field's value.
func (s *GetPoolInput) SetPoolId(v string) *GetPoolInput {
	s.PoolId = &v
	return s
}

type GetPoolOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	AddrType *string `type:"string"`

	Addresses []*AddressForGetPoolOutput `type:"list"`

	Capacity *int32 `type:"int32"`

	CapacityMode *string `type:"string"`

	CreateTime *string `type:"string"`

	Deletable *bool `type:"boolean"`

	Name *string `type:"string"`

	PoolId *string `type:"string"`

	Remark *string `type:"string"`

	UpdateTime *string `type:"string"`
}

// String returns the string representation
func (s GetPoolOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GetPoolOutput) GoString() string {
	return s.String()
}

// SetAddrType sets the AddrType field's value.
func (s *GetPoolOutput) SetAddrType(v string) *GetPoolOutput {
	s.AddrType = &v
	return s
}

// SetAddresses sets the Addresses field's value.
func (s *GetPoolOutput) SetAddresses(v []*AddressForGetPoolOutput) *GetPoolOutput {
	s.Addresses = v
	return s
}

// SetCapacity sets the Capacity field's value.
func (s *GetPoolOutput) SetCapacity(v int32) *GetPoolOutput {
	s.Capacity = &v
	return s
}

// SetCapacityMode sets the CapacityMode field's value.
func (s *GetPoolOutput) SetCapacityMode(v string) *GetPoolOutput {
	s.CapacityMode = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *GetPoolOutput) SetCreateTime(v string) *GetPoolOutput {
	s.CreateTime = &v
	return s
}

// SetDeletable sets the Deletable field's value.
func (s *GetPoolOutput) SetDeletable(v bool) *GetPoolOutput {
	s.Deletable = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetPoolOutput) SetName(v string) *GetPoolOutput {
	s.Name = &v
	return s
}

// SetPoolId sets the PoolId field's value.
func (s *GetPoolOutput) SetPoolId(v string) *GetPoolOutput {
	s.PoolId = &v
	return s
}

// SetRemark sets the Remark field's value.
func (s *GetPoolOutput) SetRemark(v string) *GetPoolOutput {
	s.Remark = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *GetPoolOutput) SetUpdateTime(v string) *GetPoolOutput {
	s.UpdateTime = &v
	return s
}
