// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package gtm

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreatePoolCommon = "CreatePool"

// CreatePoolCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreatePoolCommon operation. The "output" return
// value will be populated with the CreatePoolCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreatePoolCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreatePoolCommon Send returns without error.
//
// See CreatePoolCommon for more information on using the CreatePoolCommon
// API call, and error handling.
//
//    // Example sending a request using the CreatePoolCommonRequest method.
//    req, resp := client.CreatePoolCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *GTM) CreatePoolCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreatePoolCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreatePoolCommon API operation for GTM.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for GTM's
// API operation CreatePoolCommon for usage and error information.
func (c *GTM) CreatePoolCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreatePoolCommonRequest(input)
	return out, req.Send()
}

// CreatePoolCommonWithContext is the same as CreatePoolCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePoolCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GTM) CreatePoolCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreatePoolCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreatePool = "CreatePool"

// CreatePoolRequest generates a "volcengine/request.Request" representing the
// client's request for the CreatePool operation. The "output" return
// value will be populated with the CreatePoolCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreatePoolCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreatePoolCommon Send returns without error.
//
// See CreatePool for more information on using the CreatePool
// API call, and error handling.
//
//    // Example sending a request using the CreatePoolRequest method.
//    req, resp := client.CreatePoolRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *GTM) CreatePoolRequest(input *CreatePoolInput) (req *request.Request, output *CreatePoolOutput) {
	op := &request.Operation{
		Name:       opCreatePool,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreatePoolInput{}
	}

	output = &CreatePoolOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreatePool API operation for GTM.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for GTM's
// API operation CreatePool for usage and error information.
func (c *GTM) CreatePool(input *CreatePoolInput) (*CreatePoolOutput, error) {
	req, out := c.CreatePoolRequest(input)
	return out, req.Send()
}

// CreatePoolWithContext is the same as CreatePool with the addition of
// the ability to pass a context and additional request options.
//
// See CreatePool for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GTM) CreatePoolWithContext(ctx volcengine.Context, input *CreatePoolInput, opts ...request.Option) (*CreatePoolOutput, error) {
	req, out := c.CreatePoolRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AddressForCreatePoolInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Capacity *int64 `type:"int64" json:",omitempty"`

	Mode *string `type:"string" json:",omitempty"`

	RectifiedGeos []*string `type:"list" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`

	Weight *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s AddressForCreatePoolInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AddressForCreatePoolInput) GoString() string {
	return s.String()
}

// SetCapacity sets the Capacity field's value.
func (s *AddressForCreatePoolInput) SetCapacity(v int64) *AddressForCreatePoolInput {
	s.Capacity = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *AddressForCreatePoolInput) SetMode(v string) *AddressForCreatePoolInput {
	s.Mode = &v
	return s
}

// SetRectifiedGeos sets the RectifiedGeos field's value.
func (s *AddressForCreatePoolInput) SetRectifiedGeos(v []*string) *AddressForCreatePoolInput {
	s.RectifiedGeos = v
	return s
}

// SetValue sets the Value field's value.
func (s *AddressForCreatePoolInput) SetValue(v string) *AddressForCreatePoolInput {
	s.Value = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *AddressForCreatePoolInput) SetWeight(v int32) *AddressForCreatePoolInput {
	s.Weight = &v
	return s
}

type CreatePoolInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// GtmId is a required field
	GtmId *string `type:"string" json:",omitempty" required:"true"`

	Pool *PoolForCreatePoolInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s CreatePoolInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePoolInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreatePoolInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreatePoolInput"}
	if s.GtmId == nil {
		invalidParams.Add(request.NewErrParamRequired("GtmId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGtmId sets the GtmId field's value.
func (s *CreatePoolInput) SetGtmId(v string) *CreatePoolInput {
	s.GtmId = &v
	return s
}

// SetPool sets the Pool field's value.
func (s *CreatePoolInput) SetPool(v *PoolForCreatePoolInput) *CreatePoolInput {
	s.Pool = v
	return s
}

type CreatePoolOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	PoolId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreatePoolOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreatePoolOutput) GoString() string {
	return s.String()
}

// SetPoolId sets the PoolId field's value.
func (s *CreatePoolOutput) SetPoolId(v string) *CreatePoolOutput {
	s.PoolId = &v
	return s
}

type PoolForCreatePoolInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AddrType *string `type:"string" json:",omitempty"`

	Addresses []*AddressForCreatePoolInput `type:"list" json:",omitempty"`

	Capacity *int32 `type:"int32" json:",omitempty"`

	CapacityMode *string `type:"string" json:",omitempty" enum:"EnumOfCapacityModeForCreatePoolInput"`

	Name *string `type:"string" json:",omitempty"`

	Remark *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s PoolForCreatePoolInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PoolForCreatePoolInput) GoString() string {
	return s.String()
}

// SetAddrType sets the AddrType field's value.
func (s *PoolForCreatePoolInput) SetAddrType(v string) *PoolForCreatePoolInput {
	s.AddrType = &v
	return s
}

// SetAddresses sets the Addresses field's value.
func (s *PoolForCreatePoolInput) SetAddresses(v []*AddressForCreatePoolInput) *PoolForCreatePoolInput {
	s.Addresses = v
	return s
}

// SetCapacity sets the Capacity field's value.
func (s *PoolForCreatePoolInput) SetCapacity(v int32) *PoolForCreatePoolInput {
	s.Capacity = &v
	return s
}

// SetCapacityMode sets the CapacityMode field's value.
func (s *PoolForCreatePoolInput) SetCapacityMode(v string) *PoolForCreatePoolInput {
	s.CapacityMode = &v
	return s
}

// SetName sets the Name field's value.
func (s *PoolForCreatePoolInput) SetName(v string) *PoolForCreatePoolInput {
	s.Name = &v
	return s
}

// SetRemark sets the Remark field's value.
func (s *PoolForCreatePoolInput) SetRemark(v string) *PoolForCreatePoolInput {
	s.Remark = &v
	return s
}

const (
	// EnumOfCapacityModeForCreatePoolInputPool is a EnumOfCapacityModeForCreatePoolInput enum value
	EnumOfCapacityModeForCreatePoolInputPool = "pool"

	// EnumOfCapacityModeForCreatePoolInputAddress is a EnumOfCapacityModeForCreatePoolInput enum value
	EnumOfCapacityModeForCreatePoolInputAddress = "address"
)
