// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package graph

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateInstanceCommon = "CreateInstance"

// CreateInstanceCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateInstanceCommon operation. The "output" return
// value will be populated with the CreateInstanceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateInstanceCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateInstanceCommon Send returns without error.
//
// See CreateInstanceCommon for more information on using the CreateInstanceCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateInstanceCommonRequest method.
//    req, resp := client.CreateInstanceCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *GRAPH) CreateInstanceCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateInstanceCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateInstanceCommon API operation for GRAPH.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for GRAPH's
// API operation CreateInstanceCommon for usage and error information.
func (c *GRAPH) CreateInstanceCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateInstanceCommonRequest(input)
	return out, req.Send()
}

// CreateInstanceCommonWithContext is the same as CreateInstanceCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInstanceCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GRAPH) CreateInstanceCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateInstanceCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateInstance = "CreateInstance"

// CreateInstanceRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateInstance operation. The "output" return
// value will be populated with the CreateInstanceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateInstanceCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateInstanceCommon Send returns without error.
//
// See CreateInstance for more information on using the CreateInstance
// API call, and error handling.
//
//    // Example sending a request using the CreateInstanceRequest method.
//    req, resp := client.CreateInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *GRAPH) CreateInstanceRequest(input *CreateInstanceInput) (req *request.Request, output *CreateInstanceOutput) {
	op := &request.Operation{
		Name:       opCreateInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateInstanceInput{}
	}

	output = &CreateInstanceOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateInstance API operation for GRAPH.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for GRAPH's
// API operation CreateInstance for usage and error information.
func (c *GRAPH) CreateInstance(input *CreateInstanceInput) (*CreateInstanceOutput, error) {
	req, out := c.CreateInstanceRequest(input)
	return out, req.Send()
}

// CreateInstanceWithContext is the same as CreateInstance with the addition of
// the ability to pass a context and additional request options.
//
// See CreateInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *GRAPH) CreateInstanceWithContext(ctx volcengine.Context, input *CreateInstanceInput, opts ...request.Option) (*CreateInstanceOutput, error) {
	req, out := c.CreateInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AvailabilityZoneForCreateInstanceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AvailabilityZoneId *string `type:"string" json:",omitempty"`

	K8sDomain *string `type:"string" json:",omitempty"`

	NodeNum *int32 `type:"int32" json:",omitempty"`

	NodePoolName *string `type:"string" json:",omitempty"`

	SubnetID *string `type:"string" json:",omitempty"`

	SubnetName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s AvailabilityZoneForCreateInstanceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AvailabilityZoneForCreateInstanceInput) GoString() string {
	return s.String()
}

// SetAvailabilityZoneId sets the AvailabilityZoneId field's value.
func (s *AvailabilityZoneForCreateInstanceInput) SetAvailabilityZoneId(v string) *AvailabilityZoneForCreateInstanceInput {
	s.AvailabilityZoneId = &v
	return s
}

// SetK8sDomain sets the K8sDomain field's value.
func (s *AvailabilityZoneForCreateInstanceInput) SetK8sDomain(v string) *AvailabilityZoneForCreateInstanceInput {
	s.K8sDomain = &v
	return s
}

// SetNodeNum sets the NodeNum field's value.
func (s *AvailabilityZoneForCreateInstanceInput) SetNodeNum(v int32) *AvailabilityZoneForCreateInstanceInput {
	s.NodeNum = &v
	return s
}

// SetNodePoolName sets the NodePoolName field's value.
func (s *AvailabilityZoneForCreateInstanceInput) SetNodePoolName(v string) *AvailabilityZoneForCreateInstanceInput {
	s.NodePoolName = &v
	return s
}

// SetSubnetID sets the SubnetID field's value.
func (s *AvailabilityZoneForCreateInstanceInput) SetSubnetID(v string) *AvailabilityZoneForCreateInstanceInput {
	s.SubnetID = &v
	return s
}

// SetSubnetName sets the SubnetName field's value.
func (s *AvailabilityZoneForCreateInstanceInput) SetSubnetName(v string) *AvailabilityZoneForCreateInstanceInput {
	s.SubnetName = &v
	return s
}

type Bg3LinkForCreateInstanceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AddressType *string `type:"string" json:",omitempty"`

	AvailabilityZoneId *string `type:"string" json:",omitempty"`

	Bg3Link *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s Bg3LinkForCreateInstanceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s Bg3LinkForCreateInstanceInput) GoString() string {
	return s.String()
}

// SetAddressType sets the AddressType field's value.
func (s *Bg3LinkForCreateInstanceInput) SetAddressType(v string) *Bg3LinkForCreateInstanceInput {
	s.AddressType = &v
	return s
}

// SetAvailabilityZoneId sets the AvailabilityZoneId field's value.
func (s *Bg3LinkForCreateInstanceInput) SetAvailabilityZoneId(v string) *Bg3LinkForCreateInstanceInput {
	s.AvailabilityZoneId = &v
	return s
}

// SetBg3Link sets the Bg3Link field's value.
func (s *Bg3LinkForCreateInstanceInput) SetBg3Link(v string) *Bg3LinkForCreateInstanceInput {
	s.Bg3Link = &v
	return s
}

type BytestoreInfoForCreateInstanceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Cluster *string `type:"string" json:",omitempty"`

	Id *int64 `type:"int64" json:",omitempty"`

	Pool *string `type:"string" json:",omitempty"`

	Region *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s BytestoreInfoForCreateInstanceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BytestoreInfoForCreateInstanceInput) GoString() string {
	return s.String()
}

// SetCluster sets the Cluster field's value.
func (s *BytestoreInfoForCreateInstanceInput) SetCluster(v string) *BytestoreInfoForCreateInstanceInput {
	s.Cluster = &v
	return s
}

// SetId sets the Id field's value.
func (s *BytestoreInfoForCreateInstanceInput) SetId(v int64) *BytestoreInfoForCreateInstanceInput {
	s.Id = &v
	return s
}

// SetPool sets the Pool field's value.
func (s *BytestoreInfoForCreateInstanceInput) SetPool(v string) *BytestoreInfoForCreateInstanceInput {
	s.Pool = &v
	return s
}

// SetRegion sets the Region field's value.
func (s *BytestoreInfoForCreateInstanceInput) SetRegion(v string) *BytestoreInfoForCreateInstanceInput {
	s.Region = &v
	return s
}

type CreateInstanceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ClientToken *string `type:"string" json:",omitempty"`

	DeletionProtection *string `type:"string" json:",omitempty"`

	Info *InfoForCreateInstanceInput `type:"structure" json:",omitempty"`

	InstanceTags []*InstanceTagForCreateInstanceInput `type:"list" json:",omitempty"`

	NetworkDescriptions []*NetworkDescriptionForCreateInstanceInput `type:"list" json:",omitempty"`

	OneStep *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s CreateInstanceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstanceInput) GoString() string {
	return s.String()
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateInstanceInput) SetClientToken(v string) *CreateInstanceInput {
	s.ClientToken = &v
	return s
}

// SetDeletionProtection sets the DeletionProtection field's value.
func (s *CreateInstanceInput) SetDeletionProtection(v string) *CreateInstanceInput {
	s.DeletionProtection = &v
	return s
}

// SetInfo sets the Info field's value.
func (s *CreateInstanceInput) SetInfo(v *InfoForCreateInstanceInput) *CreateInstanceInput {
	s.Info = v
	return s
}

// SetInstanceTags sets the InstanceTags field's value.
func (s *CreateInstanceInput) SetInstanceTags(v []*InstanceTagForCreateInstanceInput) *CreateInstanceInput {
	s.InstanceTags = v
	return s
}

// SetNetworkDescriptions sets the NetworkDescriptions field's value.
func (s *CreateInstanceInput) SetNetworkDescriptions(v []*NetworkDescriptionForCreateInstanceInput) *CreateInstanceInput {
	s.NetworkDescriptions = v
	return s
}

// SetOneStep sets the OneStep field's value.
func (s *CreateInstanceInput) SetOneStep(v bool) *CreateInstanceInput {
	s.OneStep = &v
	return s
}

type CreateInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	InstanceId *string `type:"string" json:",omitempty"`

	TradeNO *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateInstanceOutput) GoString() string {
	return s.String()
}

// SetInstanceId sets the InstanceId field's value.
func (s *CreateInstanceOutput) SetInstanceId(v string) *CreateInstanceOutput {
	s.InstanceId = &v
	return s
}

// SetTradeNO sets the TradeNO field's value.
func (s *CreateInstanceOutput) SetTradeNO(v string) *CreateInstanceOutput {
	s.TradeNO = &v
	return s
}

type ImageInfoForCreateInstanceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Bg3DeployVersion *string `type:"string" json:",omitempty"`

	Bg3ImageVersion *string `type:"string" json:",omitempty"`

	MsDeployVersion *string `type:"string" json:",omitempty"`

	MsImageVersion *string `type:"string" json:",omitempty"`

	VersionSetID *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s ImageInfoForCreateInstanceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ImageInfoForCreateInstanceInput) GoString() string {
	return s.String()
}

// SetBg3DeployVersion sets the Bg3DeployVersion field's value.
func (s *ImageInfoForCreateInstanceInput) SetBg3DeployVersion(v string) *ImageInfoForCreateInstanceInput {
	s.Bg3DeployVersion = &v
	return s
}

// SetBg3ImageVersion sets the Bg3ImageVersion field's value.
func (s *ImageInfoForCreateInstanceInput) SetBg3ImageVersion(v string) *ImageInfoForCreateInstanceInput {
	s.Bg3ImageVersion = &v
	return s
}

// SetMsDeployVersion sets the MsDeployVersion field's value.
func (s *ImageInfoForCreateInstanceInput) SetMsDeployVersion(v string) *ImageInfoForCreateInstanceInput {
	s.MsDeployVersion = &v
	return s
}

// SetMsImageVersion sets the MsImageVersion field's value.
func (s *ImageInfoForCreateInstanceInput) SetMsImageVersion(v string) *ImageInfoForCreateInstanceInput {
	s.MsImageVersion = &v
	return s
}

// SetVersionSetID sets the VersionSetID field's value.
func (s *ImageInfoForCreateInstanceInput) SetVersionSetID(v int64) *ImageInfoForCreateInstanceInput {
	s.VersionSetID = &v
	return s
}

type InfoForCreateInstanceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AvailabilityZoneId *string `type:"string" json:",omitempty"`

	AvailabilityZones []*AvailabilityZoneForCreateInstanceInput `type:"list" json:",omitempty"`

	Bg3Link *string `type:"string" json:",omitempty"`

	Bg3Links []*Bg3LinkForCreateInstanceInput `type:"list" json:",omitempty"`

	CreateTime *string `type:"string" json:",omitempty"`

	Creator *string `type:"string" json:",omitempty"`

	DeletionProtection *string `type:"string" json:",omitempty"`

	DiskSpace *int32 `type:"int32" json:",omitempty"`

	DiskUsed *int64 `type:"int64" json:",omitempty"`

	ExpireTime *string `type:"string" json:",omitempty"`

	GraphVersion *string `type:"string" json:",omitempty"`

	Id *string `type:"string" json:",omitempty"`

	ImageInfo *ImageInfoForCreateInstanceInput `type:"structure" json:",omitempty"`

	InsSpec *InsSpecForCreateInstanceInput `type:"structure" json:",omitempty"`

	K8sDomain *string `type:"string" json:",omitempty"`

	MaintenanceTime *string `type:"string" json:",omitempty"`

	Mode *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	NodeNum *int32 `type:"int32" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`

	RegionId *string `type:"string" json:",omitempty"`

	Status *string `type:"string" json:",omitempty"`

	StorageInfo *StorageInfoForCreateInstanceInput `type:"structure" json:",omitempty"`

	SubnetID *string `type:"string" json:",omitempty"`

	SubnetName *string `type:"string" json:",omitempty"`

	Tags []*TagForCreateInstanceInput `type:"list" json:",omitempty"`

	TradeNO *string `type:"string" json:",omitempty"`

	VpcId *string `type:"string" json:",omitempty"`

	VpcName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s InfoForCreateInstanceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s InfoForCreateInstanceInput) GoString() string {
	return s.String()
}

// SetAvailabilityZoneId sets the AvailabilityZoneId field's value.
func (s *InfoForCreateInstanceInput) SetAvailabilityZoneId(v string) *InfoForCreateInstanceInput {
	s.AvailabilityZoneId = &v
	return s
}

// SetAvailabilityZones sets the AvailabilityZones field's value.
func (s *InfoForCreateInstanceInput) SetAvailabilityZones(v []*AvailabilityZoneForCreateInstanceInput) *InfoForCreateInstanceInput {
	s.AvailabilityZones = v
	return s
}

// SetBg3Link sets the Bg3Link field's value.
func (s *InfoForCreateInstanceInput) SetBg3Link(v string) *InfoForCreateInstanceInput {
	s.Bg3Link = &v
	return s
}

// SetBg3Links sets the Bg3Links field's value.
func (s *InfoForCreateInstanceInput) SetBg3Links(v []*Bg3LinkForCreateInstanceInput) *InfoForCreateInstanceInput {
	s.Bg3Links = v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *InfoForCreateInstanceInput) SetCreateTime(v string) *InfoForCreateInstanceInput {
	s.CreateTime = &v
	return s
}

// SetCreator sets the Creator field's value.
func (s *InfoForCreateInstanceInput) SetCreator(v string) *InfoForCreateInstanceInput {
	s.Creator = &v
	return s
}

// SetDeletionProtection sets the DeletionProtection field's value.
func (s *InfoForCreateInstanceInput) SetDeletionProtection(v string) *InfoForCreateInstanceInput {
	s.DeletionProtection = &v
	return s
}

// SetDiskSpace sets the DiskSpace field's value.
func (s *InfoForCreateInstanceInput) SetDiskSpace(v int32) *InfoForCreateInstanceInput {
	s.DiskSpace = &v
	return s
}

// SetDiskUsed sets the DiskUsed field's value.
func (s *InfoForCreateInstanceInput) SetDiskUsed(v int64) *InfoForCreateInstanceInput {
	s.DiskUsed = &v
	return s
}

// SetExpireTime sets the ExpireTime field's value.
func (s *InfoForCreateInstanceInput) SetExpireTime(v string) *InfoForCreateInstanceInput {
	s.ExpireTime = &v
	return s
}

// SetGraphVersion sets the GraphVersion field's value.
func (s *InfoForCreateInstanceInput) SetGraphVersion(v string) *InfoForCreateInstanceInput {
	s.GraphVersion = &v
	return s
}

// SetId sets the Id field's value.
func (s *InfoForCreateInstanceInput) SetId(v string) *InfoForCreateInstanceInput {
	s.Id = &v
	return s
}

// SetImageInfo sets the ImageInfo field's value.
func (s *InfoForCreateInstanceInput) SetImageInfo(v *ImageInfoForCreateInstanceInput) *InfoForCreateInstanceInput {
	s.ImageInfo = v
	return s
}

// SetInsSpec sets the InsSpec field's value.
func (s *InfoForCreateInstanceInput) SetInsSpec(v *InsSpecForCreateInstanceInput) *InfoForCreateInstanceInput {
	s.InsSpec = v
	return s
}

// SetK8sDomain sets the K8sDomain field's value.
func (s *InfoForCreateInstanceInput) SetK8sDomain(v string) *InfoForCreateInstanceInput {
	s.K8sDomain = &v
	return s
}

// SetMaintenanceTime sets the MaintenanceTime field's value.
func (s *InfoForCreateInstanceInput) SetMaintenanceTime(v string) *InfoForCreateInstanceInput {
	s.MaintenanceTime = &v
	return s
}

// SetMode sets the Mode field's value.
func (s *InfoForCreateInstanceInput) SetMode(v string) *InfoForCreateInstanceInput {
	s.Mode = &v
	return s
}

// SetName sets the Name field's value.
func (s *InfoForCreateInstanceInput) SetName(v string) *InfoForCreateInstanceInput {
	s.Name = &v
	return s
}

// SetNodeNum sets the NodeNum field's value.
func (s *InfoForCreateInstanceInput) SetNodeNum(v int32) *InfoForCreateInstanceInput {
	s.NodeNum = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *InfoForCreateInstanceInput) SetProjectName(v string) *InfoForCreateInstanceInput {
	s.ProjectName = &v
	return s
}

// SetRegionId sets the RegionId field's value.
func (s *InfoForCreateInstanceInput) SetRegionId(v string) *InfoForCreateInstanceInput {
	s.RegionId = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *InfoForCreateInstanceInput) SetStatus(v string) *InfoForCreateInstanceInput {
	s.Status = &v
	return s
}

// SetStorageInfo sets the StorageInfo field's value.
func (s *InfoForCreateInstanceInput) SetStorageInfo(v *StorageInfoForCreateInstanceInput) *InfoForCreateInstanceInput {
	s.StorageInfo = v
	return s
}

// SetSubnetID sets the SubnetID field's value.
func (s *InfoForCreateInstanceInput) SetSubnetID(v string) *InfoForCreateInstanceInput {
	s.SubnetID = &v
	return s
}

// SetSubnetName sets the SubnetName field's value.
func (s *InfoForCreateInstanceInput) SetSubnetName(v string) *InfoForCreateInstanceInput {
	s.SubnetName = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *InfoForCreateInstanceInput) SetTags(v []*TagForCreateInstanceInput) *InfoForCreateInstanceInput {
	s.Tags = v
	return s
}

// SetTradeNO sets the TradeNO field's value.
func (s *InfoForCreateInstanceInput) SetTradeNO(v string) *InfoForCreateInstanceInput {
	s.TradeNO = &v
	return s
}

// SetVpcId sets the VpcId field's value.
func (s *InfoForCreateInstanceInput) SetVpcId(v string) *InfoForCreateInstanceInput {
	s.VpcId = &v
	return s
}

// SetVpcName sets the VpcName field's value.
func (s *InfoForCreateInstanceInput) SetVpcName(v string) *InfoForCreateInstanceInput {
	s.VpcName = &v
	return s
}

type InsSpecForCreateInstanceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CpuNum *int32 `type:"int32" json:",omitempty"`

	MemInGb *int32 `type:"int32" json:",omitempty"`

	SpecName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s InsSpecForCreateInstanceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s InsSpecForCreateInstanceInput) GoString() string {
	return s.String()
}

// SetCpuNum sets the CpuNum field's value.
func (s *InsSpecForCreateInstanceInput) SetCpuNum(v int32) *InsSpecForCreateInstanceInput {
	s.CpuNum = &v
	return s
}

// SetMemInGb sets the MemInGb field's value.
func (s *InsSpecForCreateInstanceInput) SetMemInGb(v int32) *InsSpecForCreateInstanceInput {
	s.MemInGb = &v
	return s
}

// SetSpecName sets the SpecName field's value.
func (s *InsSpecForCreateInstanceInput) SetSpecName(v string) *InsSpecForCreateInstanceInput {
	s.SpecName = &v
	return s
}

type InstanceTagForCreateInstanceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s InstanceTagForCreateInstanceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceTagForCreateInstanceInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *InstanceTagForCreateInstanceInput) SetKey(v string) *InstanceTagForCreateInstanceInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *InstanceTagForCreateInstanceInput) SetValue(v string) *InstanceTagForCreateInstanceInput {
	s.Value = &v
	return s
}

type NetworkDescriptionForCreateInstanceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AddressType *string `type:"string" json:",omitempty"`

	IPVersionType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s NetworkDescriptionForCreateInstanceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NetworkDescriptionForCreateInstanceInput) GoString() string {
	return s.String()
}

// SetAddressType sets the AddressType field's value.
func (s *NetworkDescriptionForCreateInstanceInput) SetAddressType(v string) *NetworkDescriptionForCreateInstanceInput {
	s.AddressType = &v
	return s
}

// SetIPVersionType sets the IPVersionType field's value.
func (s *NetworkDescriptionForCreateInstanceInput) SetIPVersionType(v string) *NetworkDescriptionForCreateInstanceInput {
	s.IPVersionType = &v
	return s
}

type StorageInfoForCreateInstanceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BytestoreInfo *BytestoreInfoForCreateInstanceInput `type:"structure" json:",omitempty"`

	StorageType *string `type:"string" json:",omitempty" enum:"EnumOfStorageTypeForCreateInstanceInput"`
}

// String returns the string representation
func (s StorageInfoForCreateInstanceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StorageInfoForCreateInstanceInput) GoString() string {
	return s.String()
}

// SetBytestoreInfo sets the BytestoreInfo field's value.
func (s *StorageInfoForCreateInstanceInput) SetBytestoreInfo(v *BytestoreInfoForCreateInstanceInput) *StorageInfoForCreateInstanceInput {
	s.BytestoreInfo = v
	return s
}

// SetStorageType sets the StorageType field's value.
func (s *StorageInfoForCreateInstanceInput) SetStorageType(v string) *StorageInfoForCreateInstanceInput {
	s.StorageType = &v
	return s
}

type TagForCreateInstanceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TagForCreateInstanceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForCreateInstanceInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForCreateInstanceInput) SetKey(v string) *TagForCreateInstanceInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForCreateInstanceInput) SetValue(v string) *TagForCreateInstanceInput {
	s.Value = &v
	return s
}

const (
	// EnumOfStorageTypeForCreateInstanceInputMemory is a EnumOfStorageTypeForCreateInstanceInput enum value
	EnumOfStorageTypeForCreateInstanceInputMemory = "Memory"

	// EnumOfStorageTypeForCreateInstanceInputByteStore is a EnumOfStorageTypeForCreateInstanceInput enum value
	EnumOfStorageTypeForCreateInstanceInputByteStore = "ByteStore"
)
