// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package fwcenter

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeAddressBookCommon = "DescribeAddressBook"

// DescribeAddressBookCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeAddressBookCommon operation. The "output" return
// value will be populated with the DescribeAddressBookCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeAddressBookCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeAddressBookCommon Send returns without error.
//
// See DescribeAddressBookCommon for more information on using the DescribeAddressBookCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeAddressBookCommonRequest method.
//    req, resp := client.DescribeAddressBookCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *FWCENTER) DescribeAddressBookCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeAddressBookCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeAddressBookCommon API operation for FWCENTER.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for FWCENTER's
// API operation DescribeAddressBookCommon for usage and error information.
func (c *FWCENTER) DescribeAddressBookCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeAddressBookCommonRequest(input)
	return out, req.Send()
}

// DescribeAddressBookCommonWithContext is the same as DescribeAddressBookCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAddressBookCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FWCENTER) DescribeAddressBookCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeAddressBookCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeAddressBook = "DescribeAddressBook"

// DescribeAddressBookRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeAddressBook operation. The "output" return
// value will be populated with the DescribeAddressBookCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeAddressBookCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeAddressBookCommon Send returns without error.
//
// See DescribeAddressBook for more information on using the DescribeAddressBook
// API call, and error handling.
//
//    // Example sending a request using the DescribeAddressBookRequest method.
//    req, resp := client.DescribeAddressBookRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *FWCENTER) DescribeAddressBookRequest(input *DescribeAddressBookInput) (req *request.Request, output *DescribeAddressBookOutput) {
	op := &request.Operation{
		Name:       opDescribeAddressBook,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeAddressBookInput{}
	}

	output = &DescribeAddressBookOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeAddressBook API operation for FWCENTER.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for FWCENTER's
// API operation DescribeAddressBook for usage and error information.
func (c *FWCENTER) DescribeAddressBook(input *DescribeAddressBookInput) (*DescribeAddressBookOutput, error) {
	req, out := c.DescribeAddressBookRequest(input)
	return out, req.Send()
}

// DescribeAddressBookWithContext is the same as DescribeAddressBook with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeAddressBook for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *FWCENTER) DescribeAddressBookWithContext(ctx volcengine.Context, input *DescribeAddressBookInput, opts ...request.Option) (*DescribeAddressBookOutput, error) {
	req, out := c.DescribeAddressBookRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AddressDetailListForDescribeAddressBookOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Address *string `type:"string" json:",omitempty"`

	Description *string `max:"32" type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s AddressDetailListForDescribeAddressBookOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AddressDetailListForDescribeAddressBookOutput) GoString() string {
	return s.String()
}

// SetAddress sets the Address field's value.
func (s *AddressDetailListForDescribeAddressBookOutput) SetAddress(v string) *AddressDetailListForDescribeAddressBookOutput {
	s.Address = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AddressDetailListForDescribeAddressBookOutput) SetDescription(v string) *AddressDetailListForDescribeAddressBookOutput {
	s.Description = &v
	return s
}

// SetType sets the Type field's value.
func (s *AddressDetailListForDescribeAddressBookOutput) SetType(v string) *AddressDetailListForDescribeAddressBookOutput {
	s.Type = &v
	return s
}

type DataForDescribeAddressBookOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AddressDetailList []*AddressDetailListForDescribeAddressBookOutput `type:"list" json:",omitempty"`

	AddressList []*string `type:"list" json:",omitempty"`

	AutoUpdateType *string `type:"string" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	GroupName *string `type:"string" json:",omitempty"`

	GroupType *string `type:"string" json:",omitempty"`

	GroupUuid *string `type:"string" json:",omitempty"`

	InstanceTypeList []*string `type:"list" json:",omitempty"`

	RefCnt *int32 `type:"int32" json:",omitempty"`

	ResourceType *string `type:"string" json:",omitempty"`

	TagRelation *string `type:"string" json:",omitempty"`

	Tags []*TagForDescribeAddressBookOutput `type:"list" json:",omitempty"`

	Updated *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s DataForDescribeAddressBookOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DataForDescribeAddressBookOutput) GoString() string {
	return s.String()
}

// SetAddressDetailList sets the AddressDetailList field's value.
func (s *DataForDescribeAddressBookOutput) SetAddressDetailList(v []*AddressDetailListForDescribeAddressBookOutput) *DataForDescribeAddressBookOutput {
	s.AddressDetailList = v
	return s
}

// SetAddressList sets the AddressList field's value.
func (s *DataForDescribeAddressBookOutput) SetAddressList(v []*string) *DataForDescribeAddressBookOutput {
	s.AddressList = v
	return s
}

// SetAutoUpdateType sets the AutoUpdateType field's value.
func (s *DataForDescribeAddressBookOutput) SetAutoUpdateType(v string) *DataForDescribeAddressBookOutput {
	s.AutoUpdateType = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *DataForDescribeAddressBookOutput) SetDescription(v string) *DataForDescribeAddressBookOutput {
	s.Description = &v
	return s
}

// SetGroupName sets the GroupName field's value.
func (s *DataForDescribeAddressBookOutput) SetGroupName(v string) *DataForDescribeAddressBookOutput {
	s.GroupName = &v
	return s
}

// SetGroupType sets the GroupType field's value.
func (s *DataForDescribeAddressBookOutput) SetGroupType(v string) *DataForDescribeAddressBookOutput {
	s.GroupType = &v
	return s
}

// SetGroupUuid sets the GroupUuid field's value.
func (s *DataForDescribeAddressBookOutput) SetGroupUuid(v string) *DataForDescribeAddressBookOutput {
	s.GroupUuid = &v
	return s
}

// SetInstanceTypeList sets the InstanceTypeList field's value.
func (s *DataForDescribeAddressBookOutput) SetInstanceTypeList(v []*string) *DataForDescribeAddressBookOutput {
	s.InstanceTypeList = v
	return s
}

// SetRefCnt sets the RefCnt field's value.
func (s *DataForDescribeAddressBookOutput) SetRefCnt(v int32) *DataForDescribeAddressBookOutput {
	s.RefCnt = &v
	return s
}

// SetResourceType sets the ResourceType field's value.
func (s *DataForDescribeAddressBookOutput) SetResourceType(v string) *DataForDescribeAddressBookOutput {
	s.ResourceType = &v
	return s
}

// SetTagRelation sets the TagRelation field's value.
func (s *DataForDescribeAddressBookOutput) SetTagRelation(v string) *DataForDescribeAddressBookOutput {
	s.TagRelation = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *DataForDescribeAddressBookOutput) SetTags(v []*TagForDescribeAddressBookOutput) *DataForDescribeAddressBookOutput {
	s.Tags = v
	return s
}

// SetUpdated sets the Updated field's value.
func (s *DataForDescribeAddressBookOutput) SetUpdated(v int32) *DataForDescribeAddressBookOutput {
	s.Updated = &v
	return s
}

type DescribeAddressBookInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CloudFirewallId *string `type:"string" json:",omitempty"`

	GroupType *string `type:"string" json:",omitempty" enum:"EnumOfGroupTypeForDescribeAddressBookInput"`

	PageNumber *int32 `max:"100" type:"int32" json:",omitempty"`

	PageSize *int32 `max:"1000" type:"int32" json:",omitempty"`

	Query *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s DescribeAddressBookInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAddressBookInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeAddressBookInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeAddressBookInput"}
	if s.PageNumber != nil && *s.PageNumber > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("PageNumber", 100))
	}
	if s.PageSize != nil && *s.PageSize > 1000 {
		invalidParams.Add(request.NewErrParamMaxValue("PageSize", 1000))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetCloudFirewallId sets the CloudFirewallId field's value.
func (s *DescribeAddressBookInput) SetCloudFirewallId(v string) *DescribeAddressBookInput {
	s.CloudFirewallId = &v
	return s
}

// SetGroupType sets the GroupType field's value.
func (s *DescribeAddressBookInput) SetGroupType(v string) *DescribeAddressBookInput {
	s.GroupType = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *DescribeAddressBookInput) SetPageNumber(v int32) *DescribeAddressBookInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribeAddressBookInput) SetPageSize(v int32) *DescribeAddressBookInput {
	s.PageSize = &v
	return s
}

// SetQuery sets the Query field's value.
func (s *DescribeAddressBookInput) SetQuery(v string) *DescribeAddressBookInput {
	s.Query = &v
	return s
}

type DescribeAddressBookOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Count *int32 `type:"int32" json:",omitempty"`

	Data []*DataForDescribeAddressBookOutput `type:"list" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s DescribeAddressBookOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeAddressBookOutput) GoString() string {
	return s.String()
}

// SetCount sets the Count field's value.
func (s *DescribeAddressBookOutput) SetCount(v int32) *DescribeAddressBookOutput {
	s.Count = &v
	return s
}

// SetData sets the Data field's value.
func (s *DescribeAddressBookOutput) SetData(v []*DataForDescribeAddressBookOutput) *DescribeAddressBookOutput {
	s.Data = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *DescribeAddressBookOutput) SetPageNumber(v int32) *DescribeAddressBookOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribeAddressBookOutput) SetPageSize(v int32) *DescribeAddressBookOutput {
	s.PageSize = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *DescribeAddressBookOutput) SetTotalCount(v int32) *DescribeAddressBookOutput {
	s.TotalCount = &v
	return s
}

type TagForDescribeAddressBookOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `min:"1" max:"128" type:"string" json:",omitempty"`

	Value *string `max:"256" type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TagForDescribeAddressBookOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForDescribeAddressBookOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForDescribeAddressBookOutput) SetKey(v string) *TagForDescribeAddressBookOutput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForDescribeAddressBookOutput) SetValue(v string) *TagForDescribeAddressBookOutput {
	s.Value = &v
	return s
}

const (
	// EnumOfGroupTypeForDescribeAddressBookInputIp is a EnumOfGroupTypeForDescribeAddressBookInput enum value
	EnumOfGroupTypeForDescribeAddressBookInputIp = "ip"

	// EnumOfGroupTypeForDescribeAddressBookInputIpv6 is a EnumOfGroupTypeForDescribeAddressBookInput enum value
	EnumOfGroupTypeForDescribeAddressBookInputIpv6 = "ipv6"

	// EnumOfGroupTypeForDescribeAddressBookInputPort is a EnumOfGroupTypeForDescribeAddressBookInput enum value
	EnumOfGroupTypeForDescribeAddressBookInputPort = "port"

	// EnumOfGroupTypeForDescribeAddressBookInputDomain is a EnumOfGroupTypeForDescribeAddressBookInput enum value
	EnumOfGroupTypeForDescribeAddressBookInputDomain = "domain"
)
