// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package escloud

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeInstancesCommon = "DescribeInstances"

// DescribeInstancesCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeInstancesCommon operation. The "output" return
// value will be populated with the DescribeInstancesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeInstancesCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeInstancesCommon Send returns without error.
//
// See DescribeInstancesCommon for more information on using the DescribeInstancesCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeInstancesCommonRequest method.
//    req, resp := client.DescribeInstancesCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ESCLOUD) DescribeInstancesCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeInstancesCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeInstancesCommon API operation for ESCLOUD.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ESCLOUD's
// API operation DescribeInstancesCommon for usage and error information.
func (c *ESCLOUD) DescribeInstancesCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeInstancesCommonRequest(input)
	return out, req.Send()
}

// DescribeInstancesCommonWithContext is the same as DescribeInstancesCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstancesCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ESCLOUD) DescribeInstancesCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeInstancesCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInstances = "DescribeInstances"

// DescribeInstancesRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeInstances operation. The "output" return
// value will be populated with the DescribeInstancesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeInstancesCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeInstancesCommon Send returns without error.
//
// See DescribeInstances for more information on using the DescribeInstances
// API call, and error handling.
//
//    // Example sending a request using the DescribeInstancesRequest method.
//    req, resp := client.DescribeInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ESCLOUD) DescribeInstancesRequest(input *DescribeInstancesInput) (req *request.Request, output *DescribeInstancesOutput) {
	op := &request.Operation{
		Name:       opDescribeInstances,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInstancesInput{}
	}

	output = &DescribeInstancesOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeInstances API operation for ESCLOUD.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ESCLOUD's
// API operation DescribeInstances for usage and error information.
func (c *ESCLOUD) DescribeInstances(input *DescribeInstancesInput) (*DescribeInstancesOutput, error) {
	req, out := c.DescribeInstancesRequest(input)
	return out, req.Send()
}

// DescribeInstancesWithContext is the same as DescribeInstances with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ESCLOUD) DescribeInstancesWithContext(ctx volcengine.Context, input *DescribeInstancesInput, opts ...request.Option) (*DescribeInstancesOutput, error) {
	req, out := c.DescribeInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ColdNodeResourceSpecForDescribeInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CPU *int32 `type:"int32" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	DisplayName *string `type:"string" json:",omitempty"`

	Memory *int32 `type:"int32" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ColdNodeResourceSpecForDescribeInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ColdNodeResourceSpecForDescribeInstancesOutput) GoString() string {
	return s.String()
}

// SetCPU sets the CPU field's value.
func (s *ColdNodeResourceSpecForDescribeInstancesOutput) SetCPU(v int32) *ColdNodeResourceSpecForDescribeInstancesOutput {
	s.CPU = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ColdNodeResourceSpecForDescribeInstancesOutput) SetDescription(v string) *ColdNodeResourceSpecForDescribeInstancesOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *ColdNodeResourceSpecForDescribeInstancesOutput) SetDisplayName(v string) *ColdNodeResourceSpecForDescribeInstancesOutput {
	s.DisplayName = &v
	return s
}

// SetMemory sets the Memory field's value.
func (s *ColdNodeResourceSpecForDescribeInstancesOutput) SetMemory(v int32) *ColdNodeResourceSpecForDescribeInstancesOutput {
	s.Memory = &v
	return s
}

// SetName sets the Name field's value.
func (s *ColdNodeResourceSpecForDescribeInstancesOutput) SetName(v string) *ColdNodeResourceSpecForDescribeInstancesOutput {
	s.Name = &v
	return s
}

type ColdNodeStorageSpecForDescribeInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	DisplayName *string `type:"string" json:",omitempty"`

	MaxSize *int32 `type:"int32" json:",omitempty"`

	MinSize *int32 `type:"int32" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Size *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ColdNodeStorageSpecForDescribeInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ColdNodeStorageSpecForDescribeInstancesOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *ColdNodeStorageSpecForDescribeInstancesOutput) SetDescription(v string) *ColdNodeStorageSpecForDescribeInstancesOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *ColdNodeStorageSpecForDescribeInstancesOutput) SetDisplayName(v string) *ColdNodeStorageSpecForDescribeInstancesOutput {
	s.DisplayName = &v
	return s
}

// SetMaxSize sets the MaxSize field's value.
func (s *ColdNodeStorageSpecForDescribeInstancesOutput) SetMaxSize(v int32) *ColdNodeStorageSpecForDescribeInstancesOutput {
	s.MaxSize = &v
	return s
}

// SetMinSize sets the MinSize field's value.
func (s *ColdNodeStorageSpecForDescribeInstancesOutput) SetMinSize(v int32) *ColdNodeStorageSpecForDescribeInstancesOutput {
	s.MinSize = &v
	return s
}

// SetName sets the Name field's value.
func (s *ColdNodeStorageSpecForDescribeInstancesOutput) SetName(v string) *ColdNodeStorageSpecForDescribeInstancesOutput {
	s.Name = &v
	return s
}

// SetSize sets the Size field's value.
func (s *ColdNodeStorageSpecForDescribeInstancesOutput) SetSize(v int32) *ColdNodeStorageSpecForDescribeInstancesOutput {
	s.Size = &v
	return s
}

type CoordinatorNodeResourceSpecForDescribeInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CPU *int32 `type:"int32" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	DisplayName *string `type:"string" json:",omitempty"`

	Memory *int32 `type:"int32" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CoordinatorNodeResourceSpecForDescribeInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CoordinatorNodeResourceSpecForDescribeInstancesOutput) GoString() string {
	return s.String()
}

// SetCPU sets the CPU field's value.
func (s *CoordinatorNodeResourceSpecForDescribeInstancesOutput) SetCPU(v int32) *CoordinatorNodeResourceSpecForDescribeInstancesOutput {
	s.CPU = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CoordinatorNodeResourceSpecForDescribeInstancesOutput) SetDescription(v string) *CoordinatorNodeResourceSpecForDescribeInstancesOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CoordinatorNodeResourceSpecForDescribeInstancesOutput) SetDisplayName(v string) *CoordinatorNodeResourceSpecForDescribeInstancesOutput {
	s.DisplayName = &v
	return s
}

// SetMemory sets the Memory field's value.
func (s *CoordinatorNodeResourceSpecForDescribeInstancesOutput) SetMemory(v int32) *CoordinatorNodeResourceSpecForDescribeInstancesOutput {
	s.Memory = &v
	return s
}

// SetName sets the Name field's value.
func (s *CoordinatorNodeResourceSpecForDescribeInstancesOutput) SetName(v string) *CoordinatorNodeResourceSpecForDescribeInstancesOutput {
	s.Name = &v
	return s
}

type CoordinatorNodeStorageSpecForDescribeInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	DisplayName *string `type:"string" json:",omitempty"`

	MaxSize *int32 `type:"int32" json:",omitempty"`

	MinSize *int32 `type:"int32" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Size *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s CoordinatorNodeStorageSpecForDescribeInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CoordinatorNodeStorageSpecForDescribeInstancesOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *CoordinatorNodeStorageSpecForDescribeInstancesOutput) SetDescription(v string) *CoordinatorNodeStorageSpecForDescribeInstancesOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CoordinatorNodeStorageSpecForDescribeInstancesOutput) SetDisplayName(v string) *CoordinatorNodeStorageSpecForDescribeInstancesOutput {
	s.DisplayName = &v
	return s
}

// SetMaxSize sets the MaxSize field's value.
func (s *CoordinatorNodeStorageSpecForDescribeInstancesOutput) SetMaxSize(v int32) *CoordinatorNodeStorageSpecForDescribeInstancesOutput {
	s.MaxSize = &v
	return s
}

// SetMinSize sets the MinSize field's value.
func (s *CoordinatorNodeStorageSpecForDescribeInstancesOutput) SetMinSize(v int32) *CoordinatorNodeStorageSpecForDescribeInstancesOutput {
	s.MinSize = &v
	return s
}

// SetName sets the Name field's value.
func (s *CoordinatorNodeStorageSpecForDescribeInstancesOutput) SetName(v string) *CoordinatorNodeStorageSpecForDescribeInstancesOutput {
	s.Name = &v
	return s
}

// SetSize sets the Size field's value.
func (s *CoordinatorNodeStorageSpecForDescribeInstancesOutput) SetSize(v int32) *CoordinatorNodeStorageSpecForDescribeInstancesOutput {
	s.Size = &v
	return s
}

type DescribeInstancesInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Filters []*FilterForDescribeInstancesInput `type:"list" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`

	TagFilter *TagFilterForDescribeInstancesInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s DescribeInstancesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstancesInput) GoString() string {
	return s.String()
}

// SetFilters sets the Filters field's value.
func (s *DescribeInstancesInput) SetFilters(v []*FilterForDescribeInstancesInput) *DescribeInstancesInput {
	s.Filters = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *DescribeInstancesInput) SetPageNumber(v int32) *DescribeInstancesInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *DescribeInstancesInput) SetPageSize(v int32) *DescribeInstancesInput {
	s.PageSize = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *DescribeInstancesInput) SetProjectName(v string) *DescribeInstancesInput {
	s.ProjectName = &v
	return s
}

// SetTagFilter sets the TagFilter field's value.
func (s *DescribeInstancesInput) SetTagFilter(v *TagFilterForDescribeInstancesInput) *DescribeInstancesInput {
	s.TagFilter = v
	return s
}

type DescribeInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Instances []*InstanceForDescribeInstancesOutput `type:"list" json:",omitempty"`

	TotalCount *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s DescribeInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstancesOutput) GoString() string {
	return s.String()
}

// SetInstances sets the Instances field's value.
func (s *DescribeInstancesOutput) SetInstances(v []*InstanceForDescribeInstancesOutput) *DescribeInstancesOutput {
	s.Instances = v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *DescribeInstancesOutput) SetTotalCount(v int64) *DescribeInstancesOutput {
	s.TotalCount = &v
	return s
}

type FilterForDescribeInstancesInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Name *string `type:"string" json:",omitempty" enum:"EnumOfNameForDescribeInstancesInput"`

	Values []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s FilterForDescribeInstancesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FilterForDescribeInstancesInput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *FilterForDescribeInstancesInput) SetName(v string) *FilterForDescribeInstancesInput {
	s.Name = &v
	return s
}

// SetValues sets the Values field's value.
func (s *FilterForDescribeInstancesInput) SetValues(v []*string) *FilterForDescribeInstancesInput {
	s.Values = v
	return s
}

type HotNodeResourceSpecForDescribeInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CPU *int32 `type:"int32" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	DisplayName *string `type:"string" json:",omitempty"`

	Memory *int32 `type:"int32" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s HotNodeResourceSpecForDescribeInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HotNodeResourceSpecForDescribeInstancesOutput) GoString() string {
	return s.String()
}

// SetCPU sets the CPU field's value.
func (s *HotNodeResourceSpecForDescribeInstancesOutput) SetCPU(v int32) *HotNodeResourceSpecForDescribeInstancesOutput {
	s.CPU = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *HotNodeResourceSpecForDescribeInstancesOutput) SetDescription(v string) *HotNodeResourceSpecForDescribeInstancesOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *HotNodeResourceSpecForDescribeInstancesOutput) SetDisplayName(v string) *HotNodeResourceSpecForDescribeInstancesOutput {
	s.DisplayName = &v
	return s
}

// SetMemory sets the Memory field's value.
func (s *HotNodeResourceSpecForDescribeInstancesOutput) SetMemory(v int32) *HotNodeResourceSpecForDescribeInstancesOutput {
	s.Memory = &v
	return s
}

// SetName sets the Name field's value.
func (s *HotNodeResourceSpecForDescribeInstancesOutput) SetName(v string) *HotNodeResourceSpecForDescribeInstancesOutput {
	s.Name = &v
	return s
}

type HotNodeStorageSpecForDescribeInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	DisplayName *string `type:"string" json:",omitempty"`

	MaxSize *int32 `type:"int32" json:",omitempty"`

	MinSize *int32 `type:"int32" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Size *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s HotNodeStorageSpecForDescribeInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HotNodeStorageSpecForDescribeInstancesOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *HotNodeStorageSpecForDescribeInstancesOutput) SetDescription(v string) *HotNodeStorageSpecForDescribeInstancesOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *HotNodeStorageSpecForDescribeInstancesOutput) SetDisplayName(v string) *HotNodeStorageSpecForDescribeInstancesOutput {
	s.DisplayName = &v
	return s
}

// SetMaxSize sets the MaxSize field's value.
func (s *HotNodeStorageSpecForDescribeInstancesOutput) SetMaxSize(v int32) *HotNodeStorageSpecForDescribeInstancesOutput {
	s.MaxSize = &v
	return s
}

// SetMinSize sets the MinSize field's value.
func (s *HotNodeStorageSpecForDescribeInstancesOutput) SetMinSize(v int32) *HotNodeStorageSpecForDescribeInstancesOutput {
	s.MinSize = &v
	return s
}

// SetName sets the Name field's value.
func (s *HotNodeStorageSpecForDescribeInstancesOutput) SetName(v string) *HotNodeStorageSpecForDescribeInstancesOutput {
	s.Name = &v
	return s
}

// SetSize sets the Size field's value.
func (s *HotNodeStorageSpecForDescribeInstancesOutput) SetSize(v int32) *HotNodeStorageSpecForDescribeInstancesOutput {
	s.Size = &v
	return s
}

type InstanceConfigurationForDescribeInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AdminUserName *string `type:"string" json:",omitempty"`

	ChargeType *string `type:"string" json:",omitempty" enum:"EnumOfChargeTypeForDescribeInstancesOutput"`

	ColdNodeNumber *int32 `type:"int32" json:",omitempty"`

	ColdNodeResourceSpec *ColdNodeResourceSpecForDescribeInstancesOutput `type:"structure" json:",omitempty"`

	ColdNodeStorageSpec *ColdNodeStorageSpecForDescribeInstancesOutput `type:"structure" json:",omitempty"`

	CoordinatorNodeNumber *int32 `type:"int32" json:",omitempty"`

	CoordinatorNodeResourceSpec *CoordinatorNodeResourceSpecForDescribeInstancesOutput `type:"structure" json:",omitempty"`

	CoordinatorNodeStorageSpec *CoordinatorNodeStorageSpecForDescribeInstancesOutput `type:"structure" json:",omitempty"`

	EnableHttps *bool `type:"boolean" json:",omitempty"`

	EnablePureMaster *bool `type:"boolean" json:",omitempty"`

	HotNodeNumber *int32 `type:"int32" json:",omitempty"`

	HotNodeResourceSpec *HotNodeResourceSpecForDescribeInstancesOutput `type:"structure" json:",omitempty"`

	HotNodeStorageSpec *HotNodeStorageSpecForDescribeInstancesOutput `type:"structure" json:",omitempty"`

	InstanceName *string `type:"string" json:",omitempty"`

	KibanaNodeNumber *int32 `type:"int32" json:",omitempty"`

	KibanaNodeResourceSpec *KibanaNodeResourceSpecForDescribeInstancesOutput `type:"structure" json:",omitempty"`

	MasterNodeNumber *int32 `type:"int32" json:",omitempty"`

	MasterNodeResourceSpec *MasterNodeResourceSpecForDescribeInstancesOutput `type:"structure" json:",omitempty"`

	MasterNodeStorageSpec *MasterNodeStorageSpecForDescribeInstancesOutput `type:"structure" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`

	RegionId *string `type:"string" json:",omitempty"`

	Subnet *SubnetForDescribeInstancesOutput `type:"structure" json:",omitempty"`

	VPC *VPCForDescribeInstancesOutput `type:"structure" json:",omitempty"`

	Version *string `type:"string" json:",omitempty" enum:"EnumOfVersionForDescribeInstancesOutput"`

	WarmNodeNumber *int32 `type:"int32" json:",omitempty"`

	WarmNodeResourceSpec *WarmNodeResourceSpecForDescribeInstancesOutput `type:"structure" json:",omitempty"`

	WarmNodeStorageSpec *WarmNodeStorageSpecForDescribeInstancesOutput `type:"structure" json:",omitempty"`

	ZoneId *string `type:"string" json:",omitempty"`

	ZoneNumber *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s InstanceConfigurationForDescribeInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceConfigurationForDescribeInstancesOutput) GoString() string {
	return s.String()
}

// SetAdminUserName sets the AdminUserName field's value.
func (s *InstanceConfigurationForDescribeInstancesOutput) SetAdminUserName(v string) *InstanceConfigurationForDescribeInstancesOutput {
	s.AdminUserName = &v
	return s
}

// SetChargeType sets the ChargeType field's value.
func (s *InstanceConfigurationForDescribeInstancesOutput) SetChargeType(v string) *InstanceConfigurationForDescribeInstancesOutput {
	s.ChargeType = &v
	return s
}

// SetColdNodeNumber sets the ColdNodeNumber field's value.
func (s *InstanceConfigurationForDescribeInstancesOutput) SetColdNodeNumber(v int32) *InstanceConfigurationForDescribeInstancesOutput {
	s.ColdNodeNumber = &v
	return s
}

// SetColdNodeResourceSpec sets the ColdNodeResourceSpec field's value.
func (s *InstanceConfigurationForDescribeInstancesOutput) SetColdNodeResourceSpec(v *ColdNodeResourceSpecForDescribeInstancesOutput) *InstanceConfigurationForDescribeInstancesOutput {
	s.ColdNodeResourceSpec = v
	return s
}

// SetColdNodeStorageSpec sets the ColdNodeStorageSpec field's value.
func (s *InstanceConfigurationForDescribeInstancesOutput) SetColdNodeStorageSpec(v *ColdNodeStorageSpecForDescribeInstancesOutput) *InstanceConfigurationForDescribeInstancesOutput {
	s.ColdNodeStorageSpec = v
	return s
}

// SetCoordinatorNodeNumber sets the CoordinatorNodeNumber field's value.
func (s *InstanceConfigurationForDescribeInstancesOutput) SetCoordinatorNodeNumber(v int32) *InstanceConfigurationForDescribeInstancesOutput {
	s.CoordinatorNodeNumber = &v
	return s
}

// SetCoordinatorNodeResourceSpec sets the CoordinatorNodeResourceSpec field's value.
func (s *InstanceConfigurationForDescribeInstancesOutput) SetCoordinatorNodeResourceSpec(v *CoordinatorNodeResourceSpecForDescribeInstancesOutput) *InstanceConfigurationForDescribeInstancesOutput {
	s.CoordinatorNodeResourceSpec = v
	return s
}

// SetCoordinatorNodeStorageSpec sets the CoordinatorNodeStorageSpec field's value.
func (s *InstanceConfigurationForDescribeInstancesOutput) SetCoordinatorNodeStorageSpec(v *CoordinatorNodeStorageSpecForDescribeInstancesOutput) *InstanceConfigurationForDescribeInstancesOutput {
	s.CoordinatorNodeStorageSpec = v
	return s
}

// SetEnableHttps sets the EnableHttps field's value.
func (s *InstanceConfigurationForDescribeInstancesOutput) SetEnableHttps(v bool) *InstanceConfigurationForDescribeInstancesOutput {
	s.EnableHttps = &v
	return s
}

// SetEnablePureMaster sets the EnablePureMaster field's value.
func (s *InstanceConfigurationForDescribeInstancesOutput) SetEnablePureMaster(v bool) *InstanceConfigurationForDescribeInstancesOutput {
	s.EnablePureMaster = &v
	return s
}

// SetHotNodeNumber sets the HotNodeNumber field's value.
func (s *InstanceConfigurationForDescribeInstancesOutput) SetHotNodeNumber(v int32) *InstanceConfigurationForDescribeInstancesOutput {
	s.HotNodeNumber = &v
	return s
}

// SetHotNodeResourceSpec sets the HotNodeResourceSpec field's value.
func (s *InstanceConfigurationForDescribeInstancesOutput) SetHotNodeResourceSpec(v *HotNodeResourceSpecForDescribeInstancesOutput) *InstanceConfigurationForDescribeInstancesOutput {
	s.HotNodeResourceSpec = v
	return s
}

// SetHotNodeStorageSpec sets the HotNodeStorageSpec field's value.
func (s *InstanceConfigurationForDescribeInstancesOutput) SetHotNodeStorageSpec(v *HotNodeStorageSpecForDescribeInstancesOutput) *InstanceConfigurationForDescribeInstancesOutput {
	s.HotNodeStorageSpec = v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *InstanceConfigurationForDescribeInstancesOutput) SetInstanceName(v string) *InstanceConfigurationForDescribeInstancesOutput {
	s.InstanceName = &v
	return s
}

// SetKibanaNodeNumber sets the KibanaNodeNumber field's value.
func (s *InstanceConfigurationForDescribeInstancesOutput) SetKibanaNodeNumber(v int32) *InstanceConfigurationForDescribeInstancesOutput {
	s.KibanaNodeNumber = &v
	return s
}

// SetKibanaNodeResourceSpec sets the KibanaNodeResourceSpec field's value.
func (s *InstanceConfigurationForDescribeInstancesOutput) SetKibanaNodeResourceSpec(v *KibanaNodeResourceSpecForDescribeInstancesOutput) *InstanceConfigurationForDescribeInstancesOutput {
	s.KibanaNodeResourceSpec = v
	return s
}

// SetMasterNodeNumber sets the MasterNodeNumber field's value.
func (s *InstanceConfigurationForDescribeInstancesOutput) SetMasterNodeNumber(v int32) *InstanceConfigurationForDescribeInstancesOutput {
	s.MasterNodeNumber = &v
	return s
}

// SetMasterNodeResourceSpec sets the MasterNodeResourceSpec field's value.
func (s *InstanceConfigurationForDescribeInstancesOutput) SetMasterNodeResourceSpec(v *MasterNodeResourceSpecForDescribeInstancesOutput) *InstanceConfigurationForDescribeInstancesOutput {
	s.MasterNodeResourceSpec = v
	return s
}

// SetMasterNodeStorageSpec sets the MasterNodeStorageSpec field's value.
func (s *InstanceConfigurationForDescribeInstancesOutput) SetMasterNodeStorageSpec(v *MasterNodeStorageSpecForDescribeInstancesOutput) *InstanceConfigurationForDescribeInstancesOutput {
	s.MasterNodeStorageSpec = v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *InstanceConfigurationForDescribeInstancesOutput) SetProjectName(v string) *InstanceConfigurationForDescribeInstancesOutput {
	s.ProjectName = &v
	return s
}

// SetRegionId sets the RegionId field's value.
func (s *InstanceConfigurationForDescribeInstancesOutput) SetRegionId(v string) *InstanceConfigurationForDescribeInstancesOutput {
	s.RegionId = &v
	return s
}

// SetSubnet sets the Subnet field's value.
func (s *InstanceConfigurationForDescribeInstancesOutput) SetSubnet(v *SubnetForDescribeInstancesOutput) *InstanceConfigurationForDescribeInstancesOutput {
	s.Subnet = v
	return s
}

// SetVPC sets the VPC field's value.
func (s *InstanceConfigurationForDescribeInstancesOutput) SetVPC(v *VPCForDescribeInstancesOutput) *InstanceConfigurationForDescribeInstancesOutput {
	s.VPC = v
	return s
}

// SetVersion sets the Version field's value.
func (s *InstanceConfigurationForDescribeInstancesOutput) SetVersion(v string) *InstanceConfigurationForDescribeInstancesOutput {
	s.Version = &v
	return s
}

// SetWarmNodeNumber sets the WarmNodeNumber field's value.
func (s *InstanceConfigurationForDescribeInstancesOutput) SetWarmNodeNumber(v int32) *InstanceConfigurationForDescribeInstancesOutput {
	s.WarmNodeNumber = &v
	return s
}

// SetWarmNodeResourceSpec sets the WarmNodeResourceSpec field's value.
func (s *InstanceConfigurationForDescribeInstancesOutput) SetWarmNodeResourceSpec(v *WarmNodeResourceSpecForDescribeInstancesOutput) *InstanceConfigurationForDescribeInstancesOutput {
	s.WarmNodeResourceSpec = v
	return s
}

// SetWarmNodeStorageSpec sets the WarmNodeStorageSpec field's value.
func (s *InstanceConfigurationForDescribeInstancesOutput) SetWarmNodeStorageSpec(v *WarmNodeStorageSpecForDescribeInstancesOutput) *InstanceConfigurationForDescribeInstancesOutput {
	s.WarmNodeStorageSpec = v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *InstanceConfigurationForDescribeInstancesOutput) SetZoneId(v string) *InstanceConfigurationForDescribeInstancesOutput {
	s.ZoneId = &v
	return s
}

// SetZoneNumber sets the ZoneNumber field's value.
func (s *InstanceConfigurationForDescribeInstancesOutput) SetZoneNumber(v int32) *InstanceConfigurationForDescribeInstancesOutput {
	s.ZoneNumber = &v
	return s
}

type InstanceForDescribeInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CerebroEnabled *bool `type:"boolean" json:",omitempty"`

	CerebroPrivateDomain *string `type:"string" json:",omitempty"`

	CerebroPublicDomain *string `type:"string" json:",omitempty"`

	ChargeEnabled *bool `type:"boolean" json:",omitempty"`

	ClusterId *string `type:"string" json:",omitempty"`

	CreateTime *string `type:"string" json:",omitempty"`

	DeletionProtection *bool `type:"boolean" json:",omitempty"`

	ESEip *string `type:"string" json:",omitempty"`

	ESEipId *string `type:"string" json:",omitempty"`

	ESPrivateEndpoint *string `type:"string" json:",omitempty"`

	ESPrivateIpAllowList *string `type:"string" json:",omitempty"`

	ESPrivateIpWhitelist *string `type:"string" json:",omitempty"`

	ESPublicEndpoint *string `type:"string" json:",omitempty"`

	ESPublicIpAllowList *string `type:"string" json:",omitempty"`

	ESPublicIpWhitelist *string `type:"string" json:",omitempty"`

	EnableESPrivateDomainPublic *bool `type:"boolean" json:",omitempty"`

	EnableESPrivateNetwork *bool `type:"boolean" json:",omitempty"`

	EnableESPublicNetwork *bool `type:"boolean" json:",omitempty"`

	EnableKibanaPrivateDomainPublic *bool `type:"boolean" json:",omitempty"`

	EnableKibanaPrivateNetwork *bool `type:"boolean" json:",omitempty"`

	EnableKibanaPublicNetwork *bool `type:"boolean" json:",omitempty"`

	ExpireDate *string `type:"string" json:",omitempty"`

	InstanceConfiguration *InstanceConfigurationForDescribeInstancesOutput `type:"structure" json:",omitempty"`

	InstanceId *string `type:"string" json:",omitempty"`

	KibanaConfig *KibanaConfigForDescribeInstancesOutput `type:"structure" json:",omitempty"`

	KibanaEip *string `type:"string" json:",omitempty"`

	KibanaEipId *string `type:"string" json:",omitempty"`

	KibanaPrivateDomain *string `type:"string" json:",omitempty"`

	KibanaPrivateIpAllowList *string `type:"string" json:",omitempty"`

	KibanaPrivateIpWhitelist *string `type:"string" json:",omitempty"`

	KibanaPublicDomain *string `type:"string" json:",omitempty"`

	KibanaPublicIpAllowList *string `type:"string" json:",omitempty"`

	KibanaPublicIpWhitelist *string `type:"string" json:",omitempty"`

	MainZoneId *string `type:"string" json:",omitempty"`

	MaintenanceDay []*string `type:"list" json:",omitempty"`

	MaintenanceTime *string `type:"string" json:",omitempty"`

	ResourceTags []*ResourceTagForDescribeInstancesOutput `type:"list" json:",omitempty"`

	Status *string `type:"string" json:",omitempty" enum:"EnumOfStatusForDescribeInstancesOutput"`

	SubInstanceEnable *string `type:"string" json:",omitempty" enum:"EnumOfSubInstanceEnableForDescribeInstancesOutput"`

	SubInstances []*SubInstanceForDescribeInstancesOutput `type:"list" json:",omitempty"`

	SupportColdNode *bool `type:"boolean" json:",omitempty"`

	TotalNodes *int32 `type:"int32" json:",omitempty"`

	TransferInfo *TransferInfoForDescribeInstancesOutput `type:"structure" json:",omitempty"`

	UserId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s InstanceForDescribeInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceForDescribeInstancesOutput) GoString() string {
	return s.String()
}

// SetCerebroEnabled sets the CerebroEnabled field's value.
func (s *InstanceForDescribeInstancesOutput) SetCerebroEnabled(v bool) *InstanceForDescribeInstancesOutput {
	s.CerebroEnabled = &v
	return s
}

// SetCerebroPrivateDomain sets the CerebroPrivateDomain field's value.
func (s *InstanceForDescribeInstancesOutput) SetCerebroPrivateDomain(v string) *InstanceForDescribeInstancesOutput {
	s.CerebroPrivateDomain = &v
	return s
}

// SetCerebroPublicDomain sets the CerebroPublicDomain field's value.
func (s *InstanceForDescribeInstancesOutput) SetCerebroPublicDomain(v string) *InstanceForDescribeInstancesOutput {
	s.CerebroPublicDomain = &v
	return s
}

// SetChargeEnabled sets the ChargeEnabled field's value.
func (s *InstanceForDescribeInstancesOutput) SetChargeEnabled(v bool) *InstanceForDescribeInstancesOutput {
	s.ChargeEnabled = &v
	return s
}

// SetClusterId sets the ClusterId field's value.
func (s *InstanceForDescribeInstancesOutput) SetClusterId(v string) *InstanceForDescribeInstancesOutput {
	s.ClusterId = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *InstanceForDescribeInstancesOutput) SetCreateTime(v string) *InstanceForDescribeInstancesOutput {
	s.CreateTime = &v
	return s
}

// SetDeletionProtection sets the DeletionProtection field's value.
func (s *InstanceForDescribeInstancesOutput) SetDeletionProtection(v bool) *InstanceForDescribeInstancesOutput {
	s.DeletionProtection = &v
	return s
}

// SetESEip sets the ESEip field's value.
func (s *InstanceForDescribeInstancesOutput) SetESEip(v string) *InstanceForDescribeInstancesOutput {
	s.ESEip = &v
	return s
}

// SetESEipId sets the ESEipId field's value.
func (s *InstanceForDescribeInstancesOutput) SetESEipId(v string) *InstanceForDescribeInstancesOutput {
	s.ESEipId = &v
	return s
}

// SetESPrivateEndpoint sets the ESPrivateEndpoint field's value.
func (s *InstanceForDescribeInstancesOutput) SetESPrivateEndpoint(v string) *InstanceForDescribeInstancesOutput {
	s.ESPrivateEndpoint = &v
	return s
}

// SetESPrivateIpAllowList sets the ESPrivateIpAllowList field's value.
func (s *InstanceForDescribeInstancesOutput) SetESPrivateIpAllowList(v string) *InstanceForDescribeInstancesOutput {
	s.ESPrivateIpAllowList = &v
	return s
}

// SetESPrivateIpWhitelist sets the ESPrivateIpWhitelist field's value.
func (s *InstanceForDescribeInstancesOutput) SetESPrivateIpWhitelist(v string) *InstanceForDescribeInstancesOutput {
	s.ESPrivateIpWhitelist = &v
	return s
}

// SetESPublicEndpoint sets the ESPublicEndpoint field's value.
func (s *InstanceForDescribeInstancesOutput) SetESPublicEndpoint(v string) *InstanceForDescribeInstancesOutput {
	s.ESPublicEndpoint = &v
	return s
}

// SetESPublicIpAllowList sets the ESPublicIpAllowList field's value.
func (s *InstanceForDescribeInstancesOutput) SetESPublicIpAllowList(v string) *InstanceForDescribeInstancesOutput {
	s.ESPublicIpAllowList = &v
	return s
}

// SetESPublicIpWhitelist sets the ESPublicIpWhitelist field's value.
func (s *InstanceForDescribeInstancesOutput) SetESPublicIpWhitelist(v string) *InstanceForDescribeInstancesOutput {
	s.ESPublicIpWhitelist = &v
	return s
}

// SetEnableESPrivateDomainPublic sets the EnableESPrivateDomainPublic field's value.
func (s *InstanceForDescribeInstancesOutput) SetEnableESPrivateDomainPublic(v bool) *InstanceForDescribeInstancesOutput {
	s.EnableESPrivateDomainPublic = &v
	return s
}

// SetEnableESPrivateNetwork sets the EnableESPrivateNetwork field's value.
func (s *InstanceForDescribeInstancesOutput) SetEnableESPrivateNetwork(v bool) *InstanceForDescribeInstancesOutput {
	s.EnableESPrivateNetwork = &v
	return s
}

// SetEnableESPublicNetwork sets the EnableESPublicNetwork field's value.
func (s *InstanceForDescribeInstancesOutput) SetEnableESPublicNetwork(v bool) *InstanceForDescribeInstancesOutput {
	s.EnableESPublicNetwork = &v
	return s
}

// SetEnableKibanaPrivateDomainPublic sets the EnableKibanaPrivateDomainPublic field's value.
func (s *InstanceForDescribeInstancesOutput) SetEnableKibanaPrivateDomainPublic(v bool) *InstanceForDescribeInstancesOutput {
	s.EnableKibanaPrivateDomainPublic = &v
	return s
}

// SetEnableKibanaPrivateNetwork sets the EnableKibanaPrivateNetwork field's value.
func (s *InstanceForDescribeInstancesOutput) SetEnableKibanaPrivateNetwork(v bool) *InstanceForDescribeInstancesOutput {
	s.EnableKibanaPrivateNetwork = &v
	return s
}

// SetEnableKibanaPublicNetwork sets the EnableKibanaPublicNetwork field's value.
func (s *InstanceForDescribeInstancesOutput) SetEnableKibanaPublicNetwork(v bool) *InstanceForDescribeInstancesOutput {
	s.EnableKibanaPublicNetwork = &v
	return s
}

// SetExpireDate sets the ExpireDate field's value.
func (s *InstanceForDescribeInstancesOutput) SetExpireDate(v string) *InstanceForDescribeInstancesOutput {
	s.ExpireDate = &v
	return s
}

// SetInstanceConfiguration sets the InstanceConfiguration field's value.
func (s *InstanceForDescribeInstancesOutput) SetInstanceConfiguration(v *InstanceConfigurationForDescribeInstancesOutput) *InstanceForDescribeInstancesOutput {
	s.InstanceConfiguration = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *InstanceForDescribeInstancesOutput) SetInstanceId(v string) *InstanceForDescribeInstancesOutput {
	s.InstanceId = &v
	return s
}

// SetKibanaConfig sets the KibanaConfig field's value.
func (s *InstanceForDescribeInstancesOutput) SetKibanaConfig(v *KibanaConfigForDescribeInstancesOutput) *InstanceForDescribeInstancesOutput {
	s.KibanaConfig = v
	return s
}

// SetKibanaEip sets the KibanaEip field's value.
func (s *InstanceForDescribeInstancesOutput) SetKibanaEip(v string) *InstanceForDescribeInstancesOutput {
	s.KibanaEip = &v
	return s
}

// SetKibanaEipId sets the KibanaEipId field's value.
func (s *InstanceForDescribeInstancesOutput) SetKibanaEipId(v string) *InstanceForDescribeInstancesOutput {
	s.KibanaEipId = &v
	return s
}

// SetKibanaPrivateDomain sets the KibanaPrivateDomain field's value.
func (s *InstanceForDescribeInstancesOutput) SetKibanaPrivateDomain(v string) *InstanceForDescribeInstancesOutput {
	s.KibanaPrivateDomain = &v
	return s
}

// SetKibanaPrivateIpAllowList sets the KibanaPrivateIpAllowList field's value.
func (s *InstanceForDescribeInstancesOutput) SetKibanaPrivateIpAllowList(v string) *InstanceForDescribeInstancesOutput {
	s.KibanaPrivateIpAllowList = &v
	return s
}

// SetKibanaPrivateIpWhitelist sets the KibanaPrivateIpWhitelist field's value.
func (s *InstanceForDescribeInstancesOutput) SetKibanaPrivateIpWhitelist(v string) *InstanceForDescribeInstancesOutput {
	s.KibanaPrivateIpWhitelist = &v
	return s
}

// SetKibanaPublicDomain sets the KibanaPublicDomain field's value.
func (s *InstanceForDescribeInstancesOutput) SetKibanaPublicDomain(v string) *InstanceForDescribeInstancesOutput {
	s.KibanaPublicDomain = &v
	return s
}

// SetKibanaPublicIpAllowList sets the KibanaPublicIpAllowList field's value.
func (s *InstanceForDescribeInstancesOutput) SetKibanaPublicIpAllowList(v string) *InstanceForDescribeInstancesOutput {
	s.KibanaPublicIpAllowList = &v
	return s
}

// SetKibanaPublicIpWhitelist sets the KibanaPublicIpWhitelist field's value.
func (s *InstanceForDescribeInstancesOutput) SetKibanaPublicIpWhitelist(v string) *InstanceForDescribeInstancesOutput {
	s.KibanaPublicIpWhitelist = &v
	return s
}

// SetMainZoneId sets the MainZoneId field's value.
func (s *InstanceForDescribeInstancesOutput) SetMainZoneId(v string) *InstanceForDescribeInstancesOutput {
	s.MainZoneId = &v
	return s
}

// SetMaintenanceDay sets the MaintenanceDay field's value.
func (s *InstanceForDescribeInstancesOutput) SetMaintenanceDay(v []*string) *InstanceForDescribeInstancesOutput {
	s.MaintenanceDay = v
	return s
}

// SetMaintenanceTime sets the MaintenanceTime field's value.
func (s *InstanceForDescribeInstancesOutput) SetMaintenanceTime(v string) *InstanceForDescribeInstancesOutput {
	s.MaintenanceTime = &v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *InstanceForDescribeInstancesOutput) SetResourceTags(v []*ResourceTagForDescribeInstancesOutput) *InstanceForDescribeInstancesOutput {
	s.ResourceTags = v
	return s
}

// SetStatus sets the Status field's value.
func (s *InstanceForDescribeInstancesOutput) SetStatus(v string) *InstanceForDescribeInstancesOutput {
	s.Status = &v
	return s
}

// SetSubInstanceEnable sets the SubInstanceEnable field's value.
func (s *InstanceForDescribeInstancesOutput) SetSubInstanceEnable(v string) *InstanceForDescribeInstancesOutput {
	s.SubInstanceEnable = &v
	return s
}

// SetSubInstances sets the SubInstances field's value.
func (s *InstanceForDescribeInstancesOutput) SetSubInstances(v []*SubInstanceForDescribeInstancesOutput) *InstanceForDescribeInstancesOutput {
	s.SubInstances = v
	return s
}

// SetSupportColdNode sets the SupportColdNode field's value.
func (s *InstanceForDescribeInstancesOutput) SetSupportColdNode(v bool) *InstanceForDescribeInstancesOutput {
	s.SupportColdNode = &v
	return s
}

// SetTotalNodes sets the TotalNodes field's value.
func (s *InstanceForDescribeInstancesOutput) SetTotalNodes(v int32) *InstanceForDescribeInstancesOutput {
	s.TotalNodes = &v
	return s
}

// SetTransferInfo sets the TransferInfo field's value.
func (s *InstanceForDescribeInstancesOutput) SetTransferInfo(v *TransferInfoForDescribeInstancesOutput) *InstanceForDescribeInstancesOutput {
	s.TransferInfo = v
	return s
}

// SetUserId sets the UserId field's value.
func (s *InstanceForDescribeInstancesOutput) SetUserId(v string) *InstanceForDescribeInstancesOutput {
	s.UserId = &v
	return s
}

type KibanaConfigForDescribeInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CookieTTL *int64 `type:"int64" json:",omitempty"`

	KibanaBasePath *string `type:"string" json:",omitempty"`

	RequestTimeout *int64 `min:"30000" max:"120000" type:"int64" json:",omitempty"`

	SessionKeepAlive *bool `type:"boolean" json:",omitempty"`

	SessionTTL *int64 `min:"30000" type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s KibanaConfigForDescribeInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s KibanaConfigForDescribeInstancesOutput) GoString() string {
	return s.String()
}

// SetCookieTTL sets the CookieTTL field's value.
func (s *KibanaConfigForDescribeInstancesOutput) SetCookieTTL(v int64) *KibanaConfigForDescribeInstancesOutput {
	s.CookieTTL = &v
	return s
}

// SetKibanaBasePath sets the KibanaBasePath field's value.
func (s *KibanaConfigForDescribeInstancesOutput) SetKibanaBasePath(v string) *KibanaConfigForDescribeInstancesOutput {
	s.KibanaBasePath = &v
	return s
}

// SetRequestTimeout sets the RequestTimeout field's value.
func (s *KibanaConfigForDescribeInstancesOutput) SetRequestTimeout(v int64) *KibanaConfigForDescribeInstancesOutput {
	s.RequestTimeout = &v
	return s
}

// SetSessionKeepAlive sets the SessionKeepAlive field's value.
func (s *KibanaConfigForDescribeInstancesOutput) SetSessionKeepAlive(v bool) *KibanaConfigForDescribeInstancesOutput {
	s.SessionKeepAlive = &v
	return s
}

// SetSessionTTL sets the SessionTTL field's value.
func (s *KibanaConfigForDescribeInstancesOutput) SetSessionTTL(v int64) *KibanaConfigForDescribeInstancesOutput {
	s.SessionTTL = &v
	return s
}

type KibanaNodeResourceSpecForDescribeInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CPU *int32 `type:"int32" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	DisplayName *string `type:"string" json:",omitempty"`

	Memory *int32 `type:"int32" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s KibanaNodeResourceSpecForDescribeInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s KibanaNodeResourceSpecForDescribeInstancesOutput) GoString() string {
	return s.String()
}

// SetCPU sets the CPU field's value.
func (s *KibanaNodeResourceSpecForDescribeInstancesOutput) SetCPU(v int32) *KibanaNodeResourceSpecForDescribeInstancesOutput {
	s.CPU = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *KibanaNodeResourceSpecForDescribeInstancesOutput) SetDescription(v string) *KibanaNodeResourceSpecForDescribeInstancesOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *KibanaNodeResourceSpecForDescribeInstancesOutput) SetDisplayName(v string) *KibanaNodeResourceSpecForDescribeInstancesOutput {
	s.DisplayName = &v
	return s
}

// SetMemory sets the Memory field's value.
func (s *KibanaNodeResourceSpecForDescribeInstancesOutput) SetMemory(v int32) *KibanaNodeResourceSpecForDescribeInstancesOutput {
	s.Memory = &v
	return s
}

// SetName sets the Name field's value.
func (s *KibanaNodeResourceSpecForDescribeInstancesOutput) SetName(v string) *KibanaNodeResourceSpecForDescribeInstancesOutput {
	s.Name = &v
	return s
}

type MasterNodeResourceSpecForDescribeInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CPU *int32 `type:"int32" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	DisplayName *string `type:"string" json:",omitempty"`

	Memory *int32 `type:"int32" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s MasterNodeResourceSpecForDescribeInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MasterNodeResourceSpecForDescribeInstancesOutput) GoString() string {
	return s.String()
}

// SetCPU sets the CPU field's value.
func (s *MasterNodeResourceSpecForDescribeInstancesOutput) SetCPU(v int32) *MasterNodeResourceSpecForDescribeInstancesOutput {
	s.CPU = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *MasterNodeResourceSpecForDescribeInstancesOutput) SetDescription(v string) *MasterNodeResourceSpecForDescribeInstancesOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *MasterNodeResourceSpecForDescribeInstancesOutput) SetDisplayName(v string) *MasterNodeResourceSpecForDescribeInstancesOutput {
	s.DisplayName = &v
	return s
}

// SetMemory sets the Memory field's value.
func (s *MasterNodeResourceSpecForDescribeInstancesOutput) SetMemory(v int32) *MasterNodeResourceSpecForDescribeInstancesOutput {
	s.Memory = &v
	return s
}

// SetName sets the Name field's value.
func (s *MasterNodeResourceSpecForDescribeInstancesOutput) SetName(v string) *MasterNodeResourceSpecForDescribeInstancesOutput {
	s.Name = &v
	return s
}

type MasterNodeStorageSpecForDescribeInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	DisplayName *string `type:"string" json:",omitempty"`

	MaxSize *int32 `type:"int32" json:",omitempty"`

	MinSize *int32 `type:"int32" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Size *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s MasterNodeStorageSpecForDescribeInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MasterNodeStorageSpecForDescribeInstancesOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *MasterNodeStorageSpecForDescribeInstancesOutput) SetDescription(v string) *MasterNodeStorageSpecForDescribeInstancesOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *MasterNodeStorageSpecForDescribeInstancesOutput) SetDisplayName(v string) *MasterNodeStorageSpecForDescribeInstancesOutput {
	s.DisplayName = &v
	return s
}

// SetMaxSize sets the MaxSize field's value.
func (s *MasterNodeStorageSpecForDescribeInstancesOutput) SetMaxSize(v int32) *MasterNodeStorageSpecForDescribeInstancesOutput {
	s.MaxSize = &v
	return s
}

// SetMinSize sets the MinSize field's value.
func (s *MasterNodeStorageSpecForDescribeInstancesOutput) SetMinSize(v int32) *MasterNodeStorageSpecForDescribeInstancesOutput {
	s.MinSize = &v
	return s
}

// SetName sets the Name field's value.
func (s *MasterNodeStorageSpecForDescribeInstancesOutput) SetName(v string) *MasterNodeStorageSpecForDescribeInstancesOutput {
	s.Name = &v
	return s
}

// SetSize sets the Size field's value.
func (s *MasterNodeStorageSpecForDescribeInstancesOutput) SetSize(v int32) *MasterNodeStorageSpecForDescribeInstancesOutput {
	s.Size = &v
	return s
}

type ReduceSpecConfigForDescribeInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ColdNodeNum *int32 `type:"int32" json:",omitempty"`

	DataNodeNum *int32 `type:"int32" json:",omitempty"`

	EnablePureMaster *bool `type:"boolean" json:",omitempty"`

	MasterNodeNum *int32 `type:"int32" json:",omitempty"`

	WarmNodeNum *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ReduceSpecConfigForDescribeInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ReduceSpecConfigForDescribeInstancesOutput) GoString() string {
	return s.String()
}

// SetColdNodeNum sets the ColdNodeNum field's value.
func (s *ReduceSpecConfigForDescribeInstancesOutput) SetColdNodeNum(v int32) *ReduceSpecConfigForDescribeInstancesOutput {
	s.ColdNodeNum = &v
	return s
}

// SetDataNodeNum sets the DataNodeNum field's value.
func (s *ReduceSpecConfigForDescribeInstancesOutput) SetDataNodeNum(v int32) *ReduceSpecConfigForDescribeInstancesOutput {
	s.DataNodeNum = &v
	return s
}

// SetEnablePureMaster sets the EnablePureMaster field's value.
func (s *ReduceSpecConfigForDescribeInstancesOutput) SetEnablePureMaster(v bool) *ReduceSpecConfigForDescribeInstancesOutput {
	s.EnablePureMaster = &v
	return s
}

// SetMasterNodeNum sets the MasterNodeNum field's value.
func (s *ReduceSpecConfigForDescribeInstancesOutput) SetMasterNodeNum(v int32) *ReduceSpecConfigForDescribeInstancesOutput {
	s.MasterNodeNum = &v
	return s
}

// SetWarmNodeNum sets the WarmNodeNum field's value.
func (s *ReduceSpecConfigForDescribeInstancesOutput) SetWarmNodeNum(v int32) *ReduceSpecConfigForDescribeInstancesOutput {
	s.WarmNodeNum = &v
	return s
}

type ResourceTagForDescribeInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	TagKeys []*string `type:"list" json:",omitempty"`

	TagKvs *TagKvsForDescribeInstancesOutput `type:"structure" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ResourceTagForDescribeInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceTagForDescribeInstancesOutput) GoString() string {
	return s.String()
}

// SetTagKeys sets the TagKeys field's value.
func (s *ResourceTagForDescribeInstancesOutput) SetTagKeys(v []*string) *ResourceTagForDescribeInstancesOutput {
	s.TagKeys = v
	return s
}

// SetTagKvs sets the TagKvs field's value.
func (s *ResourceTagForDescribeInstancesOutput) SetTagKvs(v *TagKvsForDescribeInstancesOutput) *ResourceTagForDescribeInstancesOutput {
	s.TagKvs = v
	return s
}

// SetType sets the Type field's value.
func (s *ResourceTagForDescribeInstancesOutput) SetType(v string) *ResourceTagForDescribeInstancesOutput {
	s.Type = &v
	return s
}

type SubInstanceForDescribeInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	SubInstanceId *string `type:"string" json:",omitempty"`

	SubInstanceStatus *string `type:"string" json:",omitempty" enum:"EnumOfSubInstanceStatusForDescribeInstancesOutput"`

	SubInstanceType *string `type:"string" json:",omitempty" enum:"EnumOfSubInstanceTypeForDescribeInstancesOutput"`
}

// String returns the string representation
func (s SubInstanceForDescribeInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SubInstanceForDescribeInstancesOutput) GoString() string {
	return s.String()
}

// SetSubInstanceId sets the SubInstanceId field's value.
func (s *SubInstanceForDescribeInstancesOutput) SetSubInstanceId(v string) *SubInstanceForDescribeInstancesOutput {
	s.SubInstanceId = &v
	return s
}

// SetSubInstanceStatus sets the SubInstanceStatus field's value.
func (s *SubInstanceForDescribeInstancesOutput) SetSubInstanceStatus(v string) *SubInstanceForDescribeInstancesOutput {
	s.SubInstanceStatus = &v
	return s
}

// SetSubInstanceType sets the SubInstanceType field's value.
func (s *SubInstanceForDescribeInstancesOutput) SetSubInstanceType(v string) *SubInstanceForDescribeInstancesOutput {
	s.SubInstanceType = &v
	return s
}

type SubnetForDescribeInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	SubnetId *string `type:"string" json:",omitempty"`

	SubnetName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s SubnetForDescribeInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SubnetForDescribeInstancesOutput) GoString() string {
	return s.String()
}

// SetSubnetId sets the SubnetId field's value.
func (s *SubnetForDescribeInstancesOutput) SetSubnetId(v string) *SubnetForDescribeInstancesOutput {
	s.SubnetId = &v
	return s
}

// SetSubnetName sets the SubnetName field's value.
func (s *SubnetForDescribeInstancesOutput) SetSubnetName(v string) *SubnetForDescribeInstancesOutput {
	s.SubnetName = &v
	return s
}

type TagFilterForDescribeInstancesInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Tags []*TagForDescribeInstancesInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s TagFilterForDescribeInstancesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagFilterForDescribeInstancesInput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *TagFilterForDescribeInstancesInput) SetTags(v []*TagForDescribeInstancesInput) *TagFilterForDescribeInstancesInput {
	s.Tags = v
	return s
}

type TagForDescribeInstancesInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Values []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s TagForDescribeInstancesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForDescribeInstancesInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForDescribeInstancesInput) SetKey(v string) *TagForDescribeInstancesInput {
	s.Key = &v
	return s
}

// SetValues sets the Values field's value.
func (s *TagForDescribeInstancesInput) SetValues(v []*string) *TagForDescribeInstancesInput {
	s.Values = v
	return s
}

type TagKvsForDescribeInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s TagKvsForDescribeInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagKvsForDescribeInstancesOutput) GoString() string {
	return s.String()
}

type TransferInfoForDescribeInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ForbidStop *bool `type:"boolean" json:",omitempty"`

	ReduceSpecConfig *ReduceSpecConfigForDescribeInstancesOutput `type:"structure" json:",omitempty"`

	TransferProgress *float64 `type:"double" json:",omitempty"`

	TransferStatus *string `type:"string" json:",omitempty" enum:"EnumOfTransferStatusForDescribeInstancesOutput"`

	TransferTaskId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TransferInfoForDescribeInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TransferInfoForDescribeInstancesOutput) GoString() string {
	return s.String()
}

// SetForbidStop sets the ForbidStop field's value.
func (s *TransferInfoForDescribeInstancesOutput) SetForbidStop(v bool) *TransferInfoForDescribeInstancesOutput {
	s.ForbidStop = &v
	return s
}

// SetReduceSpecConfig sets the ReduceSpecConfig field's value.
func (s *TransferInfoForDescribeInstancesOutput) SetReduceSpecConfig(v *ReduceSpecConfigForDescribeInstancesOutput) *TransferInfoForDescribeInstancesOutput {
	s.ReduceSpecConfig = v
	return s
}

// SetTransferProgress sets the TransferProgress field's value.
func (s *TransferInfoForDescribeInstancesOutput) SetTransferProgress(v float64) *TransferInfoForDescribeInstancesOutput {
	s.TransferProgress = &v
	return s
}

// SetTransferStatus sets the TransferStatus field's value.
func (s *TransferInfoForDescribeInstancesOutput) SetTransferStatus(v string) *TransferInfoForDescribeInstancesOutput {
	s.TransferStatus = &v
	return s
}

// SetTransferTaskId sets the TransferTaskId field's value.
func (s *TransferInfoForDescribeInstancesOutput) SetTransferTaskId(v string) *TransferInfoForDescribeInstancesOutput {
	s.TransferTaskId = &v
	return s
}

type VPCForDescribeInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	VpcId *string `type:"string" json:",omitempty"`

	VpcName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s VPCForDescribeInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VPCForDescribeInstancesOutput) GoString() string {
	return s.String()
}

// SetVpcId sets the VpcId field's value.
func (s *VPCForDescribeInstancesOutput) SetVpcId(v string) *VPCForDescribeInstancesOutput {
	s.VpcId = &v
	return s
}

// SetVpcName sets the VpcName field's value.
func (s *VPCForDescribeInstancesOutput) SetVpcName(v string) *VPCForDescribeInstancesOutput {
	s.VpcName = &v
	return s
}

type WarmNodeResourceSpecForDescribeInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CPU *int32 `type:"int32" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	DisplayName *string `type:"string" json:",omitempty"`

	Memory *int32 `type:"int32" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s WarmNodeResourceSpecForDescribeInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s WarmNodeResourceSpecForDescribeInstancesOutput) GoString() string {
	return s.String()
}

// SetCPU sets the CPU field's value.
func (s *WarmNodeResourceSpecForDescribeInstancesOutput) SetCPU(v int32) *WarmNodeResourceSpecForDescribeInstancesOutput {
	s.CPU = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *WarmNodeResourceSpecForDescribeInstancesOutput) SetDescription(v string) *WarmNodeResourceSpecForDescribeInstancesOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *WarmNodeResourceSpecForDescribeInstancesOutput) SetDisplayName(v string) *WarmNodeResourceSpecForDescribeInstancesOutput {
	s.DisplayName = &v
	return s
}

// SetMemory sets the Memory field's value.
func (s *WarmNodeResourceSpecForDescribeInstancesOutput) SetMemory(v int32) *WarmNodeResourceSpecForDescribeInstancesOutput {
	s.Memory = &v
	return s
}

// SetName sets the Name field's value.
func (s *WarmNodeResourceSpecForDescribeInstancesOutput) SetName(v string) *WarmNodeResourceSpecForDescribeInstancesOutput {
	s.Name = &v
	return s
}

type WarmNodeStorageSpecForDescribeInstancesOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	DisplayName *string `type:"string" json:",omitempty"`

	MaxSize *int32 `type:"int32" json:",omitempty"`

	MinSize *int32 `type:"int32" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Size *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s WarmNodeStorageSpecForDescribeInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s WarmNodeStorageSpecForDescribeInstancesOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *WarmNodeStorageSpecForDescribeInstancesOutput) SetDescription(v string) *WarmNodeStorageSpecForDescribeInstancesOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *WarmNodeStorageSpecForDescribeInstancesOutput) SetDisplayName(v string) *WarmNodeStorageSpecForDescribeInstancesOutput {
	s.DisplayName = &v
	return s
}

// SetMaxSize sets the MaxSize field's value.
func (s *WarmNodeStorageSpecForDescribeInstancesOutput) SetMaxSize(v int32) *WarmNodeStorageSpecForDescribeInstancesOutput {
	s.MaxSize = &v
	return s
}

// SetMinSize sets the MinSize field's value.
func (s *WarmNodeStorageSpecForDescribeInstancesOutput) SetMinSize(v int32) *WarmNodeStorageSpecForDescribeInstancesOutput {
	s.MinSize = &v
	return s
}

// SetName sets the Name field's value.
func (s *WarmNodeStorageSpecForDescribeInstancesOutput) SetName(v string) *WarmNodeStorageSpecForDescribeInstancesOutput {
	s.Name = &v
	return s
}

// SetSize sets the Size field's value.
func (s *WarmNodeStorageSpecForDescribeInstancesOutput) SetSize(v int32) *WarmNodeStorageSpecForDescribeInstancesOutput {
	s.Size = &v
	return s
}

const (
	// EnumOfChargeTypeForDescribeInstancesOutputPrePaid is a EnumOfChargeTypeForDescribeInstancesOutput enum value
	EnumOfChargeTypeForDescribeInstancesOutputPrePaid = "PrePaid"

	// EnumOfChargeTypeForDescribeInstancesOutputPostPaid is a EnumOfChargeTypeForDescribeInstancesOutput enum value
	EnumOfChargeTypeForDescribeInstancesOutputPostPaid = "PostPaid"
)

const (
	// EnumOfNameForDescribeInstancesInputInstanceId is a EnumOfNameForDescribeInstancesInput enum value
	EnumOfNameForDescribeInstancesInputInstanceId = "InstanceId"

	// EnumOfNameForDescribeInstancesInputInstanceName is a EnumOfNameForDescribeInstancesInput enum value
	EnumOfNameForDescribeInstancesInputInstanceName = "InstanceName"

	// EnumOfNameForDescribeInstancesInputZoneId is a EnumOfNameForDescribeInstancesInput enum value
	EnumOfNameForDescribeInstancesInputZoneId = "ZoneId"

	// EnumOfNameForDescribeInstancesInputStatus is a EnumOfNameForDescribeInstancesInput enum value
	EnumOfNameForDescribeInstancesInputStatus = "Status"

	// EnumOfNameForDescribeInstancesInputVersion is a EnumOfNameForDescribeInstancesInput enum value
	EnumOfNameForDescribeInstancesInputVersion = "Version"

	// EnumOfNameForDescribeInstancesInputChargeType is a EnumOfNameForDescribeInstancesInput enum value
	EnumOfNameForDescribeInstancesInputChargeType = "ChargeType"
)

const (
	// EnumOfStatusForDescribeInstancesOutputInit is a EnumOfStatusForDescribeInstancesOutput enum value
	EnumOfStatusForDescribeInstancesOutputInit = "Init"

	// EnumOfStatusForDescribeInstancesOutputWaitingPaid is a EnumOfStatusForDescribeInstancesOutput enum value
	EnumOfStatusForDescribeInstancesOutputWaitingPaid = "WaitingPaid"

	// EnumOfStatusForDescribeInstancesOutputWaitCreate is a EnumOfStatusForDescribeInstancesOutput enum value
	EnumOfStatusForDescribeInstancesOutputWaitCreate = "WaitCreate"

	// EnumOfStatusForDescribeInstancesOutputCreating is a EnumOfStatusForDescribeInstancesOutput enum value
	EnumOfStatusForDescribeInstancesOutputCreating = "Creating"

	// EnumOfStatusForDescribeInstancesOutputRunning is a EnumOfStatusForDescribeInstancesOutput enum value
	EnumOfStatusForDescribeInstancesOutputRunning = "Running"

	// EnumOfStatusForDescribeInstancesOutputRestarting is a EnumOfStatusForDescribeInstancesOutput enum value
	EnumOfStatusForDescribeInstancesOutputRestarting = "Restarting"

	// EnumOfStatusForDescribeInstancesOutputUpdating is a EnumOfStatusForDescribeInstancesOutput enum value
	EnumOfStatusForDescribeInstancesOutputUpdating = "Updating"

	// EnumOfStatusForDescribeInstancesOutputWaitScale is a EnumOfStatusForDescribeInstancesOutput enum value
	EnumOfStatusForDescribeInstancesOutputWaitScale = "WaitScale"

	// EnumOfStatusForDescribeInstancesOutputScaling is a EnumOfStatusForDescribeInstancesOutput enum value
	EnumOfStatusForDescribeInstancesOutputScaling = "Scaling"

	// EnumOfStatusForDescribeInstancesOutputRestoring is a EnumOfStatusForDescribeInstancesOutput enum value
	EnumOfStatusForDescribeInstancesOutputRestoring = "Restoring"

	// EnumOfStatusForDescribeInstancesOutputUpgrading is a EnumOfStatusForDescribeInstancesOutput enum value
	EnumOfStatusForDescribeInstancesOutputUpgrading = "Upgrading"

	// EnumOfStatusForDescribeInstancesOutputClosing is a EnumOfStatusForDescribeInstancesOutput enum value
	EnumOfStatusForDescribeInstancesOutputClosing = "Closing"

	// EnumOfStatusForDescribeInstancesOutputClosed is a EnumOfStatusForDescribeInstancesOutput enum value
	EnumOfStatusForDescribeInstancesOutputClosed = "Closed"

	// EnumOfStatusForDescribeInstancesOutputReclaiming is a EnumOfStatusForDescribeInstancesOutput enum value
	EnumOfStatusForDescribeInstancesOutputReclaiming = "Reclaiming"

	// EnumOfStatusForDescribeInstancesOutputResuming is a EnumOfStatusForDescribeInstancesOutput enum value
	EnumOfStatusForDescribeInstancesOutputResuming = "Resuming"

	// EnumOfStatusForDescribeInstancesOutputWaitRelease is a EnumOfStatusForDescribeInstancesOutput enum value
	EnumOfStatusForDescribeInstancesOutputWaitRelease = "WaitRelease"

	// EnumOfStatusForDescribeInstancesOutputReleasing is a EnumOfStatusForDescribeInstancesOutput enum value
	EnumOfStatusForDescribeInstancesOutputReleasing = "Releasing"

	// EnumOfStatusForDescribeInstancesOutputReleased is a EnumOfStatusForDescribeInstancesOutput enum value
	EnumOfStatusForDescribeInstancesOutputReleased = "Released"

	// EnumOfStatusForDescribeInstancesOutputDeleted is a EnumOfStatusForDescribeInstancesOutput enum value
	EnumOfStatusForDescribeInstancesOutputDeleted = "Deleted"

	// EnumOfStatusForDescribeInstancesOutputDestroying is a EnumOfStatusForDescribeInstancesOutput enum value
	EnumOfStatusForDescribeInstancesOutputDestroying = "Destroying"

	// EnumOfStatusForDescribeInstancesOutputDestroyed is a EnumOfStatusForDescribeInstancesOutput enum value
	EnumOfStatusForDescribeInstancesOutputDestroyed = "Destroyed"

	// EnumOfStatusForDescribeInstancesOutputCreateFailed is a EnumOfStatusForDescribeInstancesOutput enum value
	EnumOfStatusForDescribeInstancesOutputCreateFailed = "CreateFailed"

	// EnumOfStatusForDescribeInstancesOutputTaskFailed is a EnumOfStatusForDescribeInstancesOutput enum value
	EnumOfStatusForDescribeInstancesOutputTaskFailed = "TaskFailed"

	// EnumOfStatusForDescribeInstancesOutputError is a EnumOfStatusForDescribeInstancesOutput enum value
	EnumOfStatusForDescribeInstancesOutputError = "Error"

	// EnumOfStatusForDescribeInstancesOutputWarn is a EnumOfStatusForDescribeInstancesOutput enum value
	EnumOfStatusForDescribeInstancesOutputWarn = "Warn"

	// EnumOfStatusForDescribeInstancesOutputUnknown is a EnumOfStatusForDescribeInstancesOutput enum value
	EnumOfStatusForDescribeInstancesOutputUnknown = "Unknown"
)

const (
	// EnumOfSubInstanceEnableForDescribeInstancesOutputNone is a EnumOfSubInstanceEnableForDescribeInstancesOutput enum value
	EnumOfSubInstanceEnableForDescribeInstancesOutputNone = "None"

	// EnumOfSubInstanceEnableForDescribeInstancesOutputAi is a EnumOfSubInstanceEnableForDescribeInstancesOutput enum value
	EnumOfSubInstanceEnableForDescribeInstancesOutputAi = " AI"

	// EnumOfSubInstanceEnableForDescribeInstancesOutputSql is a EnumOfSubInstanceEnableForDescribeInstancesOutput enum value
	EnumOfSubInstanceEnableForDescribeInstancesOutputSql = " Sql"

	// EnumOfSubInstanceEnableForDescribeInstancesOutputAiSql is a EnumOfSubInstanceEnableForDescribeInstancesOutput enum value
	EnumOfSubInstanceEnableForDescribeInstancesOutputAiSql = " AI_Sql"
)

const (
	// EnumOfSubInstanceStatusForDescribeInstancesOutputAvailable is a EnumOfSubInstanceStatusForDescribeInstancesOutput enum value
	EnumOfSubInstanceStatusForDescribeInstancesOutputAvailable = "AVAILABLE"

	// EnumOfSubInstanceStatusForDescribeInstancesOutputReleased is a EnumOfSubInstanceStatusForDescribeInstancesOutput enum value
	EnumOfSubInstanceStatusForDescribeInstancesOutputReleased = "RELEASED"
)

const (
	// EnumOfSubInstanceTypeForDescribeInstancesOutputSql is a EnumOfSubInstanceTypeForDescribeInstancesOutput enum value
	EnumOfSubInstanceTypeForDescribeInstancesOutputSql = "Sql"

	// EnumOfSubInstanceTypeForDescribeInstancesOutputAi is a EnumOfSubInstanceTypeForDescribeInstancesOutput enum value
	EnumOfSubInstanceTypeForDescribeInstancesOutputAi = "AI"
)

const (
	// EnumOfTransferStatusForDescribeInstancesOutputCreated is a EnumOfTransferStatusForDescribeInstancesOutput enum value
	EnumOfTransferStatusForDescribeInstancesOutputCreated = "CREATED"

	// EnumOfTransferStatusForDescribeInstancesOutputRunning is a EnumOfTransferStatusForDescribeInstancesOutput enum value
	EnumOfTransferStatusForDescribeInstancesOutputRunning = "RUNNING"

	// EnumOfTransferStatusForDescribeInstancesOutputFinish is a EnumOfTransferStatusForDescribeInstancesOutput enum value
	EnumOfTransferStatusForDescribeInstancesOutputFinish = "FINISH"

	// EnumOfTransferStatusForDescribeInstancesOutputCanceling is a EnumOfTransferStatusForDescribeInstancesOutput enum value
	EnumOfTransferStatusForDescribeInstancesOutputCanceling = "CANCELING"

	// EnumOfTransferStatusForDescribeInstancesOutputCancel is a EnumOfTransferStatusForDescribeInstancesOutput enum value
	EnumOfTransferStatusForDescribeInstancesOutputCancel = "CANCEL"

	// EnumOfTransferStatusForDescribeInstancesOutputCancelFailed is a EnumOfTransferStatusForDescribeInstancesOutput enum value
	EnumOfTransferStatusForDescribeInstancesOutputCancelFailed = "CANCEL_FAILED"

	// EnumOfTransferStatusForDescribeInstancesOutputTimeout is a EnumOfTransferStatusForDescribeInstancesOutput enum value
	EnumOfTransferStatusForDescribeInstancesOutputTimeout = "TIMEOUT"

	// EnumOfTransferStatusForDescribeInstancesOutputShrinkComplete is a EnumOfTransferStatusForDescribeInstancesOutput enum value
	EnumOfTransferStatusForDescribeInstancesOutputShrinkComplete = "SHRINK_COMPLETE"
)

const (
	// EnumOfVersionForDescribeInstancesOutputV67 is a EnumOfVersionForDescribeInstancesOutput enum value
	EnumOfVersionForDescribeInstancesOutputV67 = "V6_7"

	// EnumOfVersionForDescribeInstancesOutputV710 is a EnumOfVersionForDescribeInstancesOutput enum value
	EnumOfVersionForDescribeInstancesOutputV710 = "V7_10"

	// EnumOfVersionForDescribeInstancesOutputV7Tls is a EnumOfVersionForDescribeInstancesOutput enum value
	EnumOfVersionForDescribeInstancesOutputV7Tls = "V7_TLS"

	// EnumOfVersionForDescribeInstancesOutputV7Byte is a EnumOfVersionForDescribeInstancesOutput enum value
	EnumOfVersionForDescribeInstancesOutputV7Byte = "V7_BYTE"

	// EnumOfVersionForDescribeInstancesOutputOpenSearch29 is a EnumOfVersionForDescribeInstancesOutput enum value
	EnumOfVersionForDescribeInstancesOutputOpenSearch29 = "OPEN_SEARCH_2_9"
)
