// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package escloud

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opDescribeInstanceCommon = "DescribeInstance"

// DescribeInstanceCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeInstanceCommon operation. The "output" return
// value will be populated with the DescribeInstanceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeInstanceCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeInstanceCommon Send returns without error.
//
// See DescribeInstanceCommon for more information on using the DescribeInstanceCommon
// API call, and error handling.
//
//    // Example sending a request using the DescribeInstanceCommonRequest method.
//    req, resp := client.DescribeInstanceCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ESCLOUD) DescribeInstanceCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opDescribeInstanceCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeInstanceCommon API operation for ESCLOUD.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ESCLOUD's
// API operation DescribeInstanceCommon for usage and error information.
func (c *ESCLOUD) DescribeInstanceCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.DescribeInstanceCommonRequest(input)
	return out, req.Send()
}

// DescribeInstanceCommonWithContext is the same as DescribeInstanceCommon with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstanceCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ESCLOUD) DescribeInstanceCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.DescribeInstanceCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDescribeInstance = "DescribeInstance"

// DescribeInstanceRequest generates a "volcengine/request.Request" representing the
// client's request for the DescribeInstance operation. The "output" return
// value will be populated with the DescribeInstanceCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned DescribeInstanceCommon Request to send the API call to the service.
// the "output" return value is not valid until after DescribeInstanceCommon Send returns without error.
//
// See DescribeInstance for more information on using the DescribeInstance
// API call, and error handling.
//
//    // Example sending a request using the DescribeInstanceRequest method.
//    req, resp := client.DescribeInstanceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ESCLOUD) DescribeInstanceRequest(input *DescribeInstanceInput) (req *request.Request, output *DescribeInstanceOutput) {
	op := &request.Operation{
		Name:       opDescribeInstance,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeInstanceInput{}
	}

	output = &DescribeInstanceOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// DescribeInstance API operation for ESCLOUD.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ESCLOUD's
// API operation DescribeInstance for usage and error information.
func (c *ESCLOUD) DescribeInstance(input *DescribeInstanceInput) (*DescribeInstanceOutput, error) {
	req, out := c.DescribeInstanceRequest(input)
	return out, req.Send()
}

// DescribeInstanceWithContext is the same as DescribeInstance with the addition of
// the ability to pass a context and additional request options.
//
// See DescribeInstance for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ESCLOUD) DescribeInstanceWithContext(ctx volcengine.Context, input *DescribeInstanceInput, opts ...request.Option) (*DescribeInstanceOutput, error) {
	req, out := c.DescribeInstanceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ColdNodeResourceSpecForDescribeInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CPU *int32 `type:"int32" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	DisplayName *string `type:"string" json:",omitempty"`

	Memory *int32 `type:"int32" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ColdNodeResourceSpecForDescribeInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ColdNodeResourceSpecForDescribeInstanceOutput) GoString() string {
	return s.String()
}

// SetCPU sets the CPU field's value.
func (s *ColdNodeResourceSpecForDescribeInstanceOutput) SetCPU(v int32) *ColdNodeResourceSpecForDescribeInstanceOutput {
	s.CPU = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ColdNodeResourceSpecForDescribeInstanceOutput) SetDescription(v string) *ColdNodeResourceSpecForDescribeInstanceOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *ColdNodeResourceSpecForDescribeInstanceOutput) SetDisplayName(v string) *ColdNodeResourceSpecForDescribeInstanceOutput {
	s.DisplayName = &v
	return s
}

// SetMemory sets the Memory field's value.
func (s *ColdNodeResourceSpecForDescribeInstanceOutput) SetMemory(v int32) *ColdNodeResourceSpecForDescribeInstanceOutput {
	s.Memory = &v
	return s
}

// SetName sets the Name field's value.
func (s *ColdNodeResourceSpecForDescribeInstanceOutput) SetName(v string) *ColdNodeResourceSpecForDescribeInstanceOutput {
	s.Name = &v
	return s
}

type ColdNodeStorageSpecForDescribeInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	DisplayName *string `type:"string" json:",omitempty"`

	MaxSize *int32 `type:"int32" json:",omitempty"`

	MinSize *int32 `type:"int32" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Size *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ColdNodeStorageSpecForDescribeInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ColdNodeStorageSpecForDescribeInstanceOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *ColdNodeStorageSpecForDescribeInstanceOutput) SetDescription(v string) *ColdNodeStorageSpecForDescribeInstanceOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *ColdNodeStorageSpecForDescribeInstanceOutput) SetDisplayName(v string) *ColdNodeStorageSpecForDescribeInstanceOutput {
	s.DisplayName = &v
	return s
}

// SetMaxSize sets the MaxSize field's value.
func (s *ColdNodeStorageSpecForDescribeInstanceOutput) SetMaxSize(v int32) *ColdNodeStorageSpecForDescribeInstanceOutput {
	s.MaxSize = &v
	return s
}

// SetMinSize sets the MinSize field's value.
func (s *ColdNodeStorageSpecForDescribeInstanceOutput) SetMinSize(v int32) *ColdNodeStorageSpecForDescribeInstanceOutput {
	s.MinSize = &v
	return s
}

// SetName sets the Name field's value.
func (s *ColdNodeStorageSpecForDescribeInstanceOutput) SetName(v string) *ColdNodeStorageSpecForDescribeInstanceOutput {
	s.Name = &v
	return s
}

// SetSize sets the Size field's value.
func (s *ColdNodeStorageSpecForDescribeInstanceOutput) SetSize(v int32) *ColdNodeStorageSpecForDescribeInstanceOutput {
	s.Size = &v
	return s
}

type CoordinatorNodeResourceSpecForDescribeInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CPU *int32 `type:"int32" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	DisplayName *string `type:"string" json:",omitempty"`

	Memory *int32 `type:"int32" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CoordinatorNodeResourceSpecForDescribeInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CoordinatorNodeResourceSpecForDescribeInstanceOutput) GoString() string {
	return s.String()
}

// SetCPU sets the CPU field's value.
func (s *CoordinatorNodeResourceSpecForDescribeInstanceOutput) SetCPU(v int32) *CoordinatorNodeResourceSpecForDescribeInstanceOutput {
	s.CPU = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CoordinatorNodeResourceSpecForDescribeInstanceOutput) SetDescription(v string) *CoordinatorNodeResourceSpecForDescribeInstanceOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CoordinatorNodeResourceSpecForDescribeInstanceOutput) SetDisplayName(v string) *CoordinatorNodeResourceSpecForDescribeInstanceOutput {
	s.DisplayName = &v
	return s
}

// SetMemory sets the Memory field's value.
func (s *CoordinatorNodeResourceSpecForDescribeInstanceOutput) SetMemory(v int32) *CoordinatorNodeResourceSpecForDescribeInstanceOutput {
	s.Memory = &v
	return s
}

// SetName sets the Name field's value.
func (s *CoordinatorNodeResourceSpecForDescribeInstanceOutput) SetName(v string) *CoordinatorNodeResourceSpecForDescribeInstanceOutput {
	s.Name = &v
	return s
}

type CoordinatorNodeStorageSpecForDescribeInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	DisplayName *string `type:"string" json:",omitempty"`

	MaxSize *int32 `type:"int32" json:",omitempty"`

	MinSize *int32 `type:"int32" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Size *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s CoordinatorNodeStorageSpecForDescribeInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CoordinatorNodeStorageSpecForDescribeInstanceOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *CoordinatorNodeStorageSpecForDescribeInstanceOutput) SetDescription(v string) *CoordinatorNodeStorageSpecForDescribeInstanceOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CoordinatorNodeStorageSpecForDescribeInstanceOutput) SetDisplayName(v string) *CoordinatorNodeStorageSpecForDescribeInstanceOutput {
	s.DisplayName = &v
	return s
}

// SetMaxSize sets the MaxSize field's value.
func (s *CoordinatorNodeStorageSpecForDescribeInstanceOutput) SetMaxSize(v int32) *CoordinatorNodeStorageSpecForDescribeInstanceOutput {
	s.MaxSize = &v
	return s
}

// SetMinSize sets the MinSize field's value.
func (s *CoordinatorNodeStorageSpecForDescribeInstanceOutput) SetMinSize(v int32) *CoordinatorNodeStorageSpecForDescribeInstanceOutput {
	s.MinSize = &v
	return s
}

// SetName sets the Name field's value.
func (s *CoordinatorNodeStorageSpecForDescribeInstanceOutput) SetName(v string) *CoordinatorNodeStorageSpecForDescribeInstanceOutput {
	s.Name = &v
	return s
}

// SetSize sets the Size field's value.
func (s *CoordinatorNodeStorageSpecForDescribeInstanceOutput) SetSize(v int32) *CoordinatorNodeStorageSpecForDescribeInstanceOutput {
	s.Size = &v
	return s
}

type DescribeInstanceInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// InstanceId is a required field
	InstanceId *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s DescribeInstanceInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstanceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeInstanceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DescribeInstanceInput"}
	if s.InstanceId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetInstanceId sets the InstanceId field's value.
func (s *DescribeInstanceInput) SetInstanceId(v string) *DescribeInstanceInput {
	s.InstanceId = &v
	return s
}

type DescribeInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	InstanceInfo *InstanceInfoForDescribeInstanceOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s DescribeInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DescribeInstanceOutput) GoString() string {
	return s.String()
}

// SetInstanceInfo sets the InstanceInfo field's value.
func (s *DescribeInstanceOutput) SetInstanceInfo(v *InstanceInfoForDescribeInstanceOutput) *DescribeInstanceOutput {
	s.InstanceInfo = v
	return s
}

type HotNodeResourceSpecForDescribeInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CPU *int32 `type:"int32" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	DisplayName *string `type:"string" json:",omitempty"`

	Memory *int32 `type:"int32" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s HotNodeResourceSpecForDescribeInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HotNodeResourceSpecForDescribeInstanceOutput) GoString() string {
	return s.String()
}

// SetCPU sets the CPU field's value.
func (s *HotNodeResourceSpecForDescribeInstanceOutput) SetCPU(v int32) *HotNodeResourceSpecForDescribeInstanceOutput {
	s.CPU = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *HotNodeResourceSpecForDescribeInstanceOutput) SetDescription(v string) *HotNodeResourceSpecForDescribeInstanceOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *HotNodeResourceSpecForDescribeInstanceOutput) SetDisplayName(v string) *HotNodeResourceSpecForDescribeInstanceOutput {
	s.DisplayName = &v
	return s
}

// SetMemory sets the Memory field's value.
func (s *HotNodeResourceSpecForDescribeInstanceOutput) SetMemory(v int32) *HotNodeResourceSpecForDescribeInstanceOutput {
	s.Memory = &v
	return s
}

// SetName sets the Name field's value.
func (s *HotNodeResourceSpecForDescribeInstanceOutput) SetName(v string) *HotNodeResourceSpecForDescribeInstanceOutput {
	s.Name = &v
	return s
}

type HotNodeStorageSpecForDescribeInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	DisplayName *string `type:"string" json:",omitempty"`

	MaxSize *int32 `type:"int32" json:",omitempty"`

	MinSize *int32 `type:"int32" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Size *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s HotNodeStorageSpecForDescribeInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HotNodeStorageSpecForDescribeInstanceOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *HotNodeStorageSpecForDescribeInstanceOutput) SetDescription(v string) *HotNodeStorageSpecForDescribeInstanceOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *HotNodeStorageSpecForDescribeInstanceOutput) SetDisplayName(v string) *HotNodeStorageSpecForDescribeInstanceOutput {
	s.DisplayName = &v
	return s
}

// SetMaxSize sets the MaxSize field's value.
func (s *HotNodeStorageSpecForDescribeInstanceOutput) SetMaxSize(v int32) *HotNodeStorageSpecForDescribeInstanceOutput {
	s.MaxSize = &v
	return s
}

// SetMinSize sets the MinSize field's value.
func (s *HotNodeStorageSpecForDescribeInstanceOutput) SetMinSize(v int32) *HotNodeStorageSpecForDescribeInstanceOutput {
	s.MinSize = &v
	return s
}

// SetName sets the Name field's value.
func (s *HotNodeStorageSpecForDescribeInstanceOutput) SetName(v string) *HotNodeStorageSpecForDescribeInstanceOutput {
	s.Name = &v
	return s
}

// SetSize sets the Size field's value.
func (s *HotNodeStorageSpecForDescribeInstanceOutput) SetSize(v int32) *HotNodeStorageSpecForDescribeInstanceOutput {
	s.Size = &v
	return s
}

type InstanceConfigurationForDescribeInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AdminUserName *string `type:"string" json:",omitempty"`

	ChargeType *string `type:"string" json:",omitempty" enum:"EnumOfChargeTypeForDescribeInstanceOutput"`

	ColdNodeNumber *int32 `type:"int32" json:",omitempty"`

	ColdNodeResourceSpec *ColdNodeResourceSpecForDescribeInstanceOutput `type:"structure" json:",omitempty"`

	ColdNodeStorageSpec *ColdNodeStorageSpecForDescribeInstanceOutput `type:"structure" json:",omitempty"`

	CoordinatorNodeNumber *int32 `type:"int32" json:",omitempty"`

	CoordinatorNodeResourceSpec *CoordinatorNodeResourceSpecForDescribeInstanceOutput `type:"structure" json:",omitempty"`

	CoordinatorNodeStorageSpec *CoordinatorNodeStorageSpecForDescribeInstanceOutput `type:"structure" json:",omitempty"`

	EnableHttps *bool `type:"boolean" json:",omitempty"`

	EnablePureMaster *bool `type:"boolean" json:",omitempty"`

	HotNodeNumber *int32 `type:"int32" json:",omitempty"`

	HotNodeResourceSpec *HotNodeResourceSpecForDescribeInstanceOutput `type:"structure" json:",omitempty"`

	HotNodeStorageSpec *HotNodeStorageSpecForDescribeInstanceOutput `type:"structure" json:",omitempty"`

	InstanceName *string `type:"string" json:",omitempty"`

	KibanaNodeNumber *int32 `type:"int32" json:",omitempty"`

	KibanaNodeResourceSpec *KibanaNodeResourceSpecForDescribeInstanceOutput `type:"structure" json:",omitempty"`

	MasterNodeNumber *int32 `type:"int32" json:",omitempty"`

	MasterNodeResourceSpec *MasterNodeResourceSpecForDescribeInstanceOutput `type:"structure" json:",omitempty"`

	MasterNodeStorageSpec *MasterNodeStorageSpecForDescribeInstanceOutput `type:"structure" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`

	RegionId *string `type:"string" json:",omitempty"`

	Subnet *SubnetForDescribeInstanceOutput `type:"structure" json:",omitempty"`

	VPC *VPCForDescribeInstanceOutput `type:"structure" json:",omitempty"`

	Version *string `type:"string" json:",omitempty" enum:"EnumOfVersionForDescribeInstanceOutput"`

	WarmNodeNumber *int32 `type:"int32" json:",omitempty"`

	WarmNodeResourceSpec *WarmNodeResourceSpecForDescribeInstanceOutput `type:"structure" json:",omitempty"`

	WarmNodeStorageSpec *WarmNodeStorageSpecForDescribeInstanceOutput `type:"structure" json:",omitempty"`

	ZoneId *string `type:"string" json:",omitempty"`

	ZoneNumber *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s InstanceConfigurationForDescribeInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceConfigurationForDescribeInstanceOutput) GoString() string {
	return s.String()
}

// SetAdminUserName sets the AdminUserName field's value.
func (s *InstanceConfigurationForDescribeInstanceOutput) SetAdminUserName(v string) *InstanceConfigurationForDescribeInstanceOutput {
	s.AdminUserName = &v
	return s
}

// SetChargeType sets the ChargeType field's value.
func (s *InstanceConfigurationForDescribeInstanceOutput) SetChargeType(v string) *InstanceConfigurationForDescribeInstanceOutput {
	s.ChargeType = &v
	return s
}

// SetColdNodeNumber sets the ColdNodeNumber field's value.
func (s *InstanceConfigurationForDescribeInstanceOutput) SetColdNodeNumber(v int32) *InstanceConfigurationForDescribeInstanceOutput {
	s.ColdNodeNumber = &v
	return s
}

// SetColdNodeResourceSpec sets the ColdNodeResourceSpec field's value.
func (s *InstanceConfigurationForDescribeInstanceOutput) SetColdNodeResourceSpec(v *ColdNodeResourceSpecForDescribeInstanceOutput) *InstanceConfigurationForDescribeInstanceOutput {
	s.ColdNodeResourceSpec = v
	return s
}

// SetColdNodeStorageSpec sets the ColdNodeStorageSpec field's value.
func (s *InstanceConfigurationForDescribeInstanceOutput) SetColdNodeStorageSpec(v *ColdNodeStorageSpecForDescribeInstanceOutput) *InstanceConfigurationForDescribeInstanceOutput {
	s.ColdNodeStorageSpec = v
	return s
}

// SetCoordinatorNodeNumber sets the CoordinatorNodeNumber field's value.
func (s *InstanceConfigurationForDescribeInstanceOutput) SetCoordinatorNodeNumber(v int32) *InstanceConfigurationForDescribeInstanceOutput {
	s.CoordinatorNodeNumber = &v
	return s
}

// SetCoordinatorNodeResourceSpec sets the CoordinatorNodeResourceSpec field's value.
func (s *InstanceConfigurationForDescribeInstanceOutput) SetCoordinatorNodeResourceSpec(v *CoordinatorNodeResourceSpecForDescribeInstanceOutput) *InstanceConfigurationForDescribeInstanceOutput {
	s.CoordinatorNodeResourceSpec = v
	return s
}

// SetCoordinatorNodeStorageSpec sets the CoordinatorNodeStorageSpec field's value.
func (s *InstanceConfigurationForDescribeInstanceOutput) SetCoordinatorNodeStorageSpec(v *CoordinatorNodeStorageSpecForDescribeInstanceOutput) *InstanceConfigurationForDescribeInstanceOutput {
	s.CoordinatorNodeStorageSpec = v
	return s
}

// SetEnableHttps sets the EnableHttps field's value.
func (s *InstanceConfigurationForDescribeInstanceOutput) SetEnableHttps(v bool) *InstanceConfigurationForDescribeInstanceOutput {
	s.EnableHttps = &v
	return s
}

// SetEnablePureMaster sets the EnablePureMaster field's value.
func (s *InstanceConfigurationForDescribeInstanceOutput) SetEnablePureMaster(v bool) *InstanceConfigurationForDescribeInstanceOutput {
	s.EnablePureMaster = &v
	return s
}

// SetHotNodeNumber sets the HotNodeNumber field's value.
func (s *InstanceConfigurationForDescribeInstanceOutput) SetHotNodeNumber(v int32) *InstanceConfigurationForDescribeInstanceOutput {
	s.HotNodeNumber = &v
	return s
}

// SetHotNodeResourceSpec sets the HotNodeResourceSpec field's value.
func (s *InstanceConfigurationForDescribeInstanceOutput) SetHotNodeResourceSpec(v *HotNodeResourceSpecForDescribeInstanceOutput) *InstanceConfigurationForDescribeInstanceOutput {
	s.HotNodeResourceSpec = v
	return s
}

// SetHotNodeStorageSpec sets the HotNodeStorageSpec field's value.
func (s *InstanceConfigurationForDescribeInstanceOutput) SetHotNodeStorageSpec(v *HotNodeStorageSpecForDescribeInstanceOutput) *InstanceConfigurationForDescribeInstanceOutput {
	s.HotNodeStorageSpec = v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *InstanceConfigurationForDescribeInstanceOutput) SetInstanceName(v string) *InstanceConfigurationForDescribeInstanceOutput {
	s.InstanceName = &v
	return s
}

// SetKibanaNodeNumber sets the KibanaNodeNumber field's value.
func (s *InstanceConfigurationForDescribeInstanceOutput) SetKibanaNodeNumber(v int32) *InstanceConfigurationForDescribeInstanceOutput {
	s.KibanaNodeNumber = &v
	return s
}

// SetKibanaNodeResourceSpec sets the KibanaNodeResourceSpec field's value.
func (s *InstanceConfigurationForDescribeInstanceOutput) SetKibanaNodeResourceSpec(v *KibanaNodeResourceSpecForDescribeInstanceOutput) *InstanceConfigurationForDescribeInstanceOutput {
	s.KibanaNodeResourceSpec = v
	return s
}

// SetMasterNodeNumber sets the MasterNodeNumber field's value.
func (s *InstanceConfigurationForDescribeInstanceOutput) SetMasterNodeNumber(v int32) *InstanceConfigurationForDescribeInstanceOutput {
	s.MasterNodeNumber = &v
	return s
}

// SetMasterNodeResourceSpec sets the MasterNodeResourceSpec field's value.
func (s *InstanceConfigurationForDescribeInstanceOutput) SetMasterNodeResourceSpec(v *MasterNodeResourceSpecForDescribeInstanceOutput) *InstanceConfigurationForDescribeInstanceOutput {
	s.MasterNodeResourceSpec = v
	return s
}

// SetMasterNodeStorageSpec sets the MasterNodeStorageSpec field's value.
func (s *InstanceConfigurationForDescribeInstanceOutput) SetMasterNodeStorageSpec(v *MasterNodeStorageSpecForDescribeInstanceOutput) *InstanceConfigurationForDescribeInstanceOutput {
	s.MasterNodeStorageSpec = v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *InstanceConfigurationForDescribeInstanceOutput) SetProjectName(v string) *InstanceConfigurationForDescribeInstanceOutput {
	s.ProjectName = &v
	return s
}

// SetRegionId sets the RegionId field's value.
func (s *InstanceConfigurationForDescribeInstanceOutput) SetRegionId(v string) *InstanceConfigurationForDescribeInstanceOutput {
	s.RegionId = &v
	return s
}

// SetSubnet sets the Subnet field's value.
func (s *InstanceConfigurationForDescribeInstanceOutput) SetSubnet(v *SubnetForDescribeInstanceOutput) *InstanceConfigurationForDescribeInstanceOutput {
	s.Subnet = v
	return s
}

// SetVPC sets the VPC field's value.
func (s *InstanceConfigurationForDescribeInstanceOutput) SetVPC(v *VPCForDescribeInstanceOutput) *InstanceConfigurationForDescribeInstanceOutput {
	s.VPC = v
	return s
}

// SetVersion sets the Version field's value.
func (s *InstanceConfigurationForDescribeInstanceOutput) SetVersion(v string) *InstanceConfigurationForDescribeInstanceOutput {
	s.Version = &v
	return s
}

// SetWarmNodeNumber sets the WarmNodeNumber field's value.
func (s *InstanceConfigurationForDescribeInstanceOutput) SetWarmNodeNumber(v int32) *InstanceConfigurationForDescribeInstanceOutput {
	s.WarmNodeNumber = &v
	return s
}

// SetWarmNodeResourceSpec sets the WarmNodeResourceSpec field's value.
func (s *InstanceConfigurationForDescribeInstanceOutput) SetWarmNodeResourceSpec(v *WarmNodeResourceSpecForDescribeInstanceOutput) *InstanceConfigurationForDescribeInstanceOutput {
	s.WarmNodeResourceSpec = v
	return s
}

// SetWarmNodeStorageSpec sets the WarmNodeStorageSpec field's value.
func (s *InstanceConfigurationForDescribeInstanceOutput) SetWarmNodeStorageSpec(v *WarmNodeStorageSpecForDescribeInstanceOutput) *InstanceConfigurationForDescribeInstanceOutput {
	s.WarmNodeStorageSpec = v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *InstanceConfigurationForDescribeInstanceOutput) SetZoneId(v string) *InstanceConfigurationForDescribeInstanceOutput {
	s.ZoneId = &v
	return s
}

// SetZoneNumber sets the ZoneNumber field's value.
func (s *InstanceConfigurationForDescribeInstanceOutput) SetZoneNumber(v int32) *InstanceConfigurationForDescribeInstanceOutput {
	s.ZoneNumber = &v
	return s
}

type InstanceInfoForDescribeInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CerebroEnabled *bool `type:"boolean" json:",omitempty"`

	CerebroPrivateDomain *string `type:"string" json:",omitempty"`

	CerebroPublicDomain *string `type:"string" json:",omitempty"`

	ChargeEnabled *bool `type:"boolean" json:",omitempty"`

	ClusterId *string `type:"string" json:",omitempty"`

	CreateTime *string `type:"string" json:",omitempty"`

	DeletionProtection *bool `type:"boolean" json:",omitempty"`

	ESEip *string `type:"string" json:",omitempty"`

	ESEipId *string `type:"string" json:",omitempty"`

	ESPrivateEndpoint *string `type:"string" json:",omitempty"`

	ESPrivateIpWhitelist *string `type:"string" json:",omitempty"`

	ESPublicEndpoint *string `type:"string" json:",omitempty"`

	ESPublicIpWhitelist *string `type:"string" json:",omitempty"`

	EnableESPrivateDomainPublic *bool `type:"boolean" json:",omitempty"`

	EnableESPrivateNetwork *bool `type:"boolean" json:",omitempty"`

	EnableESPublicNetwork *bool `type:"boolean" json:",omitempty"`

	EnableKibanaPrivateDomainPublic *bool `type:"boolean" json:",omitempty"`

	EnableKibanaPrivateNetwork *bool `type:"boolean" json:",omitempty"`

	EnableKibanaPublicNetwork *bool `type:"boolean" json:",omitempty"`

	EsPubBandwidth *int32 `type:"int32" json:",omitempty"`

	ExpireDate *string `type:"string" json:",omitempty"`

	InstanceConfiguration *InstanceConfigurationForDescribeInstanceOutput `type:"structure" json:",omitempty"`

	InstanceId *string `type:"string" json:",omitempty"`

	KibanaConfig *KibanaConfigForDescribeInstanceOutput `type:"structure" json:",omitempty"`

	KibanaEip *string `type:"string" json:",omitempty"`

	KibanaEipId *string `type:"string" json:",omitempty"`

	KibanaPrivateDomain *string `type:"string" json:",omitempty"`

	KibanaPrivateIpWhitelist *string `type:"string" json:",omitempty"`

	KibanaPubBandwidth *int32 `type:"int32" json:",omitempty"`

	KibanaPublicDomain *string `type:"string" json:",omitempty"`

	KibanaPublicIpWhitelist *string `type:"string" json:",omitempty"`

	MainZoneId *string `type:"string" json:",omitempty"`

	MaintenanceDay []*string `type:"list" json:",omitempty"`

	MaintenanceTime *string `type:"string" json:",omitempty"`

	ResourceTags []*ResourceTagForDescribeInstanceOutput `type:"list" json:",omitempty"`

	Status *string `type:"string" json:",omitempty" enum:"EnumOfStatusForDescribeInstanceOutput"`

	SubInstanceEnable *string `type:"string" json:",omitempty" enum:"EnumOfSubInstanceEnableForDescribeInstanceOutput"`

	SubInstances []*SubInstanceForDescribeInstanceOutput `type:"list" json:",omitempty"`

	SupportColdNode *bool `type:"boolean" json:",omitempty"`

	TotalNodes *int32 `type:"int32" json:",omitempty"`

	TransferInfo *TransferInfoForDescribeInstanceOutput `type:"structure" json:",omitempty"`

	UserId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s InstanceInfoForDescribeInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s InstanceInfoForDescribeInstanceOutput) GoString() string {
	return s.String()
}

// SetCerebroEnabled sets the CerebroEnabled field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetCerebroEnabled(v bool) *InstanceInfoForDescribeInstanceOutput {
	s.CerebroEnabled = &v
	return s
}

// SetCerebroPrivateDomain sets the CerebroPrivateDomain field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetCerebroPrivateDomain(v string) *InstanceInfoForDescribeInstanceOutput {
	s.CerebroPrivateDomain = &v
	return s
}

// SetCerebroPublicDomain sets the CerebroPublicDomain field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetCerebroPublicDomain(v string) *InstanceInfoForDescribeInstanceOutput {
	s.CerebroPublicDomain = &v
	return s
}

// SetChargeEnabled sets the ChargeEnabled field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetChargeEnabled(v bool) *InstanceInfoForDescribeInstanceOutput {
	s.ChargeEnabled = &v
	return s
}

// SetClusterId sets the ClusterId field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetClusterId(v string) *InstanceInfoForDescribeInstanceOutput {
	s.ClusterId = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetCreateTime(v string) *InstanceInfoForDescribeInstanceOutput {
	s.CreateTime = &v
	return s
}

// SetDeletionProtection sets the DeletionProtection field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetDeletionProtection(v bool) *InstanceInfoForDescribeInstanceOutput {
	s.DeletionProtection = &v
	return s
}

// SetESEip sets the ESEip field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetESEip(v string) *InstanceInfoForDescribeInstanceOutput {
	s.ESEip = &v
	return s
}

// SetESEipId sets the ESEipId field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetESEipId(v string) *InstanceInfoForDescribeInstanceOutput {
	s.ESEipId = &v
	return s
}

// SetESPrivateEndpoint sets the ESPrivateEndpoint field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetESPrivateEndpoint(v string) *InstanceInfoForDescribeInstanceOutput {
	s.ESPrivateEndpoint = &v
	return s
}

// SetESPrivateIpWhitelist sets the ESPrivateIpWhitelist field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetESPrivateIpWhitelist(v string) *InstanceInfoForDescribeInstanceOutput {
	s.ESPrivateIpWhitelist = &v
	return s
}

// SetESPublicEndpoint sets the ESPublicEndpoint field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetESPublicEndpoint(v string) *InstanceInfoForDescribeInstanceOutput {
	s.ESPublicEndpoint = &v
	return s
}

// SetESPublicIpWhitelist sets the ESPublicIpWhitelist field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetESPublicIpWhitelist(v string) *InstanceInfoForDescribeInstanceOutput {
	s.ESPublicIpWhitelist = &v
	return s
}

// SetEnableESPrivateDomainPublic sets the EnableESPrivateDomainPublic field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetEnableESPrivateDomainPublic(v bool) *InstanceInfoForDescribeInstanceOutput {
	s.EnableESPrivateDomainPublic = &v
	return s
}

// SetEnableESPrivateNetwork sets the EnableESPrivateNetwork field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetEnableESPrivateNetwork(v bool) *InstanceInfoForDescribeInstanceOutput {
	s.EnableESPrivateNetwork = &v
	return s
}

// SetEnableESPublicNetwork sets the EnableESPublicNetwork field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetEnableESPublicNetwork(v bool) *InstanceInfoForDescribeInstanceOutput {
	s.EnableESPublicNetwork = &v
	return s
}

// SetEnableKibanaPrivateDomainPublic sets the EnableKibanaPrivateDomainPublic field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetEnableKibanaPrivateDomainPublic(v bool) *InstanceInfoForDescribeInstanceOutput {
	s.EnableKibanaPrivateDomainPublic = &v
	return s
}

// SetEnableKibanaPrivateNetwork sets the EnableKibanaPrivateNetwork field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetEnableKibanaPrivateNetwork(v bool) *InstanceInfoForDescribeInstanceOutput {
	s.EnableKibanaPrivateNetwork = &v
	return s
}

// SetEnableKibanaPublicNetwork sets the EnableKibanaPublicNetwork field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetEnableKibanaPublicNetwork(v bool) *InstanceInfoForDescribeInstanceOutput {
	s.EnableKibanaPublicNetwork = &v
	return s
}

// SetEsPubBandwidth sets the EsPubBandwidth field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetEsPubBandwidth(v int32) *InstanceInfoForDescribeInstanceOutput {
	s.EsPubBandwidth = &v
	return s
}

// SetExpireDate sets the ExpireDate field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetExpireDate(v string) *InstanceInfoForDescribeInstanceOutput {
	s.ExpireDate = &v
	return s
}

// SetInstanceConfiguration sets the InstanceConfiguration field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetInstanceConfiguration(v *InstanceConfigurationForDescribeInstanceOutput) *InstanceInfoForDescribeInstanceOutput {
	s.InstanceConfiguration = v
	return s
}

// SetInstanceId sets the InstanceId field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetInstanceId(v string) *InstanceInfoForDescribeInstanceOutput {
	s.InstanceId = &v
	return s
}

// SetKibanaConfig sets the KibanaConfig field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetKibanaConfig(v *KibanaConfigForDescribeInstanceOutput) *InstanceInfoForDescribeInstanceOutput {
	s.KibanaConfig = v
	return s
}

// SetKibanaEip sets the KibanaEip field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetKibanaEip(v string) *InstanceInfoForDescribeInstanceOutput {
	s.KibanaEip = &v
	return s
}

// SetKibanaEipId sets the KibanaEipId field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetKibanaEipId(v string) *InstanceInfoForDescribeInstanceOutput {
	s.KibanaEipId = &v
	return s
}

// SetKibanaPrivateDomain sets the KibanaPrivateDomain field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetKibanaPrivateDomain(v string) *InstanceInfoForDescribeInstanceOutput {
	s.KibanaPrivateDomain = &v
	return s
}

// SetKibanaPrivateIpWhitelist sets the KibanaPrivateIpWhitelist field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetKibanaPrivateIpWhitelist(v string) *InstanceInfoForDescribeInstanceOutput {
	s.KibanaPrivateIpWhitelist = &v
	return s
}

// SetKibanaPubBandwidth sets the KibanaPubBandwidth field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetKibanaPubBandwidth(v int32) *InstanceInfoForDescribeInstanceOutput {
	s.KibanaPubBandwidth = &v
	return s
}

// SetKibanaPublicDomain sets the KibanaPublicDomain field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetKibanaPublicDomain(v string) *InstanceInfoForDescribeInstanceOutput {
	s.KibanaPublicDomain = &v
	return s
}

// SetKibanaPublicIpWhitelist sets the KibanaPublicIpWhitelist field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetKibanaPublicIpWhitelist(v string) *InstanceInfoForDescribeInstanceOutput {
	s.KibanaPublicIpWhitelist = &v
	return s
}

// SetMainZoneId sets the MainZoneId field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetMainZoneId(v string) *InstanceInfoForDescribeInstanceOutput {
	s.MainZoneId = &v
	return s
}

// SetMaintenanceDay sets the MaintenanceDay field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetMaintenanceDay(v []*string) *InstanceInfoForDescribeInstanceOutput {
	s.MaintenanceDay = v
	return s
}

// SetMaintenanceTime sets the MaintenanceTime field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetMaintenanceTime(v string) *InstanceInfoForDescribeInstanceOutput {
	s.MaintenanceTime = &v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetResourceTags(v []*ResourceTagForDescribeInstanceOutput) *InstanceInfoForDescribeInstanceOutput {
	s.ResourceTags = v
	return s
}

// SetStatus sets the Status field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetStatus(v string) *InstanceInfoForDescribeInstanceOutput {
	s.Status = &v
	return s
}

// SetSubInstanceEnable sets the SubInstanceEnable field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetSubInstanceEnable(v string) *InstanceInfoForDescribeInstanceOutput {
	s.SubInstanceEnable = &v
	return s
}

// SetSubInstances sets the SubInstances field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetSubInstances(v []*SubInstanceForDescribeInstanceOutput) *InstanceInfoForDescribeInstanceOutput {
	s.SubInstances = v
	return s
}

// SetSupportColdNode sets the SupportColdNode field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetSupportColdNode(v bool) *InstanceInfoForDescribeInstanceOutput {
	s.SupportColdNode = &v
	return s
}

// SetTotalNodes sets the TotalNodes field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetTotalNodes(v int32) *InstanceInfoForDescribeInstanceOutput {
	s.TotalNodes = &v
	return s
}

// SetTransferInfo sets the TransferInfo field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetTransferInfo(v *TransferInfoForDescribeInstanceOutput) *InstanceInfoForDescribeInstanceOutput {
	s.TransferInfo = v
	return s
}

// SetUserId sets the UserId field's value.
func (s *InstanceInfoForDescribeInstanceOutput) SetUserId(v string) *InstanceInfoForDescribeInstanceOutput {
	s.UserId = &v
	return s
}

type KibanaConfigForDescribeInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	RequestTimeout *int64 `min:"30000" max:"120000" type:"int64" json:",omitempty"`

	SessionKeepAlive *bool `type:"boolean" json:",omitempty"`

	SessionTTL *int64 `min:"30000" type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s KibanaConfigForDescribeInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s KibanaConfigForDescribeInstanceOutput) GoString() string {
	return s.String()
}

// SetRequestTimeout sets the RequestTimeout field's value.
func (s *KibanaConfigForDescribeInstanceOutput) SetRequestTimeout(v int64) *KibanaConfigForDescribeInstanceOutput {
	s.RequestTimeout = &v
	return s
}

// SetSessionKeepAlive sets the SessionKeepAlive field's value.
func (s *KibanaConfigForDescribeInstanceOutput) SetSessionKeepAlive(v bool) *KibanaConfigForDescribeInstanceOutput {
	s.SessionKeepAlive = &v
	return s
}

// SetSessionTTL sets the SessionTTL field's value.
func (s *KibanaConfigForDescribeInstanceOutput) SetSessionTTL(v int64) *KibanaConfigForDescribeInstanceOutput {
	s.SessionTTL = &v
	return s
}

type KibanaNodeResourceSpecForDescribeInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CPU *int32 `type:"int32" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	DisplayName *string `type:"string" json:",omitempty"`

	Memory *int32 `type:"int32" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s KibanaNodeResourceSpecForDescribeInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s KibanaNodeResourceSpecForDescribeInstanceOutput) GoString() string {
	return s.String()
}

// SetCPU sets the CPU field's value.
func (s *KibanaNodeResourceSpecForDescribeInstanceOutput) SetCPU(v int32) *KibanaNodeResourceSpecForDescribeInstanceOutput {
	s.CPU = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *KibanaNodeResourceSpecForDescribeInstanceOutput) SetDescription(v string) *KibanaNodeResourceSpecForDescribeInstanceOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *KibanaNodeResourceSpecForDescribeInstanceOutput) SetDisplayName(v string) *KibanaNodeResourceSpecForDescribeInstanceOutput {
	s.DisplayName = &v
	return s
}

// SetMemory sets the Memory field's value.
func (s *KibanaNodeResourceSpecForDescribeInstanceOutput) SetMemory(v int32) *KibanaNodeResourceSpecForDescribeInstanceOutput {
	s.Memory = &v
	return s
}

// SetName sets the Name field's value.
func (s *KibanaNodeResourceSpecForDescribeInstanceOutput) SetName(v string) *KibanaNodeResourceSpecForDescribeInstanceOutput {
	s.Name = &v
	return s
}

type MasterNodeResourceSpecForDescribeInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CPU *int32 `type:"int32" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	DisplayName *string `type:"string" json:",omitempty"`

	Memory *int32 `type:"int32" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s MasterNodeResourceSpecForDescribeInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MasterNodeResourceSpecForDescribeInstanceOutput) GoString() string {
	return s.String()
}

// SetCPU sets the CPU field's value.
func (s *MasterNodeResourceSpecForDescribeInstanceOutput) SetCPU(v int32) *MasterNodeResourceSpecForDescribeInstanceOutput {
	s.CPU = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *MasterNodeResourceSpecForDescribeInstanceOutput) SetDescription(v string) *MasterNodeResourceSpecForDescribeInstanceOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *MasterNodeResourceSpecForDescribeInstanceOutput) SetDisplayName(v string) *MasterNodeResourceSpecForDescribeInstanceOutput {
	s.DisplayName = &v
	return s
}

// SetMemory sets the Memory field's value.
func (s *MasterNodeResourceSpecForDescribeInstanceOutput) SetMemory(v int32) *MasterNodeResourceSpecForDescribeInstanceOutput {
	s.Memory = &v
	return s
}

// SetName sets the Name field's value.
func (s *MasterNodeResourceSpecForDescribeInstanceOutput) SetName(v string) *MasterNodeResourceSpecForDescribeInstanceOutput {
	s.Name = &v
	return s
}

type MasterNodeStorageSpecForDescribeInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	DisplayName *string `type:"string" json:",omitempty"`

	MaxSize *int32 `type:"int32" json:",omitempty"`

	MinSize *int32 `type:"int32" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Size *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s MasterNodeStorageSpecForDescribeInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MasterNodeStorageSpecForDescribeInstanceOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *MasterNodeStorageSpecForDescribeInstanceOutput) SetDescription(v string) *MasterNodeStorageSpecForDescribeInstanceOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *MasterNodeStorageSpecForDescribeInstanceOutput) SetDisplayName(v string) *MasterNodeStorageSpecForDescribeInstanceOutput {
	s.DisplayName = &v
	return s
}

// SetMaxSize sets the MaxSize field's value.
func (s *MasterNodeStorageSpecForDescribeInstanceOutput) SetMaxSize(v int32) *MasterNodeStorageSpecForDescribeInstanceOutput {
	s.MaxSize = &v
	return s
}

// SetMinSize sets the MinSize field's value.
func (s *MasterNodeStorageSpecForDescribeInstanceOutput) SetMinSize(v int32) *MasterNodeStorageSpecForDescribeInstanceOutput {
	s.MinSize = &v
	return s
}

// SetName sets the Name field's value.
func (s *MasterNodeStorageSpecForDescribeInstanceOutput) SetName(v string) *MasterNodeStorageSpecForDescribeInstanceOutput {
	s.Name = &v
	return s
}

// SetSize sets the Size field's value.
func (s *MasterNodeStorageSpecForDescribeInstanceOutput) SetSize(v int32) *MasterNodeStorageSpecForDescribeInstanceOutput {
	s.Size = &v
	return s
}

type ReduceSpecConfigForDescribeInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ColdNodeNum *int32 `type:"int32" json:",omitempty"`

	DataNodeNum *int32 `type:"int32" json:",omitempty"`

	EnablePureMaster *bool `type:"boolean" json:",omitempty"`

	MasterNodeNum *int32 `type:"int32" json:",omitempty"`

	WarmNodeNum *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ReduceSpecConfigForDescribeInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ReduceSpecConfigForDescribeInstanceOutput) GoString() string {
	return s.String()
}

// SetColdNodeNum sets the ColdNodeNum field's value.
func (s *ReduceSpecConfigForDescribeInstanceOutput) SetColdNodeNum(v int32) *ReduceSpecConfigForDescribeInstanceOutput {
	s.ColdNodeNum = &v
	return s
}

// SetDataNodeNum sets the DataNodeNum field's value.
func (s *ReduceSpecConfigForDescribeInstanceOutput) SetDataNodeNum(v int32) *ReduceSpecConfigForDescribeInstanceOutput {
	s.DataNodeNum = &v
	return s
}

// SetEnablePureMaster sets the EnablePureMaster field's value.
func (s *ReduceSpecConfigForDescribeInstanceOutput) SetEnablePureMaster(v bool) *ReduceSpecConfigForDescribeInstanceOutput {
	s.EnablePureMaster = &v
	return s
}

// SetMasterNodeNum sets the MasterNodeNum field's value.
func (s *ReduceSpecConfigForDescribeInstanceOutput) SetMasterNodeNum(v int32) *ReduceSpecConfigForDescribeInstanceOutput {
	s.MasterNodeNum = &v
	return s
}

// SetWarmNodeNum sets the WarmNodeNum field's value.
func (s *ReduceSpecConfigForDescribeInstanceOutput) SetWarmNodeNum(v int32) *ReduceSpecConfigForDescribeInstanceOutput {
	s.WarmNodeNum = &v
	return s
}

type ResourceTagForDescribeInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	TagKeys []*string `type:"list" json:",omitempty"`

	TagKvs *TagKvsForDescribeInstanceOutput `type:"structure" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ResourceTagForDescribeInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceTagForDescribeInstanceOutput) GoString() string {
	return s.String()
}

// SetTagKeys sets the TagKeys field's value.
func (s *ResourceTagForDescribeInstanceOutput) SetTagKeys(v []*string) *ResourceTagForDescribeInstanceOutput {
	s.TagKeys = v
	return s
}

// SetTagKvs sets the TagKvs field's value.
func (s *ResourceTagForDescribeInstanceOutput) SetTagKvs(v *TagKvsForDescribeInstanceOutput) *ResourceTagForDescribeInstanceOutput {
	s.TagKvs = v
	return s
}

// SetType sets the Type field's value.
func (s *ResourceTagForDescribeInstanceOutput) SetType(v string) *ResourceTagForDescribeInstanceOutput {
	s.Type = &v
	return s
}

type SubInstanceForDescribeInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	SubInstanceId *string `type:"string" json:",omitempty"`

	SubInstanceStatus *string `type:"string" json:",omitempty" enum:"EnumOfSubInstanceStatusForDescribeInstanceOutput"`

	SubInstanceType *string `type:"string" json:",omitempty" enum:"EnumOfSubInstanceTypeForDescribeInstanceOutput"`
}

// String returns the string representation
func (s SubInstanceForDescribeInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SubInstanceForDescribeInstanceOutput) GoString() string {
	return s.String()
}

// SetSubInstanceId sets the SubInstanceId field's value.
func (s *SubInstanceForDescribeInstanceOutput) SetSubInstanceId(v string) *SubInstanceForDescribeInstanceOutput {
	s.SubInstanceId = &v
	return s
}

// SetSubInstanceStatus sets the SubInstanceStatus field's value.
func (s *SubInstanceForDescribeInstanceOutput) SetSubInstanceStatus(v string) *SubInstanceForDescribeInstanceOutput {
	s.SubInstanceStatus = &v
	return s
}

// SetSubInstanceType sets the SubInstanceType field's value.
func (s *SubInstanceForDescribeInstanceOutput) SetSubInstanceType(v string) *SubInstanceForDescribeInstanceOutput {
	s.SubInstanceType = &v
	return s
}

type SubnetForDescribeInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	SubnetId *string `type:"string" json:",omitempty"`

	SubnetName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s SubnetForDescribeInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s SubnetForDescribeInstanceOutput) GoString() string {
	return s.String()
}

// SetSubnetId sets the SubnetId field's value.
func (s *SubnetForDescribeInstanceOutput) SetSubnetId(v string) *SubnetForDescribeInstanceOutput {
	s.SubnetId = &v
	return s
}

// SetSubnetName sets the SubnetName field's value.
func (s *SubnetForDescribeInstanceOutput) SetSubnetName(v string) *SubnetForDescribeInstanceOutput {
	s.SubnetName = &v
	return s
}

type TagKvsForDescribeInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s TagKvsForDescribeInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagKvsForDescribeInstanceOutput) GoString() string {
	return s.String()
}

type TransferInfoForDescribeInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ForbidStop *bool `type:"boolean" json:",omitempty"`

	ReduceSpecConfig *ReduceSpecConfigForDescribeInstanceOutput `type:"structure" json:",omitempty"`

	TransferProgress *float64 `type:"double" json:",omitempty"`

	TransferStatus *string `type:"string" json:",omitempty" enum:"EnumOfTransferStatusForDescribeInstanceOutput"`

	TransferTaskId *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TransferInfoForDescribeInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TransferInfoForDescribeInstanceOutput) GoString() string {
	return s.String()
}

// SetForbidStop sets the ForbidStop field's value.
func (s *TransferInfoForDescribeInstanceOutput) SetForbidStop(v bool) *TransferInfoForDescribeInstanceOutput {
	s.ForbidStop = &v
	return s
}

// SetReduceSpecConfig sets the ReduceSpecConfig field's value.
func (s *TransferInfoForDescribeInstanceOutput) SetReduceSpecConfig(v *ReduceSpecConfigForDescribeInstanceOutput) *TransferInfoForDescribeInstanceOutput {
	s.ReduceSpecConfig = v
	return s
}

// SetTransferProgress sets the TransferProgress field's value.
func (s *TransferInfoForDescribeInstanceOutput) SetTransferProgress(v float64) *TransferInfoForDescribeInstanceOutput {
	s.TransferProgress = &v
	return s
}

// SetTransferStatus sets the TransferStatus field's value.
func (s *TransferInfoForDescribeInstanceOutput) SetTransferStatus(v string) *TransferInfoForDescribeInstanceOutput {
	s.TransferStatus = &v
	return s
}

// SetTransferTaskId sets the TransferTaskId field's value.
func (s *TransferInfoForDescribeInstanceOutput) SetTransferTaskId(v string) *TransferInfoForDescribeInstanceOutput {
	s.TransferTaskId = &v
	return s
}

type VPCForDescribeInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	VpcId *string `type:"string" json:",omitempty"`

	VpcName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s VPCForDescribeInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VPCForDescribeInstanceOutput) GoString() string {
	return s.String()
}

// SetVpcId sets the VpcId field's value.
func (s *VPCForDescribeInstanceOutput) SetVpcId(v string) *VPCForDescribeInstanceOutput {
	s.VpcId = &v
	return s
}

// SetVpcName sets the VpcName field's value.
func (s *VPCForDescribeInstanceOutput) SetVpcName(v string) *VPCForDescribeInstanceOutput {
	s.VpcName = &v
	return s
}

type WarmNodeResourceSpecForDescribeInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CPU *int32 `type:"int32" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	DisplayName *string `type:"string" json:",omitempty"`

	Memory *int32 `type:"int32" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s WarmNodeResourceSpecForDescribeInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s WarmNodeResourceSpecForDescribeInstanceOutput) GoString() string {
	return s.String()
}

// SetCPU sets the CPU field's value.
func (s *WarmNodeResourceSpecForDescribeInstanceOutput) SetCPU(v int32) *WarmNodeResourceSpecForDescribeInstanceOutput {
	s.CPU = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *WarmNodeResourceSpecForDescribeInstanceOutput) SetDescription(v string) *WarmNodeResourceSpecForDescribeInstanceOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *WarmNodeResourceSpecForDescribeInstanceOutput) SetDisplayName(v string) *WarmNodeResourceSpecForDescribeInstanceOutput {
	s.DisplayName = &v
	return s
}

// SetMemory sets the Memory field's value.
func (s *WarmNodeResourceSpecForDescribeInstanceOutput) SetMemory(v int32) *WarmNodeResourceSpecForDescribeInstanceOutput {
	s.Memory = &v
	return s
}

// SetName sets the Name field's value.
func (s *WarmNodeResourceSpecForDescribeInstanceOutput) SetName(v string) *WarmNodeResourceSpecForDescribeInstanceOutput {
	s.Name = &v
	return s
}

type WarmNodeStorageSpecForDescribeInstanceOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	DisplayName *string `type:"string" json:",omitempty"`

	MaxSize *int32 `type:"int32" json:",omitempty"`

	MinSize *int32 `type:"int32" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Size *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s WarmNodeStorageSpecForDescribeInstanceOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s WarmNodeStorageSpecForDescribeInstanceOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *WarmNodeStorageSpecForDescribeInstanceOutput) SetDescription(v string) *WarmNodeStorageSpecForDescribeInstanceOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *WarmNodeStorageSpecForDescribeInstanceOutput) SetDisplayName(v string) *WarmNodeStorageSpecForDescribeInstanceOutput {
	s.DisplayName = &v
	return s
}

// SetMaxSize sets the MaxSize field's value.
func (s *WarmNodeStorageSpecForDescribeInstanceOutput) SetMaxSize(v int32) *WarmNodeStorageSpecForDescribeInstanceOutput {
	s.MaxSize = &v
	return s
}

// SetMinSize sets the MinSize field's value.
func (s *WarmNodeStorageSpecForDescribeInstanceOutput) SetMinSize(v int32) *WarmNodeStorageSpecForDescribeInstanceOutput {
	s.MinSize = &v
	return s
}

// SetName sets the Name field's value.
func (s *WarmNodeStorageSpecForDescribeInstanceOutput) SetName(v string) *WarmNodeStorageSpecForDescribeInstanceOutput {
	s.Name = &v
	return s
}

// SetSize sets the Size field's value.
func (s *WarmNodeStorageSpecForDescribeInstanceOutput) SetSize(v int32) *WarmNodeStorageSpecForDescribeInstanceOutput {
	s.Size = &v
	return s
}

const (
	// EnumOfChargeTypeForDescribeInstanceOutputPrePaid is a EnumOfChargeTypeForDescribeInstanceOutput enum value
	EnumOfChargeTypeForDescribeInstanceOutputPrePaid = "PrePaid"

	// EnumOfChargeTypeForDescribeInstanceOutputPostPaid is a EnumOfChargeTypeForDescribeInstanceOutput enum value
	EnumOfChargeTypeForDescribeInstanceOutputPostPaid = "PostPaid"
)

const (
	// EnumOfStatusForDescribeInstanceOutputInit is a EnumOfStatusForDescribeInstanceOutput enum value
	EnumOfStatusForDescribeInstanceOutputInit = "Init"

	// EnumOfStatusForDescribeInstanceOutputWaitingPaid is a EnumOfStatusForDescribeInstanceOutput enum value
	EnumOfStatusForDescribeInstanceOutputWaitingPaid = "WaitingPaid"

	// EnumOfStatusForDescribeInstanceOutputWaitCreate is a EnumOfStatusForDescribeInstanceOutput enum value
	EnumOfStatusForDescribeInstanceOutputWaitCreate = "WaitCreate"

	// EnumOfStatusForDescribeInstanceOutputCreating is a EnumOfStatusForDescribeInstanceOutput enum value
	EnumOfStatusForDescribeInstanceOutputCreating = "Creating"

	// EnumOfStatusForDescribeInstanceOutputRunning is a EnumOfStatusForDescribeInstanceOutput enum value
	EnumOfStatusForDescribeInstanceOutputRunning = "Running"

	// EnumOfStatusForDescribeInstanceOutputRestarting is a EnumOfStatusForDescribeInstanceOutput enum value
	EnumOfStatusForDescribeInstanceOutputRestarting = "Restarting"

	// EnumOfStatusForDescribeInstanceOutputUpdating is a EnumOfStatusForDescribeInstanceOutput enum value
	EnumOfStatusForDescribeInstanceOutputUpdating = "Updating"

	// EnumOfStatusForDescribeInstanceOutputWaitScale is a EnumOfStatusForDescribeInstanceOutput enum value
	EnumOfStatusForDescribeInstanceOutputWaitScale = "WaitScale"

	// EnumOfStatusForDescribeInstanceOutputScaling is a EnumOfStatusForDescribeInstanceOutput enum value
	EnumOfStatusForDescribeInstanceOutputScaling = "Scaling"

	// EnumOfStatusForDescribeInstanceOutputRestoring is a EnumOfStatusForDescribeInstanceOutput enum value
	EnumOfStatusForDescribeInstanceOutputRestoring = "Restoring"

	// EnumOfStatusForDescribeInstanceOutputUpgrading is a EnumOfStatusForDescribeInstanceOutput enum value
	EnumOfStatusForDescribeInstanceOutputUpgrading = "Upgrading"

	// EnumOfStatusForDescribeInstanceOutputClosing is a EnumOfStatusForDescribeInstanceOutput enum value
	EnumOfStatusForDescribeInstanceOutputClosing = "Closing"

	// EnumOfStatusForDescribeInstanceOutputClosed is a EnumOfStatusForDescribeInstanceOutput enum value
	EnumOfStatusForDescribeInstanceOutputClosed = "Closed"

	// EnumOfStatusForDescribeInstanceOutputReclaiming is a EnumOfStatusForDescribeInstanceOutput enum value
	EnumOfStatusForDescribeInstanceOutputReclaiming = "Reclaiming"

	// EnumOfStatusForDescribeInstanceOutputResuming is a EnumOfStatusForDescribeInstanceOutput enum value
	EnumOfStatusForDescribeInstanceOutputResuming = "Resuming"

	// EnumOfStatusForDescribeInstanceOutputWaitRelease is a EnumOfStatusForDescribeInstanceOutput enum value
	EnumOfStatusForDescribeInstanceOutputWaitRelease = "WaitRelease"

	// EnumOfStatusForDescribeInstanceOutputReleasing is a EnumOfStatusForDescribeInstanceOutput enum value
	EnumOfStatusForDescribeInstanceOutputReleasing = "Releasing"

	// EnumOfStatusForDescribeInstanceOutputReleased is a EnumOfStatusForDescribeInstanceOutput enum value
	EnumOfStatusForDescribeInstanceOutputReleased = "Released"

	// EnumOfStatusForDescribeInstanceOutputDeleted is a EnumOfStatusForDescribeInstanceOutput enum value
	EnumOfStatusForDescribeInstanceOutputDeleted = "Deleted"

	// EnumOfStatusForDescribeInstanceOutputDestroying is a EnumOfStatusForDescribeInstanceOutput enum value
	EnumOfStatusForDescribeInstanceOutputDestroying = "Destroying"

	// EnumOfStatusForDescribeInstanceOutputDestroyed is a EnumOfStatusForDescribeInstanceOutput enum value
	EnumOfStatusForDescribeInstanceOutputDestroyed = "Destroyed"

	// EnumOfStatusForDescribeInstanceOutputCreateFailed is a EnumOfStatusForDescribeInstanceOutput enum value
	EnumOfStatusForDescribeInstanceOutputCreateFailed = "CreateFailed"

	// EnumOfStatusForDescribeInstanceOutputTaskFailed is a EnumOfStatusForDescribeInstanceOutput enum value
	EnumOfStatusForDescribeInstanceOutputTaskFailed = "TaskFailed"

	// EnumOfStatusForDescribeInstanceOutputError is a EnumOfStatusForDescribeInstanceOutput enum value
	EnumOfStatusForDescribeInstanceOutputError = "Error"

	// EnumOfStatusForDescribeInstanceOutputWarn is a EnumOfStatusForDescribeInstanceOutput enum value
	EnumOfStatusForDescribeInstanceOutputWarn = "Warn"

	// EnumOfStatusForDescribeInstanceOutputUnknown is a EnumOfStatusForDescribeInstanceOutput enum value
	EnumOfStatusForDescribeInstanceOutputUnknown = "Unknown"
)

const (
	// EnumOfSubInstanceEnableForDescribeInstanceOutputNone is a EnumOfSubInstanceEnableForDescribeInstanceOutput enum value
	EnumOfSubInstanceEnableForDescribeInstanceOutputNone = "None"

	// EnumOfSubInstanceEnableForDescribeInstanceOutputAi is a EnumOfSubInstanceEnableForDescribeInstanceOutput enum value
	EnumOfSubInstanceEnableForDescribeInstanceOutputAi = " AI"

	// EnumOfSubInstanceEnableForDescribeInstanceOutputSql is a EnumOfSubInstanceEnableForDescribeInstanceOutput enum value
	EnumOfSubInstanceEnableForDescribeInstanceOutputSql = " Sql"

	// EnumOfSubInstanceEnableForDescribeInstanceOutputAiSql is a EnumOfSubInstanceEnableForDescribeInstanceOutput enum value
	EnumOfSubInstanceEnableForDescribeInstanceOutputAiSql = " AI_Sql"
)

const (
	// EnumOfSubInstanceStatusForDescribeInstanceOutputAvailable is a EnumOfSubInstanceStatusForDescribeInstanceOutput enum value
	EnumOfSubInstanceStatusForDescribeInstanceOutputAvailable = "AVAILABLE"

	// EnumOfSubInstanceStatusForDescribeInstanceOutputReleased is a EnumOfSubInstanceStatusForDescribeInstanceOutput enum value
	EnumOfSubInstanceStatusForDescribeInstanceOutputReleased = "RELEASED"
)

const (
	// EnumOfSubInstanceTypeForDescribeInstanceOutputSql is a EnumOfSubInstanceTypeForDescribeInstanceOutput enum value
	EnumOfSubInstanceTypeForDescribeInstanceOutputSql = "Sql"

	// EnumOfSubInstanceTypeForDescribeInstanceOutputKrypton is a EnumOfSubInstanceTypeForDescribeInstanceOutput enum value
	EnumOfSubInstanceTypeForDescribeInstanceOutputKrypton = "Krypton"
)

const (
	// EnumOfTransferStatusForDescribeInstanceOutputCreated is a EnumOfTransferStatusForDescribeInstanceOutput enum value
	EnumOfTransferStatusForDescribeInstanceOutputCreated = "CREATED"

	// EnumOfTransferStatusForDescribeInstanceOutputRunning is a EnumOfTransferStatusForDescribeInstanceOutput enum value
	EnumOfTransferStatusForDescribeInstanceOutputRunning = "RUNNING"

	// EnumOfTransferStatusForDescribeInstanceOutputFinish is a EnumOfTransferStatusForDescribeInstanceOutput enum value
	EnumOfTransferStatusForDescribeInstanceOutputFinish = "FINISH"

	// EnumOfTransferStatusForDescribeInstanceOutputCanceling is a EnumOfTransferStatusForDescribeInstanceOutput enum value
	EnumOfTransferStatusForDescribeInstanceOutputCanceling = "CANCELING"

	// EnumOfTransferStatusForDescribeInstanceOutputCancel is a EnumOfTransferStatusForDescribeInstanceOutput enum value
	EnumOfTransferStatusForDescribeInstanceOutputCancel = "CANCEL"

	// EnumOfTransferStatusForDescribeInstanceOutputCancelFailed is a EnumOfTransferStatusForDescribeInstanceOutput enum value
	EnumOfTransferStatusForDescribeInstanceOutputCancelFailed = "CANCEL_FAILED"

	// EnumOfTransferStatusForDescribeInstanceOutputTimeout is a EnumOfTransferStatusForDescribeInstanceOutput enum value
	EnumOfTransferStatusForDescribeInstanceOutputTimeout = "TIMEOUT"

	// EnumOfTransferStatusForDescribeInstanceOutputShrinkComplete is a EnumOfTransferStatusForDescribeInstanceOutput enum value
	EnumOfTransferStatusForDescribeInstanceOutputShrinkComplete = "SHRINK_COMPLETE"
)

const (
	// EnumOfVersionForDescribeInstanceOutputV67 is a EnumOfVersionForDescribeInstanceOutput enum value
	EnumOfVersionForDescribeInstanceOutputV67 = "V6_7"

	// EnumOfVersionForDescribeInstanceOutputV710 is a EnumOfVersionForDescribeInstanceOutput enum value
	EnumOfVersionForDescribeInstanceOutputV710 = "V7_10"

	// EnumOfVersionForDescribeInstanceOutputV7Tls is a EnumOfVersionForDescribeInstanceOutput enum value
	EnumOfVersionForDescribeInstanceOutputV7Tls = "V7_TLS"

	// EnumOfVersionForDescribeInstanceOutputV7Byte is a EnumOfVersionForDescribeInstanceOutput enum value
	EnumOfVersionForDescribeInstanceOutputV7Byte = "V7_BYTE"

	// EnumOfVersionForDescribeInstanceOutputOpenSearch29 is a EnumOfVersionForDescribeInstanceOutput enum value
	EnumOfVersionForDescribeInstanceOutputOpenSearch29 = "OPEN_SEARCH_2_9"
)
