// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package emr

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opUpdateApplicationConfigCommon = "UpdateApplicationConfig"

// UpdateApplicationConfigCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateApplicationConfigCommon operation. The "output" return
// value will be populated with the UpdateApplicationConfigCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateApplicationConfigCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdateApplicationConfigCommon Send returns without error.
//
// See UpdateApplicationConfigCommon for more information on using the UpdateApplicationConfigCommon
// API call, and error handling.
//
//    // Example sending a request using the UpdateApplicationConfigCommonRequest method.
//    req, resp := client.UpdateApplicationConfigCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *EMR) UpdateApplicationConfigCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opUpdateApplicationConfigCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdateApplicationConfigCommon API operation for EMR.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for EMR's
// API operation UpdateApplicationConfigCommon for usage and error information.
func (c *EMR) UpdateApplicationConfigCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.UpdateApplicationConfigCommonRequest(input)
	return out, req.Send()
}

// UpdateApplicationConfigCommonWithContext is the same as UpdateApplicationConfigCommon with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApplicationConfigCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) UpdateApplicationConfigCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.UpdateApplicationConfigCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateApplicationConfig = "UpdateApplicationConfig"

// UpdateApplicationConfigRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateApplicationConfig operation. The "output" return
// value will be populated with the UpdateApplicationConfigCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateApplicationConfigCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdateApplicationConfigCommon Send returns without error.
//
// See UpdateApplicationConfig for more information on using the UpdateApplicationConfig
// API call, and error handling.
//
//    // Example sending a request using the UpdateApplicationConfigRequest method.
//    req, resp := client.UpdateApplicationConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *EMR) UpdateApplicationConfigRequest(input *UpdateApplicationConfigInput) (req *request.Request, output *UpdateApplicationConfigOutput) {
	op := &request.Operation{
		Name:       opUpdateApplicationConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateApplicationConfigInput{}
	}

	output = &UpdateApplicationConfigOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdateApplicationConfig API operation for EMR.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for EMR's
// API operation UpdateApplicationConfig for usage and error information.
func (c *EMR) UpdateApplicationConfig(input *UpdateApplicationConfigInput) (*UpdateApplicationConfigOutput, error) {
	req, out := c.UpdateApplicationConfigRequest(input)
	return out, req.Send()
}

// UpdateApplicationConfigWithContext is the same as UpdateApplicationConfig with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateApplicationConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) UpdateApplicationConfigWithContext(ctx volcengine.Context, input *UpdateApplicationConfigInput, opts ...request.Option) (*UpdateApplicationConfigOutput, error) {
	req, out := c.UpdateApplicationConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ConfigForUpdateApplicationConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ComponentInstanceName *string `type:"string" json:",omitempty"`

	ComponentName *string `type:"string" json:",omitempty"`

	ConfigFileName *string `type:"string" json:",omitempty"`

	ConfigItemKey *string `type:"string" json:",omitempty"`

	ConfigItemValue *string `type:"string" json:",omitempty"`

	Deleted *bool `type:"boolean" json:",omitempty"`

	EffectiveScope *EffectiveScopeForUpdateApplicationConfigInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s ConfigForUpdateApplicationConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConfigForUpdateApplicationConfigInput) GoString() string {
	return s.String()
}

// SetComponentInstanceName sets the ComponentInstanceName field's value.
func (s *ConfigForUpdateApplicationConfigInput) SetComponentInstanceName(v string) *ConfigForUpdateApplicationConfigInput {
	s.ComponentInstanceName = &v
	return s
}

// SetComponentName sets the ComponentName field's value.
func (s *ConfigForUpdateApplicationConfigInput) SetComponentName(v string) *ConfigForUpdateApplicationConfigInput {
	s.ComponentName = &v
	return s
}

// SetConfigFileName sets the ConfigFileName field's value.
func (s *ConfigForUpdateApplicationConfigInput) SetConfigFileName(v string) *ConfigForUpdateApplicationConfigInput {
	s.ConfigFileName = &v
	return s
}

// SetConfigItemKey sets the ConfigItemKey field's value.
func (s *ConfigForUpdateApplicationConfigInput) SetConfigItemKey(v string) *ConfigForUpdateApplicationConfigInput {
	s.ConfigItemKey = &v
	return s
}

// SetConfigItemValue sets the ConfigItemValue field's value.
func (s *ConfigForUpdateApplicationConfigInput) SetConfigItemValue(v string) *ConfigForUpdateApplicationConfigInput {
	s.ConfigItemValue = &v
	return s
}

// SetDeleted sets the Deleted field's value.
func (s *ConfigForUpdateApplicationConfigInput) SetDeleted(v bool) *ConfigForUpdateApplicationConfigInput {
	s.Deleted = &v
	return s
}

// SetEffectiveScope sets the EffectiveScope field's value.
func (s *ConfigForUpdateApplicationConfigInput) SetEffectiveScope(v *EffectiveScopeForUpdateApplicationConfigInput) *ConfigForUpdateApplicationConfigInput {
	s.EffectiveScope = v
	return s
}

type EffectiveScopeForUpdateApplicationConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ComponentNames []*string `type:"list" json:",omitempty"`

	EffectiveType *string `type:"string" json:",omitempty" enum:"EnumOfEffectiveTypeForUpdateApplicationConfigInput"`

	NodeGroupIds []*string `type:"list" json:",omitempty"`

	NodeGroupNames []*string `type:"list" json:",omitempty"`

	NodeGroupTypes []*string `type:"list" json:",omitempty"`

	NodeIds []*string `type:"list" json:",omitempty"`

	NodeNames []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s EffectiveScopeForUpdateApplicationConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s EffectiveScopeForUpdateApplicationConfigInput) GoString() string {
	return s.String()
}

// SetComponentNames sets the ComponentNames field's value.
func (s *EffectiveScopeForUpdateApplicationConfigInput) SetComponentNames(v []*string) *EffectiveScopeForUpdateApplicationConfigInput {
	s.ComponentNames = v
	return s
}

// SetEffectiveType sets the EffectiveType field's value.
func (s *EffectiveScopeForUpdateApplicationConfigInput) SetEffectiveType(v string) *EffectiveScopeForUpdateApplicationConfigInput {
	s.EffectiveType = &v
	return s
}

// SetNodeGroupIds sets the NodeGroupIds field's value.
func (s *EffectiveScopeForUpdateApplicationConfigInput) SetNodeGroupIds(v []*string) *EffectiveScopeForUpdateApplicationConfigInput {
	s.NodeGroupIds = v
	return s
}

// SetNodeGroupNames sets the NodeGroupNames field's value.
func (s *EffectiveScopeForUpdateApplicationConfigInput) SetNodeGroupNames(v []*string) *EffectiveScopeForUpdateApplicationConfigInput {
	s.NodeGroupNames = v
	return s
}

// SetNodeGroupTypes sets the NodeGroupTypes field's value.
func (s *EffectiveScopeForUpdateApplicationConfigInput) SetNodeGroupTypes(v []*string) *EffectiveScopeForUpdateApplicationConfigInput {
	s.NodeGroupTypes = v
	return s
}

// SetNodeIds sets the NodeIds field's value.
func (s *EffectiveScopeForUpdateApplicationConfigInput) SetNodeIds(v []*string) *EffectiveScopeForUpdateApplicationConfigInput {
	s.NodeIds = v
	return s
}

// SetNodeNames sets the NodeNames field's value.
func (s *EffectiveScopeForUpdateApplicationConfigInput) SetNodeNames(v []*string) *EffectiveScopeForUpdateApplicationConfigInput {
	s.NodeNames = v
	return s
}

type ResultDataForUpdateApplicationConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s ResultDataForUpdateApplicationConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResultDataForUpdateApplicationConfigOutput) GoString() string {
	return s.String()
}

type UpdateApplicationConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// ApplicationName is a required field
	ApplicationName *string `type:"string" json:",omitempty" required:"true"`

	ClientToken *string `type:"string" json:",omitempty"`

	// ClusterId is a required field
	ClusterId *string `type:"string" json:",omitempty" required:"true"`

	Configs []*ConfigForUpdateApplicationConfigInput `type:"list" json:",omitempty"`

	// Remark is a required field
	Remark *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s UpdateApplicationConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApplicationConfigInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateApplicationConfigInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateApplicationConfigInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}
	if s.Remark == nil {
		invalidParams.Add(request.NewErrParamRequired("Remark"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *UpdateApplicationConfigInput) SetApplicationName(v string) *UpdateApplicationConfigInput {
	s.ApplicationName = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *UpdateApplicationConfigInput) SetClientToken(v string) *UpdateApplicationConfigInput {
	s.ClientToken = &v
	return s
}

// SetClusterId sets the ClusterId field's value.
func (s *UpdateApplicationConfigInput) SetClusterId(v string) *UpdateApplicationConfigInput {
	s.ClusterId = &v
	return s
}

// SetConfigs sets the Configs field's value.
func (s *UpdateApplicationConfigInput) SetConfigs(v []*ConfigForUpdateApplicationConfigInput) *UpdateApplicationConfigInput {
	s.Configs = v
	return s
}

// SetRemark sets the Remark field's value.
func (s *UpdateApplicationConfigInput) SetRemark(v string) *UpdateApplicationConfigInput {
	s.Remark = &v
	return s
}

type UpdateApplicationConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	ClusterId *string `type:"string" json:",omitempty"`

	OperationId *string `type:"string" json:",omitempty"`

	ResultData *ResultDataForUpdateApplicationConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s UpdateApplicationConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateApplicationConfigOutput) GoString() string {
	return s.String()
}

// SetClusterId sets the ClusterId field's value.
func (s *UpdateApplicationConfigOutput) SetClusterId(v string) *UpdateApplicationConfigOutput {
	s.ClusterId = &v
	return s
}

// SetOperationId sets the OperationId field's value.
func (s *UpdateApplicationConfigOutput) SetOperationId(v string) *UpdateApplicationConfigOutput {
	s.OperationId = &v
	return s
}

// SetResultData sets the ResultData field's value.
func (s *UpdateApplicationConfigOutput) SetResultData(v *ResultDataForUpdateApplicationConfigOutput) *UpdateApplicationConfigOutput {
	s.ResultData = v
	return s
}

const (
	// EnumOfEffectiveTypeForUpdateApplicationConfigInputCluster is a EnumOfEffectiveTypeForUpdateApplicationConfigInput enum value
	EnumOfEffectiveTypeForUpdateApplicationConfigInputCluster = "CLUSTER"

	// EnumOfEffectiveTypeForUpdateApplicationConfigInputNodeGroupName is a EnumOfEffectiveTypeForUpdateApplicationConfigInput enum value
	EnumOfEffectiveTypeForUpdateApplicationConfigInputNodeGroupName = "NODE_GROUP_NAME"

	// EnumOfEffectiveTypeForUpdateApplicationConfigInputNodeGroupId is a EnumOfEffectiveTypeForUpdateApplicationConfigInput enum value
	EnumOfEffectiveTypeForUpdateApplicationConfigInputNodeGroupId = "NODE_GROUP_ID"

	// EnumOfEffectiveTypeForUpdateApplicationConfigInputNodeGroupType is a EnumOfEffectiveTypeForUpdateApplicationConfigInput enum value
	EnumOfEffectiveTypeForUpdateApplicationConfigInputNodeGroupType = "NODE_GROUP_TYPE"

	// EnumOfEffectiveTypeForUpdateApplicationConfigInputNodeName is a EnumOfEffectiveTypeForUpdateApplicationConfigInput enum value
	EnumOfEffectiveTypeForUpdateApplicationConfigInputNodeName = "NODE_NAME"

	// EnumOfEffectiveTypeForUpdateApplicationConfigInputNodeId is a EnumOfEffectiveTypeForUpdateApplicationConfigInput enum value
	EnumOfEffectiveTypeForUpdateApplicationConfigInputNodeId = "NODE_ID"

	// EnumOfEffectiveTypeForUpdateApplicationConfigInputComponentName is a EnumOfEffectiveTypeForUpdateApplicationConfigInput enum value
	EnumOfEffectiveTypeForUpdateApplicationConfigInputComponentName = "COMPONENT_NAME"
)
