// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package emr

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListApplicationConfigsCommon = "ListApplicationConfigs"

// ListApplicationConfigsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListApplicationConfigsCommon operation. The "output" return
// value will be populated with the ListApplicationConfigsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListApplicationConfigsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListApplicationConfigsCommon Send returns without error.
//
// See ListApplicationConfigsCommon for more information on using the ListApplicationConfigsCommon
// API call, and error handling.
//
//    // Example sending a request using the ListApplicationConfigsCommonRequest method.
//    req, resp := client.ListApplicationConfigsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *EMR) ListApplicationConfigsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListApplicationConfigsCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListApplicationConfigsCommon API operation for EMR.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for EMR's
// API operation ListApplicationConfigsCommon for usage and error information.
func (c *EMR) ListApplicationConfigsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListApplicationConfigsCommonRequest(input)
	return out, req.Send()
}

// ListApplicationConfigsCommonWithContext is the same as ListApplicationConfigsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListApplicationConfigsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) ListApplicationConfigsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListApplicationConfigsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListApplicationConfigs = "ListApplicationConfigs"

// ListApplicationConfigsRequest generates a "volcengine/request.Request" representing the
// client's request for the ListApplicationConfigs operation. The "output" return
// value will be populated with the ListApplicationConfigsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListApplicationConfigsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListApplicationConfigsCommon Send returns without error.
//
// See ListApplicationConfigs for more information on using the ListApplicationConfigs
// API call, and error handling.
//
//    // Example sending a request using the ListApplicationConfigsRequest method.
//    req, resp := client.ListApplicationConfigsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *EMR) ListApplicationConfigsRequest(input *ListApplicationConfigsInput) (req *request.Request, output *ListApplicationConfigsOutput) {
	op := &request.Operation{
		Name:       opListApplicationConfigs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListApplicationConfigsInput{}
	}

	output = &ListApplicationConfigsOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListApplicationConfigs API operation for EMR.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for EMR's
// API operation ListApplicationConfigs for usage and error information.
func (c *EMR) ListApplicationConfigs(input *ListApplicationConfigsInput) (*ListApplicationConfigsOutput, error) {
	req, out := c.ListApplicationConfigsRequest(input)
	return out, req.Send()
}

// ListApplicationConfigsWithContext is the same as ListApplicationConfigs with the addition of
// the ability to pass a context and additional request options.
//
// See ListApplicationConfigs for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *EMR) ListApplicationConfigsWithContext(ctx volcengine.Context, input *ListApplicationConfigsInput, opts ...request.Option) (*ListApplicationConfigsOutput, error) {
	req, out := c.ListApplicationConfigsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type EffectiveScopeForListApplicationConfigsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ComponentNames []*string `type:"list" json:",omitempty"`

	EffectiveType *string `type:"string" json:",omitempty" enum:"EnumOfEffectiveTypeForListApplicationConfigsOutput"`

	NodeGroupIds []*string `type:"list" json:",omitempty"`

	NodeGroupNames []*string `type:"list" json:",omitempty"`

	NodeGroupTypes []*string `type:"list" json:",omitempty"`

	NodeIds []*string `type:"list" json:",omitempty"`

	NodeNames []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s EffectiveScopeForListApplicationConfigsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s EffectiveScopeForListApplicationConfigsOutput) GoString() string {
	return s.String()
}

// SetComponentNames sets the ComponentNames field's value.
func (s *EffectiveScopeForListApplicationConfigsOutput) SetComponentNames(v []*string) *EffectiveScopeForListApplicationConfigsOutput {
	s.ComponentNames = v
	return s
}

// SetEffectiveType sets the EffectiveType field's value.
func (s *EffectiveScopeForListApplicationConfigsOutput) SetEffectiveType(v string) *EffectiveScopeForListApplicationConfigsOutput {
	s.EffectiveType = &v
	return s
}

// SetNodeGroupIds sets the NodeGroupIds field's value.
func (s *EffectiveScopeForListApplicationConfigsOutput) SetNodeGroupIds(v []*string) *EffectiveScopeForListApplicationConfigsOutput {
	s.NodeGroupIds = v
	return s
}

// SetNodeGroupNames sets the NodeGroupNames field's value.
func (s *EffectiveScopeForListApplicationConfigsOutput) SetNodeGroupNames(v []*string) *EffectiveScopeForListApplicationConfigsOutput {
	s.NodeGroupNames = v
	return s
}

// SetNodeGroupTypes sets the NodeGroupTypes field's value.
func (s *EffectiveScopeForListApplicationConfigsOutput) SetNodeGroupTypes(v []*string) *EffectiveScopeForListApplicationConfigsOutput {
	s.NodeGroupTypes = v
	return s
}

// SetNodeIds sets the NodeIds field's value.
func (s *EffectiveScopeForListApplicationConfigsOutput) SetNodeIds(v []*string) *EffectiveScopeForListApplicationConfigsOutput {
	s.NodeIds = v
	return s
}

// SetNodeNames sets the NodeNames field's value.
func (s *EffectiveScopeForListApplicationConfigsOutput) SetNodeNames(v []*string) *EffectiveScopeForListApplicationConfigsOutput {
	s.NodeNames = v
	return s
}

type ItemForListApplicationConfigsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ApplicationName *string `type:"string" json:",omitempty"`

	Applied *bool `type:"boolean" json:",omitempty"`

	ConfigFileName *string `type:"string" json:",omitempty"`

	ConfigItemKey *string `type:"string" json:",omitempty"`

	ConfigItemValue *string `type:"string" json:",omitempty"`

	ConfigVersion *string `type:"string" json:",omitempty"`

	Customized *bool `type:"boolean" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	EffectiveScope *EffectiveScopeForListApplicationConfigsOutput `type:"structure" json:",omitempty"`

	OperatorId *string `type:"string" json:",omitempty"`

	PresetConfigItemValue *string `type:"string" json:",omitempty"`

	Remark *string `type:"string" json:",omitempty"`

	UpdateTime *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s ItemForListApplicationConfigsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ItemForListApplicationConfigsOutput) GoString() string {
	return s.String()
}

// SetApplicationName sets the ApplicationName field's value.
func (s *ItemForListApplicationConfigsOutput) SetApplicationName(v string) *ItemForListApplicationConfigsOutput {
	s.ApplicationName = &v
	return s
}

// SetApplied sets the Applied field's value.
func (s *ItemForListApplicationConfigsOutput) SetApplied(v bool) *ItemForListApplicationConfigsOutput {
	s.Applied = &v
	return s
}

// SetConfigFileName sets the ConfigFileName field's value.
func (s *ItemForListApplicationConfigsOutput) SetConfigFileName(v string) *ItemForListApplicationConfigsOutput {
	s.ConfigFileName = &v
	return s
}

// SetConfigItemKey sets the ConfigItemKey field's value.
func (s *ItemForListApplicationConfigsOutput) SetConfigItemKey(v string) *ItemForListApplicationConfigsOutput {
	s.ConfigItemKey = &v
	return s
}

// SetConfigItemValue sets the ConfigItemValue field's value.
func (s *ItemForListApplicationConfigsOutput) SetConfigItemValue(v string) *ItemForListApplicationConfigsOutput {
	s.ConfigItemValue = &v
	return s
}

// SetConfigVersion sets the ConfigVersion field's value.
func (s *ItemForListApplicationConfigsOutput) SetConfigVersion(v string) *ItemForListApplicationConfigsOutput {
	s.ConfigVersion = &v
	return s
}

// SetCustomized sets the Customized field's value.
func (s *ItemForListApplicationConfigsOutput) SetCustomized(v bool) *ItemForListApplicationConfigsOutput {
	s.Customized = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *ItemForListApplicationConfigsOutput) SetDescription(v string) *ItemForListApplicationConfigsOutput {
	s.Description = &v
	return s
}

// SetEffectiveScope sets the EffectiveScope field's value.
func (s *ItemForListApplicationConfigsOutput) SetEffectiveScope(v *EffectiveScopeForListApplicationConfigsOutput) *ItemForListApplicationConfigsOutput {
	s.EffectiveScope = v
	return s
}

// SetOperatorId sets the OperatorId field's value.
func (s *ItemForListApplicationConfigsOutput) SetOperatorId(v string) *ItemForListApplicationConfigsOutput {
	s.OperatorId = &v
	return s
}

// SetPresetConfigItemValue sets the PresetConfigItemValue field's value.
func (s *ItemForListApplicationConfigsOutput) SetPresetConfigItemValue(v string) *ItemForListApplicationConfigsOutput {
	s.PresetConfigItemValue = &v
	return s
}

// SetRemark sets the Remark field's value.
func (s *ItemForListApplicationConfigsOutput) SetRemark(v string) *ItemForListApplicationConfigsOutput {
	s.Remark = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *ItemForListApplicationConfigsOutput) SetUpdateTime(v int64) *ItemForListApplicationConfigsOutput {
	s.UpdateTime = &v
	return s
}

type ListApplicationConfigsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// ApplicationName is a required field
	ApplicationName *string `type:"string" json:",omitempty" required:"true"`

	// ClusterId is a required field
	ClusterId *string `type:"string" json:",omitempty" required:"true"`

	ConfigFileName *string `type:"string" json:",omitempty"`

	ConfigItemKey *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ListApplicationConfigsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListApplicationConfigsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListApplicationConfigsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListApplicationConfigsInput"}
	if s.ApplicationName == nil {
		invalidParams.Add(request.NewErrParamRequired("ApplicationName"))
	}
	if s.ClusterId == nil {
		invalidParams.Add(request.NewErrParamRequired("ClusterId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetApplicationName sets the ApplicationName field's value.
func (s *ListApplicationConfigsInput) SetApplicationName(v string) *ListApplicationConfigsInput {
	s.ApplicationName = &v
	return s
}

// SetClusterId sets the ClusterId field's value.
func (s *ListApplicationConfigsInput) SetClusterId(v string) *ListApplicationConfigsInput {
	s.ClusterId = &v
	return s
}

// SetConfigFileName sets the ConfigFileName field's value.
func (s *ListApplicationConfigsInput) SetConfigFileName(v string) *ListApplicationConfigsInput {
	s.ConfigFileName = &v
	return s
}

// SetConfigItemKey sets the ConfigItemKey field's value.
func (s *ListApplicationConfigsInput) SetConfigItemKey(v string) *ListApplicationConfigsInput {
	s.ConfigItemKey = &v
	return s
}

type ListApplicationConfigsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Items []*ItemForListApplicationConfigsOutput `type:"list" json:",omitempty"`

	MaxResults *int32 `type:"int32" json:",omitempty"`

	NextToken *string `type:"string" json:",omitempty"`

	TotalCount *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ListApplicationConfigsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListApplicationConfigsOutput) GoString() string {
	return s.String()
}

// SetItems sets the Items field's value.
func (s *ListApplicationConfigsOutput) SetItems(v []*ItemForListApplicationConfigsOutput) *ListApplicationConfigsOutput {
	s.Items = v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListApplicationConfigsOutput) SetMaxResults(v int32) *ListApplicationConfigsOutput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListApplicationConfigsOutput) SetNextToken(v string) *ListApplicationConfigsOutput {
	s.NextToken = &v
	return s
}

// SetTotalCount sets the TotalCount field's value.
func (s *ListApplicationConfigsOutput) SetTotalCount(v int32) *ListApplicationConfigsOutput {
	s.TotalCount = &v
	return s
}

const (
	// EnumOfEffectiveTypeForListApplicationConfigsOutputCluster is a EnumOfEffectiveTypeForListApplicationConfigsOutput enum value
	EnumOfEffectiveTypeForListApplicationConfigsOutputCluster = "CLUSTER"

	// EnumOfEffectiveTypeForListApplicationConfigsOutputNodeGroupName is a EnumOfEffectiveTypeForListApplicationConfigsOutput enum value
	EnumOfEffectiveTypeForListApplicationConfigsOutputNodeGroupName = "NODE_GROUP_NAME"

	// EnumOfEffectiveTypeForListApplicationConfigsOutputNodeGroupId is a EnumOfEffectiveTypeForListApplicationConfigsOutput enum value
	EnumOfEffectiveTypeForListApplicationConfigsOutputNodeGroupId = "NODE_GROUP_ID"

	// EnumOfEffectiveTypeForListApplicationConfigsOutputNodeGroupType is a EnumOfEffectiveTypeForListApplicationConfigsOutput enum value
	EnumOfEffectiveTypeForListApplicationConfigsOutputNodeGroupType = "NODE_GROUP_TYPE"

	// EnumOfEffectiveTypeForListApplicationConfigsOutputNodeName is a EnumOfEffectiveTypeForListApplicationConfigsOutput enum value
	EnumOfEffectiveTypeForListApplicationConfigsOutputNodeName = "NODE_NAME"

	// EnumOfEffectiveTypeForListApplicationConfigsOutputNodeId is a EnumOfEffectiveTypeForListApplicationConfigsOutput enum value
	EnumOfEffectiveTypeForListApplicationConfigsOutputNodeId = "NODE_ID"

	// EnumOfEffectiveTypeForListApplicationConfigsOutputComponentName is a EnumOfEffectiveTypeForListApplicationConfigsOutput enum value
	EnumOfEffectiveTypeForListApplicationConfigsOutputComponentName = "COMPONENT_NAME"
)
