// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package ecs

import (
	"fmt"

	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opAllocateInstancesCommon = "AllocateInstances"

// AllocateInstancesCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the AllocateInstancesCommon operation. The "output" return
// value will be populated with the AllocateInstancesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned AllocateInstancesCommon Request to send the API call to the service.
// the "output" return value is not valid until after AllocateInstancesCommon Send returns without error.
//
// See AllocateInstancesCommon for more information on using the AllocateInstancesCommon
// API call, and error handling.
//
//    // Example sending a request using the AllocateInstancesCommonRequest method.
//    req, resp := client.AllocateInstancesCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ECS) AllocateInstancesCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opAllocateInstancesCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// AllocateInstancesCommon API operation for ECS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ECS's
// API operation AllocateInstancesCommon for usage and error information.
func (c *ECS) AllocateInstancesCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.AllocateInstancesCommonRequest(input)
	return out, req.Send()
}

// AllocateInstancesCommonWithContext is the same as AllocateInstancesCommon with the addition of
// the ability to pass a context and additional request options.
//
// See AllocateInstancesCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) AllocateInstancesCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.AllocateInstancesCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opAllocateInstances = "AllocateInstances"

// AllocateInstancesRequest generates a "volcengine/request.Request" representing the
// client's request for the AllocateInstances operation. The "output" return
// value will be populated with the AllocateInstancesCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned AllocateInstancesCommon Request to send the API call to the service.
// the "output" return value is not valid until after AllocateInstancesCommon Send returns without error.
//
// See AllocateInstances for more information on using the AllocateInstances
// API call, and error handling.
//
//    // Example sending a request using the AllocateInstancesRequest method.
//    req, resp := client.AllocateInstancesRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *ECS) AllocateInstancesRequest(input *AllocateInstancesInput) (req *request.Request, output *AllocateInstancesOutput) {
	op := &request.Operation{
		Name:       opAllocateInstances,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &AllocateInstancesInput{}
	}

	output = &AllocateInstancesOutput{}
	req = c.newRequest(op, input, output)

	return
}

// AllocateInstances API operation for ECS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for ECS's
// API operation AllocateInstances for usage and error information.
func (c *ECS) AllocateInstances(input *AllocateInstancesInput) (*AllocateInstancesOutput, error) {
	req, out := c.AllocateInstancesRequest(input)
	return out, req.Send()
}

// AllocateInstancesWithContext is the same as AllocateInstances with the addition of
// the ability to pass a context and additional request options.
//
// See AllocateInstances for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *ECS) AllocateInstancesWithContext(ctx volcengine.Context, input *AllocateInstancesInput, opts ...request.Option) (*AllocateInstancesOutput, error) {
	req, out := c.AllocateInstancesRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type AllocateInstancesInput struct {
	_ struct{} `type:"structure"`

	AutoRenew *bool `type:"boolean"`

	AutoRenewPeriod *int32 `type:"int32"`

	BatchCreateInMultiZone *bool `type:"boolean"`

	ClientToken *string `type:"string"`

	Count *int32 `type:"int32"`

	CreditSpecification *string `type:"string"`

	DeploymentSetGroupNumber *int32 `type:"int32"`

	DeploymentSetId *string `type:"string"`

	Description *string `type:"string"`

	DryRun *bool `type:"boolean"`

	EipAddress *EipAddressForAllocateInstancesInput `type:"structure"`

	Hostname *string `type:"string"`

	HpcClusterId *string `type:"string"`

	// ImageId is a required field
	ImageId *string `type:"string" required:"true"`

	ImageReleaseVersion *string `type:"string"`

	InstallRunCommandAgent *bool `type:"boolean"`

	InstanceChargeType *string `type:"string"`

	// InstanceName is a required field
	InstanceName *string `type:"string" required:"true"`

	// InstanceTypeId is a required field
	InstanceTypeId *string `type:"string" required:"true"`

	KeepImageCredential *bool `type:"boolean"`

	KeyPairName *string `type:"string"`

	NetworkInterfaces []*NetworkInterfaceForAllocateInstancesInput `type:"list"`

	Password *string `type:"string"`

	Period *int32 `type:"int32"`

	PeriodUnit *string `type:"string"`

	Placement *PlacementForAllocateInstancesInput `type:"structure"`

	ProjectName *string `type:"string"`

	SecurityEnhancementStrategy *string `type:"string"`

	SpotPriceLimit *float64 `type:"float"`

	SpotStrategy *string `type:"string"`

	SuffixIndex *int32 `type:"int32"`

	Tags []*TagForAllocateInstancesInput `type:"list"`

	UniqueSuffix *bool `type:"boolean"`

	UserData *string `type:"string"`

	Volumes []*VolumeForAllocateInstancesInput `type:"list"`

	ZoneId *string `type:"string"`
}

// String returns the string representation
func (s AllocateInstancesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AllocateInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *AllocateInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "AllocateInstancesInput"}
	if s.ImageId == nil {
		invalidParams.Add(request.NewErrParamRequired("ImageId"))
	}
	if s.InstanceName == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceName"))
	}
	if s.InstanceTypeId == nil {
		invalidParams.Add(request.NewErrParamRequired("InstanceTypeId"))
	}
	if s.NetworkInterfaces != nil {
		for i, v := range s.NetworkInterfaces {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "NetworkInterfaces", i), err.(request.ErrInvalidParams))
			}
		}
	}
	if s.Volumes != nil {
		for i, v := range s.Volumes {
			if v == nil {
				continue
			}
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Volumes", i), err.(request.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAutoRenew sets the AutoRenew field's value.
func (s *AllocateInstancesInput) SetAutoRenew(v bool) *AllocateInstancesInput {
	s.AutoRenew = &v
	return s
}

// SetAutoRenewPeriod sets the AutoRenewPeriod field's value.
func (s *AllocateInstancesInput) SetAutoRenewPeriod(v int32) *AllocateInstancesInput {
	s.AutoRenewPeriod = &v
	return s
}

// SetBatchCreateInMultiZone sets the BatchCreateInMultiZone field's value.
func (s *AllocateInstancesInput) SetBatchCreateInMultiZone(v bool) *AllocateInstancesInput {
	s.BatchCreateInMultiZone = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *AllocateInstancesInput) SetClientToken(v string) *AllocateInstancesInput {
	s.ClientToken = &v
	return s
}

// SetCount sets the Count field's value.
func (s *AllocateInstancesInput) SetCount(v int32) *AllocateInstancesInput {
	s.Count = &v
	return s
}

// SetCreditSpecification sets the CreditSpecification field's value.
func (s *AllocateInstancesInput) SetCreditSpecification(v string) *AllocateInstancesInput {
	s.CreditSpecification = &v
	return s
}

// SetDeploymentSetGroupNumber sets the DeploymentSetGroupNumber field's value.
func (s *AllocateInstancesInput) SetDeploymentSetGroupNumber(v int32) *AllocateInstancesInput {
	s.DeploymentSetGroupNumber = &v
	return s
}

// SetDeploymentSetId sets the DeploymentSetId field's value.
func (s *AllocateInstancesInput) SetDeploymentSetId(v string) *AllocateInstancesInput {
	s.DeploymentSetId = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *AllocateInstancesInput) SetDescription(v string) *AllocateInstancesInput {
	s.Description = &v
	return s
}

// SetDryRun sets the DryRun field's value.
func (s *AllocateInstancesInput) SetDryRun(v bool) *AllocateInstancesInput {
	s.DryRun = &v
	return s
}

// SetEipAddress sets the EipAddress field's value.
func (s *AllocateInstancesInput) SetEipAddress(v *EipAddressForAllocateInstancesInput) *AllocateInstancesInput {
	s.EipAddress = v
	return s
}

// SetHostname sets the Hostname field's value.
func (s *AllocateInstancesInput) SetHostname(v string) *AllocateInstancesInput {
	s.Hostname = &v
	return s
}

// SetHpcClusterId sets the HpcClusterId field's value.
func (s *AllocateInstancesInput) SetHpcClusterId(v string) *AllocateInstancesInput {
	s.HpcClusterId = &v
	return s
}

// SetImageId sets the ImageId field's value.
func (s *AllocateInstancesInput) SetImageId(v string) *AllocateInstancesInput {
	s.ImageId = &v
	return s
}

// SetImageReleaseVersion sets the ImageReleaseVersion field's value.
func (s *AllocateInstancesInput) SetImageReleaseVersion(v string) *AllocateInstancesInput {
	s.ImageReleaseVersion = &v
	return s
}

// SetInstallRunCommandAgent sets the InstallRunCommandAgent field's value.
func (s *AllocateInstancesInput) SetInstallRunCommandAgent(v bool) *AllocateInstancesInput {
	s.InstallRunCommandAgent = &v
	return s
}

// SetInstanceChargeType sets the InstanceChargeType field's value.
func (s *AllocateInstancesInput) SetInstanceChargeType(v string) *AllocateInstancesInput {
	s.InstanceChargeType = &v
	return s
}

// SetInstanceName sets the InstanceName field's value.
func (s *AllocateInstancesInput) SetInstanceName(v string) *AllocateInstancesInput {
	s.InstanceName = &v
	return s
}

// SetInstanceTypeId sets the InstanceTypeId field's value.
func (s *AllocateInstancesInput) SetInstanceTypeId(v string) *AllocateInstancesInput {
	s.InstanceTypeId = &v
	return s
}

// SetKeepImageCredential sets the KeepImageCredential field's value.
func (s *AllocateInstancesInput) SetKeepImageCredential(v bool) *AllocateInstancesInput {
	s.KeepImageCredential = &v
	return s
}

// SetKeyPairName sets the KeyPairName field's value.
func (s *AllocateInstancesInput) SetKeyPairName(v string) *AllocateInstancesInput {
	s.KeyPairName = &v
	return s
}

// SetNetworkInterfaces sets the NetworkInterfaces field's value.
func (s *AllocateInstancesInput) SetNetworkInterfaces(v []*NetworkInterfaceForAllocateInstancesInput) *AllocateInstancesInput {
	s.NetworkInterfaces = v
	return s
}

// SetPassword sets the Password field's value.
func (s *AllocateInstancesInput) SetPassword(v string) *AllocateInstancesInput {
	s.Password = &v
	return s
}

// SetPeriod sets the Period field's value.
func (s *AllocateInstancesInput) SetPeriod(v int32) *AllocateInstancesInput {
	s.Period = &v
	return s
}

// SetPeriodUnit sets the PeriodUnit field's value.
func (s *AllocateInstancesInput) SetPeriodUnit(v string) *AllocateInstancesInput {
	s.PeriodUnit = &v
	return s
}

// SetPlacement sets the Placement field's value.
func (s *AllocateInstancesInput) SetPlacement(v *PlacementForAllocateInstancesInput) *AllocateInstancesInput {
	s.Placement = v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *AllocateInstancesInput) SetProjectName(v string) *AllocateInstancesInput {
	s.ProjectName = &v
	return s
}

// SetSecurityEnhancementStrategy sets the SecurityEnhancementStrategy field's value.
func (s *AllocateInstancesInput) SetSecurityEnhancementStrategy(v string) *AllocateInstancesInput {
	s.SecurityEnhancementStrategy = &v
	return s
}

// SetSpotPriceLimit sets the SpotPriceLimit field's value.
func (s *AllocateInstancesInput) SetSpotPriceLimit(v float64) *AllocateInstancesInput {
	s.SpotPriceLimit = &v
	return s
}

// SetSpotStrategy sets the SpotStrategy field's value.
func (s *AllocateInstancesInput) SetSpotStrategy(v string) *AllocateInstancesInput {
	s.SpotStrategy = &v
	return s
}

// SetSuffixIndex sets the SuffixIndex field's value.
func (s *AllocateInstancesInput) SetSuffixIndex(v int32) *AllocateInstancesInput {
	s.SuffixIndex = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *AllocateInstancesInput) SetTags(v []*TagForAllocateInstancesInput) *AllocateInstancesInput {
	s.Tags = v
	return s
}

// SetUniqueSuffix sets the UniqueSuffix field's value.
func (s *AllocateInstancesInput) SetUniqueSuffix(v bool) *AllocateInstancesInput {
	s.UniqueSuffix = &v
	return s
}

// SetUserData sets the UserData field's value.
func (s *AllocateInstancesInput) SetUserData(v string) *AllocateInstancesInput {
	s.UserData = &v
	return s
}

// SetVolumes sets the Volumes field's value.
func (s *AllocateInstancesInput) SetVolumes(v []*VolumeForAllocateInstancesInput) *AllocateInstancesInput {
	s.Volumes = v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *AllocateInstancesInput) SetZoneId(v string) *AllocateInstancesInput {
	s.ZoneId = &v
	return s
}

type AllocateInstancesOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	OperationDetails []*OperationDetailForAllocateInstancesOutput `type:"list"`
}

// String returns the string representation
func (s AllocateInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s AllocateInstancesOutput) GoString() string {
	return s.String()
}

// SetOperationDetails sets the OperationDetails field's value.
func (s *AllocateInstancesOutput) SetOperationDetails(v []*OperationDetailForAllocateInstancesOutput) *AllocateInstancesOutput {
	s.OperationDetails = v
	return s
}

type EipAddressForAllocateInstancesInput struct {
	_ struct{} `type:"structure"`

	BandwidthMbps *int32 `type:"int32"`

	BandwidthPackageId *string `type:"string"`

	ChargeType *string `type:"string"`

	ISP *string `type:"string"`

	ReleaseWithInstance *bool `type:"boolean"`

	SecurityProtectionInstanceId *int32 `type:"int32"`

	SecurityProtectionTypes []*string `type:"list"`
}

// String returns the string representation
func (s EipAddressForAllocateInstancesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s EipAddressForAllocateInstancesInput) GoString() string {
	return s.String()
}

// SetBandwidthMbps sets the BandwidthMbps field's value.
func (s *EipAddressForAllocateInstancesInput) SetBandwidthMbps(v int32) *EipAddressForAllocateInstancesInput {
	s.BandwidthMbps = &v
	return s
}

// SetBandwidthPackageId sets the BandwidthPackageId field's value.
func (s *EipAddressForAllocateInstancesInput) SetBandwidthPackageId(v string) *EipAddressForAllocateInstancesInput {
	s.BandwidthPackageId = &v
	return s
}

// SetChargeType sets the ChargeType field's value.
func (s *EipAddressForAllocateInstancesInput) SetChargeType(v string) *EipAddressForAllocateInstancesInput {
	s.ChargeType = &v
	return s
}

// SetISP sets the ISP field's value.
func (s *EipAddressForAllocateInstancesInput) SetISP(v string) *EipAddressForAllocateInstancesInput {
	s.ISP = &v
	return s
}

// SetReleaseWithInstance sets the ReleaseWithInstance field's value.
func (s *EipAddressForAllocateInstancesInput) SetReleaseWithInstance(v bool) *EipAddressForAllocateInstancesInput {
	s.ReleaseWithInstance = &v
	return s
}

// SetSecurityProtectionInstanceId sets the SecurityProtectionInstanceId field's value.
func (s *EipAddressForAllocateInstancesInput) SetSecurityProtectionInstanceId(v int32) *EipAddressForAllocateInstancesInput {
	s.SecurityProtectionInstanceId = &v
	return s
}

// SetSecurityProtectionTypes sets the SecurityProtectionTypes field's value.
func (s *EipAddressForAllocateInstancesInput) SetSecurityProtectionTypes(v []*string) *EipAddressForAllocateInstancesInput {
	s.SecurityProtectionTypes = v
	return s
}

type ErrorForAllocateInstancesOutput struct {
	_ struct{} `type:"structure"`

	Code *string `type:"string"`

	Message *string `type:"string"`
}

// String returns the string representation
func (s ErrorForAllocateInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ErrorForAllocateInstancesOutput) GoString() string {
	return s.String()
}

// SetCode sets the Code field's value.
func (s *ErrorForAllocateInstancesOutput) SetCode(v string) *ErrorForAllocateInstancesOutput {
	s.Code = &v
	return s
}

// SetMessage sets the Message field's value.
func (s *ErrorForAllocateInstancesOutput) SetMessage(v string) *ErrorForAllocateInstancesOutput {
	s.Message = &v
	return s
}

type NetworkInterfaceForAllocateInstancesInput struct {
	_ struct{} `type:"structure"`

	Ipv6AddressCount *int32 `type:"int32"`

	// SecurityGroupIds is a required field
	SecurityGroupIds []*string `type:"list" required:"true"`

	// SubnetId is a required field
	SubnetId []*string `type:"list" required:"true"`
}

// String returns the string representation
func (s NetworkInterfaceForAllocateInstancesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s NetworkInterfaceForAllocateInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *NetworkInterfaceForAllocateInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "NetworkInterfaceForAllocateInstancesInput"}
	if s.SecurityGroupIds == nil {
		invalidParams.Add(request.NewErrParamRequired("SecurityGroupIds"))
	}
	if s.SubnetId == nil {
		invalidParams.Add(request.NewErrParamRequired("SubnetId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIpv6AddressCount sets the Ipv6AddressCount field's value.
func (s *NetworkInterfaceForAllocateInstancesInput) SetIpv6AddressCount(v int32) *NetworkInterfaceForAllocateInstancesInput {
	s.Ipv6AddressCount = &v
	return s
}

// SetSecurityGroupIds sets the SecurityGroupIds field's value.
func (s *NetworkInterfaceForAllocateInstancesInput) SetSecurityGroupIds(v []*string) *NetworkInterfaceForAllocateInstancesInput {
	s.SecurityGroupIds = v
	return s
}

// SetSubnetId sets the SubnetId field's value.
func (s *NetworkInterfaceForAllocateInstancesInput) SetSubnetId(v []*string) *NetworkInterfaceForAllocateInstancesInput {
	s.SubnetId = v
	return s
}

type OperationDetailForAllocateInstancesOutput struct {
	_ struct{} `type:"structure"`

	Error *ErrorForAllocateInstancesOutput `type:"structure"`

	InstanceIds []*string `type:"list"`

	PreorderIds []*string `type:"list"`

	ZoneId *string `type:"string"`
}

// String returns the string representation
func (s OperationDetailForAllocateInstancesOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OperationDetailForAllocateInstancesOutput) GoString() string {
	return s.String()
}

// SetError sets the Error field's value.
func (s *OperationDetailForAllocateInstancesOutput) SetError(v *ErrorForAllocateInstancesOutput) *OperationDetailForAllocateInstancesOutput {
	s.Error = v
	return s
}

// SetInstanceIds sets the InstanceIds field's value.
func (s *OperationDetailForAllocateInstancesOutput) SetInstanceIds(v []*string) *OperationDetailForAllocateInstancesOutput {
	s.InstanceIds = v
	return s
}

// SetPreorderIds sets the PreorderIds field's value.
func (s *OperationDetailForAllocateInstancesOutput) SetPreorderIds(v []*string) *OperationDetailForAllocateInstancesOutput {
	s.PreorderIds = v
	return s
}

// SetZoneId sets the ZoneId field's value.
func (s *OperationDetailForAllocateInstancesOutput) SetZoneId(v string) *OperationDetailForAllocateInstancesOutput {
	s.ZoneId = &v
	return s
}

type PlacementForAllocateInstancesInput struct {
	_ struct{} `type:"structure"`

	Affinity *string `type:"string"`

	DedicatedHostClusterId *string `type:"string"`

	DedicatedHostId *string `type:"string"`

	Tenancy *string `type:"string"`
}

// String returns the string representation
func (s PlacementForAllocateInstancesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PlacementForAllocateInstancesInput) GoString() string {
	return s.String()
}

// SetAffinity sets the Affinity field's value.
func (s *PlacementForAllocateInstancesInput) SetAffinity(v string) *PlacementForAllocateInstancesInput {
	s.Affinity = &v
	return s
}

// SetDedicatedHostClusterId sets the DedicatedHostClusterId field's value.
func (s *PlacementForAllocateInstancesInput) SetDedicatedHostClusterId(v string) *PlacementForAllocateInstancesInput {
	s.DedicatedHostClusterId = &v
	return s
}

// SetDedicatedHostId sets the DedicatedHostId field's value.
func (s *PlacementForAllocateInstancesInput) SetDedicatedHostId(v string) *PlacementForAllocateInstancesInput {
	s.DedicatedHostId = &v
	return s
}

// SetTenancy sets the Tenancy field's value.
func (s *PlacementForAllocateInstancesInput) SetTenancy(v string) *PlacementForAllocateInstancesInput {
	s.Tenancy = &v
	return s
}

type TagForAllocateInstancesInput struct {
	_ struct{} `type:"structure"`

	Key *string `type:"string"`

	Value *string `type:"string"`
}

// String returns the string representation
func (s TagForAllocateInstancesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForAllocateInstancesInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForAllocateInstancesInput) SetKey(v string) *TagForAllocateInstancesInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForAllocateInstancesInput) SetValue(v string) *TagForAllocateInstancesInput {
	s.Value = &v
	return s
}

type VolumeForAllocateInstancesInput struct {
	_ struct{} `type:"structure"`

	DeleteWithInstance *string `type:"string"`

	ExtraPerformanceIOPS *int32 `type:"int32"`

	ExtraPerformanceThroughputMB *int32 `type:"int32"`

	ExtraPerformanceTypeId *string `type:"string"`

	// Size is a required field
	Size *int32 `type:"int32" required:"true"`

	SnapshotId *string `type:"string"`

	VolumeType *string `type:"string"`
}

// String returns the string representation
func (s VolumeForAllocateInstancesInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s VolumeForAllocateInstancesInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VolumeForAllocateInstancesInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "VolumeForAllocateInstancesInput"}
	if s.Size == nil {
		invalidParams.Add(request.NewErrParamRequired("Size"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDeleteWithInstance sets the DeleteWithInstance field's value.
func (s *VolumeForAllocateInstancesInput) SetDeleteWithInstance(v string) *VolumeForAllocateInstancesInput {
	s.DeleteWithInstance = &v
	return s
}

// SetExtraPerformanceIOPS sets the ExtraPerformanceIOPS field's value.
func (s *VolumeForAllocateInstancesInput) SetExtraPerformanceIOPS(v int32) *VolumeForAllocateInstancesInput {
	s.ExtraPerformanceIOPS = &v
	return s
}

// SetExtraPerformanceThroughputMB sets the ExtraPerformanceThroughputMB field's value.
func (s *VolumeForAllocateInstancesInput) SetExtraPerformanceThroughputMB(v int32) *VolumeForAllocateInstancesInput {
	s.ExtraPerformanceThroughputMB = &v
	return s
}

// SetExtraPerformanceTypeId sets the ExtraPerformanceTypeId field's value.
func (s *VolumeForAllocateInstancesInput) SetExtraPerformanceTypeId(v string) *VolumeForAllocateInstancesInput {
	s.ExtraPerformanceTypeId = &v
	return s
}

// SetSize sets the Size field's value.
func (s *VolumeForAllocateInstancesInput) SetSize(v int32) *VolumeForAllocateInstancesInput {
	s.Size = &v
	return s
}

// SetSnapshotId sets the SnapshotId field's value.
func (s *VolumeForAllocateInstancesInput) SetSnapshotId(v string) *VolumeForAllocateInstancesInput {
	s.SnapshotId = &v
	return s
}

// SetVolumeType sets the VolumeType field's value.
func (s *VolumeForAllocateInstancesInput) SetVolumeType(v string) *VolumeForAllocateInstancesInput {
	s.VolumeType = &v
	return s
}
