// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package dns

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateZoneCommon = "CreateZone"

// CreateZoneCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateZoneCommon operation. The "output" return
// value will be populated with the CreateZoneCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateZoneCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateZoneCommon Send returns without error.
//
// See CreateZoneCommon for more information on using the CreateZoneCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateZoneCommonRequest method.
//    req, resp := client.CreateZoneCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *DNS) CreateZoneCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateZoneCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateZoneCommon API operation for DNS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for DNS's
// API operation CreateZoneCommon for usage and error information.
func (c *DNS) CreateZoneCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateZoneCommonRequest(input)
	return out, req.Send()
}

// CreateZoneCommonWithContext is the same as CreateZoneCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateZoneCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DNS) CreateZoneCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateZoneCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateZone = "CreateZone"

// CreateZoneRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateZone operation. The "output" return
// value will be populated with the CreateZoneCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateZoneCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateZoneCommon Send returns without error.
//
// See CreateZone for more information on using the CreateZone
// API call, and error handling.
//
//    // Example sending a request using the CreateZoneRequest method.
//    req, resp := client.CreateZoneRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *DNS) CreateZoneRequest(input *CreateZoneInput) (req *request.Request, output *CreateZoneOutput) {
	op := &request.Operation{
		Name:       opCreateZone,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateZoneInput{}
	}

	output = &CreateZoneOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateZone API operation for DNS.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for DNS's
// API operation CreateZone for usage and error information.
func (c *DNS) CreateZone(input *CreateZoneInput) (*CreateZoneOutput, error) {
	req, out := c.CreateZoneRequest(input)
	return out, req.Send()
}

// CreateZoneWithContext is the same as CreateZone with the addition of
// the ability to pass a context and additional request options.
//
// See CreateZone for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DNS) CreateZoneWithContext(ctx volcengine.Context, input *CreateZoneInput, opts ...request.Option) (*CreateZoneOutput, error) {
	req, out := c.CreateZoneRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateZoneInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`

	Remark *string `type:"string" json:",omitempty"`

	Tags []*TagForCreateZoneInput `type:"list" json:",omitempty"`

	// ZoneName is a required field
	ZoneName *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s CreateZoneInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateZoneInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateZoneInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateZoneInput"}
	if s.ZoneName == nil {
		invalidParams.Add(request.NewErrParamRequired("ZoneName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateZoneInput) SetProjectName(v string) *CreateZoneInput {
	s.ProjectName = &v
	return s
}

// SetRemark sets the Remark field's value.
func (s *CreateZoneInput) SetRemark(v string) *CreateZoneInput {
	s.Remark = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateZoneInput) SetTags(v []*TagForCreateZoneInput) *CreateZoneInput {
	s.Tags = v
	return s
}

// SetZoneName sets the ZoneName field's value.
func (s *CreateZoneInput) SetZoneName(v string) *CreateZoneInput {
	s.ZoneName = &v
	return s
}

type CreateZoneOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	CacheStage *int32 `type:"int32" json:",omitempty"`

	ConfigurationCode *string `type:"string" json:",omitempty"`

	CreatedAt *string `type:"string" json:",omitempty"`

	DnsSecurity *string `type:"string" json:",omitempty"`

	ExpiredTime *int64 `type:"int64" json:",omitempty"`

	InstanceID *string `type:"string" json:",omitempty"`

	IsSubDomain *bool `type:"boolean" json:",omitempty"`

	LastOperator *string `type:"string" json:",omitempty"`

	RecordCount *int32 `type:"int32" json:",omitempty"`

	Remark *string `type:"string" json:",omitempty"`

	TradeCode *string `type:"string" json:",omitempty"`

	UpdatedAt *string `type:"string" json:",omitempty"`

	ZID *int64 `type:"int64" json:",omitempty"`

	ZoneName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateZoneOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateZoneOutput) GoString() string {
	return s.String()
}

// SetCacheStage sets the CacheStage field's value.
func (s *CreateZoneOutput) SetCacheStage(v int32) *CreateZoneOutput {
	s.CacheStage = &v
	return s
}

// SetConfigurationCode sets the ConfigurationCode field's value.
func (s *CreateZoneOutput) SetConfigurationCode(v string) *CreateZoneOutput {
	s.ConfigurationCode = &v
	return s
}

// SetCreatedAt sets the CreatedAt field's value.
func (s *CreateZoneOutput) SetCreatedAt(v string) *CreateZoneOutput {
	s.CreatedAt = &v
	return s
}

// SetDnsSecurity sets the DnsSecurity field's value.
func (s *CreateZoneOutput) SetDnsSecurity(v string) *CreateZoneOutput {
	s.DnsSecurity = &v
	return s
}

// SetExpiredTime sets the ExpiredTime field's value.
func (s *CreateZoneOutput) SetExpiredTime(v int64) *CreateZoneOutput {
	s.ExpiredTime = &v
	return s
}

// SetInstanceID sets the InstanceID field's value.
func (s *CreateZoneOutput) SetInstanceID(v string) *CreateZoneOutput {
	s.InstanceID = &v
	return s
}

// SetIsSubDomain sets the IsSubDomain field's value.
func (s *CreateZoneOutput) SetIsSubDomain(v bool) *CreateZoneOutput {
	s.IsSubDomain = &v
	return s
}

// SetLastOperator sets the LastOperator field's value.
func (s *CreateZoneOutput) SetLastOperator(v string) *CreateZoneOutput {
	s.LastOperator = &v
	return s
}

// SetRecordCount sets the RecordCount field's value.
func (s *CreateZoneOutput) SetRecordCount(v int32) *CreateZoneOutput {
	s.RecordCount = &v
	return s
}

// SetRemark sets the Remark field's value.
func (s *CreateZoneOutput) SetRemark(v string) *CreateZoneOutput {
	s.Remark = &v
	return s
}

// SetTradeCode sets the TradeCode field's value.
func (s *CreateZoneOutput) SetTradeCode(v string) *CreateZoneOutput {
	s.TradeCode = &v
	return s
}

// SetUpdatedAt sets the UpdatedAt field's value.
func (s *CreateZoneOutput) SetUpdatedAt(v string) *CreateZoneOutput {
	s.UpdatedAt = &v
	return s
}

// SetZID sets the ZID field's value.
func (s *CreateZoneOutput) SetZID(v int64) *CreateZoneOutput {
	s.ZID = &v
	return s
}

// SetZoneName sets the ZoneName field's value.
func (s *CreateZoneOutput) SetZoneName(v string) *CreateZoneOutput {
	s.ZoneName = &v
	return s
}

type TagForCreateZoneInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s TagForCreateZoneInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TagForCreateZoneInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *TagForCreateZoneInput) SetKey(v string) *TagForCreateZoneInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *TagForCreateZoneInput) SetValue(v string) *TagForCreateZoneInput {
	s.Value = &v
	return s
}
