// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package directconnect

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateBgpPeerCommon = "CreateBgpPeer"

// CreateBgpPeerCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateBgpPeerCommon operation. The "output" return
// value will be populated with the CreateBgpPeerCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateBgpPeerCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateBgpPeerCommon Send returns without error.
//
// See CreateBgpPeerCommon for more information on using the CreateBgpPeerCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateBgpPeerCommonRequest method.
//    req, resp := client.CreateBgpPeerCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *DIRECTCONNECT) CreateBgpPeerCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateBgpPeerCommon,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	return
}

// CreateBgpPeerCommon API operation for DIRECTCONNECT.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for DIRECTCONNECT's
// API operation CreateBgpPeerCommon for usage and error information.
func (c *DIRECTCONNECT) CreateBgpPeerCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateBgpPeerCommonRequest(input)
	return out, req.Send()
}

// CreateBgpPeerCommonWithContext is the same as CreateBgpPeerCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBgpPeerCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DIRECTCONNECT) CreateBgpPeerCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateBgpPeerCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateBgpPeer = "CreateBgpPeer"

// CreateBgpPeerRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateBgpPeer operation. The "output" return
// value will be populated with the CreateBgpPeerCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateBgpPeerCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateBgpPeerCommon Send returns without error.
//
// See CreateBgpPeer for more information on using the CreateBgpPeer
// API call, and error handling.
//
//    // Example sending a request using the CreateBgpPeerRequest method.
//    req, resp := client.CreateBgpPeerRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *DIRECTCONNECT) CreateBgpPeerRequest(input *CreateBgpPeerInput) (req *request.Request, output *CreateBgpPeerOutput) {
	op := &request.Operation{
		Name:       opCreateBgpPeer,
		HTTPMethod: "GET",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateBgpPeerInput{}
	}

	output = &CreateBgpPeerOutput{}
	req = c.newRequest(op, input, output)

	return
}

// CreateBgpPeer API operation for DIRECTCONNECT.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for DIRECTCONNECT's
// API operation CreateBgpPeer for usage and error information.
func (c *DIRECTCONNECT) CreateBgpPeer(input *CreateBgpPeerInput) (*CreateBgpPeerOutput, error) {
	req, out := c.CreateBgpPeerRequest(input)
	return out, req.Send()
}

// CreateBgpPeerWithContext is the same as CreateBgpPeer with the addition of
// the ability to pass a context and additional request options.
//
// See CreateBgpPeer for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DIRECTCONNECT) CreateBgpPeerWithContext(ctx volcengine.Context, input *CreateBgpPeerInput, opts ...request.Option) (*CreateBgpPeerOutput, error) {
	req, out := c.CreateBgpPeerRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateBgpPeerInput struct {
	_ struct{} `type:"structure"`

	AuthKey *string `type:"string"`

	BgpPeerName *string `min:"1" max:"128" type:"string"`

	Description *string `min:"1" max:"255" type:"string"`

	IpVersion *string `type:"string"`

	// RemoteAsn is a required field
	RemoteAsn *int64 `type:"integer" required:"true"`

	// VirtualInterfaceId is a required field
	VirtualInterfaceId *string `type:"string" required:"true"`
}

// String returns the string representation
func (s CreateBgpPeerInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBgpPeerInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateBgpPeerInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateBgpPeerInput"}
	if s.BgpPeerName != nil && len(*s.BgpPeerName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("BgpPeerName", 1))
	}
	if s.BgpPeerName != nil && len(*s.BgpPeerName) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("BgpPeerName", 128, *s.BgpPeerName))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Description != nil && len(*s.Description) > 255 {
		invalidParams.Add(request.NewErrParamMaxLen("Description", 255, *s.Description))
	}
	if s.RemoteAsn == nil {
		invalidParams.Add(request.NewErrParamRequired("RemoteAsn"))
	}
	if s.VirtualInterfaceId == nil {
		invalidParams.Add(request.NewErrParamRequired("VirtualInterfaceId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAuthKey sets the AuthKey field's value.
func (s *CreateBgpPeerInput) SetAuthKey(v string) *CreateBgpPeerInput {
	s.AuthKey = &v
	return s
}

// SetBgpPeerName sets the BgpPeerName field's value.
func (s *CreateBgpPeerInput) SetBgpPeerName(v string) *CreateBgpPeerInput {
	s.BgpPeerName = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateBgpPeerInput) SetDescription(v string) *CreateBgpPeerInput {
	s.Description = &v
	return s
}

// SetIpVersion sets the IpVersion field's value.
func (s *CreateBgpPeerInput) SetIpVersion(v string) *CreateBgpPeerInput {
	s.IpVersion = &v
	return s
}

// SetRemoteAsn sets the RemoteAsn field's value.
func (s *CreateBgpPeerInput) SetRemoteAsn(v int64) *CreateBgpPeerInput {
	s.RemoteAsn = &v
	return s
}

// SetVirtualInterfaceId sets the VirtualInterfaceId field's value.
func (s *CreateBgpPeerInput) SetVirtualInterfaceId(v string) *CreateBgpPeerInput {
	s.VirtualInterfaceId = &v
	return s
}

type CreateBgpPeerOutput struct {
	_ struct{} `type:"structure"`

	Metadata *response.ResponseMetadata

	BgpPeerId *string `type:"string"`

	RequestId *string `type:"string"`
}

// String returns the string representation
func (s CreateBgpPeerOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateBgpPeerOutput) GoString() string {
	return s.String()
}

// SetBgpPeerId sets the BgpPeerId field's value.
func (s *CreateBgpPeerOutput) SetBgpPeerId(v string) *CreateBgpPeerOutput {
	s.BgpPeerId = &v
	return s
}

// SetRequestId sets the RequestId field's value.
func (s *CreateBgpPeerOutput) SetRequestId(v string) *CreateBgpPeerOutput {
	s.RequestId = &v
	return s
}
