// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package dcdn

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListDomainConfigCommon = "ListDomainConfig"

// ListDomainConfigCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListDomainConfigCommon operation. The "output" return
// value will be populated with the ListDomainConfigCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListDomainConfigCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListDomainConfigCommon Send returns without error.
//
// See ListDomainConfigCommon for more information on using the ListDomainConfigCommon
// API call, and error handling.
//
//    // Example sending a request using the ListDomainConfigCommonRequest method.
//    req, resp := client.ListDomainConfigCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *DCDN) ListDomainConfigCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListDomainConfigCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListDomainConfigCommon API operation for DCDN.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for DCDN's
// API operation ListDomainConfigCommon for usage and error information.
func (c *DCDN) ListDomainConfigCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListDomainConfigCommonRequest(input)
	return out, req.Send()
}

// ListDomainConfigCommonWithContext is the same as ListDomainConfigCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListDomainConfigCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DCDN) ListDomainConfigCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListDomainConfigCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDomainConfig = "ListDomainConfig"

// ListDomainConfigRequest generates a "volcengine/request.Request" representing the
// client's request for the ListDomainConfig operation. The "output" return
// value will be populated with the ListDomainConfigCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListDomainConfigCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListDomainConfigCommon Send returns without error.
//
// See ListDomainConfig for more information on using the ListDomainConfig
// API call, and error handling.
//
//    // Example sending a request using the ListDomainConfigRequest method.
//    req, resp := client.ListDomainConfigRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *DCDN) ListDomainConfigRequest(input *ListDomainConfigInput) (req *request.Request, output *ListDomainConfigOutput) {
	op := &request.Operation{
		Name:       opListDomainConfig,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListDomainConfigInput{}
	}

	output = &ListDomainConfigOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListDomainConfig API operation for DCDN.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for DCDN's
// API operation ListDomainConfig for usage and error information.
func (c *DCDN) ListDomainConfig(input *ListDomainConfigInput) (*ListDomainConfigOutput, error) {
	req, out := c.ListDomainConfigRequest(input)
	return out, req.Send()
}

// ListDomainConfigWithContext is the same as ListDomainConfig with the addition of
// the ability to pass a context and additional request options.
//
// See ListDomainConfig for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *DCDN) ListDomainConfigWithContext(ctx volcengine.Context, input *ListDomainConfigInput, opts ...request.Option) (*ListDomainConfigOutput, error) {
	req, out := c.ListDomainConfigRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type BackupOriginForListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Port *int32 `type:"int32" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`

	Weight *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s BackupOriginForListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BackupOriginForListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *BackupOriginForListDomainConfigOutput) SetName(v string) *BackupOriginForListDomainConfigOutput {
	s.Name = &v
	return s
}

// SetPort sets the Port field's value.
func (s *BackupOriginForListDomainConfigOutput) SetPort(v int32) *BackupOriginForListDomainConfigOutput {
	s.Port = &v
	return s
}

// SetType sets the Type field's value.
func (s *BackupOriginForListDomainConfigOutput) SetType(v string) *BackupOriginForListDomainConfigOutput {
	s.Type = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *BackupOriginForListDomainConfigOutput) SetWeight(v int32) *BackupOriginForListDomainConfigOutput {
	s.Weight = &v
	return s
}

type BrCompressForListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s BrCompressForListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s BrCompressForListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *BrCompressForListDomainConfigOutput) SetEnable(v bool) *BrCompressForListDomainConfigOutput {
	s.Enable = &v
	return s
}

type CacheForListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AdaptCache *bool `type:"boolean" json:",omitempty"`

	CacheKeyRules []*CacheKeyRuleForListDomainConfigOutput `type:"list" json:",omitempty"`

	CacheRules []*CacheRuleForListDomainConfigOutput `type:"list" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	StatusCodeCacheRule *StatusCodeCacheRuleForListDomainConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s CacheForListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheForListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetAdaptCache sets the AdaptCache field's value.
func (s *CacheForListDomainConfigOutput) SetAdaptCache(v bool) *CacheForListDomainConfigOutput {
	s.AdaptCache = &v
	return s
}

// SetCacheKeyRules sets the CacheKeyRules field's value.
func (s *CacheForListDomainConfigOutput) SetCacheKeyRules(v []*CacheKeyRuleForListDomainConfigOutput) *CacheForListDomainConfigOutput {
	s.CacheKeyRules = v
	return s
}

// SetCacheRules sets the CacheRules field's value.
func (s *CacheForListDomainConfigOutput) SetCacheRules(v []*CacheRuleForListDomainConfigOutput) *CacheForListDomainConfigOutput {
	s.CacheRules = v
	return s
}

// SetEnable sets the Enable field's value.
func (s *CacheForListDomainConfigOutput) SetEnable(v bool) *CacheForListDomainConfigOutput {
	s.Enable = &v
	return s
}

// SetStatusCodeCacheRule sets the StatusCodeCacheRule field's value.
func (s *CacheForListDomainConfigOutput) SetStatusCodeCacheRule(v *StatusCodeCacheRuleForListDomainConfigOutput) *CacheForListDomainConfigOutput {
	s.StatusCodeCacheRule = v
	return s
}

type CacheKeyRuleForListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Contents *string `type:"string" json:",omitempty"`

	IgnoreCase *bool `type:"boolean" json:",omitempty"`

	ParamsFilterType *string `type:"string" json:",omitempty"`

	ParamsReserveList *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CacheKeyRuleForListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheKeyRuleForListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetContents sets the Contents field's value.
func (s *CacheKeyRuleForListDomainConfigOutput) SetContents(v string) *CacheKeyRuleForListDomainConfigOutput {
	s.Contents = &v
	return s
}

// SetIgnoreCase sets the IgnoreCase field's value.
func (s *CacheKeyRuleForListDomainConfigOutput) SetIgnoreCase(v bool) *CacheKeyRuleForListDomainConfigOutput {
	s.IgnoreCase = &v
	return s
}

// SetParamsFilterType sets the ParamsFilterType field's value.
func (s *CacheKeyRuleForListDomainConfigOutput) SetParamsFilterType(v string) *CacheKeyRuleForListDomainConfigOutput {
	s.ParamsFilterType = &v
	return s
}

// SetParamsReserveList sets the ParamsReserveList field's value.
func (s *CacheKeyRuleForListDomainConfigOutput) SetParamsReserveList(v string) *CacheKeyRuleForListDomainConfigOutput {
	s.ParamsReserveList = &v
	return s
}

// SetType sets the Type field's value.
func (s *CacheKeyRuleForListDomainConfigOutput) SetType(v string) *CacheKeyRuleForListDomainConfigOutput {
	s.Type = &v
	return s
}

type CacheRuleForListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CacheTime *int32 `type:"int32" json:",omitempty"`

	CacheTimeUnit *string `type:"string" json:",omitempty"`

	Contents *string `type:"string" json:",omitempty"`

	IgnoreCase *bool `type:"boolean" json:",omitempty"`

	ParamsFilterType *string `type:"string" json:",omitempty"`

	ParamsReserveList *string `type:"string" json:",omitempty"`

	Policy *string `type:"string" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CacheRuleForListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CacheRuleForListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetCacheTime sets the CacheTime field's value.
func (s *CacheRuleForListDomainConfigOutput) SetCacheTime(v int32) *CacheRuleForListDomainConfigOutput {
	s.CacheTime = &v
	return s
}

// SetCacheTimeUnit sets the CacheTimeUnit field's value.
func (s *CacheRuleForListDomainConfigOutput) SetCacheTimeUnit(v string) *CacheRuleForListDomainConfigOutput {
	s.CacheTimeUnit = &v
	return s
}

// SetContents sets the Contents field's value.
func (s *CacheRuleForListDomainConfigOutput) SetContents(v string) *CacheRuleForListDomainConfigOutput {
	s.Contents = &v
	return s
}

// SetIgnoreCase sets the IgnoreCase field's value.
func (s *CacheRuleForListDomainConfigOutput) SetIgnoreCase(v bool) *CacheRuleForListDomainConfigOutput {
	s.IgnoreCase = &v
	return s
}

// SetParamsFilterType sets the ParamsFilterType field's value.
func (s *CacheRuleForListDomainConfigOutput) SetParamsFilterType(v string) *CacheRuleForListDomainConfigOutput {
	s.ParamsFilterType = &v
	return s
}

// SetParamsReserveList sets the ParamsReserveList field's value.
func (s *CacheRuleForListDomainConfigOutput) SetParamsReserveList(v string) *CacheRuleForListDomainConfigOutput {
	s.ParamsReserveList = &v
	return s
}

// SetPolicy sets the Policy field's value.
func (s *CacheRuleForListDomainConfigOutput) SetPolicy(v string) *CacheRuleForListDomainConfigOutput {
	s.Policy = &v
	return s
}

// SetType sets the Type field's value.
func (s *CacheRuleForListDomainConfigOutput) SetType(v string) *CacheRuleForListDomainConfigOutput {
	s.Type = &v
	return s
}

type CertBindForListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CertId *string `type:"string" json:",omitempty"`

	CertName *string `type:"string" json:",omitempty"`

	CertSource *string `type:"string" json:",omitempty"`

	Expire *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CertBindForListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CertBindForListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetCertId sets the CertId field's value.
func (s *CertBindForListDomainConfigOutput) SetCertId(v string) *CertBindForListDomainConfigOutput {
	s.CertId = &v
	return s
}

// SetCertName sets the CertName field's value.
func (s *CertBindForListDomainConfigOutput) SetCertName(v string) *CertBindForListDomainConfigOutput {
	s.CertName = &v
	return s
}

// SetCertSource sets the CertSource field's value.
func (s *CertBindForListDomainConfigOutput) SetCertSource(v string) *CertBindForListDomainConfigOutput {
	s.CertSource = &v
	return s
}

// SetExpire sets the Expire field's value.
func (s *CertBindForListDomainConfigOutput) SetExpire(v string) *CertBindForListDomainConfigOutput {
	s.Expire = &v
	return s
}

type ConditionalOriginForListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BackupOrigins []*BackupOriginForListDomainConfigOutput `type:"list" json:",omitempty"`

	MatchingRuleGroupJSON *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Origins []*BackupOriginForListDomainConfigOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ConditionalOriginForListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConditionalOriginForListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetBackupOrigins sets the BackupOrigins field's value.
func (s *ConditionalOriginForListDomainConfigOutput) SetBackupOrigins(v []*BackupOriginForListDomainConfigOutput) *ConditionalOriginForListDomainConfigOutput {
	s.BackupOrigins = v
	return s
}

// SetMatchingRuleGroupJSON sets the MatchingRuleGroupJSON field's value.
func (s *ConditionalOriginForListDomainConfigOutput) SetMatchingRuleGroupJSON(v string) *ConditionalOriginForListDomainConfigOutput {
	s.MatchingRuleGroupJSON = &v
	return s
}

// SetName sets the Name field's value.
func (s *ConditionalOriginForListDomainConfigOutput) SetName(v string) *ConditionalOriginForListDomainConfigOutput {
	s.Name = &v
	return s
}

// SetOrigins sets the Origins field's value.
func (s *ConditionalOriginForListDomainConfigOutput) SetOrigins(v []*BackupOriginForListDomainConfigOutput) *ConditionalOriginForListDomainConfigOutput {
	s.Origins = v
	return s
}

type ConvertConvertOriginForListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BackupOriginType *string `type:"string" json:",omitempty"`

	BackupOrigins []*BackupOriginForListDomainConfigOutput `type:"list" json:",omitempty"`

	ConditionalOrigins []*ConditionalOriginForListDomainConfigOutput `type:"list" json:",omitempty"`

	FollowRedirect *FollowRedirectForListDomainConfigOutput `type:"structure" json:",omitempty"`

	OriginHost *OriginHostForListDomainConfigOutput `type:"structure" json:",omitempty"`

	OriginProtocolType *string `type:"string" json:",omitempty"`

	OriginRange *OriginRangeForListDomainConfigOutput `type:"structure" json:",omitempty"`

	OriginSni *OriginSniForListDomainConfigOutput `type:"structure" json:",omitempty"`

	OriginType *string `type:"string" json:",omitempty"`

	Origins []*ConvertOriginForListDomainConfigOutput `type:"list" json:",omitempty"`

	RequestHeader *RequestHeaderForListDomainConfigOutput `type:"structure" json:",omitempty"`

	ResponseHeader *ResponseHeaderForListDomainConfigOutput `type:"structure" json:",omitempty"`

	ResponseTimeout *int32 `type:"int32" json:",omitempty"`

	TosPrivateAccess *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s ConvertConvertOriginForListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertConvertOriginForListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetBackupOriginType sets the BackupOriginType field's value.
func (s *ConvertConvertOriginForListDomainConfigOutput) SetBackupOriginType(v string) *ConvertConvertOriginForListDomainConfigOutput {
	s.BackupOriginType = &v
	return s
}

// SetBackupOrigins sets the BackupOrigins field's value.
func (s *ConvertConvertOriginForListDomainConfigOutput) SetBackupOrigins(v []*BackupOriginForListDomainConfigOutput) *ConvertConvertOriginForListDomainConfigOutput {
	s.BackupOrigins = v
	return s
}

// SetConditionalOrigins sets the ConditionalOrigins field's value.
func (s *ConvertConvertOriginForListDomainConfigOutput) SetConditionalOrigins(v []*ConditionalOriginForListDomainConfigOutput) *ConvertConvertOriginForListDomainConfigOutput {
	s.ConditionalOrigins = v
	return s
}

// SetFollowRedirect sets the FollowRedirect field's value.
func (s *ConvertConvertOriginForListDomainConfigOutput) SetFollowRedirect(v *FollowRedirectForListDomainConfigOutput) *ConvertConvertOriginForListDomainConfigOutput {
	s.FollowRedirect = v
	return s
}

// SetOriginHost sets the OriginHost field's value.
func (s *ConvertConvertOriginForListDomainConfigOutput) SetOriginHost(v *OriginHostForListDomainConfigOutput) *ConvertConvertOriginForListDomainConfigOutput {
	s.OriginHost = v
	return s
}

// SetOriginProtocolType sets the OriginProtocolType field's value.
func (s *ConvertConvertOriginForListDomainConfigOutput) SetOriginProtocolType(v string) *ConvertConvertOriginForListDomainConfigOutput {
	s.OriginProtocolType = &v
	return s
}

// SetOriginRange sets the OriginRange field's value.
func (s *ConvertConvertOriginForListDomainConfigOutput) SetOriginRange(v *OriginRangeForListDomainConfigOutput) *ConvertConvertOriginForListDomainConfigOutput {
	s.OriginRange = v
	return s
}

// SetOriginSni sets the OriginSni field's value.
func (s *ConvertConvertOriginForListDomainConfigOutput) SetOriginSni(v *OriginSniForListDomainConfigOutput) *ConvertConvertOriginForListDomainConfigOutput {
	s.OriginSni = v
	return s
}

// SetOriginType sets the OriginType field's value.
func (s *ConvertConvertOriginForListDomainConfigOutput) SetOriginType(v string) *ConvertConvertOriginForListDomainConfigOutput {
	s.OriginType = &v
	return s
}

// SetOrigins sets the Origins field's value.
func (s *ConvertConvertOriginForListDomainConfigOutput) SetOrigins(v []*ConvertOriginForListDomainConfigOutput) *ConvertConvertOriginForListDomainConfigOutput {
	s.Origins = v
	return s
}

// SetRequestHeader sets the RequestHeader field's value.
func (s *ConvertConvertOriginForListDomainConfigOutput) SetRequestHeader(v *RequestHeaderForListDomainConfigOutput) *ConvertConvertOriginForListDomainConfigOutput {
	s.RequestHeader = v
	return s
}

// SetResponseHeader sets the ResponseHeader field's value.
func (s *ConvertConvertOriginForListDomainConfigOutput) SetResponseHeader(v *ResponseHeaderForListDomainConfigOutput) *ConvertConvertOriginForListDomainConfigOutput {
	s.ResponseHeader = v
	return s
}

// SetResponseTimeout sets the ResponseTimeout field's value.
func (s *ConvertConvertOriginForListDomainConfigOutput) SetResponseTimeout(v int32) *ConvertConvertOriginForListDomainConfigOutput {
	s.ResponseTimeout = &v
	return s
}

// SetTosPrivateAccess sets the TosPrivateAccess field's value.
func (s *ConvertConvertOriginForListDomainConfigOutput) SetTosPrivateAccess(v bool) *ConvertConvertOriginForListDomainConfigOutput {
	s.TosPrivateAccess = &v
	return s
}

type ConvertOriginForListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	Port *int32 `type:"int32" json:",omitempty"`

	Type *string `type:"string" json:",omitempty"`

	Weight *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ConvertOriginForListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertOriginForListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetName sets the Name field's value.
func (s *ConvertOriginForListDomainConfigOutput) SetName(v string) *ConvertOriginForListDomainConfigOutput {
	s.Name = &v
	return s
}

// SetPort sets the Port field's value.
func (s *ConvertOriginForListDomainConfigOutput) SetPort(v int32) *ConvertOriginForListDomainConfigOutput {
	s.Port = &v
	return s
}

// SetType sets the Type field's value.
func (s *ConvertOriginForListDomainConfigOutput) SetType(v string) *ConvertOriginForListDomainConfigOutput {
	s.Type = &v
	return s
}

// SetWeight sets the Weight field's value.
func (s *ConvertOriginForListDomainConfigOutput) SetWeight(v int32) *ConvertOriginForListDomainConfigOutput {
	s.Weight = &v
	return s
}

type ConvertRuleForListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Match *string `type:"string" json:",omitempty"`

	Replacement *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ConvertRuleForListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ConvertRuleForListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetMatch sets the Match field's value.
func (s *ConvertRuleForListDomainConfigOutput) SetMatch(v string) *ConvertRuleForListDomainConfigOutput {
	s.Match = &v
	return s
}

// SetReplacement sets the Replacement field's value.
func (s *ConvertRuleForListDomainConfigOutput) SetReplacement(v string) *ConvertRuleForListDomainConfigOutput {
	s.Replacement = &v
	return s
}

type DomainListForListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BrCompress *BrCompressForListDomainConfigOutput `type:"structure" json:",omitempty"`

	Cache *CacheForListDomainConfigOutput `type:"structure" json:",omitempty"`

	Cname *string `type:"string" json:",omitempty"`

	CreateTime *string `type:"string" json:",omitempty"`

	Domain *string `type:"string" json:",omitempty"`

	EnableFailOver *bool `type:"boolean" json:",omitempty"`

	GzipCompress *GzipCompressForListDomainConfigOutput `type:"structure" json:",omitempty"`

	Https *HttpsForListDomainConfigOutput `type:"structure" json:",omitempty"`

	IPv6Switch *bool `type:"boolean" json:",omitempty"`

	IpAccess *IpAccessForListDomainConfigOutput `type:"structure" json:",omitempty"`

	IsCNAMEResolved *bool `type:"boolean" json:",omitempty"`

	Origin *ConvertConvertOriginForListDomainConfigOutput `type:"structure" json:",omitempty"`

	PreConnect *PreConnectForListDomainConfigOutput `type:"structure" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`

	RTTOptimize *RTTOptimizeForListDomainConfigOutput `type:"structure" json:",omitempty"`

	RecordFiling *string `type:"string" json:",omitempty"`

	RefererAccess *RefererAccessForListDomainConfigOutput `type:"structure" json:",omitempty"`

	ResourceTags []*ResourceTagForListDomainConfigOutput `type:"list" json:",omitempty"`

	Scope *string `type:"string" json:",omitempty"`

	ServiceType *string `type:"string" json:",omitempty"`

	StaticOptimization *StaticOptimizationForListDomainConfigOutput `type:"structure" json:",omitempty"`

	Status *string `type:"string" json:",omitempty"`

	StrategyType *string `type:"string" json:",omitempty"`

	UpdateTime *string `type:"string" json:",omitempty"`

	UploadOptimize *UploadOptimizeForListDomainConfigOutput `type:"structure" json:",omitempty"`

	UrlAccess *UrlAccessForListDomainConfigOutput `type:"structure" json:",omitempty"`

	UrlRedirect *UrlRedirectForListDomainConfigOutput `type:"structure" json:",omitempty"`

	UserAgentAccess *UserAgentAccessForListDomainConfigOutput `type:"structure" json:",omitempty"`

	UserName *string `type:"string" json:",omitempty"`

	WebSocket *WebSocketForListDomainConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s DomainListForListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DomainListForListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetBrCompress sets the BrCompress field's value.
func (s *DomainListForListDomainConfigOutput) SetBrCompress(v *BrCompressForListDomainConfigOutput) *DomainListForListDomainConfigOutput {
	s.BrCompress = v
	return s
}

// SetCache sets the Cache field's value.
func (s *DomainListForListDomainConfigOutput) SetCache(v *CacheForListDomainConfigOutput) *DomainListForListDomainConfigOutput {
	s.Cache = v
	return s
}

// SetCname sets the Cname field's value.
func (s *DomainListForListDomainConfigOutput) SetCname(v string) *DomainListForListDomainConfigOutput {
	s.Cname = &v
	return s
}

// SetCreateTime sets the CreateTime field's value.
func (s *DomainListForListDomainConfigOutput) SetCreateTime(v string) *DomainListForListDomainConfigOutput {
	s.CreateTime = &v
	return s
}

// SetDomain sets the Domain field's value.
func (s *DomainListForListDomainConfigOutput) SetDomain(v string) *DomainListForListDomainConfigOutput {
	s.Domain = &v
	return s
}

// SetEnableFailOver sets the EnableFailOver field's value.
func (s *DomainListForListDomainConfigOutput) SetEnableFailOver(v bool) *DomainListForListDomainConfigOutput {
	s.EnableFailOver = &v
	return s
}

// SetGzipCompress sets the GzipCompress field's value.
func (s *DomainListForListDomainConfigOutput) SetGzipCompress(v *GzipCompressForListDomainConfigOutput) *DomainListForListDomainConfigOutput {
	s.GzipCompress = v
	return s
}

// SetHttps sets the Https field's value.
func (s *DomainListForListDomainConfigOutput) SetHttps(v *HttpsForListDomainConfigOutput) *DomainListForListDomainConfigOutput {
	s.Https = v
	return s
}

// SetIPv6Switch sets the IPv6Switch field's value.
func (s *DomainListForListDomainConfigOutput) SetIPv6Switch(v bool) *DomainListForListDomainConfigOutput {
	s.IPv6Switch = &v
	return s
}

// SetIpAccess sets the IpAccess field's value.
func (s *DomainListForListDomainConfigOutput) SetIpAccess(v *IpAccessForListDomainConfigOutput) *DomainListForListDomainConfigOutput {
	s.IpAccess = v
	return s
}

// SetIsCNAMEResolved sets the IsCNAMEResolved field's value.
func (s *DomainListForListDomainConfigOutput) SetIsCNAMEResolved(v bool) *DomainListForListDomainConfigOutput {
	s.IsCNAMEResolved = &v
	return s
}

// SetOrigin sets the Origin field's value.
func (s *DomainListForListDomainConfigOutput) SetOrigin(v *ConvertConvertOriginForListDomainConfigOutput) *DomainListForListDomainConfigOutput {
	s.Origin = v
	return s
}

// SetPreConnect sets the PreConnect field's value.
func (s *DomainListForListDomainConfigOutput) SetPreConnect(v *PreConnectForListDomainConfigOutput) *DomainListForListDomainConfigOutput {
	s.PreConnect = v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *DomainListForListDomainConfigOutput) SetProjectName(v string) *DomainListForListDomainConfigOutput {
	s.ProjectName = &v
	return s
}

// SetRTTOptimize sets the RTTOptimize field's value.
func (s *DomainListForListDomainConfigOutput) SetRTTOptimize(v *RTTOptimizeForListDomainConfigOutput) *DomainListForListDomainConfigOutput {
	s.RTTOptimize = v
	return s
}

// SetRecordFiling sets the RecordFiling field's value.
func (s *DomainListForListDomainConfigOutput) SetRecordFiling(v string) *DomainListForListDomainConfigOutput {
	s.RecordFiling = &v
	return s
}

// SetRefererAccess sets the RefererAccess field's value.
func (s *DomainListForListDomainConfigOutput) SetRefererAccess(v *RefererAccessForListDomainConfigOutput) *DomainListForListDomainConfigOutput {
	s.RefererAccess = v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *DomainListForListDomainConfigOutput) SetResourceTags(v []*ResourceTagForListDomainConfigOutput) *DomainListForListDomainConfigOutput {
	s.ResourceTags = v
	return s
}

// SetScope sets the Scope field's value.
func (s *DomainListForListDomainConfigOutput) SetScope(v string) *DomainListForListDomainConfigOutput {
	s.Scope = &v
	return s
}

// SetServiceType sets the ServiceType field's value.
func (s *DomainListForListDomainConfigOutput) SetServiceType(v string) *DomainListForListDomainConfigOutput {
	s.ServiceType = &v
	return s
}

// SetStaticOptimization sets the StaticOptimization field's value.
func (s *DomainListForListDomainConfigOutput) SetStaticOptimization(v *StaticOptimizationForListDomainConfigOutput) *DomainListForListDomainConfigOutput {
	s.StaticOptimization = v
	return s
}

// SetStatus sets the Status field's value.
func (s *DomainListForListDomainConfigOutput) SetStatus(v string) *DomainListForListDomainConfigOutput {
	s.Status = &v
	return s
}

// SetStrategyType sets the StrategyType field's value.
func (s *DomainListForListDomainConfigOutput) SetStrategyType(v string) *DomainListForListDomainConfigOutput {
	s.StrategyType = &v
	return s
}

// SetUpdateTime sets the UpdateTime field's value.
func (s *DomainListForListDomainConfigOutput) SetUpdateTime(v string) *DomainListForListDomainConfigOutput {
	s.UpdateTime = &v
	return s
}

// SetUploadOptimize sets the UploadOptimize field's value.
func (s *DomainListForListDomainConfigOutput) SetUploadOptimize(v *UploadOptimizeForListDomainConfigOutput) *DomainListForListDomainConfigOutput {
	s.UploadOptimize = v
	return s
}

// SetUrlAccess sets the UrlAccess field's value.
func (s *DomainListForListDomainConfigOutput) SetUrlAccess(v *UrlAccessForListDomainConfigOutput) *DomainListForListDomainConfigOutput {
	s.UrlAccess = v
	return s
}

// SetUrlRedirect sets the UrlRedirect field's value.
func (s *DomainListForListDomainConfigOutput) SetUrlRedirect(v *UrlRedirectForListDomainConfigOutput) *DomainListForListDomainConfigOutput {
	s.UrlRedirect = v
	return s
}

// SetUserAgentAccess sets the UserAgentAccess field's value.
func (s *DomainListForListDomainConfigOutput) SetUserAgentAccess(v *UserAgentAccessForListDomainConfigOutput) *DomainListForListDomainConfigOutput {
	s.UserAgentAccess = v
	return s
}

// SetUserName sets the UserName field's value.
func (s *DomainListForListDomainConfigOutput) SetUserName(v string) *DomainListForListDomainConfigOutput {
	s.UserName = &v
	return s
}

// SetWebSocket sets the WebSocket field's value.
func (s *DomainListForListDomainConfigOutput) SetWebSocket(v *WebSocketForListDomainConfigOutput) *DomainListForListDomainConfigOutput {
	s.WebSocket = v
	return s
}

type FollowRedirectForListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	MaxTries *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s FollowRedirectForListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s FollowRedirectForListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *FollowRedirectForListDomainConfigOutput) SetEnable(v bool) *FollowRedirectForListDomainConfigOutput {
	s.Enable = &v
	return s
}

// SetMaxTries sets the MaxTries field's value.
func (s *FollowRedirectForListDomainConfigOutput) SetMaxTries(v int32) *FollowRedirectForListDomainConfigOutput {
	s.MaxTries = &v
	return s
}

type ForceRedirectForListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	RedirectCode *int32 `type:"int32" json:",omitempty"`

	RedirectType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ForceRedirectForListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ForceRedirectForListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *ForceRedirectForListDomainConfigOutput) SetEnable(v bool) *ForceRedirectForListDomainConfigOutput {
	s.Enable = &v
	return s
}

// SetRedirectCode sets the RedirectCode field's value.
func (s *ForceRedirectForListDomainConfigOutput) SetRedirectCode(v int32) *ForceRedirectForListDomainConfigOutput {
	s.RedirectCode = &v
	return s
}

// SetRedirectType sets the RedirectType field's value.
func (s *ForceRedirectForListDomainConfigOutput) SetRedirectType(v string) *ForceRedirectForListDomainConfigOutput {
	s.RedirectType = &v
	return s
}

type GzipCompressForListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s GzipCompressForListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GzipCompressForListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *GzipCompressForListDomainConfigOutput) SetEnable(v bool) *GzipCompressForListDomainConfigOutput {
	s.Enable = &v
	return s
}

type HeaderInfoForListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	HeaderMode *int32 `type:"int32" json:",omitempty"`

	HeaderName *string `type:"string" json:",omitempty"`

	HeaderValue *string `type:"string" json:",omitempty"`

	HeaderValueType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s HeaderInfoForListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HeaderInfoForListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetHeaderMode sets the HeaderMode field's value.
func (s *HeaderInfoForListDomainConfigOutput) SetHeaderMode(v int32) *HeaderInfoForListDomainConfigOutput {
	s.HeaderMode = &v
	return s
}

// SetHeaderName sets the HeaderName field's value.
func (s *HeaderInfoForListDomainConfigOutput) SetHeaderName(v string) *HeaderInfoForListDomainConfigOutput {
	s.HeaderName = &v
	return s
}

// SetHeaderValue sets the HeaderValue field's value.
func (s *HeaderInfoForListDomainConfigOutput) SetHeaderValue(v string) *HeaderInfoForListDomainConfigOutput {
	s.HeaderValue = &v
	return s
}

// SetHeaderValueType sets the HeaderValueType field's value.
func (s *HeaderInfoForListDomainConfigOutput) SetHeaderValueType(v string) *HeaderInfoForListDomainConfigOutput {
	s.HeaderValueType = &v
	return s
}

type HstsForListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	IncludeSubDomain *bool `type:"boolean" json:",omitempty"`

	MaxAge *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s HstsForListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HstsForListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *HstsForListDomainConfigOutput) SetEnable(v bool) *HstsForListDomainConfigOutput {
	s.Enable = &v
	return s
}

// SetIncludeSubDomain sets the IncludeSubDomain field's value.
func (s *HstsForListDomainConfigOutput) SetIncludeSubDomain(v bool) *HstsForListDomainConfigOutput {
	s.IncludeSubDomain = &v
	return s
}

// SetMaxAge sets the MaxAge field's value.
func (s *HstsForListDomainConfigOutput) SetMaxAge(v int32) *HstsForListDomainConfigOutput {
	s.MaxAge = &v
	return s
}

type HttpsForListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CertBind *CertBindForListDomainConfigOutput `type:"structure" json:",omitempty"`

	EnableHttps *bool `type:"boolean" json:",omitempty"`

	ForceRedirect *ForceRedirectForListDomainConfigOutput `type:"structure" json:",omitempty"`

	Hsts *HstsForListDomainConfigOutput `type:"structure" json:",omitempty"`

	Http2 *bool `type:"boolean" json:",omitempty"`

	OCSPStapling *bool `type:"boolean" json:",omitempty"`

	QUICSwitch *bool `type:"boolean" json:",omitempty"`

	TlsVersions *TlsVersionsForListDomainConfigOutput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s HttpsForListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HttpsForListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetCertBind sets the CertBind field's value.
func (s *HttpsForListDomainConfigOutput) SetCertBind(v *CertBindForListDomainConfigOutput) *HttpsForListDomainConfigOutput {
	s.CertBind = v
	return s
}

// SetEnableHttps sets the EnableHttps field's value.
func (s *HttpsForListDomainConfigOutput) SetEnableHttps(v bool) *HttpsForListDomainConfigOutput {
	s.EnableHttps = &v
	return s
}

// SetForceRedirect sets the ForceRedirect field's value.
func (s *HttpsForListDomainConfigOutput) SetForceRedirect(v *ForceRedirectForListDomainConfigOutput) *HttpsForListDomainConfigOutput {
	s.ForceRedirect = v
	return s
}

// SetHsts sets the Hsts field's value.
func (s *HttpsForListDomainConfigOutput) SetHsts(v *HstsForListDomainConfigOutput) *HttpsForListDomainConfigOutput {
	s.Hsts = v
	return s
}

// SetHttp2 sets the Http2 field's value.
func (s *HttpsForListDomainConfigOutput) SetHttp2(v bool) *HttpsForListDomainConfigOutput {
	s.Http2 = &v
	return s
}

// SetOCSPStapling sets the OCSPStapling field's value.
func (s *HttpsForListDomainConfigOutput) SetOCSPStapling(v bool) *HttpsForListDomainConfigOutput {
	s.OCSPStapling = &v
	return s
}

// SetQUICSwitch sets the QUICSwitch field's value.
func (s *HttpsForListDomainConfigOutput) SetQUICSwitch(v bool) *HttpsForListDomainConfigOutput {
	s.QUICSwitch = &v
	return s
}

// SetTlsVersions sets the TlsVersions field's value.
func (s *HttpsForListDomainConfigOutput) SetTlsVersions(v *TlsVersionsForListDomainConfigOutput) *HttpsForListDomainConfigOutput {
	s.TlsVersions = v
	return s
}

type IpAccessForListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	FilterList []*string `type:"list" json:",omitempty"`

	FilterType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s IpAccessForListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s IpAccessForListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *IpAccessForListDomainConfigOutput) SetEnable(v bool) *IpAccessForListDomainConfigOutput {
	s.Enable = &v
	return s
}

// SetFilterList sets the FilterList field's value.
func (s *IpAccessForListDomainConfigOutput) SetFilterList(v []*string) *IpAccessForListDomainConfigOutput {
	s.FilterList = v
	return s
}

// SetFilterType sets the FilterType field's value.
func (s *IpAccessForListDomainConfigOutput) SetFilterType(v string) *IpAccessForListDomainConfigOutput {
	s.FilterType = &v
	return s
}

type ListDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	HTTPs *bool `type:"boolean" json:",omitempty"`

	Keyword *string `type:"string" json:",omitempty"`

	OriginType []*string `type:"list" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	ProjectName []*string `type:"list" json:",omitempty"`

	ResourceTagFilter *ResourceTagFilterForListDomainConfigInput `type:"structure" json:",omitempty"`

	Scope []*string `type:"list" json:",omitempty"`

	Status []*string `type:"list" json:",omitempty"`

	TimeSortOrder *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ListDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainConfigInput) GoString() string {
	return s.String()
}

// SetHTTPs sets the HTTPs field's value.
func (s *ListDomainConfigInput) SetHTTPs(v bool) *ListDomainConfigInput {
	s.HTTPs = &v
	return s
}

// SetKeyword sets the Keyword field's value.
func (s *ListDomainConfigInput) SetKeyword(v string) *ListDomainConfigInput {
	s.Keyword = &v
	return s
}

// SetOriginType sets the OriginType field's value.
func (s *ListDomainConfigInput) SetOriginType(v []*string) *ListDomainConfigInput {
	s.OriginType = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListDomainConfigInput) SetPageNumber(v int32) *ListDomainConfigInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListDomainConfigInput) SetPageSize(v int32) *ListDomainConfigInput {
	s.PageSize = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *ListDomainConfigInput) SetProjectName(v []*string) *ListDomainConfigInput {
	s.ProjectName = v
	return s
}

// SetResourceTagFilter sets the ResourceTagFilter field's value.
func (s *ListDomainConfigInput) SetResourceTagFilter(v *ResourceTagFilterForListDomainConfigInput) *ListDomainConfigInput {
	s.ResourceTagFilter = v
	return s
}

// SetScope sets the Scope field's value.
func (s *ListDomainConfigInput) SetScope(v []*string) *ListDomainConfigInput {
	s.Scope = v
	return s
}

// SetStatus sets the Status field's value.
func (s *ListDomainConfigInput) SetStatus(v []*string) *ListDomainConfigInput {
	s.Status = v
	return s
}

// SetTimeSortOrder sets the TimeSortOrder field's value.
func (s *ListDomainConfigInput) SetTimeSortOrder(v string) *ListDomainConfigInput {
	s.TimeSortOrder = &v
	return s
}

type ListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	DomainList []*DomainListForListDomainConfigOutput `type:"list" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	Total *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s ListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetDomainList sets the DomainList field's value.
func (s *ListDomainConfigOutput) SetDomainList(v []*DomainListForListDomainConfigOutput) *ListDomainConfigOutput {
	s.DomainList = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListDomainConfigOutput) SetPageNumber(v int32) *ListDomainConfigOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListDomainConfigOutput) SetPageSize(v int32) *ListDomainConfigOutput {
	s.PageSize = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *ListDomainConfigOutput) SetTotal(v int32) *ListDomainConfigOutput {
	s.Total = &v
	return s
}

type OriginHostForListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	HostInfo *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s OriginHostForListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginHostForListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *OriginHostForListDomainConfigOutput) SetEnable(v bool) *OriginHostForListDomainConfigOutput {
	s.Enable = &v
	return s
}

// SetHostInfo sets the HostInfo field's value.
func (s *OriginHostForListDomainConfigOutput) SetHostInfo(v string) *OriginHostForListDomainConfigOutput {
	s.HostInfo = &v
	return s
}

type OriginRangeForListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s OriginRangeForListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginRangeForListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *OriginRangeForListDomainConfigOutput) SetEnable(v bool) *OriginRangeForListDomainConfigOutput {
	s.Enable = &v
	return s
}

type OriginSniForListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	SniInfo *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s OriginSniForListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s OriginSniForListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *OriginSniForListDomainConfigOutput) SetEnable(v bool) *OriginSniForListDomainConfigOutput {
	s.Enable = &v
	return s
}

// SetSniInfo sets the SniInfo field's value.
func (s *OriginSniForListDomainConfigOutput) SetSniInfo(v string) *OriginSniForListDomainConfigOutput {
	s.SniInfo = &v
	return s
}

type PreConnectForListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s PreConnectForListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PreConnectForListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *PreConnectForListDomainConfigOutput) SetEnable(v bool) *PreConnectForListDomainConfigOutput {
	s.Enable = &v
	return s
}

type RTTOptimizeForListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s RTTOptimizeForListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RTTOptimizeForListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *RTTOptimizeForListDomainConfigOutput) SetEnable(v bool) *RTTOptimizeForListDomainConfigOutput {
	s.Enable = &v
	return s
}

type RefererAccessForListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	AllowNone *bool `type:"boolean" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	FilterList []*string `type:"list" json:",omitempty"`

	FilterType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s RefererAccessForListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RefererAccessForListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetAllowNone sets the AllowNone field's value.
func (s *RefererAccessForListDomainConfigOutput) SetAllowNone(v bool) *RefererAccessForListDomainConfigOutput {
	s.AllowNone = &v
	return s
}

// SetEnable sets the Enable field's value.
func (s *RefererAccessForListDomainConfigOutput) SetEnable(v bool) *RefererAccessForListDomainConfigOutput {
	s.Enable = &v
	return s
}

// SetFilterList sets the FilterList field's value.
func (s *RefererAccessForListDomainConfigOutput) SetFilterList(v []*string) *RefererAccessForListDomainConfigOutput {
	s.FilterList = v
	return s
}

// SetFilterType sets the FilterType field's value.
func (s *RefererAccessForListDomainConfigOutput) SetFilterType(v string) *RefererAccessForListDomainConfigOutput {
	s.FilterType = &v
	return s
}

type RequestHeaderForListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	HeaderInfo []*HeaderInfoForListDomainConfigOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s RequestHeaderForListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RequestHeaderForListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *RequestHeaderForListDomainConfigOutput) SetEnable(v bool) *RequestHeaderForListDomainConfigOutput {
	s.Enable = &v
	return s
}

// SetHeaderInfo sets the HeaderInfo field's value.
func (s *RequestHeaderForListDomainConfigOutput) SetHeaderInfo(v []*HeaderInfoForListDomainConfigOutput) *RequestHeaderForListDomainConfigOutput {
	s.HeaderInfo = v
	return s
}

type ResourceTagFilterForListDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	FilterType *string `type:"string" json:",omitempty"`

	ResourceTags []*ResourceTagForListDomainConfigInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ResourceTagFilterForListDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceTagFilterForListDomainConfigInput) GoString() string {
	return s.String()
}

// SetFilterType sets the FilterType field's value.
func (s *ResourceTagFilterForListDomainConfigInput) SetFilterType(v string) *ResourceTagFilterForListDomainConfigInput {
	s.FilterType = &v
	return s
}

// SetResourceTags sets the ResourceTags field's value.
func (s *ResourceTagFilterForListDomainConfigInput) SetResourceTags(v []*ResourceTagForListDomainConfigInput) *ResourceTagFilterForListDomainConfigInput {
	s.ResourceTags = v
	return s
}

type ResourceTagForListDomainConfigInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ResourceTagForListDomainConfigInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceTagForListDomainConfigInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *ResourceTagForListDomainConfigInput) SetKey(v string) *ResourceTagForListDomainConfigInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ResourceTagForListDomainConfigInput) SetValue(v string) *ResourceTagForListDomainConfigInput {
	s.Value = &v
	return s
}

type ResourceTagForListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ResourceTagForListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResourceTagForListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *ResourceTagForListDomainConfigOutput) SetKey(v string) *ResourceTagForListDomainConfigOutput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *ResourceTagForListDomainConfigOutput) SetValue(v string) *ResourceTagForListDomainConfigOutput {
	s.Value = &v
	return s
}

type ResponseHeaderForListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	HeaderInfo []*HeaderInfoForListDomainConfigOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s ResponseHeaderForListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ResponseHeaderForListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *ResponseHeaderForListDomainConfigOutput) SetEnable(v bool) *ResponseHeaderForListDomainConfigOutput {
	s.Enable = &v
	return s
}

// SetHeaderInfo sets the HeaderInfo field's value.
func (s *ResponseHeaderForListDomainConfigOutput) SetHeaderInfo(v []*HeaderInfoForListDomainConfigOutput) *ResponseHeaderForListDomainConfigOutput {
	s.HeaderInfo = v
	return s
}

type RuleForListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CacheTime *int32 `type:"int32" json:",omitempty"`

	CacheTimeUnit *string `type:"string" json:",omitempty"`

	RespUrl *string `type:"string" json:",omitempty"`

	Status *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s RuleForListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s RuleForListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetCacheTime sets the CacheTime field's value.
func (s *RuleForListDomainConfigOutput) SetCacheTime(v int32) *RuleForListDomainConfigOutput {
	s.CacheTime = &v
	return s
}

// SetCacheTimeUnit sets the CacheTimeUnit field's value.
func (s *RuleForListDomainConfigOutput) SetCacheTimeUnit(v string) *RuleForListDomainConfigOutput {
	s.CacheTimeUnit = &v
	return s
}

// SetRespUrl sets the RespUrl field's value.
func (s *RuleForListDomainConfigOutput) SetRespUrl(v string) *RuleForListDomainConfigOutput {
	s.RespUrl = &v
	return s
}

// SetStatus sets the Status field's value.
func (s *RuleForListDomainConfigOutput) SetStatus(v string) *RuleForListDomainConfigOutput {
	s.Status = &v
	return s
}

type StaticOptimizationForListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	H2Priority *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s StaticOptimizationForListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StaticOptimizationForListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetH2Priority sets the H2Priority field's value.
func (s *StaticOptimizationForListDomainConfigOutput) SetH2Priority(v bool) *StaticOptimizationForListDomainConfigOutput {
	s.H2Priority = &v
	return s
}

type StatusCodeCacheRuleForListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	Rules []*RuleForListDomainConfigOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s StatusCodeCacheRuleForListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StatusCodeCacheRuleForListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *StatusCodeCacheRuleForListDomainConfigOutput) SetEnable(v bool) *StatusCodeCacheRuleForListDomainConfigOutput {
	s.Enable = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *StatusCodeCacheRuleForListDomainConfigOutput) SetRules(v []*RuleForListDomainConfigOutput) *StatusCodeCacheRuleForListDomainConfigOutput {
	s.Rules = v
	return s
}

type TlsVersionsForListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	TlsVersion []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s TlsVersionsForListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TlsVersionsForListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *TlsVersionsForListDomainConfigOutput) SetEnable(v bool) *TlsVersionsForListDomainConfigOutput {
	s.Enable = &v
	return s
}

// SetTlsVersion sets the TlsVersion field's value.
func (s *TlsVersionsForListDomainConfigOutput) SetTlsVersion(v []*string) *TlsVersionsForListDomainConfigOutput {
	s.TlsVersion = v
	return s
}

type UploadOptimizeForListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`
}

// String returns the string representation
func (s UploadOptimizeForListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UploadOptimizeForListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *UploadOptimizeForListDomainConfigOutput) SetEnable(v bool) *UploadOptimizeForListDomainConfigOutput {
	s.Enable = &v
	return s
}

type UrlAccessForListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	GenKey *string `type:"string" json:",omitempty"`

	GenTTL *int32 `type:"int32" json:",omitempty"`

	GenType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s UrlAccessForListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UrlAccessForListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *UrlAccessForListDomainConfigOutput) SetEnable(v bool) *UrlAccessForListDomainConfigOutput {
	s.Enable = &v
	return s
}

// SetGenKey sets the GenKey field's value.
func (s *UrlAccessForListDomainConfigOutput) SetGenKey(v string) *UrlAccessForListDomainConfigOutput {
	s.GenKey = &v
	return s
}

// SetGenTTL sets the GenTTL field's value.
func (s *UrlAccessForListDomainConfigOutput) SetGenTTL(v int32) *UrlAccessForListDomainConfigOutput {
	s.GenTTL = &v
	return s
}

// SetGenType sets the GenType field's value.
func (s *UrlAccessForListDomainConfigOutput) SetGenType(v string) *UrlAccessForListDomainConfigOutput {
	s.GenType = &v
	return s
}

type UrlRedirectForListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	Rules []*ConvertRuleForListDomainConfigOutput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s UrlRedirectForListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UrlRedirectForListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *UrlRedirectForListDomainConfigOutput) SetEnable(v bool) *UrlRedirectForListDomainConfigOutput {
	s.Enable = &v
	return s
}

// SetRules sets the Rules field's value.
func (s *UrlRedirectForListDomainConfigOutput) SetRules(v []*ConvertRuleForListDomainConfigOutput) *UrlRedirectForListDomainConfigOutput {
	s.Rules = v
	return s
}

type UserAgentAccessForListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	FilterList []*string `type:"list" json:",omitempty"`

	FilterType *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s UserAgentAccessForListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UserAgentAccessForListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *UserAgentAccessForListDomainConfigOutput) SetEnable(v bool) *UserAgentAccessForListDomainConfigOutput {
	s.Enable = &v
	return s
}

// SetFilterList sets the FilterList field's value.
func (s *UserAgentAccessForListDomainConfigOutput) SetFilterList(v []*string) *UserAgentAccessForListDomainConfigOutput {
	s.FilterList = v
	return s
}

// SetFilterType sets the FilterType field's value.
func (s *UserAgentAccessForListDomainConfigOutput) SetFilterType(v string) *UserAgentAccessForListDomainConfigOutput {
	s.FilterType = &v
	return s
}

type WebSocketForListDomainConfigOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Enable *bool `type:"boolean" json:",omitempty"`

	Timeout *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s WebSocketForListDomainConfigOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s WebSocketForListDomainConfigOutput) GoString() string {
	return s.String()
}

// SetEnable sets the Enable field's value.
func (s *WebSocketForListDomainConfigOutput) SetEnable(v bool) *WebSocketForListDomainConfigOutput {
	s.Enable = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *WebSocketForListDomainConfigOutput) SetTimeout(v int32) *WebSocketForListDomainConfigOutput {
	s.Timeout = &v
	return s
}
