// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudidentity

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opUpdateGroupCommon = "UpdateGroup"

// UpdateGroupCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateGroupCommon operation. The "output" return
// value will be populated with the UpdateGroupCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateGroupCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdateGroupCommon Send returns without error.
//
// See UpdateGroupCommon for more information on using the UpdateGroupCommon
// API call, and error handling.
//
//    // Example sending a request using the UpdateGroupCommonRequest method.
//    req, resp := client.UpdateGroupCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLOUDIDENTITY) UpdateGroupCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opUpdateGroupCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdateGroupCommon API operation for CLOUDIDENTITY.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLOUDIDENTITY's
// API operation UpdateGroupCommon for usage and error information.
func (c *CLOUDIDENTITY) UpdateGroupCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.UpdateGroupCommonRequest(input)
	return out, req.Send()
}

// UpdateGroupCommonWithContext is the same as UpdateGroupCommon with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGroupCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLOUDIDENTITY) UpdateGroupCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.UpdateGroupCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateGroup = "UpdateGroup"

// UpdateGroupRequest generates a "volcengine/request.Request" representing the
// client's request for the UpdateGroup operation. The "output" return
// value will be populated with the UpdateGroupCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned UpdateGroupCommon Request to send the API call to the service.
// the "output" return value is not valid until after UpdateGroupCommon Send returns without error.
//
// See UpdateGroup for more information on using the UpdateGroup
// API call, and error handling.
//
//    // Example sending a request using the UpdateGroupRequest method.
//    req, resp := client.UpdateGroupRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLOUDIDENTITY) UpdateGroupRequest(input *UpdateGroupInput) (req *request.Request, output *UpdateGroupOutput) {
	op := &request.Operation{
		Name:       opUpdateGroup,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateGroupInput{}
	}

	output = &UpdateGroupOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// UpdateGroup API operation for CLOUDIDENTITY.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLOUDIDENTITY's
// API operation UpdateGroup for usage and error information.
func (c *CLOUDIDENTITY) UpdateGroup(input *UpdateGroupInput) (*UpdateGroupOutput, error) {
	req, out := c.UpdateGroupRequest(input)
	return out, req.Send()
}

// UpdateGroupWithContext is the same as UpdateGroup with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateGroup for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLOUDIDENTITY) UpdateGroupWithContext(ctx volcengine.Context, input *UpdateGroupInput, opts ...request.Option) (*UpdateGroupOutput, error) {
	req, out := c.UpdateGroupRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type UpdateGroupInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Description *string `max:"128" type:"string" json:",omitempty"`

	DisplayName *string `max:"64" type:"string" json:",omitempty"`

	// GroupId is a required field
	GroupId *string `type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s UpdateGroupInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGroupInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateGroupInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateGroupInput"}
	if s.Description != nil && len(*s.Description) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("Description", 128, *s.Description))
	}
	if s.DisplayName != nil && len(*s.DisplayName) > 64 {
		invalidParams.Add(request.NewErrParamMaxLen("DisplayName", 64, *s.DisplayName))
	}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateGroupInput) SetDescription(v string) *UpdateGroupInput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *UpdateGroupInput) SetDisplayName(v string) *UpdateGroupInput {
	s.DisplayName = &v
	return s
}

// SetGroupId sets the GroupId field's value.
func (s *UpdateGroupInput) SetGroupId(v string) *UpdateGroupInput {
	s.GroupId = &v
	return s
}

type UpdateGroupOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata
}

// String returns the string representation
func (s UpdateGroupOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UpdateGroupOutput) GoString() string {
	return s.String()
}
