// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudidentity

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListPermissionSetsCommon = "ListPermissionSets"

// ListPermissionSetsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListPermissionSetsCommon operation. The "output" return
// value will be populated with the ListPermissionSetsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListPermissionSetsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListPermissionSetsCommon Send returns without error.
//
// See ListPermissionSetsCommon for more information on using the ListPermissionSetsCommon
// API call, and error handling.
//
//    // Example sending a request using the ListPermissionSetsCommonRequest method.
//    req, resp := client.ListPermissionSetsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLOUDIDENTITY) ListPermissionSetsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListPermissionSetsCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListPermissionSetsCommon API operation for CLOUDIDENTITY.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLOUDIDENTITY's
// API operation ListPermissionSetsCommon for usage and error information.
func (c *CLOUDIDENTITY) ListPermissionSetsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListPermissionSetsCommonRequest(input)
	return out, req.Send()
}

// ListPermissionSetsCommonWithContext is the same as ListPermissionSetsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListPermissionSetsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLOUDIDENTITY) ListPermissionSetsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListPermissionSetsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListPermissionSets = "ListPermissionSets"

// ListPermissionSetsRequest generates a "volcengine/request.Request" representing the
// client's request for the ListPermissionSets operation. The "output" return
// value will be populated with the ListPermissionSetsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListPermissionSetsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListPermissionSetsCommon Send returns without error.
//
// See ListPermissionSets for more information on using the ListPermissionSets
// API call, and error handling.
//
//    // Example sending a request using the ListPermissionSetsRequest method.
//    req, resp := client.ListPermissionSetsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLOUDIDENTITY) ListPermissionSetsRequest(input *ListPermissionSetsInput) (req *request.Request, output *ListPermissionSetsOutput) {
	op := &request.Operation{
		Name:       opListPermissionSets,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListPermissionSetsInput{}
	}

	output = &ListPermissionSetsOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListPermissionSets API operation for CLOUDIDENTITY.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLOUDIDENTITY's
// API operation ListPermissionSets for usage and error information.
func (c *CLOUDIDENTITY) ListPermissionSets(input *ListPermissionSetsInput) (*ListPermissionSetsOutput, error) {
	req, out := c.ListPermissionSetsRequest(input)
	return out, req.Send()
}

// ListPermissionSetsWithContext is the same as ListPermissionSets with the addition of
// the ability to pass a context and additional request options.
//
// See ListPermissionSets for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLOUDIDENTITY) ListPermissionSetsWithContext(ctx volcengine.Context, input *ListPermissionSetsInput, opts ...request.Option) (*ListPermissionSetsOutput, error) {
	req, out := c.ListPermissionSetsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ListPermissionSetsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Filter *string `max:"254" type:"string" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `min:"1" max:"100" type:"int32" json:",omitempty"`

	PermissionSetIds *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ListPermissionSetsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPermissionSetsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListPermissionSetsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListPermissionSetsInput"}
	if s.Filter != nil && len(*s.Filter) > 254 {
		invalidParams.Add(request.NewErrParamMaxLen("Filter", 254, *s.Filter))
	}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}
	if s.PageSize != nil && *s.PageSize > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("PageSize", 100))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFilter sets the Filter field's value.
func (s *ListPermissionSetsInput) SetFilter(v string) *ListPermissionSetsInput {
	s.Filter = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListPermissionSetsInput) SetPageNumber(v int32) *ListPermissionSetsInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListPermissionSetsInput) SetPageSize(v int32) *ListPermissionSetsInput {
	s.PageSize = &v
	return s
}

// SetPermissionSetIds sets the PermissionSetIds field's value.
func (s *ListPermissionSetsInput) SetPermissionSetIds(v string) *ListPermissionSetsInput {
	s.PermissionSetIds = &v
	return s
}

type ListPermissionSetsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	PermissionSets []*PermissionSetForListPermissionSetsOutput `type:"list" json:",omitempty"`

	Total *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s ListPermissionSetsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListPermissionSetsOutput) GoString() string {
	return s.String()
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListPermissionSetsOutput) SetPageNumber(v int32) *ListPermissionSetsOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListPermissionSetsOutput) SetPageSize(v int32) *ListPermissionSetsOutput {
	s.PageSize = &v
	return s
}

// SetPermissionSets sets the PermissionSets field's value.
func (s *ListPermissionSetsOutput) SetPermissionSets(v []*PermissionSetForListPermissionSetsOutput) *ListPermissionSetsOutput {
	s.PermissionSets = v
	return s
}

// SetTotal sets the Total field's value.
func (s *ListPermissionSetsOutput) SetTotal(v int64) *ListPermissionSetsOutput {
	s.Total = &v
	return s
}

type PermissionSetForListPermissionSetsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CreatedTime *string `type:"string" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	PermissionSetId *string `type:"string" json:",omitempty"`

	RelayState *string `type:"string" json:",omitempty"`

	SessionDuration *int64 `type:"int64" json:",omitempty"`

	StatusNotifications []*string `type:"list" json:",omitempty"`

	UpdatedTime *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s PermissionSetForListPermissionSetsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PermissionSetForListPermissionSetsOutput) GoString() string {
	return s.String()
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *PermissionSetForListPermissionSetsOutput) SetCreatedTime(v string) *PermissionSetForListPermissionSetsOutput {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *PermissionSetForListPermissionSetsOutput) SetDescription(v string) *PermissionSetForListPermissionSetsOutput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *PermissionSetForListPermissionSetsOutput) SetName(v string) *PermissionSetForListPermissionSetsOutput {
	s.Name = &v
	return s
}

// SetPermissionSetId sets the PermissionSetId field's value.
func (s *PermissionSetForListPermissionSetsOutput) SetPermissionSetId(v string) *PermissionSetForListPermissionSetsOutput {
	s.PermissionSetId = &v
	return s
}

// SetRelayState sets the RelayState field's value.
func (s *PermissionSetForListPermissionSetsOutput) SetRelayState(v string) *PermissionSetForListPermissionSetsOutput {
	s.RelayState = &v
	return s
}

// SetSessionDuration sets the SessionDuration field's value.
func (s *PermissionSetForListPermissionSetsOutput) SetSessionDuration(v int64) *PermissionSetForListPermissionSetsOutput {
	s.SessionDuration = &v
	return s
}

// SetStatusNotifications sets the StatusNotifications field's value.
func (s *PermissionSetForListPermissionSetsOutput) SetStatusNotifications(v []*string) *PermissionSetForListPermissionSetsOutput {
	s.StatusNotifications = v
	return s
}

// SetUpdatedTime sets the UpdatedTime field's value.
func (s *PermissionSetForListPermissionSetsOutput) SetUpdatedTime(v string) *PermissionSetForListPermissionSetsOutput {
	s.UpdatedTime = &v
	return s
}
