// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudidentity

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListGroupMembersCommon = "ListGroupMembers"

// ListGroupMembersCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListGroupMembersCommon operation. The "output" return
// value will be populated with the ListGroupMembersCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListGroupMembersCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListGroupMembersCommon Send returns without error.
//
// See ListGroupMembersCommon for more information on using the ListGroupMembersCommon
// API call, and error handling.
//
//    // Example sending a request using the ListGroupMembersCommonRequest method.
//    req, resp := client.ListGroupMembersCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLOUDIDENTITY) ListGroupMembersCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListGroupMembersCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListGroupMembersCommon API operation for CLOUDIDENTITY.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLOUDIDENTITY's
// API operation ListGroupMembersCommon for usage and error information.
func (c *CLOUDIDENTITY) ListGroupMembersCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListGroupMembersCommonRequest(input)
	return out, req.Send()
}

// ListGroupMembersCommonWithContext is the same as ListGroupMembersCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListGroupMembersCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLOUDIDENTITY) ListGroupMembersCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListGroupMembersCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListGroupMembers = "ListGroupMembers"

// ListGroupMembersRequest generates a "volcengine/request.Request" representing the
// client's request for the ListGroupMembers operation. The "output" return
// value will be populated with the ListGroupMembersCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListGroupMembersCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListGroupMembersCommon Send returns without error.
//
// See ListGroupMembers for more information on using the ListGroupMembers
// API call, and error handling.
//
//    // Example sending a request using the ListGroupMembersRequest method.
//    req, resp := client.ListGroupMembersRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLOUDIDENTITY) ListGroupMembersRequest(input *ListGroupMembersInput) (req *request.Request, output *ListGroupMembersOutput) {
	op := &request.Operation{
		Name:       opListGroupMembers,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListGroupMembersInput{}
	}

	output = &ListGroupMembersOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListGroupMembers API operation for CLOUDIDENTITY.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLOUDIDENTITY's
// API operation ListGroupMembers for usage and error information.
func (c *CLOUDIDENTITY) ListGroupMembers(input *ListGroupMembersInput) (*ListGroupMembersOutput, error) {
	req, out := c.ListGroupMembersRequest(input)
	return out, req.Send()
}

// ListGroupMembersWithContext is the same as ListGroupMembers with the addition of
// the ability to pass a context and additional request options.
//
// See ListGroupMembers for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLOUDIDENTITY) ListGroupMembersWithContext(ctx volcengine.Context, input *ListGroupMembersInput, opts ...request.Option) (*ListGroupMembersOutput, error) {
	req, out := c.ListGroupMembersRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type ListGroupMembersInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// GroupId is a required field
	GroupId *string `type:"string" json:",omitempty" required:"true"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `min:"1" max:"100" type:"int32" json:",omitempty"`

	QueryString *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ListGroupMembersInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupMembersInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListGroupMembersInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListGroupMembersInput"}
	if s.GroupId == nil {
		invalidParams.Add(request.NewErrParamRequired("GroupId"))
	}
	if s.PageSize != nil && *s.PageSize < 1 {
		invalidParams.Add(request.NewErrParamMinValue("PageSize", 1))
	}
	if s.PageSize != nil && *s.PageSize > 100 {
		invalidParams.Add(request.NewErrParamMaxValue("PageSize", 100))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetGroupId sets the GroupId field's value.
func (s *ListGroupMembersInput) SetGroupId(v string) *ListGroupMembersInput {
	s.GroupId = &v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListGroupMembersInput) SetPageNumber(v int32) *ListGroupMembersInput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListGroupMembersInput) SetPageSize(v int32) *ListGroupMembersInput {
	s.PageSize = &v
	return s
}

// SetQueryString sets the QueryString field's value.
func (s *ListGroupMembersInput) SetQueryString(v string) *ListGroupMembersInput {
	s.QueryString = &v
	return s
}

type ListGroupMembersOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Members []*MemberForListGroupMembersOutput `type:"list" json:",omitempty"`

	PageNumber *int32 `type:"int32" json:",omitempty"`

	PageSize *int32 `type:"int32" json:",omitempty"`

	Total *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s ListGroupMembersOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListGroupMembersOutput) GoString() string {
	return s.String()
}

// SetMembers sets the Members field's value.
func (s *ListGroupMembersOutput) SetMembers(v []*MemberForListGroupMembersOutput) *ListGroupMembersOutput {
	s.Members = v
	return s
}

// SetPageNumber sets the PageNumber field's value.
func (s *ListGroupMembersOutput) SetPageNumber(v int32) *ListGroupMembersOutput {
	s.PageNumber = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListGroupMembersOutput) SetPageSize(v int32) *ListGroupMembersOutput {
	s.PageSize = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *ListGroupMembersOutput) SetTotal(v int64) *ListGroupMembersOutput {
	s.Total = &v
	return s
}

type MemberForListGroupMembersOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	DisplayName *string `type:"string" json:",omitempty"`

	Email *string `type:"string" json:",omitempty"`

	IdentityType *string `type:"string" json:",omitempty"`

	JoinTime *string `type:"string" json:",omitempty"`

	Phone *string `type:"string" json:",omitempty"`

	Source *string `type:"string" json:",omitempty"`

	UserId *string `type:"string" json:",omitempty"`

	UserName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s MemberForListGroupMembersOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MemberForListGroupMembersOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *MemberForListGroupMembersOutput) SetDescription(v string) *MemberForListGroupMembersOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *MemberForListGroupMembersOutput) SetDisplayName(v string) *MemberForListGroupMembersOutput {
	s.DisplayName = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *MemberForListGroupMembersOutput) SetEmail(v string) *MemberForListGroupMembersOutput {
	s.Email = &v
	return s
}

// SetIdentityType sets the IdentityType field's value.
func (s *MemberForListGroupMembersOutput) SetIdentityType(v string) *MemberForListGroupMembersOutput {
	s.IdentityType = &v
	return s
}

// SetJoinTime sets the JoinTime field's value.
func (s *MemberForListGroupMembersOutput) SetJoinTime(v string) *MemberForListGroupMembersOutput {
	s.JoinTime = &v
	return s
}

// SetPhone sets the Phone field's value.
func (s *MemberForListGroupMembersOutput) SetPhone(v string) *MemberForListGroupMembersOutput {
	s.Phone = &v
	return s
}

// SetSource sets the Source field's value.
func (s *MemberForListGroupMembersOutput) SetSource(v string) *MemberForListGroupMembersOutput {
	s.Source = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *MemberForListGroupMembersOutput) SetUserId(v string) *MemberForListGroupMembersOutput {
	s.UserId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *MemberForListGroupMembersOutput) SetUserName(v string) *MemberForListGroupMembersOutput {
	s.UserName = &v
	return s
}
