// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package cloudidentity

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateUserCommon = "CreateUser"

// CreateUserCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateUserCommon operation. The "output" return
// value will be populated with the CreateUserCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateUserCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateUserCommon Send returns without error.
//
// See CreateUserCommon for more information on using the CreateUserCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateUserCommonRequest method.
//    req, resp := client.CreateUserCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLOUDIDENTITY) CreateUserCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateUserCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateUserCommon API operation for CLOUDIDENTITY.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLOUDIDENTITY's
// API operation CreateUserCommon for usage and error information.
func (c *CLOUDIDENTITY) CreateUserCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateUserCommonRequest(input)
	return out, req.Send()
}

// CreateUserCommonWithContext is the same as CreateUserCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUserCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLOUDIDENTITY) CreateUserCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateUserCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateUser = "CreateUser"

// CreateUserRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateUser operation. The "output" return
// value will be populated with the CreateUserCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateUserCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateUserCommon Send returns without error.
//
// See CreateUser for more information on using the CreateUser
// API call, and error handling.
//
//    // Example sending a request using the CreateUserRequest method.
//    req, resp := client.CreateUserRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLOUDIDENTITY) CreateUserRequest(input *CreateUserInput) (req *request.Request, output *CreateUserOutput) {
	op := &request.Operation{
		Name:       opCreateUser,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateUserInput{}
	}

	output = &CreateUserOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateUser API operation for CLOUDIDENTITY.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLOUDIDENTITY's
// API operation CreateUser for usage and error information.
func (c *CLOUDIDENTITY) CreateUser(input *CreateUserInput) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	return out, req.Send()
}

// CreateUserWithContext is the same as CreateUser with the addition of
// the ability to pass a context and additional request options.
//
// See CreateUser for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLOUDIDENTITY) CreateUserWithContext(ctx volcengine.Context, input *CreateUserInput, opts ...request.Option) (*CreateUserOutput, error) {
	req, out := c.CreateUserRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateUserInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Description *string `max:"255" type:"string" json:",omitempty"`

	DisplayName *string `max:"64" type:"string" json:",omitempty"`

	Email *string `max:"128" type:"string" json:",omitempty"`

	Phone *string `max:"20" type:"string" json:",omitempty"`

	// UserName is a required field
	UserName *string `min:"1" max:"54" type:"string" json:",omitempty" required:"true"`
}

// String returns the string representation
func (s CreateUserInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateUserInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateUserInput"}
	if s.Description != nil && len(*s.Description) > 255 {
		invalidParams.Add(request.NewErrParamMaxLen("Description", 255, *s.Description))
	}
	if s.DisplayName != nil && len(*s.DisplayName) > 64 {
		invalidParams.Add(request.NewErrParamMaxLen("DisplayName", 64, *s.DisplayName))
	}
	if s.Email != nil && len(*s.Email) > 128 {
		invalidParams.Add(request.NewErrParamMaxLen("Email", 128, *s.Email))
	}
	if s.Phone != nil && len(*s.Phone) > 20 {
		invalidParams.Add(request.NewErrParamMaxLen("Phone", 20, *s.Phone))
	}
	if s.UserName == nil {
		invalidParams.Add(request.NewErrParamRequired("UserName"))
	}
	if s.UserName != nil && len(*s.UserName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("UserName", 1))
	}
	if s.UserName != nil && len(*s.UserName) > 54 {
		invalidParams.Add(request.NewErrParamMaxLen("UserName", 54, *s.UserName))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *CreateUserInput) SetDescription(v string) *CreateUserInput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateUserInput) SetDisplayName(v string) *CreateUserInput {
	s.DisplayName = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *CreateUserInput) SetEmail(v string) *CreateUserInput {
	s.Email = &v
	return s
}

// SetPhone sets the Phone field's value.
func (s *CreateUserInput) SetPhone(v string) *CreateUserInput {
	s.Phone = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *CreateUserInput) SetUserName(v string) *CreateUserInput {
	s.UserName = &v
	return s
}

type CreateUserOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	CreatedTime *string `type:"string" json:",omitempty"`

	Description *string `type:"string" json:",omitempty"`

	DisplayName *string `type:"string" json:",omitempty"`

	Email *string `type:"string" json:",omitempty"`

	Phone *string `type:"string" json:",omitempty"`

	Source *string `type:"string" json:",omitempty"`

	UpdatedTime *string `type:"string" json:",omitempty"`

	UserId *string `type:"string" json:",omitempty"`

	UserName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s CreateUserOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateUserOutput) GoString() string {
	return s.String()
}

// SetCreatedTime sets the CreatedTime field's value.
func (s *CreateUserOutput) SetCreatedTime(v string) *CreateUserOutput {
	s.CreatedTime = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateUserOutput) SetDescription(v string) *CreateUserOutput {
	s.Description = &v
	return s
}

// SetDisplayName sets the DisplayName field's value.
func (s *CreateUserOutput) SetDisplayName(v string) *CreateUserOutput {
	s.DisplayName = &v
	return s
}

// SetEmail sets the Email field's value.
func (s *CreateUserOutput) SetEmail(v string) *CreateUserOutput {
	s.Email = &v
	return s
}

// SetPhone sets the Phone field's value.
func (s *CreateUserOutput) SetPhone(v string) *CreateUserOutput {
	s.Phone = &v
	return s
}

// SetSource sets the Source field's value.
func (s *CreateUserOutput) SetSource(v string) *CreateUserOutput {
	s.Source = &v
	return s
}

// SetUpdatedTime sets the UpdatedTime field's value.
func (s *CreateUserOutput) SetUpdatedTime(v string) *CreateUserOutput {
	s.UpdatedTime = &v
	return s
}

// SetUserId sets the UserId field's value.
func (s *CreateUserOutput) SetUserId(v string) *CreateUserOutput {
	s.UserId = &v
	return s
}

// SetUserName sets the UserName field's value.
func (s *CreateUserOutput) SetUserName(v string) *CreateUserOutput {
	s.UserName = &v
	return s
}
