// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package clouddetect

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opListTaskGroupsCommon = "ListTaskGroups"

// ListTaskGroupsCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the ListTaskGroupsCommon operation. The "output" return
// value will be populated with the ListTaskGroupsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListTaskGroupsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListTaskGroupsCommon Send returns without error.
//
// See ListTaskGroupsCommon for more information on using the ListTaskGroupsCommon
// API call, and error handling.
//
//    // Example sending a request using the ListTaskGroupsCommonRequest method.
//    req, resp := client.ListTaskGroupsCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLOUDDETECT) ListTaskGroupsCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opListTaskGroupsCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListTaskGroupsCommon API operation for CLOUD_DETECT.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLOUD_DETECT's
// API operation ListTaskGroupsCommon for usage and error information.
func (c *CLOUDDETECT) ListTaskGroupsCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.ListTaskGroupsCommonRequest(input)
	return out, req.Send()
}

// ListTaskGroupsCommonWithContext is the same as ListTaskGroupsCommon with the addition of
// the ability to pass a context and additional request options.
//
// See ListTaskGroupsCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLOUDDETECT) ListTaskGroupsCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.ListTaskGroupsCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTaskGroups = "ListTaskGroups"

// ListTaskGroupsRequest generates a "volcengine/request.Request" representing the
// client's request for the ListTaskGroups operation. The "output" return
// value will be populated with the ListTaskGroupsCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned ListTaskGroupsCommon Request to send the API call to the service.
// the "output" return value is not valid until after ListTaskGroupsCommon Send returns without error.
//
// See ListTaskGroups for more information on using the ListTaskGroups
// API call, and error handling.
//
//    // Example sending a request using the ListTaskGroupsRequest method.
//    req, resp := client.ListTaskGroupsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLOUDDETECT) ListTaskGroupsRequest(input *ListTaskGroupsInput) (req *request.Request, output *ListTaskGroupsOutput) {
	op := &request.Operation{
		Name:       opListTaskGroups,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListTaskGroupsInput{}
	}

	output = &ListTaskGroupsOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// ListTaskGroups API operation for CLOUD_DETECT.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLOUD_DETECT's
// API operation ListTaskGroups for usage and error information.
func (c *CLOUDDETECT) ListTaskGroups(input *ListTaskGroupsInput) (*ListTaskGroupsOutput, error) {
	req, out := c.ListTaskGroupsRequest(input)
	return out, req.Send()
}

// ListTaskGroupsWithContext is the same as ListTaskGroups with the addition of
// the ability to pass a context and additional request options.
//
// See ListTaskGroups for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLOUDDETECT) ListTaskGroupsWithContext(ctx volcengine.Context, input *ListTaskGroupsInput, opts ...request.Option) (*ListTaskGroupsOutput, error) {
	req, out := c.ListTaskGroupsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type GroupForListTaskGroupsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CreateTime *string `type:"string" json:",omitempty"`

	IDStr *string `type:"string" json:",omitempty"`

	Name *string `type:"string" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s GroupForListTaskGroupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s GroupForListTaskGroupsOutput) GoString() string {
	return s.String()
}

// SetCreateTime sets the CreateTime field's value.
func (s *GroupForListTaskGroupsOutput) SetCreateTime(v string) *GroupForListTaskGroupsOutput {
	s.CreateTime = &v
	return s
}

// SetIDStr sets the IDStr field's value.
func (s *GroupForListTaskGroupsOutput) SetIDStr(v string) *GroupForListTaskGroupsOutput {
	s.IDStr = &v
	return s
}

// SetName sets the Name field's value.
func (s *GroupForListTaskGroupsOutput) SetName(v string) *GroupForListTaskGroupsOutput {
	s.Name = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *GroupForListTaskGroupsOutput) SetProjectName(v string) *GroupForListTaskGroupsOutput {
	s.ProjectName = &v
	return s
}

type ListTaskGroupsInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// PageNum is a required field
	PageNum *int64 `type:"int64" json:",omitempty" required:"true"`

	// PageSize is a required field
	PageSize *int64 `type:"int64" json:",omitempty" required:"true"`

	ProjectName *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s ListTaskGroupsInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTaskGroupsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTaskGroupsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTaskGroupsInput"}
	if s.PageNum == nil {
		invalidParams.Add(request.NewErrParamRequired("PageNum"))
	}
	if s.PageSize == nil {
		invalidParams.Add(request.NewErrParamRequired("PageSize"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetPageNum sets the PageNum field's value.
func (s *ListTaskGroupsInput) SetPageNum(v int64) *ListTaskGroupsInput {
	s.PageNum = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListTaskGroupsInput) SetPageSize(v int64) *ListTaskGroupsInput {
	s.PageSize = &v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *ListTaskGroupsInput) SetProjectName(v string) *ListTaskGroupsInput {
	s.ProjectName = &v
	return s
}

type ListTaskGroupsOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	Groups []*GroupForListTaskGroupsOutput `type:"list" json:",omitempty"`

	PageNum *int64 `type:"int64" json:",omitempty"`

	PageSize *int64 `type:"int64" json:",omitempty"`

	Total *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s ListTaskGroupsOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s ListTaskGroupsOutput) GoString() string {
	return s.String()
}

// SetGroups sets the Groups field's value.
func (s *ListTaskGroupsOutput) SetGroups(v []*GroupForListTaskGroupsOutput) *ListTaskGroupsOutput {
	s.Groups = v
	return s
}

// SetPageNum sets the PageNum field's value.
func (s *ListTaskGroupsOutput) SetPageNum(v int64) *ListTaskGroupsOutput {
	s.PageNum = &v
	return s
}

// SetPageSize sets the PageSize field's value.
func (s *ListTaskGroupsOutput) SetPageSize(v int64) *ListTaskGroupsOutput {
	s.PageSize = &v
	return s
}

// SetTotal sets the Total field's value.
func (s *ListTaskGroupsOutput) SetTotal(v int64) *ListTaskGroupsOutput {
	s.Total = &v
	return s
}
