// Code generated by volcengine with private/model/cli/gen-api/main.go. DO NOT EDIT.

package clouddetect

import (
	"github.com/volcengine/volcengine-go-sdk/volcengine"
	"github.com/volcengine/volcengine-go-sdk/volcengine/request"
	"github.com/volcengine/volcengine-go-sdk/volcengine/response"
	"github.com/volcengine/volcengine-go-sdk/volcengine/volcengineutil"
)

const opCreateTaskCommon = "CreateTask"

// CreateTaskCommonRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateTaskCommon operation. The "output" return
// value will be populated with the CreateTaskCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateTaskCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateTaskCommon Send returns without error.
//
// See CreateTaskCommon for more information on using the CreateTaskCommon
// API call, and error handling.
//
//    // Example sending a request using the CreateTaskCommonRequest method.
//    req, resp := client.CreateTaskCommonRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLOUDDETECT) CreateTaskCommonRequest(input *map[string]interface{}) (req *request.Request, output *map[string]interface{}) {
	op := &request.Operation{
		Name:       opCreateTaskCommon,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &map[string]interface{}{}
	}

	output = &map[string]interface{}{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateTaskCommon API operation for CLOUD_DETECT.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLOUD_DETECT's
// API operation CreateTaskCommon for usage and error information.
func (c *CLOUDDETECT) CreateTaskCommon(input *map[string]interface{}) (*map[string]interface{}, error) {
	req, out := c.CreateTaskCommonRequest(input)
	return out, req.Send()
}

// CreateTaskCommonWithContext is the same as CreateTaskCommon with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTaskCommon for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If the context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLOUDDETECT) CreateTaskCommonWithContext(ctx volcengine.Context, input *map[string]interface{}, opts ...request.Option) (*map[string]interface{}, error) {
	req, out := c.CreateTaskCommonRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateTask = "CreateTask"

// CreateTaskRequest generates a "volcengine/request.Request" representing the
// client's request for the CreateTask operation. The "output" return
// value will be populated with the CreateTaskCommon request's response once the request completes
// successfully.
//
// Use "Send" method on the returned CreateTaskCommon Request to send the API call to the service.
// the "output" return value is not valid until after CreateTaskCommon Send returns without error.
//
// See CreateTask for more information on using the CreateTask
// API call, and error handling.
//
//    // Example sending a request using the CreateTaskRequest method.
//    req, resp := client.CreateTaskRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
func (c *CLOUDDETECT) CreateTaskRequest(input *CreateTaskInput) (req *request.Request, output *CreateTaskOutput) {
	op := &request.Operation{
		Name:       opCreateTask,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &CreateTaskInput{}
	}

	output = &CreateTaskOutput{}
	req = c.newRequest(op, input, output)

	req.HTTPRequest.Header.Set("Content-Type", "application/json; charset=utf-8")

	return
}

// CreateTask API operation for CLOUD_DETECT.
//
// Returns volcengineerr.Error for service API and SDK errors. Use runtime type assertions
// with volcengineerr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the VOLCENGINE API reference guide for CLOUD_DETECT's
// API operation CreateTask for usage and error information.
func (c *CLOUDDETECT) CreateTask(input *CreateTaskInput) (*CreateTaskOutput, error) {
	req, out := c.CreateTaskRequest(input)
	return out, req.Send()
}

// CreateTaskWithContext is the same as CreateTask with the addition of
// the ability to pass a context and additional request options.
//
// See CreateTask for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. Ifthe context is nil a panic will occur.
// In the future the SDK may create sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *CLOUDDETECT) CreateTaskWithContext(ctx volcengine.Context, input *CreateTaskInput, opts ...request.Option) (*CreateTaskOutput, error) {
	req, out := c.CreateTaskRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

type CreateTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	// Address is a required field
	Address *string `type:"string" json:",omitempty" required:"true"`

	DNSConfig *DNSConfigForCreateTaskInput `type:"structure" json:",omitempty"`

	DiagnoseConfig *DiagnoseConfigForCreateTaskInput `type:"structure" json:",omitempty"`

	// FinishTime is a required field
	FinishTime *int64 `type:"int64" json:",omitempty" required:"true"`

	HTTPConfig *HTTPConfigForCreateTaskInput `type:"structure" json:",omitempty"`

	// IntervalSeconds is a required field
	IntervalSeconds *int64 `type:"int64" json:",omitempty" required:"true"`

	LineIDList []*int64 `type:"list" json:",omitempty"`

	// Name is a required field
	Name *string `type:"string" json:",omitempty" required:"true"`

	// NodeCount is a required field
	NodeCount *int32 `type:"int32" json:",omitempty" required:"true"`

	PeriodConfig *PeriodConfigForCreateTaskInput `type:"structure" json:",omitempty"`

	PingConfig *PingConfigForCreateTaskInput `type:"structure" json:",omitempty"`

	ProjectName *string `type:"string" json:",omitempty"`

	TCPConfig *TCPConfigForCreateTaskInput `type:"structure" json:",omitempty"`

	// Type is a required field
	Type *int32 `type:"int32" json:",omitempty" required:"true"`

	UDPConfig *UDPConfigForCreateTaskInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s CreateTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTaskInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateTaskInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateTaskInput"}
	if s.Address == nil {
		invalidParams.Add(request.NewErrParamRequired("Address"))
	}
	if s.FinishTime == nil {
		invalidParams.Add(request.NewErrParamRequired("FinishTime"))
	}
	if s.IntervalSeconds == nil {
		invalidParams.Add(request.NewErrParamRequired("IntervalSeconds"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.NodeCount == nil {
		invalidParams.Add(request.NewErrParamRequired("NodeCount"))
	}
	if s.Type == nil {
		invalidParams.Add(request.NewErrParamRequired("Type"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetAddress sets the Address field's value.
func (s *CreateTaskInput) SetAddress(v string) *CreateTaskInput {
	s.Address = &v
	return s
}

// SetDNSConfig sets the DNSConfig field's value.
func (s *CreateTaskInput) SetDNSConfig(v *DNSConfigForCreateTaskInput) *CreateTaskInput {
	s.DNSConfig = v
	return s
}

// SetDiagnoseConfig sets the DiagnoseConfig field's value.
func (s *CreateTaskInput) SetDiagnoseConfig(v *DiagnoseConfigForCreateTaskInput) *CreateTaskInput {
	s.DiagnoseConfig = v
	return s
}

// SetFinishTime sets the FinishTime field's value.
func (s *CreateTaskInput) SetFinishTime(v int64) *CreateTaskInput {
	s.FinishTime = &v
	return s
}

// SetHTTPConfig sets the HTTPConfig field's value.
func (s *CreateTaskInput) SetHTTPConfig(v *HTTPConfigForCreateTaskInput) *CreateTaskInput {
	s.HTTPConfig = v
	return s
}

// SetIntervalSeconds sets the IntervalSeconds field's value.
func (s *CreateTaskInput) SetIntervalSeconds(v int64) *CreateTaskInput {
	s.IntervalSeconds = &v
	return s
}

// SetLineIDList sets the LineIDList field's value.
func (s *CreateTaskInput) SetLineIDList(v []*int64) *CreateTaskInput {
	s.LineIDList = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateTaskInput) SetName(v string) *CreateTaskInput {
	s.Name = &v
	return s
}

// SetNodeCount sets the NodeCount field's value.
func (s *CreateTaskInput) SetNodeCount(v int32) *CreateTaskInput {
	s.NodeCount = &v
	return s
}

// SetPeriodConfig sets the PeriodConfig field's value.
func (s *CreateTaskInput) SetPeriodConfig(v *PeriodConfigForCreateTaskInput) *CreateTaskInput {
	s.PeriodConfig = v
	return s
}

// SetPingConfig sets the PingConfig field's value.
func (s *CreateTaskInput) SetPingConfig(v *PingConfigForCreateTaskInput) *CreateTaskInput {
	s.PingConfig = v
	return s
}

// SetProjectName sets the ProjectName field's value.
func (s *CreateTaskInput) SetProjectName(v string) *CreateTaskInput {
	s.ProjectName = &v
	return s
}

// SetTCPConfig sets the TCPConfig field's value.
func (s *CreateTaskInput) SetTCPConfig(v *TCPConfigForCreateTaskInput) *CreateTaskInput {
	s.TCPConfig = v
	return s
}

// SetType sets the Type field's value.
func (s *CreateTaskInput) SetType(v int32) *CreateTaskInput {
	s.Type = &v
	return s
}

// SetUDPConfig sets the UDPConfig field's value.
func (s *CreateTaskInput) SetUDPConfig(v *UDPConfigForCreateTaskInput) *CreateTaskInput {
	s.UDPConfig = v
	return s
}

type CreateTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Metadata *response.ResponseMetadata

	LocationInfo *LocationInfoForCreateTaskOutput `type:"structure" json:",omitempty"`

	TaskID *int64 `type:"int64" json:",omitempty"`
}

// String returns the string representation
func (s CreateTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CreateTaskOutput) GoString() string {
	return s.String()
}

// SetLocationInfo sets the LocationInfo field's value.
func (s *CreateTaskOutput) SetLocationInfo(v *LocationInfoForCreateTaskOutput) *CreateTaskOutput {
	s.LocationInfo = v
	return s
}

// SetTaskID sets the TaskID field's value.
func (s *CreateTaskOutput) SetTaskID(v int64) *CreateTaskOutput {
	s.TaskID = &v
	return s
}

type CustomHostConfigForCreateTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	CustomHosts []*CustomHostForCreateTaskInput `type:"list" json:",omitempty"`

	Strategy *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s CustomHostConfigForCreateTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomHostConfigForCreateTaskInput) GoString() string {
	return s.String()
}

// SetCustomHosts sets the CustomHosts field's value.
func (s *CustomHostConfigForCreateTaskInput) SetCustomHosts(v []*CustomHostForCreateTaskInput) *CustomHostConfigForCreateTaskInput {
	s.CustomHosts = v
	return s
}

// SetStrategy sets the Strategy field's value.
func (s *CustomHostConfigForCreateTaskInput) SetStrategy(v int32) *CustomHostConfigForCreateTaskInput {
	s.Strategy = &v
	return s
}

type CustomHostForCreateTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	RawHostPort *string `type:"string" json:",omitempty"`

	ResolveList []*string `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s CustomHostForCreateTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s CustomHostForCreateTaskInput) GoString() string {
	return s.String()
}

// SetRawHostPort sets the RawHostPort field's value.
func (s *CustomHostForCreateTaskInput) SetRawHostPort(v string) *CustomHostForCreateTaskInput {
	s.RawHostPort = &v
	return s
}

// SetResolveList sets the ResolveList field's value.
func (s *CustomHostForCreateTaskInput) SetResolveList(v []*string) *CustomHostForCreateTaskInput {
	s.ResolveList = v
	return s
}

type DNSConfigForCreateTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	EnableDig *bool `type:"boolean" json:",omitempty"`

	RecordType *int32 `type:"int32" json:",omitempty"`

	SearchType *int32 `type:"int32" json:",omitempty"`

	Server *string `type:"string" json:",omitempty"`

	ServerType *int32 `type:"int32" json:",omitempty"`

	Timeout *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s DNSConfigForCreateTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DNSConfigForCreateTaskInput) GoString() string {
	return s.String()
}

// SetEnableDig sets the EnableDig field's value.
func (s *DNSConfigForCreateTaskInput) SetEnableDig(v bool) *DNSConfigForCreateTaskInput {
	s.EnableDig = &v
	return s
}

// SetRecordType sets the RecordType field's value.
func (s *DNSConfigForCreateTaskInput) SetRecordType(v int32) *DNSConfigForCreateTaskInput {
	s.RecordType = &v
	return s
}

// SetSearchType sets the SearchType field's value.
func (s *DNSConfigForCreateTaskInput) SetSearchType(v int32) *DNSConfigForCreateTaskInput {
	s.SearchType = &v
	return s
}

// SetServer sets the Server field's value.
func (s *DNSConfigForCreateTaskInput) SetServer(v string) *DNSConfigForCreateTaskInput {
	s.Server = &v
	return s
}

// SetServerType sets the ServerType field's value.
func (s *DNSConfigForCreateTaskInput) SetServerType(v int32) *DNSConfigForCreateTaskInput {
	s.ServerType = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *DNSConfigForCreateTaskInput) SetTimeout(v int32) *DNSConfigForCreateTaskInput {
	s.Timeout = &v
	return s
}

type DiagnoseConfigForCreateTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DNSConfig *DNSConfigForCreateTaskInput `type:"structure" json:",omitempty"`

	MethodList []*int32 `type:"list" json:",omitempty"`

	MtrConfig *MtrConfigForCreateTaskInput `type:"structure" json:",omitempty"`

	PcapStatus *int32 `type:"int32" json:",omitempty"`

	PingConfig *PingConfigForCreateTaskInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s DiagnoseConfigForCreateTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s DiagnoseConfigForCreateTaskInput) GoString() string {
	return s.String()
}

// SetDNSConfig sets the DNSConfig field's value.
func (s *DiagnoseConfigForCreateTaskInput) SetDNSConfig(v *DNSConfigForCreateTaskInput) *DiagnoseConfigForCreateTaskInput {
	s.DNSConfig = v
	return s
}

// SetMethodList sets the MethodList field's value.
func (s *DiagnoseConfigForCreateTaskInput) SetMethodList(v []*int32) *DiagnoseConfigForCreateTaskInput {
	s.MethodList = v
	return s
}

// SetMtrConfig sets the MtrConfig field's value.
func (s *DiagnoseConfigForCreateTaskInput) SetMtrConfig(v *MtrConfigForCreateTaskInput) *DiagnoseConfigForCreateTaskInput {
	s.MtrConfig = v
	return s
}

// SetPcapStatus sets the PcapStatus field's value.
func (s *DiagnoseConfigForCreateTaskInput) SetPcapStatus(v int32) *DiagnoseConfigForCreateTaskInput {
	s.PcapStatus = &v
	return s
}

// SetPingConfig sets the PingConfig field's value.
func (s *DiagnoseConfigForCreateTaskInput) SetPingConfig(v *PingConfigForCreateTaskInput) *DiagnoseConfigForCreateTaskInput {
	s.PingConfig = v
	return s
}

type EndTimeForCreateTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Hour *int32 `type:"int32" json:",omitempty"`

	Minute *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s EndTimeForCreateTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s EndTimeForCreateTaskInput) GoString() string {
	return s.String()
}

// SetHour sets the Hour field's value.
func (s *EndTimeForCreateTaskInput) SetHour(v int32) *EndTimeForCreateTaskInput {
	s.Hour = &v
	return s
}

// SetMinute sets the Minute field's value.
func (s *EndTimeForCreateTaskInput) SetMinute(v int32) *EndTimeForCreateTaskInput {
	s.Minute = &v
	return s
}

type HTTPConfigForCreateTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	BodyType *int32 `type:"int32" json:",omitempty"`

	CustomHostConfig *CustomHostConfigForCreateTaskInput `type:"structure" json:",omitempty"`

	DNSServer *string `type:"string" json:",omitempty"`

	DNSType *string `type:"string" json:",omitempty"`

	HTTPHeaders []*HTTPHeaderForCreateTaskInput `type:"list" json:",omitempty"`

	HTTPMethod *int32 `type:"int32" json:",omitempty"`

	HTTPVersion *string `type:"string" json:",omitempty"`

	IgnoreCertificate *bool `type:"boolean" json:",omitempty"`

	MaxBodySize *int64 `type:"int64" json:",omitempty"`

	ProxyURL *string `type:"string" json:",omitempty"`

	Redirect *bool `type:"boolean" json:",omitempty"`

	RequestBody *string `type:"string" json:",omitempty"`

	Timeout *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s HTTPConfigForCreateTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HTTPConfigForCreateTaskInput) GoString() string {
	return s.String()
}

// SetBodyType sets the BodyType field's value.
func (s *HTTPConfigForCreateTaskInput) SetBodyType(v int32) *HTTPConfigForCreateTaskInput {
	s.BodyType = &v
	return s
}

// SetCustomHostConfig sets the CustomHostConfig field's value.
func (s *HTTPConfigForCreateTaskInput) SetCustomHostConfig(v *CustomHostConfigForCreateTaskInput) *HTTPConfigForCreateTaskInput {
	s.CustomHostConfig = v
	return s
}

// SetDNSServer sets the DNSServer field's value.
func (s *HTTPConfigForCreateTaskInput) SetDNSServer(v string) *HTTPConfigForCreateTaskInput {
	s.DNSServer = &v
	return s
}

// SetDNSType sets the DNSType field's value.
func (s *HTTPConfigForCreateTaskInput) SetDNSType(v string) *HTTPConfigForCreateTaskInput {
	s.DNSType = &v
	return s
}

// SetHTTPHeaders sets the HTTPHeaders field's value.
func (s *HTTPConfigForCreateTaskInput) SetHTTPHeaders(v []*HTTPHeaderForCreateTaskInput) *HTTPConfigForCreateTaskInput {
	s.HTTPHeaders = v
	return s
}

// SetHTTPMethod sets the HTTPMethod field's value.
func (s *HTTPConfigForCreateTaskInput) SetHTTPMethod(v int32) *HTTPConfigForCreateTaskInput {
	s.HTTPMethod = &v
	return s
}

// SetHTTPVersion sets the HTTPVersion field's value.
func (s *HTTPConfigForCreateTaskInput) SetHTTPVersion(v string) *HTTPConfigForCreateTaskInput {
	s.HTTPVersion = &v
	return s
}

// SetIgnoreCertificate sets the IgnoreCertificate field's value.
func (s *HTTPConfigForCreateTaskInput) SetIgnoreCertificate(v bool) *HTTPConfigForCreateTaskInput {
	s.IgnoreCertificate = &v
	return s
}

// SetMaxBodySize sets the MaxBodySize field's value.
func (s *HTTPConfigForCreateTaskInput) SetMaxBodySize(v int64) *HTTPConfigForCreateTaskInput {
	s.MaxBodySize = &v
	return s
}

// SetProxyURL sets the ProxyURL field's value.
func (s *HTTPConfigForCreateTaskInput) SetProxyURL(v string) *HTTPConfigForCreateTaskInput {
	s.ProxyURL = &v
	return s
}

// SetRedirect sets the Redirect field's value.
func (s *HTTPConfigForCreateTaskInput) SetRedirect(v bool) *HTTPConfigForCreateTaskInput {
	s.Redirect = &v
	return s
}

// SetRequestBody sets the RequestBody field's value.
func (s *HTTPConfigForCreateTaskInput) SetRequestBody(v string) *HTTPConfigForCreateTaskInput {
	s.RequestBody = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *HTTPConfigForCreateTaskInput) SetTimeout(v int32) *HTTPConfigForCreateTaskInput {
	s.Timeout = &v
	return s
}

type HTTPHeaderForCreateTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Key *string `type:"string" json:",omitempty"`

	Value *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s HTTPHeaderForCreateTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s HTTPHeaderForCreateTaskInput) GoString() string {
	return s.String()
}

// SetKey sets the Key field's value.
func (s *HTTPHeaderForCreateTaskInput) SetKey(v string) *HTTPHeaderForCreateTaskInput {
	s.Key = &v
	return s
}

// SetValue sets the Value field's value.
func (s *HTTPHeaderForCreateTaskInput) SetValue(v string) *HTTPHeaderForCreateTaskInput {
	s.Value = &v
	return s
}

type LocationInfoForCreateTaskOutput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	City *string `type:"string" json:",omitempty"`

	Continent *string `type:"string" json:",omitempty"`

	Country *string `type:"string" json:",omitempty"`

	Isp *string `type:"string" json:",omitempty"`

	Province *string `type:"string" json:",omitempty"`
}

// String returns the string representation
func (s LocationInfoForCreateTaskOutput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s LocationInfoForCreateTaskOutput) GoString() string {
	return s.String()
}

// SetCity sets the City field's value.
func (s *LocationInfoForCreateTaskOutput) SetCity(v string) *LocationInfoForCreateTaskOutput {
	s.City = &v
	return s
}

// SetContinent sets the Continent field's value.
func (s *LocationInfoForCreateTaskOutput) SetContinent(v string) *LocationInfoForCreateTaskOutput {
	s.Continent = &v
	return s
}

// SetCountry sets the Country field's value.
func (s *LocationInfoForCreateTaskOutput) SetCountry(v string) *LocationInfoForCreateTaskOutput {
	s.Country = &v
	return s
}

// SetIsp sets the Isp field's value.
func (s *LocationInfoForCreateTaskOutput) SetIsp(v string) *LocationInfoForCreateTaskOutput {
	s.Isp = &v
	return s
}

// SetProvince sets the Province field's value.
func (s *LocationInfoForCreateTaskOutput) SetProvince(v string) *LocationInfoForCreateTaskOutput {
	s.Province = &v
	return s
}

type MtrConfigForCreateTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	DNSReverseResolution *bool `type:"boolean" json:",omitempty"`

	Interval *float64 `type:"double" json:",omitempty"`

	MaxHops *int32 `type:"int32" json:",omitempty"`

	MaxUnknownHost *int32 `type:"int32" json:",omitempty"`

	PackageNum *int32 `type:"int32" json:",omitempty"`

	PackageSize *int32 `type:"int32" json:",omitempty"`

	PackageType *int32 `type:"int32" json:",omitempty"`

	Timeout *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s MtrConfigForCreateTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s MtrConfigForCreateTaskInput) GoString() string {
	return s.String()
}

// SetDNSReverseResolution sets the DNSReverseResolution field's value.
func (s *MtrConfigForCreateTaskInput) SetDNSReverseResolution(v bool) *MtrConfigForCreateTaskInput {
	s.DNSReverseResolution = &v
	return s
}

// SetInterval sets the Interval field's value.
func (s *MtrConfigForCreateTaskInput) SetInterval(v float64) *MtrConfigForCreateTaskInput {
	s.Interval = &v
	return s
}

// SetMaxHops sets the MaxHops field's value.
func (s *MtrConfigForCreateTaskInput) SetMaxHops(v int32) *MtrConfigForCreateTaskInput {
	s.MaxHops = &v
	return s
}

// SetMaxUnknownHost sets the MaxUnknownHost field's value.
func (s *MtrConfigForCreateTaskInput) SetMaxUnknownHost(v int32) *MtrConfigForCreateTaskInput {
	s.MaxUnknownHost = &v
	return s
}

// SetPackageNum sets the PackageNum field's value.
func (s *MtrConfigForCreateTaskInput) SetPackageNum(v int32) *MtrConfigForCreateTaskInput {
	s.PackageNum = &v
	return s
}

// SetPackageSize sets the PackageSize field's value.
func (s *MtrConfigForCreateTaskInput) SetPackageSize(v int32) *MtrConfigForCreateTaskInput {
	s.PackageSize = &v
	return s
}

// SetPackageType sets the PackageType field's value.
func (s *MtrConfigForCreateTaskInput) SetPackageType(v int32) *MtrConfigForCreateTaskInput {
	s.PackageType = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *MtrConfigForCreateTaskInput) SetTimeout(v int32) *MtrConfigForCreateTaskInput {
	s.Timeout = &v
	return s
}

type PeriodConfigForCreateTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Days []*int64 `type:"list" json:",omitempty"`

	Period *int32 `type:"int32" json:",omitempty"`

	TimeRangeConfig []*TimeRangeConfigForCreateTaskInput `type:"list" json:",omitempty"`
}

// String returns the string representation
func (s PeriodConfigForCreateTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PeriodConfigForCreateTaskInput) GoString() string {
	return s.String()
}

// SetDays sets the Days field's value.
func (s *PeriodConfigForCreateTaskInput) SetDays(v []*int64) *PeriodConfigForCreateTaskInput {
	s.Days = v
	return s
}

// SetPeriod sets the Period field's value.
func (s *PeriodConfigForCreateTaskInput) SetPeriod(v int32) *PeriodConfigForCreateTaskInput {
	s.Period = &v
	return s
}

// SetTimeRangeConfig sets the TimeRangeConfig field's value.
func (s *PeriodConfigForCreateTaskInput) SetTimeRangeConfig(v []*TimeRangeConfigForCreateTaskInput) *PeriodConfigForCreateTaskInput {
	s.TimeRangeConfig = v
	return s
}

type PingConfigForCreateTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	ConnectTimeout *float64 `type:"double" json:",omitempty"`

	EnableDividePackage *bool `type:"boolean" json:",omitempty"`

	ExecuteInterval *float64 `type:"double" json:",omitempty"`

	PackagesNum *int32 `type:"int32" json:",omitempty"`

	PackagesSize *int32 `type:"int32" json:",omitempty"`

	ProtocolType *int32 `type:"int32" json:",omitempty"`

	Timeout *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s PingConfigForCreateTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s PingConfigForCreateTaskInput) GoString() string {
	return s.String()
}

// SetConnectTimeout sets the ConnectTimeout field's value.
func (s *PingConfigForCreateTaskInput) SetConnectTimeout(v float64) *PingConfigForCreateTaskInput {
	s.ConnectTimeout = &v
	return s
}

// SetEnableDividePackage sets the EnableDividePackage field's value.
func (s *PingConfigForCreateTaskInput) SetEnableDividePackage(v bool) *PingConfigForCreateTaskInput {
	s.EnableDividePackage = &v
	return s
}

// SetExecuteInterval sets the ExecuteInterval field's value.
func (s *PingConfigForCreateTaskInput) SetExecuteInterval(v float64) *PingConfigForCreateTaskInput {
	s.ExecuteInterval = &v
	return s
}

// SetPackagesNum sets the PackagesNum field's value.
func (s *PingConfigForCreateTaskInput) SetPackagesNum(v int32) *PingConfigForCreateTaskInput {
	s.PackagesNum = &v
	return s
}

// SetPackagesSize sets the PackagesSize field's value.
func (s *PingConfigForCreateTaskInput) SetPackagesSize(v int32) *PingConfigForCreateTaskInput {
	s.PackagesSize = &v
	return s
}

// SetProtocolType sets the ProtocolType field's value.
func (s *PingConfigForCreateTaskInput) SetProtocolType(v int32) *PingConfigForCreateTaskInput {
	s.ProtocolType = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *PingConfigForCreateTaskInput) SetTimeout(v int32) *PingConfigForCreateTaskInput {
	s.Timeout = &v
	return s
}

type StartTimeForCreateTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Hour *int32 `type:"int32" json:",omitempty"`

	Minute *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s StartTimeForCreateTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s StartTimeForCreateTaskInput) GoString() string {
	return s.String()
}

// SetHour sets the Hour field's value.
func (s *StartTimeForCreateTaskInput) SetHour(v int32) *StartTimeForCreateTaskInput {
	s.Hour = &v
	return s
}

// SetMinute sets the Minute field's value.
func (s *StartTimeForCreateTaskInput) SetMinute(v int32) *StartTimeForCreateTaskInput {
	s.Minute = &v
	return s
}

type TCPConfigForCreateTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Payload *string `type:"string" json:",omitempty"`

	PayloadType *int32 `type:"int32" json:",omitempty"`

	Timeout *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s TCPConfigForCreateTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TCPConfigForCreateTaskInput) GoString() string {
	return s.String()
}

// SetPayload sets the Payload field's value.
func (s *TCPConfigForCreateTaskInput) SetPayload(v string) *TCPConfigForCreateTaskInput {
	s.Payload = &v
	return s
}

// SetPayloadType sets the PayloadType field's value.
func (s *TCPConfigForCreateTaskInput) SetPayloadType(v int32) *TCPConfigForCreateTaskInput {
	s.PayloadType = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *TCPConfigForCreateTaskInput) SetTimeout(v int32) *TCPConfigForCreateTaskInput {
	s.Timeout = &v
	return s
}

type TimeRangeConfigForCreateTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	EndTime *EndTimeForCreateTaskInput `type:"structure" json:",omitempty"`

	Interval *int64 `type:"int64" json:",omitempty"`

	StartTime *StartTimeForCreateTaskInput `type:"structure" json:",omitempty"`
}

// String returns the string representation
func (s TimeRangeConfigForCreateTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s TimeRangeConfigForCreateTaskInput) GoString() string {
	return s.String()
}

// SetEndTime sets the EndTime field's value.
func (s *TimeRangeConfigForCreateTaskInput) SetEndTime(v *EndTimeForCreateTaskInput) *TimeRangeConfigForCreateTaskInput {
	s.EndTime = v
	return s
}

// SetInterval sets the Interval field's value.
func (s *TimeRangeConfigForCreateTaskInput) SetInterval(v int64) *TimeRangeConfigForCreateTaskInput {
	s.Interval = &v
	return s
}

// SetStartTime sets the StartTime field's value.
func (s *TimeRangeConfigForCreateTaskInput) SetStartTime(v *StartTimeForCreateTaskInput) *TimeRangeConfigForCreateTaskInput {
	s.StartTime = v
	return s
}

type UDPConfigForCreateTaskInput struct {
	_ struct{} `type:"structure" json:",omitempty"`

	Payload *string `type:"string" json:",omitempty"`

	PayloadType *int32 `type:"int32" json:",omitempty"`

	Timeout *int32 `type:"int32" json:",omitempty"`
}

// String returns the string representation
func (s UDPConfigForCreateTaskInput) String() string {
	return volcengineutil.Prettify(s)
}

// GoString returns the string representation
func (s UDPConfigForCreateTaskInput) GoString() string {
	return s.String()
}

// SetPayload sets the Payload field's value.
func (s *UDPConfigForCreateTaskInput) SetPayload(v string) *UDPConfigForCreateTaskInput {
	s.Payload = &v
	return s
}

// SetPayloadType sets the PayloadType field's value.
func (s *UDPConfigForCreateTaskInput) SetPayloadType(v int32) *UDPConfigForCreateTaskInput {
	s.PayloadType = &v
	return s
}

// SetTimeout sets the Timeout field's value.
func (s *UDPConfigForCreateTaskInput) SetTimeout(v int32) *UDPConfigForCreateTaskInput {
	s.Timeout = &v
	return s
}
